/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.token;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.rendering.Document;

/**
 * HR °ɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class HrAttribute
	extends Attribute
{
	private int     attributeAlign   = Value.INHERIT;
	private boolean attributeNoshade = false;
	private Integer attributeSize    = null;
	private Value   attributeWidth   = null;
	
	/**
	 * HR °ǥեͤǺޤ
	 * 
	 * @param     document ɥȾ
	 * @param     reporter 顼ݡ
	 * @param     line   ֹ (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 * @param     column  (<code>1</code> )
	 *                   Ǥʤ <code>0</code>
	 */
	protected HrAttribute(Document document, Reporter reporter, int line, int column)
	{
		super(document, reporter, line, column);
	}
	
	/** {@inheritDoc} */
	public boolean setAttribute(String key, String value)
		throws IllegalArgumentException
	{
		if ("align"  .compareTo(key) == 0) { attributeAlign   = AttributeConverter.convertToAlign  (value); return true; }
		if ("noshade".compareTo(key) == 0) { attributeNoshade = (value.toLowerCase().compareTo("noshade") == 0); return true; }
		if ("size"   .compareTo(key) == 0) { attributeSize    = AttributeConverter.convertToInteger(value); return true; }
		if ("width"  .compareTo(key) == 0) { attributeWidth   = AttributeConverter.convertToPercent(value); return true; }
		
		return setBaseAttribute(key, value);
	}
	
//### Original Method
	
	/**
	 * ֤֤ޤ
	 * 
	 * @return    
	 */
	public int getAlign()
	{
		return attributeAlign;
	}
	
	/**
	 * Ƥդʤ֤ޤ
	 * 
	 * @return    Ƥդʤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getNoshade()
	{
		return attributeNoshade;
	}
	
	/**
	 * ֤ޤ
	 * 
	 * @return    ꤵƤʤ <code>null</code>
	 */
	public Integer getSize()
	{
		return attributeSize;
	}
	
	/**
	 * ֤ޤ
	 * 
	 * @return    ꤵƤʤ <code>null</code>
	 */
	public Value getWidth()
	{
		return attributeWidth;
	}
}
