/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.theme;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.viewer.ViewerOption;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * ơޤ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class ThemeManager
{
	private static final String RESOURCE  = "net.hizlab.kagetaka.theme.Resource";
	private static final String EXTENSION = ".kth";
	
	private ViewerOption option;
	
	private Vector themes = new Vector();
	private Theme  theme;
	
	/**
	 * ơޥޥ͡ޤ
	 * 
	 * @param     option ץ
	 */
	public ThemeManager(ViewerOption option)
	{
		this.option = option;
		refresh();
		
		theme = getTheme(option.getThemeKey());
		if (theme == null)
			theme = (Theme)themes.elementAt(0);
		
		try {
			theme.load();
		} catch (InvalidThemeException e) {
System.out.println(e);
		}
	}
	
	/**
	 * ơ޾ɹޤ
	 */
	public synchronized void refresh()
	{
		themes.removeAllElements();
		
		// ǥեȥơ
		String list = Resource.getMessage(RESOURCE, "themes.list", null);
		StringTokenizer st = new StringTokenizer(list, ",");
		while (st.hasMoreTokens()) {
			try {
				themes.addElement(new Theme(st.nextToken()));
			} catch (InvalidThemeException e) {
System.out.println(e);
			}
		}
		
		// 桼ƥơ
		File[] lists = {option.getUserThemesPath  (),
		                option.getSystemThemesPath()};
		for (int i = 0; i < lists.length; i++) {
			if (lists[i] == null)
				continue;
			
			if (!lists[i].exists() || !lists[i].isDirectory() || !lists[i].canRead())
				continue;
			
			String[] files = lists[i].list();
			if (files == null)
				continue;
			
			for (int j = 0; j < files.length; j++) {
				File file = new File(lists[i], files[j]);
				if (!files[j].toLowerCase().endsWith(EXTENSION) &&
				    !file.isDirectory())
					continue;
				
				try {
					themes.addElement(new Theme(file));
				} catch (InvalidThemeException e) {
System.out.println(e);
				}
			}
		}
	}
	
	/**
	 * 桼򤷤Ƥơޤ֤ޤ
	 * 
	 * @return    ơ
	 */
	public synchronized Theme getTheme()
	{
		return theme;
	}
	
	/**
	 * ơޤ֤ޤ
	 * 
	 * @param     key ơޤ̤륭
	 * 
	 * @return    ơ
	 */
	public synchronized Theme getTheme(String key)
	{
		Theme theme;
		
		for (int i = 0; i < themes.size(); i++) {
			theme = (Theme)themes.elementAt(i);
			if (theme.getKey().compareTo(key) == 0)
				return theme;
		}
		
		return null;
	}
	
	/**
	 * ǧƤ뤹٤ƤΥơޤ֤ޤ
	 * 
	 * @return    ٤ƤΥơ
	 */
	public synchronized Theme[] getThemes()
	{
		Theme[] ts = new Theme[themes.size()];
		themes.copyInto(ts);
		
		return ts;
	}
}
