/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.token.TokenTypes;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.net.URL;

/**
 * ߤ襹ơݻ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class Status
	implements Cloneable
{
	/** åȡ     */ public static final int TARGET_TOP    = Border.TOP   ;
	/** åȡ     */ public static final int TARGET_RIGHT  = Border.RIGHT ;
	/** åȡ     */ public static final int TARGET_BOTTOM = Border.BOTTOM;
	/** åȡ     */ public static final int TARGET_LEFT   = Border.LEFT  ;
	/** åȡ٤ */ public static final int TARGET_ALL    = Border.ALL   ;
	
	/** ȡˤ */ public static final int TOKEN = 1;
	/** ˤ */ public static final int STYLE = 2;
	
	private HawkContext context;
	private Drawkit     drawkit;
	
	private double baseFontSize = 12;
	
	// ǡ
	Status      firstChild     = null;
	Status      link           = null;
	Status      visited        = null;
	Status      hover          = null;
	Status      active         = null;
	Status      focus          = null;
	Status      firstLine      = null;
	Status      firstLetter    = null;
	Status      before         = null;
	Status      after          = null;
	
	Box         margin         = null;        // ޡ
	Border      border         = null;        // ܡ
	Box         padding        = null;        // ѥǥ
	Image       backImage      = null;        // طʲ
	Dimension   backImageSize  = null;        // طʲ
	FontData    fd             = null;        // ե
	Font        font           = null;        // ե
	FontMetrics fm             = null;        // ե
	Dimension   fdFontSize     = null;        // ե
	int         fontHeightMax  = 0;           // ե
	int         fontHeightHalf = 0;           // ե
	int         fontBaseFull   = 0;           // ե
	int         fontBaseHalf   = 0;           // ե
	URL         href           = null;        // A 
	String      tip            = null;        // ݥåץåʸ
	int         listLevel      = 0;           // ꥹȥͥȥ٥
	int         listType       = Value.LIST_NONE;   // ꥹȥ
	Status      counterStatus  = this;        // ꥹȥ
	boolean     reference      = true;        // ʸλȤ褹뤫
	
	public boolean   isBlackHole = false;     // ƥĤ̵뤹뤫
	public boolean   isHorizontalRule = false; // ʿɤ
	public Value     hrHeight  = null;        // ʿ
	
	// ơ֥
	public boolean   isTable       = false;   // ʬ TABLE ɤ
	public boolean   isVertical    = false;   // ʬȼΥ֥åĤ¤٤뤫
	public int       colSpan       = 1;       // COLSPAN
	public int       rowSpan       = 1;       // ROWSPAN
	public Value     borderVerticalSpacing   = null;    // 
	public Value     borderHorizontalSpacing = null;    // 
	
	/** ΥơΥȡ󥿥 */
	public int       type          = TokenTypes.UNKNOWN;
	/** Υơοƥơ */
	public Status    parent        = null;
	
	private double  fontPerPixel  = 0;        // ե 1 ݥȤΥԥ
	private boolean fontChanged   = false;    // եȤѹäɤ
	private Value[] fontFamilies  = null;     // ѹԤեȥեߥ̾
	private String  fontFamily    = null;     // եȥեߥ̾
	private boolean fontStyle     = false;    // եȥtrue = italic
	private int     fontWeight    = 0;        // եλ
	private double  fontSize      = 0;        // եȥλ
	private boolean fontSizeStyle = false;    // եȥǥˤ
	
	/** 侩                  */ public Value width         = null;
	/** 侩⤵                */ public Value height        = null;
	/** Ԥι⤵                    */ public Value textIndent    = null;
	/** Ԥι⤵                    */ public Value lineHeight    = null;
	/** ʸ                    */ public Value letterSpacing = null;
	/** ֥åʸ·        */ public int   align         = Value.NONE;   // HR Ѥ˥ȥåפ NONE ɬפ
	/** ֥åʸ·        */ public int   valign        = Value.VALIGN_BASELINE;
	/** ʿ                      */ public Color foreColor     = null;
	/** طʿ                      */ public Color backColor     = null;
	/** 󥯿                    */ public Color linkColor     = null;
	/** ˬѤߥ󥯿            */ public Color vlinkColor    = null;
	/** ƥ֤ʥ󥯿        */ public Color alinkColor    = null;
	/** ʸνTD_* ¡ */ public int   decoration    = Value.INHERIT;
	/** ڡμ갷          */ public int   whiteSpace    = Value.WHITESPACE_NORMAL;
	/** ꥹȤΥ󥿡          */ public int   counterNo     = 1;
	/** ֤Υեå        */ public int   offsetX       = 0;
	/** ե                    */ public int   floatType     = Value.FLOAT_NONE;
	/** ꥢ                      */ public int   clearType     = Value.CLEAR_NONE;
	
	/** 󥹥󥹤 */
	Status(Drawkit drawkit)
	{
		this.context = drawkit.context;
		this.drawkit = drawkit;
		this.parent  = this;
		
		// եȤ
		Font        font = context.getOption().getDefaultFont();
		FontMetrics fm   = context.getToolkit().getFontMetrics(font);
		fontPerPixel = context.getOption().getFontPerPixel();
		fontChanged  = true;
		fontFamily   = font.getName();
		fontStyle    = ((font.getStyle() & Font.ITALIC) != 0);
		fontWeight   = ((font.getStyle() & Font.BOLD  ) != 0 ? 700 : 400);
		fontSize     = font.getSize() / fontPerPixel;
		setupFont();
	}
	
	/**
	 * ޤ
	 * 
	 * @return    줿
	 */
	public Object clone()
	{
		try {
			Status s = (Status)super.clone();
			
			// ʣʤեɤ
			s.backImage        = null;
			s.backImageSize    = null;
			s.margin           = null;
			s.border           = null;
			s.padding          = null;
			s.type             = TokenTypes.UNKNOWN;
			s.width            = null;
			s.height           = null;
			s.valign           = Value.VALIGN_BASELINE;
			s.backColor        = null;
			s.counterNo        = 1;
			s.floatType        = Value.FLOAT_NONE;
			s.clearType        = Value.CLEAR_NONE;
			
			s.isHorizontalRule = false;
			s.hrHeight         = null;
			
			s.isTable          = false;
			s.isVertical       = false;
			s.colSpan          = 1;
			s.rowSpan          = 1;
			
			s.fontSizeStyle    = false;
			
			s.parent = this;
			return s;
		} catch (CloneNotSupportedException e) {}
		return null;
	}
	
	/**
	 * ƥơ֤ޤ
	 * 
	 * @return    ƥơ
	 */
	public Status getParent()
	{
		return parent;
	}
	
	/** inherit Ѥˡɬܥơ null ξ硢Ƥ饳ԡ */
	void checkStatus()
	{
		setupFont();
		
		if (align      == Value.INHERIT) align      = parent.align;
		if (valign     == Value.INHERIT) valign     = parent.valign;
		if (foreColor  == null         ) foreColor  = parent.foreColor;
		if (linkColor  == null         ) linkColor  = parent.linkColor;
		if (vlinkColor == null         ) vlinkColor = parent.vlinkColor;
		if (alinkColor == null         ) alinkColor = parent.alinkColor;
		if (decoration == Value.INHERIT) decoration = parent.decoration;
		if (whiteSpace == Value.INHERIT) whiteSpace = parent.whiteSpace;
	}
	
	/**
	 * ޡꤷޤ
	 * 
	 * @param     target å
	 * @param     value  
	 */
	public void setMargin(int target, Value value)
	{
		if (margin == null) margin = new Box();
		
		if ((target & TARGET_TOP   ) != 0) margin.top    = value;
		if ((target & TARGET_RIGHT ) != 0) margin.right  = value;
		if ((target & TARGET_BOTTOM) != 0) margin.bottom = value;
		if ((target & TARGET_LEFT  ) != 0) margin.left   = value;
	}
	
	/**
	 * ܡΥꤷޤ
	 * 
	 * @param     target å
	 * @param     value  
	 */
	public void setBorderStyle(int target, Value value)
	{
		if (border == null) border = new Border();
		
		border.setStyle(target, value);
	}
	
	/**
	 * ܡꤷޤ
	 * 
	 * @param     target å
	 * @param     value  
	 */
	public void setBorderWidth(int target, Value value)
	{
		if (border == null) border = new Border();
		
		border.setWidth(target, value);
	}
	
	/**
	 * ܡοꤷޤ
	 * 
	 * @param     target å
	 * @param     value  
	 */
	public void setBorderColor(int target, Color value)
	{
		if (border == null) border = new Border();
		
		border.setColor(target, value);
	}
	
	/**
	 * ѥǥ󥰤ꤷޤ
	 * 
	 * @param     target å
	 * @param     value  
	 */
	public void setPadding(int target, Value value)
	{
		if (padding == null) padding = new Box();
		
		if ((target & TARGET_TOP   ) != 0) padding.top    = value;
		if ((target & TARGET_RIGHT ) != 0) padding.right  = value;
		if ((target & TARGET_BOTTOM) != 0) padding.bottom = value;
		if ((target & TARGET_LEFT  ) != 0) padding.left   = value;
	}
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     src طʲ URL
	 */
	public void setBackImage(String src)
	{
		if (src == null)
			return;
		
		Image image = drawkit.getImage(drawkit.createURL(src), src);
		if (image == null)
			return;
		
		// ɼԤξϡطʲ˴
		if (drawkit.loadImage(image, "wait to load a background image") != MediaTracker.COMPLETE) {
			image.flush();
			return;
		}
		
		this.backImage     = image;
		this.backImageSize = new Dimension(image.getWidth (drawkit.imageDrawer),
		                                   image.getHeight(drawkit.imageDrawer));
	}
	
	/**
	 * ߤΥեȥեߥѹޤ
	 * 
	 * @param     v եȥեߥ
	 */
	public void setFontFamily(Value[] v)
	{
		if (v.length == 1 && v[0].getType() == Value.TYPE_KEY_INHERIT)
			fontFamilies = parent.fontFamilies;
		else
			fontFamilies = v;
		
		fontChanged = true;
	}
	
	/**
	 * ߤΥեȥѹޤ
	 * 
	 * @param     v եȥ
	 */
	public void setFontStyle(Value v)
	{
		switch (v.getType()) {
		case Value.TYPE_KEY_INHERIT : fontStyle = parent.fontStyle; break;
		case Value.TYPE_KEY_NORMAL  : fontStyle = false; break;
		case Value.TYPE_KEY_ITALIC  :
		case Value.TYPE_KEY_OBLIQUE : fontStyle = true ; break;
		}
		
		fontChanged = true;
	}
	
	/**
	 * ߤΥեѹޤ
	 * 
	 * @return    ե
	 */
	public int getFontWeight()
	{
		return fontWeight;
	}
	
	/**
	 * ߤΥեѹޤ
	 * 
	 * @param     v ե
	 */
	public void setFontWeight(Value v)
	{
		switch (v.getType()) {
		case Value.TYPE_KEY_INHERIT : fontWeight = parent.fontWeight; break;
		case Value.TYPE_KEY_NORMAL  : fontWeight =  400; break;
		case Value.TYPE_KEY_BOLD    : fontWeight =  700; break;
		case Value.TYPE_KEY_BOLDER  : fontWeight += 100; break;
		case Value.TYPE_KEY_LIGHTER : fontWeight -= 100; break;
		case Value.TYPE_INTEGER     : fontWeight = v.intValue(); break;
		case Value.NONE             : fontWeight = -1; break;
		}
		
		fontChanged = true;
	}
	
	/**
	 * ߤΥեȥѹޤ
	 * 
	 * @param     v եȥ
	 */
	public void setFontSize(Value v, int owner)
	{
		if (owner == STYLE && !fontSizeStyle) {
			fontSize = parent.fontSize;
			fontSizeStyle = true;
		}
		
		switch (v.getType()) {
		case Value.TYPE_KEY_INHERIT : fontSize = parent.fontSize; break;
		case Value.TYPE_KEY_XX_SMALL: fontSize = baseFontSize / Constant.FS_COEF / Constant.FS_COEF / Constant.FS_COEF; break;
		case Value.TYPE_KEY_X_SMALL : fontSize = baseFontSize / Constant.FS_COEF / Constant.FS_COEF; break;
		case Value.TYPE_KEY_SMALL   : fontSize = baseFontSize / Constant.FS_COEF; break;
		case Value.TYPE_KEY_MEDIUM  : fontSize = baseFontSize; break;
		case Value.TYPE_KEY_LARGE   : fontSize = baseFontSize * Constant.FS_COEF; break;
		case Value.TYPE_KEY_X_LARGE : fontSize = baseFontSize * Constant.FS_COEF * Constant.FS_COEF; break;
		case Value.TYPE_KEY_XX_LARGE: fontSize = baseFontSize * Constant.FS_COEF * Constant.FS_COEF * Constant.FS_COEF; break;
		case Value.TYPE_KEY_LARGER  : fontSize *= Constant.FS_COEF; break;
		case Value.TYPE_KEY_SMALLER : fontSize /= Constant.FS_COEF; break;
		case Value.TYPE_LENGTH      :
		case Value.TYPE_PERCENTAGE  : fontSize = v.getValue(fd, (int)fontSize, Value.DATA_HORIZONTAL); break;
		}
		
		fontChanged = true;
	}
	
	/**
	 * ߤΥեȤեȤꤷޤ
	 */
	public void setFixedFont()
	{
		Font font = context.getOption().getDefaultFixedFont();
		if (font != null)
			fontFamily = font.getName();
		
		fontChanged = true;
	}
	
	/** եȤ򥻥åȥåפޤ */
	private void setupFont()
	{
		if (!fontChanged)
			return;
		
		String name  = fontFamily;
		int    style = (fontWeight >= 700 ? Font.BOLD : 0) | (fontStyle ? Font.ITALIC : 0);
		int    size  = (int)(fontSize * fontPerPixel);
		Font   font  = null;
		
		if (fontFamilies != null) {
			for (int i = 0; i < fontFamilies.length; i++) {
				name = fontFamilies[i].getString();
				font = new Font(name, style, size);
				
				if (name.compareTo(font.getName()) == 0) {
					fontFamily = name;
					break;
				}
			}
			fontFamilies = null;
		}
		
		if (font == null)
			font = new Font(name, style, size);
		
		if (font.equals(this.font))
			return;
		
		this.font           = font;
		this.fd             = FontData.getInstance(context, font);
		this.fm             = fd.getFontMetrics();
		this.fdFontSize     = fd.getFullSize   ();
		this.fontHeightMax  = fd.getMaxHeight  ();
		this.fontHeightHalf = fd.getHalfHeight ();
		this.fontBaseFull   = fd.getFullBase   ();
		this.fontBaseHalf   = fd.getHalfBase   ();
		this.fontChanged    = false;
	}
	
	/**
	 * ߤΥեȥǡ֤ޤ
	 * 
	 * @return    ꤵƤեȥǡ
	 */
	public FontData getFontData()
	{
		return fd;
	}
	
	/**
	 * ʸνꤷޤ
	 * 
	 * @param     td ʸν
	 */
	public void setTextDecoration(int td)
	{
		decoration |= td;
	}
	
	/**
	 * ʸνꤷޤ
	 * 
	 * @param     td ʸν
	 * 
	 * @return    ꤵƤʸνƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean getTextDecoration(int td)
	{
		return ((decoration & td) != 0);
	}
	
	/**
	 * ꥹȤꤷޤ
	 * 
	 * @param     type ꥹȤΥ
	 */
	public void setList(int type)
	{
		listLevel++;
		if (type == Value.LIST_MIX) {
			switch (listLevel) {
			case  1: listType = Value.LIST_DISC  ; break;
			case  2: listType = Value.LIST_CIRCLE; break;
			default: listType = Value.LIST_SQUARE; break;
			}
		} else {
			listType = type;
		}
		counterStatus = this;
	}
	
//### Box
	/** ܥå */
	class Box
	{
		Value top;
		Value right;
		Value bottom;
		Value left;
		
		/** 󥹥󥹤 */
		private Box()
		{
		}
		
		/** ʸɽ֤ */
		public String toString()
		{
			StringBuffer sb = new StringBuffer();
			sb.append(getClass().getName());
			sb.append('[');
			if (top    != null) sb.append(top   .toString()); sb.append(", ");
			if (right  != null) sb.append(right .toString()); sb.append(", ");
			if (bottom != null) sb.append(bottom.toString()); sb.append(", ");
			if (left   != null) sb.append(left  .toString()); sb.append(']' );
			return sb.toString();
		}
	}
}
