/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.util.Charset;
import net.hizlab.kagetaka.util.ContentType;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.FormManager;
import net.hizlab.kagetaka.token.Style;
import net.hizlab.kagetaka.token.StyleManager;
import net.hizlab.kagetaka.token.Value;

import java.awt.Color;
import java.awt.Dimension;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;

/**
 * ߤΥ֤°ɽ饹Ǥ
 * 襨󥸥ϡ°򸵤Ԥޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public class Render
{
	// ǥեȥơ
	private static final int   DEFAULT_ALIGN       = Value.ALIGN_LEFT;
	private static final Color DEFAULT_FORE_COLOR  = Color.black;
	private static final Color DEFAULT_BACK_COLOR  = Color.white;
	private static final Color DEFAULT_LINK_COLOR  = Color.blue;
	private static final Color DEFAULT_VLINK_COLOR = new Color(0x55, 0x1A, 0x8B);
	private static final Color DEFAULT_ALINK_COLOR = Color.red;
	private static final int   DEFAULT_TD          = 0;
	
	private HawkContext context;
	private Drawkit     drawkit;
	
	// 
	private boolean      smCreate  = false;
	private StyleManager sm        = null;
	
	// ե
	private boolean      fmCreate  = false;
	private FormManager  fm        = null;
	
	// եå
	private int refreshTime = -1;
	private URL refreshUrl  = null;
	
	// ط
	private Box topBox;                       // ȥåץ٥ܥåBODYб
	private Box bottomBox;
	
	/**
	 * 襹ơޤ
	 * 
	 * @param     context 륳ƥ
	 * @param     document ɥȾ
	 */
	Render(HawkContext context, Document document)
	{
		this.context = context;
		this.drawkit = new Drawkit(context, document);
	}
	
//### Public
	/**
	 * ʸ褷ޤ
	 * 
	 * @param     text 褹ʸ
	 */
	public void drawText(String text)
	{
		if (drawkit.status.isBlackHole)
			return;
		bottomBox.appendString(text);
	}
	
	/**
	 * ԤԤޤ
	 */
	public void doBr()
	{
		if (drawkit.status.isBlackHole)
			return;
		bottomBox.appendNewLine();
	}
	
	/**
	 * Ԥɲäޤ
	 */
	public void createNewRow()
	{
		bottomBox.createNewRow();
	}
	
	/**
	 * 褷ޤ
	 * 
	 * @param     src 
	 * @param     alt ʸ
	 * @param     width  
	 * @param     height ⤵
	 * @param     border ܡ
	 * @param     floatType 
	 */
	public void drawImage(String src, String alt, Value width, Value height, Integer border, int floatType)
	{
		if (drawkit.status.isBlackHole)
			return;
		if (src == null)
			return;
		
		int b = 0;
		
		if (border != null)
			b = border.intValue();
		else if (drawkit.status.href != null)
			b = Constant.IMG_BORDER;
		else
			b = 0;
		
		bottomBox.appendImage(src, alt, width, height, b, floatType);
	}
	
	/**
	 * եॢƥ褷ޤ
	 * 
	 * @param     item ƥ
	 */
	public void drawForm(FormItem item)
	{
		bottomBox.appendForm(item);
	}
	
	/**
	 * ȥꤷޤ
	 * 
	 * @param     title ȥ
	 */
	public void setTitle(String title)
	{
		context.setTitle(title);
	}
	
	/**
	 * ߤ襹ơ֤ޤ
	 * 
	 * @return    襹ơ
	 */
	public Status getStatus()
	{
		return drawkit.status;
	}
	
	/**
	 * ١ URL ꤷޤ
	 * 
	 * @param     href ١ URL
	 */
	public void setBaseHref(String href)
	{
		if (href == null)
			return;
		
		URL url = drawkit.createURL(href);
		if (url != null)
			drawkit.document.setBaseURL(url);
	}
	
	/**
	 * ֥åޡꤷޤ
	 * 
	 * @param     name NAME
	 */
	public void setMark(String name)
	{
		if (name != null)
			drawkit.idQueue.put(name);
	}
	
	/**
	 * 󥯤ꤷޤ
	 * 
	 * @param     href 
	 */
	public void setLink(String href)
	{
		if (href != null) {
			URL url = drawkit.createURL(href);
			if (url == null)
				return;
			
			drawkit.status.href = url;
			
			if (context.haveEverVisited(url))
				drawkit.status.foreColor = drawkit.status.vlinkColor;
			else
				drawkit.status.foreColor = drawkit.status.linkColor;
		}
	}
	
	/**
	 * ݥåץåʸꤷޤ
	 * 
	 * @param     tip ݥåץåʸ
	 */
	public void setPopup(String tip)
	{
		if (tip != null)
			drawkit.status.tip = tip;
	}
	
	/**
	 * Ӥ򳫻Ϥޤ
	 */
	public void startRuby()
	{
		bottomBox.setRuby(Constant.RUBY_START);
	}
	
	/**
	 * оʸ򳫻Ϥޤ
	 */
	public void startRubyRb()
	{
		bottomBox.setRuby(Constant.RUBY_RB);
	}
	
	/**
	 * ʸ򳫻Ϥޤ
	 */
	public void startRubyRp()
	{
		bottomBox.setRuby(Constant.RUBY_RP);
	}
	
	/**
	 * ʸ򳫻Ϥޤ
	 */
	public void startRubyRt()
	{
		bottomBox.setRuby(Constant.RUBY_RT);
	}
	
	/**
	 * Ӥλޤ
	 */
	public void endRuby()
	{
		bottomBox.setRuby(Constant.RUBY_END);
	}
	
	/**
	 * ꥹȥƥꤷޤ
	 */
	public void setListItem()
	{
		bottomBox.setListItem();
	}
	
	/**
	 * ưեåϿޤ
	 * 
	 * @param     time եå夹ޤǤԵÿ
	 * @param     href եå URL
	 *                 <code>null</code> ξϼʬ
	 */
	public void setRefresh(int time, String href)
	{
		refreshTime = time;
		if (href == null) {
			refreshUrl = drawkit.document.getBaseURL();
		} else {
			refreshUrl = drawkit.createURL(href);
			if (refreshUrl == null)
				refreshTime = -1;
		}
	}
	
	/**
	 * åꤷޤ
	 * 
	 * @param     value åɽʸ
	 */
	public void setCookie(String value)
	{
		context.setCookie(value, drawkit.document.getURL());
	}
	
//### 
	/**
	 * 륷ȤϿޤ
	 * 
	 * @param     href 륷Ȥ URL
	 * @param     contentType ƥĥ
	 */
	public void setStyleSheet(String href, String contentType)
	{
		if (href == null)
			return;
		
		URL url = drawkit.createURL(href);
		if (url == null)
			return;
		
		// ޥ͡㤬̤ξϺƤߤ
		if (sm == null && !smCreate) {
			sm = StyleManager.createStyleManager(context.getReporter());
			smCreate = true;
		}
		if (sm == null)
			return;
		
		try {
			URLConnection connection = context.getURLConnection(url, null);
			if (connection == null)
				return;
			
			String encoding = null;
			
			// 饯åȤ
			if (contentType == null)
				contentType = connection.getContentType();
			contentType = ContentType.normalize(contentType, url);
			if (contentType != null) {
				try {
					ContentType ct = new ContentType(contentType);
					contentType = (ct.getType   () != null ? ct.getType   () : "") + "/" +
					              (ct.getSubType() != null ? ct.getSubType() : "");
					String charset = ct.getParameter("charset");
					if (charset != null && (encoding = Charset.toEncoding(charset)) == null)
						drawkit.reportMessage(Reporter.WARNING, "charset.warning.invalid", new String[]{charset});
				} catch (ParseException e) {}
			}
			if (contentType == null || contentType.compareTo("text/css") != 0) {
				//### ERROR
				return;
			}
			
			sm.addStyle(connection.getInputStream(), encoding);
		} catch (SecurityException e) {
			drawkit.reportMessage(Reporter.WARNING, "engine.status.load.error.security", new String[]{href});
		} catch (FileNotFoundException e) {
			drawkit.reportMessage(Reporter.WARNING, "engine.status.load.error.nofile", new String[]{href});
		} catch (IOException e) {
			drawkit.reportMessage(Reporter.WARNING, "engine.status.load.error", new String[]{href, e.getMessage()});
		}
	}
	
	/**
	 * ޥ֤͡ޤ
	 * 
	 * @param     create ޥ͡㤬̵˺
	 *                   <code>true</code>ʳξ <code>false</code>
	 * 
	 * @return    ޥ͡㤬̵䡢
	 *            뤬ݡȤƤʤ <code>null</code>
	 */
	public StyleManager getStyleManager(boolean create)
	{
		if (sm == null && !smCreate && create) {
			sm = StyleManager.createStyleManager(context.getReporter());
			smCreate = true;
		}
		
		return sm;
	}
	
//### ե
	/**
	 * եޥ֤͡ޤ
	 * 
	 * @return    եबݡȤƤʤ <code>null</code>
	 */
	public FormManager getFormManager()
	{
		if (fm == null && !fmCreate) {
			fm = FormManager.createFormManager(context, drawkit.document);
			fmCreate = true;
		}
		
		return fm;
	}
	
//### HawkEngine 
	/**
	 * ֥å򳫻Ϥޤ
	 */
	void startBlock()
	{
//System.out.println("Render.startBlock");
		bottomBox = bottomBox.createBox();
	}
	
	/**
	 * ֥åĤޤ
	 */
	void endBlock()
	{
		bottomBox = bottomBox.commitBox();
//System.out.println("Render.endBlock");
	}
	
	/**
	 * ʸ򳫻Ϥޤ
	 */
	void startBody()
	{
		Status status = drawkit.baseStatus;
		
		// BODY ơνͤ
		if (status.backColor  == null         ) status.backColor  = DEFAULT_BACK_COLOR ;
		if (status.align      == Value.INHERIT) status.align      = DEFAULT_ALIGN      ;
		if (status.foreColor  == null         ) status.foreColor  = DEFAULT_FORE_COLOR ;
		if (status.linkColor  == null         ) status.linkColor  = DEFAULT_LINK_COLOR ;
		if (status.vlinkColor == null         ) status.vlinkColor = DEFAULT_VLINK_COLOR;
		if (status.alinkColor == null         ) status.alinkColor = DEFAULT_ALINK_COLOR;
		if (status.decoration == Value.INHERIT) status.decoration = DEFAULT_TD         ;
		
		int scaleWidth  = status.fdFontSize.width;
		int scaleHeight = status.fdFontSize.height;
		if (status.lineHeight != null)
			scaleWidth  =  status.lineHeight   .getValue(status.fd, status.fdFontSize.width , Value.DATA_HORIZONTAL);
		if (status.letterSpacing != null)
			scaleHeight += status.letterSpacing.getValue(status.fd, status.fdFontSize.height, Value.DATA_VERTICAL  );
		context.setScale(new Dimension(scaleWidth, scaleHeight));
		
		if (status.backColor != null) context.setBackground(status.backColor);
		if (status.backImage != null) context.setBackground(status.backImage);
		context.setItemMap(drawkit.itemMap);
		
		// ȥåץ٥ BOX 
		bottomBox = topBox = new Box(drawkit);
	}
	
	/**
	 * ʸĤޤ
	 */
	void endBody()
	{
		Status status = drawkit.baseStatus;
		
		topBox.dispose();
	}
	
	/**
	 * ߤ¸ޤ
	 * ϥåˤʣ¸ޤ
	 */
	void save(int type)
	{
		drawkit.saveStatus(type);
	}
	
	/**
	 * ¸Ƥľᤷޤ
	 * θľ¸Ƥ˴ޤ
	 */
	void reset()
	{
		drawkit.resetStatus();
	}
	
	/**
	 * ơѹäȤޤ
	 */
	void statusChanged()
	{
		drawkit.status.checkStatus();
		
		bottomBox.statusChanged();
	}
	
	/**
	 * ɤ߹ߤλΤԤޤ
	 */
	void waitImageLoad()
	{
		drawkit.waitImageLoad();
	}
	
	/**
	 * ɤ߹ߤ򥭥󥻥뤷ޤ
	 */
	void stopImageLoad()
	{
		drawkit.stopImageLoad();
	}
	
	/**
	 * եå URL ޤ
	 */
	URL getRefreshURL()
	{
		if (refreshTime < 0)
			return null;
		
		if (refreshTime > 0) {
			try {
				Thread.sleep(refreshTime * 1000);
			} catch (InterruptedException e) {
				throw new StopException("wait for refresh");
			}
		}
		
		return refreshUrl;
	}
	
	/**
	 * ꥽ޤ
	 */
	void dispose()
	{
		drawkit.dispose();
	}
}
