/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.token.Value;

/**
 * ΰ֤ݻ륯饹
 */
class Position
{
	private int   align;
	private int   maxLineno;
	private int   maxHeight;
	private int[] widthList;
	private int[] heightList;
	private int[] offsetList;
	private int[] topList;
	private int[] bottomList;
	private int   index  = 0;
	private int   ah = 0;
	
	int startX;
	int startY;
	int x;
	int y;
	int width;
	int height;
	int offset;
	int floatTop;
	int floatBottom;
	
	/** 󥹥󥹤 */
	Position(int x, int y, int align, int maxHeight,
	         int[] widthList, int[] heightList, int[] offsetList,
	         int[] topList, int[] bottomList)
	{
		this.align      = align;
		this.maxLineno  = widthList.length;
		this.maxHeight  = maxHeight;
		this.widthList  = widthList;
		this.heightList = heightList;
		this.offsetList = offsetList;
		this.topList    = topList;
		this.bottomList = bottomList;
		
		this.startX      = x;
		this.startY      = y;
		if (maxLineno > 0) {
			this.width       = widthList [0];
			this.height      = heightList[0];
			this.offset      = offsetList[0];
			this.floatTop    = topList   [0];
			this.floatBottom = bottomList[0];
		} else {
			// ֥å˥եȥܥåʤ
			// newLine ɬ󵯤ƤޤΤǡΤȤηٹФʤ褦ˤ
			index = -1;
		}
		this.x           = x;
		this.y           = y;
		
		fixPosition();
	}
	
	/** ԤԤ */
	void newLine()
	{
if (index >= maxLineno)
System.out.println("## Postion.newLine: what ?? ["+index+","+maxLineno+"]");
		if (++index >= maxLineno)
			return;
		
		x -= offset;
		
		width       = widthList [index];
		height      = heightList[index];
		offset      = offsetList[index];
		floatTop    = topList   [index];
		floatBottom = bottomList[index];
		
		fixPosition();
	}
	
	/** ֤ĴԤ */
	private void fixPosition()
	{
		x -= width;
		y =  startY;
		
		switch (align) {
		case Value.ALIGN_CENTER:
			ah     =  Math.max(maxHeight - height, 0) / 2;
			if (ah < floatTop)
				ah = floatTop;
			else if (ah < floatBottom)
				ah -= (floatBottom - ah);
			y      += ah;
			height += ah;
			break;
		case Value.ALIGN_RIGHT:
			ah     =  Math.max(maxHeight - height, 0);
			ah     -= floatBottom;
			y      += ah;
			height += ah;
			break;
		default:
			y      += floatTop;
			height += floatTop;
			break;
		}
		
		height += startY;
	}
}
