/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.TextFormat;
import net.fclabs.util.Queue;

import java.awt.Point;
import java.util.Vector;

/**
 * ݻ륯饹
 */
class Paragraph
{
	private static final String BR    = String.valueOf((char)0x0A);
	private static final String SPACE = String.valueOf(' ');
	
	private static final int LS_BEGIN = 0;
	private static final int LS_TRUE  = 1;
	private static final int LS_FALSE = 2;
	
	Box box;
	
	private Drawkit drawkit;
	
	int preferredHeight;
	
	private boolean rearrange  = false;
	private boolean hasFloat   = false;
	
	private int     whiteSpace = Value.WHITESPACE_NORMAL;
	private int     indent     = 0;
	private boolean reference  = true;
	
	private Caddy caddy     = null;
	private Caddy topCaddy  = null;
	private Caddy lastCaddy = null;
	
	private Vector widthList  = new Vector();
	private Vector heightList = new Vector();
	private Vector offsetList = new Vector();
	private Vector topList    = new Vector();
	private Vector bottomList = new Vector();
	private int    lineno     = 0;
	int   width       = 0;
	int   height      = 0;
	int   maxHeight   = 0;
	int   drawOffsetX = 0;
	
	int lineWidth     = 0;
	int lineHeight    = 0;
	int lineOffset    = 0;
	int linePitch     = 0;
	int lineMaxHeight = 0;
	int floatTop      = 0;
	int floatBottom   = 0;
	int floatHeight   = 0;
	
	private boolean statusChanged = false;    // ơѹ줿
	private Status  listStatus    = null;     // ꥹ LI 
	private int     lastSpace     = LS_BEGIN; // Ǹ夬ڡɤ
	private Queue   floatQueue    = null;     // եȥ֥åΥ塼
	
	/** 󥹥󥹤 */
	Paragraph(Box box, Status listStatus, int height)
	{
		this.box = box;
		drawkit         = box.drawkit;
		preferredHeight = height;
		
		Status status = drawkit.status;
		if (status.textIndent != null) {
			indent = status.textIndent.getValue(status.fd, status.fdFontSize.height, Value.DATA_VERTICAL);
			lineHeight += indent;
		}
		whiteSpace = status.whiteSpace;
		reference  = status.reference;
		
		// ꥹǤξ
		if (listStatus != null) {
			// UL, OL ̵ LI иϡʰɽ
			if (listStatus.listLevel == 0) {
				drawkit.status = listStatus;
				statusChanged();
				appendString("");
				drawkit.status = status;
				statusChanged();
			} else {
				this.listStatus = listStatus;
			}
		}
	}
	
	/** ʸ */
	void appendString(String text)
	{
//System.out.println("Paragraph.append["+text+"]");
		int ls  = lastSpace;
		int end = 0;
		
		if (whiteSpace != Value.WHITESPACE_PRE)
			text = TextFormat.convertXhtml(text, (ls != LS_FALSE), false, true, reference);
		else
			text = TextFormat.convertXhtml(text, false, false, false, reference);
		
		if ((end = text.length()) == 0)
			return;
		
		checkCaddy(false, true, true);
		
		// ӤǤϤʤ硢ڡα
		if (whiteSpace != Value.WHITESPACE_PRE &&
		    !lastCaddy.ruby &&
		    text.charAt(end - 1) == ' ') {
			end--;
			lastSpace = LS_TRUE;
		}
		
		caddy.append(text, 0, end);
	}
	
	/** ɲ */
	void appendImage(String src, String alt, Value width, Value height, int border, int floatType)
	{
		boolean notFloat = (floatType == Value.FLOAT_NONE);
		checkCaddy(false, notFloat, notFloat);
		
		caddy.append(src, alt, width, height, border, floatType);
		
		// եȤξľɬ statusChanged 򵯤
		if (!notFloat)
			caddy.statusChanged();
	}
	
	/** եȤɲ */
	void appendFloat(Box box)
	{
		checkCaddy(false, false, false);
		
		caddy.append(box);
		
		// եȤξľɬ statusChanged 򵯤
		caddy.statusChanged();
	}
	
	/** եɲ */
	void appendForm(FormItem item)
	{
		checkCaddy(false, true, true);
		
		caddy.append(item);
	}
	
	/** ӤΥ⡼ɤѹ */
	void setRuby(int mode)
	{
		switch (mode) {
		case Constant.RUBY_START:
			commitCaddy();
			checkCaddy(true, true, true);
			break;
		case Constant.RUBY_END:
			caddy.setRuby(Constant.RUBY_END);
			commitCaddy();
			break;
		default:
			caddy.setRuby(mode);
		}
	}
	
	/**  */
	void newLine()
	{
		checkCaddy(false, false, false);
		
		if (!caddy.ruby)
			caddy.append(BR, 0, 1);
		
		lastSpace = LS_BEGIN;
	}
	
	/** ǸιԤꤷɲ */
	void appendLastLine(boolean br, int nextHeight)
	{
//System.out.println("Paragraph.appendLastLine["+lineWidth+","+lineHeight+"]");
		lineMaxHeight += lineHeight;
		if (br) {
			maxHeight = Math.max(maxHeight, lineMaxHeight);
			lineMaxHeight = 0;
		}
		
		// ϡԤ˹Դ֤ɬפ뤬
		// ʤơ֥ǡ֤˷֤ƤޤΤ
		// кMozilla Ǥϡߴ⡼ɤΤ߹Դ̵֤ʤ褦
		if (lineno > 0)
			lineWidth += linePitch;
		
		width  += lineWidth;
		width  += lineOffset;
		height =  Math.max(height, lineHeight);
		lineno++;
		
		widthList .addElement(new Integer(lineWidth  ));
		heightList.addElement(new Integer(lineHeight ));
		offsetList.addElement(new Integer(lineOffset ));
		topList   .addElement(new Integer(floatTop   ));
		bottomList.addElement(new Integer(floatBottom));
		
		lineWidth   = 0;
		lineHeight  = 0;
		lineOffset  = 0;
		linePitch   = 0;
		
		if (floatQueue != null) {
			FloatBlock fb;
			while ((fb = (FloatBlock)floatQueue.get()) != null)
				allocateFloatBlock(fb);
		}
		
		floatTop    = getFloatHeight(FloatChain.TOP   );
		floatBottom = getFloatHeight(FloatChain.BOTTOM);
		floatHeight = floatTop + floatBottom;
		
		// եȤ硢ɬפʹ⤵ݤǤ֤ޤǰư
		if (nextHeight > 0 && floatHeight > 0) {
			int o1 = drawOffsetX + width;
			int o2 = box.getFloatGap(o1, nextHeight, preferredHeight);
			
			if (o1 != o2) {
				linePitch   = o2 - o1;
				floatTop    = box.getFloatHeight(o2, FloatChain.TOP   );
				floatBottom = box.getFloatHeight(o2, FloatChain.BOTTOM);
				floatHeight = floatTop + floatBottom;
			}
		}
	}
	
	/** եȥ֥åɲ */
	void appendFloatBlock(int width, int height, int type, Point offset, int current)
	{
		if (!rearrange) {
			this.height   = Math.max(this.height, height);
			this.hasFloat = true;
			return;
		}
		
		FloatBlock fb = new FloatBlock(width, height, type, offset);
		
		if (lineHeight + current == 0) {
			allocateFloatBlock(fb);
			floatTop    = getFloatHeight(FloatChain.TOP   );
			floatBottom = getFloatHeight(FloatChain.BOTTOM);
			floatHeight = floatTop + floatBottom;
			return;
		}
		
		if (floatQueue == null)
			floatQueue = new Queue();
		
		floatQueue.put(fb);
	}
	
	/** եȥ֥å */
	private void allocateFloatBlock(FloatBlock fb)
	{
		int offset = drawOffsetX;
		
		Point pos = box.addFloat(offset + width,
		                         fb.width, fb.height, fb.type,
		                         preferredHeight);
		
		fb.offset.x = pos.x - offset;
		fb.offset.y = pos.y;
	}
	
	/** ֤Υեȥ֤ */
	int getFloatHeight(int type)
	{
		return box.getFloatHeight(drawOffsetX + width, type);
	}
	
	/** ̤κǽԤꤷλ */
	void commit()
	{
//System.out.println("Paragraph.commit");
		if (caddy != null) {
			caddy.commit();
			caddy = null;
		}
		
		if (lineHeight > 0)
			appendLastLine(true, 0);
	}
	
	/** ơѹ줿 */
	void statusChanged()
	{
		if (caddy == null)
			return;
		
		statusChanged = true;
	}
	
	/** Ԥ */
	void rearrange(int newHeight, boolean force)
	{
		if (!force && !hasFloat && preferredHeight == newHeight)
			return;
		
		rearrange       = true;
		preferredHeight = newHeight;
		
		widthList .removeAllElements();
		heightList.removeAllElements();
		offsetList.removeAllElements();
		topList   .removeAllElements();
		bottomList.removeAllElements();
		lineno = 0;
		width  = 0;
		height = 0;
		lineWidth   = 0;
		lineHeight  = indent;
		lineOffset  = 0;
		linePitch   = 0;
		floatTop    = getFloatHeight(FloatChain.TOP   );
		floatBottom = getFloatHeight(FloatChain.BOTTOM);
		floatHeight = floatTop + floatBottom;
		floatQueue  = null;
		
		Caddy caddy = topCaddy;
		while (caddy != null) {
			caddy.rearrange(newHeight);
			caddy = caddy.next;
		}
		
		commit();
	}
	
	/**  */
	void draw(int x, int y)
	{
//System.out.println("Paragraph.draw");
		if (lineno == 0 && !hasFloat)
			return;
		
		x -= drawOffsetX;
		
		int [] ws = new int[lineno];
		int [] hs = new int[lineno];
		int [] os = new int[lineno];
		int [] ts = new int[lineno];
		int [] bs = new int[lineno];
		for (int i = 0; i < lineno; i++) {
			ws[i] = ((Integer)widthList .elementAt(i)).intValue();
			hs[i] = ((Integer)heightList.elementAt(i)).intValue();
			os[i] = ((Integer)offsetList.elementAt(i)).intValue();
			ts[i] = ((Integer)topList   .elementAt(i)).intValue();
			bs[i] = ((Integer)bottomList.elementAt(i)).intValue();
		}
		
		Position p = new Position(x, y, box.status.align, preferredHeight, ws, hs, os, ts, bs);
		
		if (listStatus != null)
			drawkit.drawListItem(p.x, p.y, listStatus);
		
		p.y += indent;
		
		Caddy caddy = topCaddy;
		while (caddy != null) {
			caddy.draw(p);
			caddy = caddy.next;
		}
	}
	
//### Private
	/** Caddy ̵ɲ */
	private void checkCaddy(boolean ruby, boolean space, boolean changeSpace)
	{
		if (caddy == null) {
			caddy = new Caddy(this, ruby);
			if (topCaddy == null)
				topCaddy = lastCaddy = caddy;
			else
				lastCaddy = lastCaddy.next = caddy;
		} else {
			if (space && lastSpace == LS_TRUE)
				caddy.append(SPACE, 0, 1);
			if (statusChanged) {
				caddy.statusChanged();
				whiteSpace = drawkit.status.whiteSpace;
				reference  = drawkit.status.reference;
			}
		}
		
		if (changeSpace && lastSpace != LS_FALSE)
			lastSpace = LS_FALSE;
	}
	
	/** ߹ԤθǤޤ */
	private void commitCaddy()
	{
		if (caddy == null)
			return;
		
		caddy.commit();
		caddy = null;
	}
	
//### ReservedImage
	/** եȥ֥å */
	private class FloatBlock
	{
		private int   width;
		private int   height;
		private int   type;
		private Point offset;
		
		/** 󥹥󥹤 */
		private FloatBlock(int width, int height, int type, Point offset)
		{
			this.width  = width;
			this.height = height;
			this.type   = type;
			this.offset = offset;
		}
	}
}
