/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import java.io.InputStream;
import java.net.URL;

/**
 * ԤδĶɽޤ
 * Υ󥿡եͳơĶѹޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public interface PanelListener
{
	/**
	 * ꤷ URL ɽޤ
	 * 
	 * @param     url URL
	 * @param     pd  POST Ϥǡ
	 *                POST ǤϤʤ <code>null</code>
	 * @param     newWindow ɥǳ <code>true</code>
	 *                      ʳξ <code>false</code>
	 * @param     extension ĥ⡼ɤǳ <code>true</code>
	 *                      ʳξ <code>false</code>
	 */
	public abstract void openHawk(URL url, PostData pd, boolean newWindow, boolean extension);
	
	/**
	 * ޤ
	 */
	public abstract void back();
	
	/**
	 * 뤫ɤ֤ޤ
	 */
	public abstract boolean canBack();
	
	/**
	 * ؿʤߤޤ
	 */
	public abstract void forward();
	
	/**
	 * ؿʤ뤫ɤ֤ޤ
	 */
	public abstract boolean canForward();
	
	/**
	 * ɹޤ
	 * 
	 * @param     force     åѤʤǳ <code>true</code>
	 *                      ʳξ <code>false</code>
	 */
	public abstract void reload(boolean force);
	
	/**
	 * ɹǤ뤫ɤ֤ޤ
	 */
	public abstract boolean canReload();
	
	/**
	 * ߤޤ
	 */
	public abstract void stop();
	
	/**
	 * ߤǤ뤫ɤ֤ޤ
	 */
	public abstract boolean canStop();
}
