/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Font;
import java.io.Serializable;
import java.util.StringTokenizer;

/**
 * ץɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.5 $
 */
public class Option
	implements Serializable
{
	/** @serial ץåȥȥ꡼ѡ */
	private String inputStreamParser = Resource.getMessage("parser.default", null);
	/** @serial ե륿ѡ */
	private String[] filterParsers = null;
	{
		String names = null;
		
		// ꥽꤫Ͽ
		names = Resource.getMessage("parser.default.filters", null);
		if (names != null) {
			StringTokenizer st = new StringTokenizer(names, ",; ");
			int count = st.countTokens();
			if (count > 0) {
				filterParsers = new String[count];
				int index = 0;
				while (st.hasMoreTokens())
					filterParsers[index++] = st.nextToken();
			}
		}
	}
	/** @serial ǥեȥե */
	private Font     defaultFont         = Font.decode(Resource.getMessage("rendering.font.normal", null));
	/** @serial ǥեե */
	private Font     defaultFixedFont    = Font.decode(Resource.getMessage("rendering.font.fixed" , null));
	/** @serial 1 ԥ뤢Υեȥ */
	private double   fontPerPixel        = 1.2;
	
	/** @serial žʸ */
	private CharList charsSpinRight      = new CharList(Resource.getMessage("chars.spin.right"  , null));
	/** @serial ˰ưʸ */
	private CharList charsSpinLtrb       = new CharList(Resource.getMessage("chars.spin.ltrb"   , null));
	/** @serial Ƭػʸ */
	private CharList charsKinsokuHead    = new CharList(Resource.getMessage("chars.kinsoku.head", null));
	/** @serial ػʸ */
	private CharList charsKinsokuTail    = new CharList(Resource.getMessage("chars.kinsoku.tail", null));
	
	/** @serial ɤ뤫ɤ */
	private boolean  loadImage           = true;
	/** @serial Сɽ뤫ɤ */
	private boolean  showScrollbar       = true;
	/** @serial GIF ž뤫ɤ */
	private boolean  spinGifImage        = false;
	/** @serial GIF žĲ */
	private double   spinGifAspectRatio  = 1.35;
	/** @serial GIF ž */
	private int      spinGifMinWidth     = 50;
	/** @serial JPEG ž뤫ɤ */
	private boolean  spinJpegImage       = false;
	/** @serial JPEG žĲ */
	private double   spinJpegAspectRatio = 2.0;
	/** @serial JPEG ž */
	private int      spinJpegMinWidth    = 50;
	/** @serial ƥȽ饤򴹤뤫 */
	private boolean  swapDecoration      = false;
	
	/**
	 * ץޤ
	 */
	public Option()
	{
	}
	
	/**
	 * ץåȥȥ꡼ѡ֤ޤ
	 * 
	 * @return    ץåȥȥ꡼ѡ
	 */
	public synchronized String getInputStreamParser()
	{
		return inputStreamParser;
	}
	
	/**
	 * ץåȥȥ꡼ѡꤷޤ
	 * 
	 * @param     value ץåȥȥ꡼ѡ
	 */
	public synchronized void setInputStreamParser(String value)
	{
		inputStreamParser = value;
	}
	
	/**
	 * ե륿ѡ֤ޤ
	 * 
	 * @return    ե륿ѡ
	 */
	public synchronized String[] getFilterParsers()
	{
		return filterParsers;
	}
	
	/**
	 * ե륿ѡꤷޤ
	 * 
	 * @param     value ե륿ѡ
	 */
	public synchronized void setFilterParsers(String[] value)
	{
		filterParsers = value;
	}
	
	/**
	 * ѤǥեȥեȤ֤ޤ
	 * 
	 * @return    Ѥǥեȥե
	 */
	public Font getDefaultFont()
	{
		return defaultFont;
	}
	
	/**
	 * ѤǥեȥեȤꤷޤ
	 * 
	 * @param     font Ѥǥեȥե
	 */
	public void setDefaultFont(Font font)
	{
		defaultFont = font;
	}
	
	/**
	 * ѤǥեեȤ֤ޤ
	 * 
	 * @return    Ѥǥեե
	 */
	public Font getDefaultFixedFont()
	{
		return defaultFixedFont;
	}
	
	/**
	 * ѤǥեեȤꤷޤ
	 * 
	 * @param     font Ѥǥեե
	 */
	public void setDefaultFixedFont(Font font)
	{
		defaultFixedFont = font;
	}
	
	/**
	 * 1 ԥ뤢Υեȥ֤ޤ
	 * 
	 * @return    1 ԥ뤢Υեȥ
	 */
	public double getFontPerPixel()
	{
		return fontPerPixel;
	}
	
	/**
	 * 1 ԥ뤢Υեȥꤷޤ
	 * 
	 * @param     d 1 ԥ뤢Υեȥ
	 */
	public void setFontPerPixel(double d)
	{
		fontPerPixel = d;
	}
	
	/**
	 * žʸΥϥåơ֥֤ޤ
	 * 
	 * @return    žʸΥϥåơ֥
	 */
	public synchronized CharList getCharsSpinRight()
	{
		return charsSpinRight;
	}
	
	/**
	 * žʸΥꥹȤꤷޤ
	 * 
	 * @param     list žʸΥꥹ
	 */
	public synchronized void setCharsSpinRight(CharList list)
	{
		charsSpinRight = list;
	}
	
	/**
	 * ˰ưʸΥϥåơ֥֤ޤ
	 * 
	 * @return    ˰ưʸΥϥåơ֥
	 */
	public synchronized CharList getCharsSpinLtrb()
	{
		return charsSpinLtrb;
	}
	
	/**
	 * ˰ưʸΥꥹȤꤷޤ
	 * 
	 * @param     list ˰ưʸΥꥹ
	 */
	public synchronized void setCharsSpinLtrb(CharList list)
	{
		charsSpinLtrb = list;
	}
	
	/**
	 * ƬػʸΥϥåơ֥֤ޤ
	 * 
	 * @return    ƬػʸΥϥåơ֥
	 */
	public synchronized CharList getCharsKinsokuHead()
	{
		return charsKinsokuHead;
	}
	
	/**
	 * ƬػʸΥꥹȤꤷޤ
	 * 
	 * @param     list ƬػʸΥꥹ
	 */
	public synchronized void setCharsKinsokuHead(CharList list)
	{
		charsKinsokuHead = list;
	}
	
	/**
	 * ػʸΥϥåơ֥֤ޤ
	 * 
	 * @return    ػʸΥϥåơ֥
	 */
	public synchronized CharList getCharsKinsokuTail()
	{
		return charsKinsokuTail;
	}
	
	/**
	 * ػʸΥꥹȤꤷޤ
	 * 
	 * @param     list ػʸΥꥹ
	 */
	public synchronized void setCharsKinsokuTail(CharList list)
	{
		charsKinsokuTail = list;
	}
	
	/**
	 * ɤ뤫ɤ֤ޤ
	 * 
	 * @return    ɤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean getLoadImage()
	{
		return loadImage;
	}
	
	/**
	 * ɤ뤫ɤꤷޤ
	 * 
	 * @param     value ɤ <code>true</code>
	 *                  ʳξ <code>false</code>
	 */
	public synchronized void setLoadImage(boolean value)
	{
		loadImage = value;
	}
	
	/**
	 * Сɽ뤫ɤ֤ޤ
	 * 
	 * @return    ɽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean getShowScrollbar()
	{
		return showScrollbar;
	}
	
	/**
	 * Сɽ뤫ɤꤷޤ
	 * 
	 * @param     value ɽ <code>true</code>
	 *                  ʳξ <code>false</code>
	 */
	public synchronized void setShowScrollbar(boolean value)
	{
		showScrollbar = value;
	}
	
	/**
	 * GIF žɽ뤫ɤ֤ޤ
	 * 
	 * @return    ž <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean getSpinGifImage()
	{
		return spinGifImage;
	}
	
	/**
	 * GIF žɽ뤫ɤꤷޤ
	 * 
	 * @param     value ž <code>true</code>
	 *                  ʳξ <code>false</code>
	 */
	public synchronized void setSpinGifImage(boolean value)
	{
		spinGifImage = value;
	}
	
	/**
	 * GIF žĲ֤ޤ
	 * 
	 * @return    žνĲ
	 */
	public synchronized double getSpinGifAspectRatio()
	{
		return spinGifAspectRatio;
	}
	
	/**
	 * GIF žĲꤷޤ
	 * 
	 * @param     value žνĲ
	 */
	public synchronized void setSpinGifAspectRatio(double value)
	{
		spinGifAspectRatio = value;
	}
	
	/**
	 * GIF ɬž֤ޤ
	 * 
	 * @return    žκ
	 */
	public synchronized int getSpinGifMinWidth()
	{
		return spinGifMinWidth;
	}
	
	/**
	 * GIF ɬžꤷޤ
	 * 
	 * @param     value žκ
	 */
	public synchronized void setSpinGifMinWidth(int value)
	{
		spinGifMinWidth = value;
	}
	
	/**
	 * JPEG žɽ뤫ɤ֤ޤ
	 * 
	 * @return    ž <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean getSpinJpegImage()
	{
		return spinJpegImage;
	}
	
	/**
	 * JPEG žɽ뤫ɤꤷޤ
	 * 
	 * @param     value ž <code>true</code>
	 *                  ʳξ <code>false</code>
	 */
	public synchronized void setSpinJpegImage(boolean value)
	{
		spinJpegImage = value;
	}
	
	/**
	 * JPEG žĲ֤ޤ
	 * 
	 * @return    žνĲ
	 */
	public synchronized double getSpinJpegAspectRatio()
	{
		return spinJpegAspectRatio;
	}
	
	/**
	 * JPEG žĲꤷޤ
	 * 
	 * @param     value žνĲ
	 */
	public synchronized void setSpinJpegAspectRatio(double value)
	{
		spinJpegAspectRatio = value;
	}
	
	/**
	 * JPEG ɬž֤ޤ
	 * 
	 * @return    žκ
	 */
	public synchronized int getSpinJpegMinWidth()
	{
		return spinJpegMinWidth;
	}
	
	/**
	 * JPEG ɬžꤷޤ
	 * 
	 * @param     value žκ
	 */
	public synchronized void setSpinJpegMinWidth(int value)
	{
		spinJpegMinWidth = value;
	}
	
	/**
	 * ƥȽ饤κؤ뤫ɤ֤ޤ
	 * 
	 * @return    ؤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public synchronized boolean getSwapDecoration()
	{
		return swapDecoration;
	}
	
	/**
	 * ƥȽ饤κؤ뤫ɤꤷޤ
	 * 
	 * @param     value ؤ <code>true</code>
	 *                  ʳξ <code>false</code>
	 */
	public synchronized void setSwapDecoration(boolean value)
	{
		swapDecoration = value;
	}
}
