/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

import java.awt.Dimension;
import java.awt.Point;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Vector;

/**
 * ̾Υƥΰ֤ɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class ItemMap
{
	private Reporter  reporter = null;
	
	private Vector    hrefMap  = new Vector();
	private Vector    imageMap = new Vector();
	private Vector    tipMap   = new Vector();
	private Vector    infoMap  = new Vector();
	private Hashtable idMap    = new Hashtable();
	
	/**
	 * ޥåפޤ
	 */
	ItemMap(Reporter reporter)
	{
		this.reporter = reporter;
	}
	
	/** ɲ (1 = , 2 = , x1, x2 ϲ̱εΥ) */
	synchronized void addHref(int x1, int y1, int x2, int y2, URL url)
	{
		hrefMap.addElement(new InfoRectangle(x1, y1, x2, y2, url));
	}
	
	/** ֤ɲ (1 = , 2 = , x1, x2 ϲ̱εΥ) */
	synchronized void addImage(int x1, int y1, int x2, int y2, URL url)
	{
		imageMap.addElement(new InfoRectangle(x1, y1, x2, y2, url));
	}
	
	/**
	 * ꤵ줿֤Υ URL ֤ޤ
	 * 
	 * @param     x X ɸ
	 * @param     y Y ɸ
	 * 
	 * @return    
	 */
	public synchronized URL getLinkURL(int x, int y)
	{
		InfoRectangle ir = null;
		
		for (int i = 0; i < hrefMap.size(); i++) {
			ir = (InfoRectangle)hrefMap.elementAt(i);
			if (ir.isInner(x, y))
				return (URL)ir.info;
		}
		
		return null;
	}
	
	/**
	 * ꤵ줿֤β URL ֤ޤ
	 * 
	 * @param     x X ɸ
	 * @param     y Y ɸ
	 * 
	 * @return    
	 */
	public synchronized URL getImageURL(int x, int y)
	{
		InfoRectangle ir = null;
		
		for (int i = 0; i < imageMap.size(); i++) {
			ir = (InfoRectangle)imageMap.elementAt(i);
			if (ir.isInner(x, y))
				return (URL)ir.info;
		}
		
		return null;
	}
	
	/** ɲ (1 = , 2 = , x1, x2 ϲ̱εΥ) */
	synchronized void addTip(int x1, int y1, int x2, int y2, String tip)
	{
		tipMap.addElement(new InfoRectangle(x1, y1, x2, y2, tip));
	}
	
	/**
	 * ꤵ줿֤ʸ֤ޤ
	 * 
	 * @param     x X ɸ
	 * @param     y Y ɸ
	 * 
	 * @return    ʸ
	 */
	public synchronized String getTip(int x, int y)
	{
		InfoRectangle ir = null;
		
		for (int i = 0; i < tipMap.size(); i++) {
			ir = (InfoRectangle)tipMap.elementAt(i);
			if (ir.isInner(x, y))
				return (String)ir.info;
		}
		
		return null;
	}
	
	/** ɲ (1 = , 2 = , x1, x2 ϲ̱εΥ) */
	synchronized void addInfo(int x1, int y1, int x2, int y2, String tip)
	{
		infoMap.addElement(new InfoRectangle(x1, y1, x2, y2, tip));
	}
	
	/**
	 * ꤵ줿֤ξʸ֤ޤ
	 * 
	 * @param     x X ɸ
	 * @param     y Y ɸ
	 * 
	 * @return    ʸ
	 */
	public synchronized String getInfo(int x, int y)
	{
		InfoRectangle ir = null;
		
		for (int i = 0; i < infoMap.size(); i++) {
			ir = (InfoRectangle)infoMap.elementAt(i);
			if (ir.isInner(x, y))
				return (String)ir.info;
		}
		
		return null;
	}
	
	/** ID ΰ֤ɲ (x ϲ̱εΥ) */
	synchronized void addId(String id, int x, int y)
	{
		if (idMap.containsKey(id)) {
			reporter.report(Reporter.WARNING,
			                Resource.getMessage("render.warning.id.duplicate",
			                                    new String[]{id}), 0, 0);
			return;
		}
		idMap.put(id, new Point(x, y));
	}
	
	/**
	 * ꤵ줿 ID ΰ֤֤ޤ
	 * ֤ϱ夫εΥǤ
	 * 
	 * @param     id ID
	 * 
	 * @return    ID ΰ
	 */
	public synchronized Point getIdPoint(String id)
	{
		Point p = (Point)idMap.get(id);
		if (p == null)
			return null;
		
		return new Point(p.x, p.y);
	}
	
//### InfoRectangle
	// 󥯰
	private class InfoRectangle
	{
		private int    x1   = 0;
		private int    y1   = 0;
		private int    x2   = 0;
		private int    y2   = 0;
		private Object info = null;
		
		/** 󥹥󥹤 */
		private InfoRectangle(int x1, int y1, int x2, int y2, Object info)
		{
			this.x1   = x1;
			this.y1   = y1;
			this.x2   = x2;
			this.y2   = y2;
			this.info = info;
		}
		
		/** ꤵ줿ɸ¦å */
		private boolean isInner(int x, int y)
		{
			return (x1 <= x && x <= x2 && y1 <= y && y <= y2);
		}
	}
}
