/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

import java.awt.Image;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;

/**
 * å륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
class ImageCache
{
	private static Object    cacheLock = new Object   ();
	private static Hashtable oldCache  = new Hashtable();
	private static Hashtable newCache  = new Hashtable();
	private static Hashtable typeCache = new Hashtable();
	
	/** 󥹥󥹤 */
	private ImageCache()
	{
	}
	
	/**
	 * ޤ
	 * 
	 * @param     context 륳ƥ
	 * @param     url URL
	 * @param     src URL ΥѤʸ
	 * @param     create å¸ߤʤ硢url 
	 *                   <code>true</code>ʳξ <code>false</code>
	 * 
	 * @return    create  <code>false</code> ǥå¸ߤʤ
	 *            ʤä <code>null</code>
	 * 
	 * @exception IOException IO 顼ȯ
	 */
	static Image getImage(HawkContext context, URL url, String src, boolean create)
		throws IOException
	{
		synchronized (cacheLock) {
			Image image = null;
			
			image = (Image)newCache.get(url);
			if (image != null)
				return image;
			
			image = (Image)oldCache.get(url);
			if (image != null) {
				newCache.put(url, image);
				oldCache.remove(url);
				return image;
			}
			
			// 
			//  ʤСsynchronized (cacheLock) ν򡢤Υ᥽åɤ
			//  Ǹ˻äƤ٤Microsoft JavaVM ȡǤޤäƤޤ
			//  ʤΤǾࡣ
		}
		
		if (!create)
			return null;
		
		// åˤʤϡɤ߹
		URLConnection connection = context.getURLConnection(url, null);
		if (connection != null)
			return createImage(context, url, src, connection);
		
		reportMessage(context, Reporter.INFO, "render.info.image.null", new String[]{src});
		return null;
	}
	
	/**
	 * ޤ
	 * ϥå˳Ǽޤ
	 * 
	 * @param     context 륳ƥ
	 * @param     url URL
	 * @param     src URL ΥѤʸ
	 * @param     connection Υͥ󤫤ޤ
	 * 
	 * @return    ʤä <code>null</code>
	 * 
	 * @exception IOException IO 顼ȯ
	 */
	static Image createImage(HawkContext context, URL url, String src, URLConnection connection)
		throws IOException
	{
		Object content = null;
		
		try {
			content = connection.getContent();
		} catch (Exception e) {
			reportMessage(context, Reporter.WARNING, "render.warning.image.content", new String[]{src});
			return null;
		}
		
		if (content instanceof ImageProducer) {
			String type = connection.getContentType();
			if (type != null)
				typeCache.put(url, type.toLowerCase());
			
			Image image = context.createImage((ImageProducer)content);
			synchronized (cacheLock) {
				newCache.put(url, image);
			}
			return image;
		}
		
		reportMessage(context, Reporter.WARNING, "render.warning.image.invalid", new String[]{src});
		return null;
	}
	
	/**
	 * ꤷ URL Υƥĥפޤ
	 * ٥ɤȤΤ URL ФƤΤͭǤ
	 * 
	 * @param     url URL
	 * 
	 * @return    ƥĥסɤȤΤʤ <code>null</code>
	 */
	static String getContentType(URL url)
	{
		return (String)typeCache.get(url);
	}
	
	/**
	 * å򥯥ꥢޤ
	 */
	static void clear()
	{
		synchronized (cacheLock) {
			if (oldCache.size() > 0) {
				for (Enumeration e = oldCache.elements(); e.hasMoreElements(); )
					((Image)e.nextElement()).flush();
				oldCache.clear();
			}
			
			if (newCache.size() > 0) {
				oldCache = newCache;
				newCache = new Hashtable();
			}
		}
	}
	
	/** ݡ˥åޤ */
	private static void reportMessage(HawkContext context, int type, String key, String[] args)
	{
		Reporter reporter = context.getReporter();
		if (reporter != null)
			reporter.report(type, Resource.getMessage(key, args), 0, 0);
	}
}
