/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ToolTip;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.util.Environment;

import java.awt.CheckboxMenuItem;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.MediaTracker;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.net.URL;
import java.util.Vector;

/**
 * 襭ѥѥڥǤ
 * ϲ̱νĽɽʤΤǡ
 * ꥵʤɤԤޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
public class HawkPanel
	extends Panel
{
	private static final long RESIZE_WAIT = 10000;
	private static final long TIP_DELAY   =   800;
	private static final int  TIP_BOTTOM  =    22;
	
	private static final int MENU_MENU  = 0;
	private static final int MENU_ITEM  = 1;
	private static final int MENU_CHECK = 2;
	
	private static final int    MENU_SEPARATOR                  = -1;
	/** ᥤ˥塼 */
	public  static final String MENU_MAIN_BACK                  =  "canvas.menu.main.back";
	private static final int    MENU_MAIN_BACK_INDEX            =  2;
	/** ᥤ󡦼ؿʤ˥塼 */
	public  static final String MENU_MAIN_FORWARD               =  "canvas.menu.main.forward";
	private static final int    MENU_MAIN_FORWARD_INDEX         =  3;
	/** ᥤߥ˥塼 */
	public  static final String MENU_MAIN_STOP                  =  "canvas.menu.main.stop";
	private static final int    MENU_MAIN_STOP_INDEX            =  4;
	/** ᥤ󡦺ɹ˥塼 */
	public  static final String MENU_MAIN_RELOAD                =  "canvas.menu.main.reload";
	private static final int    MENU_MAIN_RELOAD_INDEX          =  5;
	/** ᥤ󡦥ץ˥塼 */
	public  static final String MENU_MAIN_OPTION                =  "canvas.menu.main.option";
	private static final int    MENU_MAIN_OPTION_INDEX          =  7;
	/** ᥤ󡦥ץ󡦲ɤ߹ޤʤ˥塼 */
	public  static final String MENU_MAIN_OPTION_IMAGE          =  "canvas.menu.main.option.image";
	private static final int    MENU_MAIN_OPTION_IMAGE_INDEX    =  8;
	/** ᥤ󡦥ץ󡦥Сɽ˥塼 */
	public  static final String MENU_MAIN_OPTION_BAR            =  "canvas.menu.main.option.bar";
	private static final int    MENU_MAIN_OPTION_BAR_INDEX      =  9;
	/** ᥤ󡦥ץGIF ž˥塼 */
	public  static final String MENU_MAIN_OPTION_SPINGIF        = "canvas.menu.main.option.spingif";
	private static final int    MENU_MAIN_OPTION_SPINGIF_INDEX  = 10;
	/** ᥤ󡦥ץJPEG ž˥塼 */
	public  static final String MENU_MAIN_OPTION_SPINJPEG       = "canvas.menu.main.option.spinjpeg";
	private static final int    MENU_MAIN_OPTION_SPINJPEG_INDEX = 11;
	/** ᥤ󡦾˥塼 */
	public  static final String MENU_MAIN_INFO                  = "canvas.menu.main.info";
	private static final int    MENU_MAIN_INFO_INDEX            = 12;
	/** 󥯡 URL 򥳥ԡ˥塼 */
	public  static final String MENU_LINK_COPY                  = "canvas.menu.link.copy";
	private static final int    MENU_LINK_COPY_INDEX            = 24;
	/** ɽ˥塼 */
	public  static final String MENU_IMAGE_OPEN                 = "canvas.menu.image.open";
	private static final int    MENU_IMAGE_OPEN_INDEX           = 32;
	/**  URL 򥳥ԡ˥塼 */
	public  static final String MENU_IMAGE_COPY                 = "canvas.menu.image.copy";
	private static final int    MENU_IMAGE_COPY_INDEX           = 33;
	
	private static final int    MENU_SIZE                       = 34;
	
	/** Υ */
	public  static final int SCROLL_HORIZONTAL = 1;
	/** Υ */
	public  static final int SCROLL_VERTICAL   = 2;
	/** ˥åñ̤ǤΥ */
	public  static final int SCROLL_UNIT       = 0;
	/** ֥åñ̤ǤΥ */
	public  static final int SCROLL_BLOCK      = 1;
	
	
	//### 
	/** @serial 륳ƥ */
	private HawkContext    hawkContext;
	/** @serial ץ */
	private Option         option;
	/** @serial 쥤 */
	private GridBagLayout  gbl;
	/** @serial 륭ѥ */
	private Canvas         canvas;
	/** @serial С */
	private FixedScrollbar horizontal;
	/** @serial ĥС */
	private FixedScrollbar vertical;
	/** @serial ġå */
	private ToolTip        toolTip;
	
	//### 
	/** @serial ѥ */
	private Dimension  canvasSize;
	/** @serial ӥ塼ݡȥ */
	private Dimension  viewportSize;
	/** @serial 褹뱦ΰ */
	private Point      position;
	
	//### ˥塼
	/** @serial ƥȥ˥塼 */
	private PopupMenu  popupMenu;
	/** @serial ƥȥ˥塼ƥ */
	private MenuItem[] menuItems;
	/** @serial ᥤΥ˥塼ƥ */
	private Vector     mainMenuItems  = new Vector();
	/** @serial 󥯤Υ˥塼ƥ */
	private Vector     linkMenuItems  = new Vector();
	/** @serial ᡼Υ˥塼ƥ */
	private Vector     imageMenuItems = new Vector();
	
	//### 
	/** @serial ʸȹ⤵ */
	private Dimension     charScale;
	/** @serial ꥹ */
	private PanelListener listener;
	
	//### 
	/** @serial å */
	private Object cursorLock          = new Object();
	/** @serial ǥեȤΥ륿 */
	private int    defaultCursorType   = Cursor.DEFAULT_CURSOR;
	/** @serial Ūʥ륿 */
	private int    temporaryCursorType = Cursor.DEFAULT_CURSOR;
	/** @serial ɽΥ륿 */
	private int    cursorType          = Cursor.DEFAULT_CURSOR;
	
	//### 󥯡ݥåץåץƥ
	/** @serial Υ */
	private URL     currentLink;
	/** @serial β */
	private URL     currentImage;
	/** @serial ƥޥå */
	private ItemMap itemMap;
	
	//### ¾
	/** @serial 롼 */
	private boolean callRequestFocus;
	
	/**
	 * 襭ѥѥڥޤ
	 */
	public HawkPanel(HawkContext hawkContext)
	{
		this.hawkContext  = hawkContext;
		this.option       = hawkContext.getOption();
		this.gbl          = new GridBagLayout();
		this.canvas       = new Canvas       ();
		this.horizontal   = new FixedScrollbar(Scrollbar.HORIZONTAL);
		this.vertical     = new FixedScrollbar(Scrollbar.VERTICAL  );
		this.canvasSize   = new Dimension(0, 0);
		this.viewportSize = new Dimension(0, 0);
		this.position     = new Point    (0, 0);
		this.charScale    = new Dimension(0, 0);
		
		// ̤
		setLayout(gbl);
		GridBagConstraints gbc = new GridBagConstraints();
		addComponent(canvas, gbl, gbc, 1.0, 0, 0, GridBagConstraints.BOTH      );
		if (option.getShowScrollbar())
			fixScrollbar(true, false);
		
		setScale(new Dimension(20, 20));
		super.setBackground(SystemColor.control);
		
		// ˥塼
		initMenu();
		
		// ꥹʡ
		addFocusListener(
			new FocusAdapter()
			{
				public void focusGained(FocusEvent e)
				{
					canvas.requestFocus();
				}
			}
		);
		
		canvas.addKeyListener        (new HawkCanvasKeyListener        ());
		canvas.addMouseListener      (new HawkCanvasMouseListener      ());
		canvas.addMouseMotionListener(new HawkCanvasMouseMotionListener());
		canvas.addComponentListener  (new HawkCanvasComponentListener  ());
	}
	
	/** ȥɲäޤ */
	private void addComponent(Component c, GridBagLayout gbl, GridBagConstraints gbc,
	                          double weight, int x, int y, int fill)
	{
		gbc.gridx   = x;
		gbc.gridy   = y;
		gbc.weightx = weight;
		gbc.weighty = weight;
		gbc.fill    = fill;
		gbl.setConstraints(c, gbc);
		add(c);
	}
	
	/** ˥塼 */
	private void initMenu()
	{
		Menu menu = null;
		menuItems = new MenuItem[MENU_SIZE];
		popupMenu = new PopupMenu(Resource.getMessage("canvas.menu", null));
		canvas.add(popupMenu);
		
		// ᥤ˥塼
		createMenuItem(MENU_MAIN_BACK_INDEX           , MENU_ITEM , null, mainMenuItems );
		createMenuItem(MENU_MAIN_FORWARD_INDEX        , MENU_ITEM , null, mainMenuItems );
		createMenuItem(MENU_SEPARATOR                 , MENU_ITEM , null, mainMenuItems );
		createMenuItem(MENU_MAIN_STOP_INDEX           , MENU_ITEM , null, mainMenuItems );
		createMenuItem(MENU_MAIN_RELOAD_INDEX         , MENU_ITEM , null, mainMenuItems );
		createMenuItem(MENU_SEPARATOR                 , MENU_ITEM , null, mainMenuItems );
		menu = (Menu)
		createMenuItem(MENU_MAIN_OPTION_INDEX         , MENU_MENU , null, mainMenuItems );
		createMenuItem(MENU_MAIN_OPTION_IMAGE_INDEX   , MENU_CHECK, menu, null          );
		createMenuItem(MENU_MAIN_OPTION_BAR_INDEX     , MENU_CHECK, menu, null          );
		createMenuItem(MENU_MAIN_OPTION_SPINGIF_INDEX , MENU_CHECK, menu, null          );
		createMenuItem(MENU_MAIN_OPTION_SPINJPEG_INDEX, MENU_CHECK, menu, null          );
		//### TODO
//		createMenuItem(MENU_MAIN_INFO_INDEX           , MENU_ITEM , null, mainMenuItems );
		
		// 󥯥˥塼
		createMenuItem(MENU_LINK_COPY_INDEX           , MENU_ITEM , null, linkMenuItems );
		
		// ˥塼
		createMenuItem(MENU_IMAGE_OPEN_INDEX          , MENU_ITEM , null, imageMenuItems);
		createMenuItem(MENU_IMAGE_COPY_INDEX          , MENU_ITEM , null, imageMenuItems);
	}
	
	/** ˥塼ܤ */
	private MenuItem createMenuItem(int index, int type, Menu parent, Vector items)
	{
		String menuKey = null;
		
		/// MENU
		switch (index) {
		case MENU_SEPARATOR                 : break;
		case MENU_MAIN_BACK_INDEX           : menuKey = MENU_MAIN_BACK           ; break;
		case MENU_MAIN_FORWARD_INDEX        : menuKey = MENU_MAIN_FORWARD        ; break;
		case MENU_MAIN_STOP_INDEX           : menuKey = MENU_MAIN_STOP           ; break;
		case MENU_MAIN_RELOAD_INDEX         : menuKey = MENU_MAIN_RELOAD         ; break;
		case MENU_MAIN_OPTION_INDEX         : menuKey = MENU_MAIN_OPTION         ; break;
		case MENU_MAIN_OPTION_IMAGE_INDEX   : menuKey = MENU_MAIN_OPTION_IMAGE   ; break;
		case MENU_MAIN_OPTION_BAR_INDEX     : menuKey = MENU_MAIN_OPTION_BAR     ; break;
		case MENU_MAIN_OPTION_SPINGIF_INDEX : menuKey = MENU_MAIN_OPTION_SPINGIF ; break;
		case MENU_MAIN_OPTION_SPINJPEG_INDEX: menuKey = MENU_MAIN_OPTION_SPINJPEG; break;
		case MENU_MAIN_INFO_INDEX           : menuKey = MENU_MAIN_INFO           ; break;
		case MENU_LINK_COPY_INDEX           : menuKey = MENU_LINK_COPY           ; break;
		case MENU_IMAGE_OPEN_INDEX          : menuKey = MENU_IMAGE_OPEN          ; break;
		case MENU_IMAGE_COPY_INDEX          : menuKey = MENU_IMAGE_COPY          ; break;
		default:
			Reporter reporter = hawkContext.getReporter();
			if (reporter != null)
				reporter.report(Reporter.ERROR, Resource.getMessage("internal.error", new String[]{"HawkPanel.createMenuItem", "panel menu", ""}), 0, 0);
			return null;
		}
		
		String label = (menuKey == null ? "-" : Resource.getMessage(menuKey, null));
		MenuItem mi = null;
		switch (type) {
		case MENU_MENU:
			mi = new Menu(label);
			break;
		case MENU_ITEM:
			mi = new MenuItem(label);
			if (index != MENU_SEPARATOR)
				mi.addActionListener(new MenuActionListner(index));
			break;
		case MENU_CHECK:
			mi = new CheckboxMenuItem(label);
			((CheckboxMenuItem)mi).addItemListener(new MenuActionListner(index));
			break;
		}
		
		mi.setActionCommand(menuKey != null ? menuKey : "-");
		
		if (index != MENU_SEPARATOR)
			menuItems[index] = mi;
		
		if (parent != null)
			parent.add(mi);
		if (items != null)
			items.addElement(mi);
		
		return mi;
	}
	
//### Original Method
	/**
	 * 뤷ڥΥӥ塼ݡȤ 0, 0 ֤ɽθߤ
	 * 夫 x, y ֤֤ޤ
	 * 
	 * @return    ߤΥ֤α夫κɸ
	 */
	public Point getScrollPosition()
	{
		return new Point(position.x, position.y);
	}
	
	/**
	 * ҥݡͥλꤵ줿֤إ뤷ޤ
	 * ֤ϱ夫εΥˤʤޤ
	 * 
	 * @param     x  x 
	 * @param     y  y 
	 */
	public void setScrollPosition(int x, int y)
	{
		synchronized (canvasSize) {
			x = Math.max(Math.min(x, canvasSize.width  - viewportSize.width ), 0);
			y = Math.max(Math.min(y, canvasSize.height - viewportSize.height), 0);
			
			if (position.x == x && position.y == y)
				return;
			
			position.x = x;
			position.y = y;
			
			horizontal.setValue(horizontal.getMaximum() - horizontal.getVisibleAmount() - x);
			vertical  .setValue(y);
			
			canvas.movePosition(x, y);
		}
	}
	
	/**
	 * ᥤΥ˥塼ƥ֤ޤ
	 * 
	 * @return    ᥤ˥塼ƥ
	 */
	public Vector getMainMenuItems()
	{
		return mainMenuItems;
	}
	
	/**
	 * 󥯤Υ˥塼ƥ֤ޤ
	 * 
	 * @return    󥯥˥塼ƥ
	 */
	public Vector getLinkMenuItems()
	{
		return linkMenuItems;
	}
	
	/**
	 * ᡼Υ˥塼ƥ֤ޤ
	 * 
	 * @return    ᡼˥塼ƥ
	 */
	public Vector getImageMenuItems()
	{
		return imageMenuItems;
	}
	
	/**
	 * СɽƤ뤫ɤ֤ޤ
	 * 
	 * @return    ɽƤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean isVisibleScrollbar()
	{
		synchronized (canvasSize) {
			return horizontal.added;
		}
	}
	
	/**
	 * Сɽ뤫ɤꤷޤ
	 * 
	 * @param     b ɽ <code>true</code>
	 *              ʳξ <code>false</code>
	 */
	public void setVisibleScrollbar(boolean b)
	{
		synchronized (canvasSize) {
			// ľСϡʿСɽȤ˥ɥȤɹƼưɽ
			fixScrollbar(b, (b ? vertical.added : false));
			option.setShowScrollbar(b);
		}
	}
	
	/**
	 * ѥͥꥹʤϿޤ
	 * 
	 * @param     listener ѥͥꥹ
	 */
	public void setPanelListener(PanelListener listener)
	{
		this.listener = listener;
	}
	
	/**
	 * ǥȥå֤ޤ
	 * 
	 * @return    ǥȥå
	 */
	public MediaTracker getMediaTracker()
	{
		return new MediaTracker(canvas);
	}
	
	/**
	 * ꡼󥤥᡼ɲäޤ
	 * 
	 * @param     image ꡼󥤥᡼
	 * @param     size ꡼󥤥᡼Υ
	 */
	public void addImage(Image image, Dimension size)
	{
		synchronized (canvasSize) {
			canvasSize.width  += size.width;
			canvasSize.height =  Math.max(size.height, canvasSize.height);
			
			horizontal.setMaximum(canvasSize.width );
			vertical  .setMaximum(canvasSize.height);
			
			canvas.addImage(image, size);
			
			if (horizontal.added && canvasSize.height > viewportSize.height && !vertical.added)
				fixScrollbar(true, true);
		}
	}
	
	/**
	 * եॢƥɲäޤ
	 * 
	 * @param     item եॢƥ
	 */
	public void addFormItem(FormItem item)
	{
		canvas.addFormItem(item);
	}
	
	/**
	 * ѥ򥯥ꥢޤ
	 */
	public void cleanCanvas()
	{
		synchronized (canvasSize) {
			canvas.cleanScreen();
			itemMap = null;
			canvasSize.width  = 0;
			canvasSize.height = 0;
			position.x = 0;
			position.y = 0;
			horizontal.setMaximum(0);
			vertical  .setMaximum(0);
		}
		
		// С֤Ʊ
		if (horizontal.added != option.getShowScrollbar() || vertical.added) {
			synchronized (viewportSize) {
				fixScrollbar(option.getShowScrollbar(), false);
				try {
					viewportSize.wait(RESIZE_WAIT);
				} catch (InterruptedException e) {}
			}
			
			setTemporaryCursor(Cursor.DEFAULT_CURSOR);
		}
	}
	
	/**
	 * ѥϰϤꤷƺɽޤ
	 * ɸϱ夫εΥǤ
	 * 
	 * @param     x ѥα顢ɽ֤αüεΥ
	 * @param     y ѥξ夫顢ɽ֤ξüεΥ
	 * @param     width  ɽϰϤ
	 * @param     height ɽϰϤι⤵
	 */
	public void repaintCanvas(int x, int y, int width, int height)
	{
		synchronized (canvasSize) {
			if (canvasSize.width < x || canvasSize.height < y)
				return;
			
			canvas.repaintImage(x, y, width, height);
		}
	}
	
	/**
	 * ѤιԤȡʸι⤵ꤷޤ
	 * {@link java.awt.Dimension#width} Ԥ
	 * {@link java.awt.Dimension#height} ʸι⤵ɽޤ
	 * 
	 * @param     scale ȹ⤵
	 */
	public void setScale(Dimension scale)
	{
		synchronized (canvasSize) {
			this.charScale = scale;
			horizontal.setUnitIncrement (scale.width );
			vertical  .setUnitIncrement (scale.height);
			horizontal.setBlockIncrement(viewportSize.width  - charScale.width );
			vertical  .setBlockIncrement(viewportSize.height - charScale.height);
		}
	}
	
	/**
	 * ƥޥåפꤷޤ
	 * 
	 * @param     map ƥޥå
	 */
	public void setItemMap(ItemMap map)
	{
		this.itemMap = map;
	}
	
	/**
	 * ꤷޤ
	 * 
	 * @param     cursor 
	 */
	public void setCursor(int cursor)
	{
		setCursor(Cursor.getPredefinedCursor(cursor));
	}
	
	/**
	 * ڥΥӥ塼ݡȤθߤΥ֤ޤ
	 * 
	 * @return    ԥñ̤Υӥ塼ݡȤΥ
	 */
	public Dimension getViewportSize()
	{
		synchronized (viewportSize) {
			// ޤ֤λƤʤϡִλԤ
			if (viewportSize.width  == 0 &&
			    viewportSize.height == 0 &&
			    getParent() != null) {
				try {
					viewportSize.wait(RESIZE_WAIT);
				} catch (InterruptedException e) {}
			}
			return new Dimension(viewportSize.width, viewportSize.height);
		}
	}
	
	/**
	 * 򤵤Ƥ󥯤 URL ֤ޤ
	 * 
	 * @return    򤵤Ƥ󥯤 URL
	 *            򤵤Ƥʤ <code>null</code>
	 */
	public URL getSelectedLink()
	{
		return currentLink;
	}
	
	/**
	 * ºݤΥݡͥȤ֤ޤ
	 * Υ᥽åɤϡľܥˡ󶡤ޤ
	 * λѤˤϽʬդƤ
	 * 
	 * @return    Υݡͥ
	 */
	public Component getCanvas()
	{
		return canvas;
	}
	
	/**
	 * ºݤΥݡͥȤ֤ޤ
	 * Υ᥽åɤϡľܥˡ󶡤ޤ
	 * λѤˤϽʬդƤ
	 * 
	 * @return    Υݡͥ
	 */
	public void scroll(int sense, int type, int value)
	{
		if (type == SCROLL_UNIT) {
			if (sense == SCROLL_HORIZONTAL)
				position.x += charScale.width  * value;
			else
				position.y += charScale.height * value;
		} else {
			if (sense == SCROLL_HORIZONTAL)
				position.x += (viewportSize.width  - charScale.width )  * value;
			else
				position.y += (viewportSize.height - charScale.height) * value;
		}
		setScrollPosition(position.x, position.y);
	}
	
//### Override
	/**
	 * 褷ޤ
	 * 
	 * @param     g Graphics
	 */
	public void update(Graphics g)
	{
		paint(g);
	}
	
	/**
	 * 褷ޤ
	 * 
	 * @param     g Graphics
	 */
	public void paint(Graphics g)
	{
		super.paint(g);
		if (toolTip != null)
			toolTip.paint(g);
	}
	
	/**
	 * ꤷޤ
	 * 
	 * @param     cursor 
	 */
	public void setCursor(Cursor cursor)
	{
		synchronized (cursorLock) {
			defaultCursorType = cursor.getType();
			
			if (temporaryCursorType == Cursor.DEFAULT_CURSOR &&
			    cursorType != defaultCursorType) {
				cursorType = defaultCursorType;
				super .setCursor(cursor);
				canvas.setCursor(cursor);
			}
		}
	}
	
	/**
	 * طʿꤷޤ
	 * 
	 * @param     color طʿ
	 */
	public void setBackground(Color color)
	{
		canvas.setBackground(color);
	}
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     image طʲ
	 */
	public void setBackground(Image image)
	{
		canvas.setBackground(image);
	}
	
	/**
	 *  ϥե׵ᤷޤ
	 */
	public void requestFocus()
	{
		if (callRequestFocus)
			return;
		callRequestFocus = true;
		
		super .requestFocus();
		canvas.requestFocus();
		
		callRequestFocus = false;
	}
	
	/**
	 * ΥڥΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	public String paramString()
	{
		String str = super.paramString();
		return str;
	}
	
//### private
	/** ֤ư */
	private void movePosition(FixedScrollbar bar, int value)
	{
		synchronized (canvasSize) {
			if (bar == horizontal) { position.x = value; } else
			if (bar == vertical  ) { position.y = value; }
			
			canvas.movePosition(position.x, position.y);
		}
	}
	
	/** ˥塼˥ƥɲ */
	private void appendPopupMenuItem(Vector src)
	{
		if (src.size() == 0)
			return;
		
		if (popupMenu.getItemCount() > 0)
			popupMenu.addSeparator();
		
		MenuItem mi;
		for (int i = 0; i < src.size(); i++) {
			mi = (MenuItem)src.elementAt(i);
			if (mi.getLabel() != null && mi.getLabel().compareTo("-") != 0) {
				popupMenu.remove(mi);
			}
			popupMenu.add(mi);
		}
	}
	
	/** ꤵ줿̾Υ URL  */
	private URL getLinkURL(int x, int y)
	{
		synchronized (canvasSize) {
			if (itemMap == null)
				return null;
			
			x =  position.x + viewportSize.width - x;
			y += position.y;
			
			return itemMap.getLinkURL(x, y);
		}
	}
	
	/** ꤵ줿̾β URL  */
	private URL getImageURL(int x, int y)
	{
		synchronized (canvasSize) {
			if (itemMap == null)
				return null;
			
			x =  position.x + viewportSize.width - x;
			y += position.y;
			
			return itemMap.getImageURL(x, y);
		}
	}
	
	/** 򸵤᤹ */
	private void setTemporaryCursor(int type)
	{
		temporaryCursorType = type;
		
		if (type == Cursor.DEFAULT_CURSOR)
			type = defaultCursorType;
		
		if (cursorType != type) {
			cursorType = type;
			Cursor cursor = Cursor.getPredefinedCursor(cursorType);
			super .setCursor(cursor);
			canvas.setCursor(cursor);
		}
	}
	
	/** СĴ */
	private void fixScrollbar(boolean h, boolean v)
	{
		if (horizontal.added == h && vertical.added == v)
			return;
		
		GridBagConstraints gbc = new GridBagConstraints();
		
		canvas.invalidate();
		if (horizontal.added != h) {
			if (h)
				addComponent(horizontal, gbl, gbc, 0.0, 0, 1, GridBagConstraints.HORIZONTAL);
			else
				remove(horizontal);
			horizontal.added = h;
		}
		
		if (vertical.added != v) {
			if (v)
				addComponent(vertical, gbl, gbc, 0.0, 1, 0, GridBagConstraints.VERTICAL);
			else
				remove(vertical);
			vertical.added = v;
		}
		validate();
	}
	
//### ޥ
	/** åץܡɤ˥ԡ */
	private void copyClipboard(String value)
	{
		Clipboard       clipboard = getToolkit().getSystemClipboard();
		StringSelection data      = new StringSelection(value);
		clipboard.setContents(data, data);
	}
	
//### HawkCanvasKeyListener
	/** ϥɥ */
	private class HawkCanvasKeyListener
		extends KeyAdapter
	{
		/** 󥹥󥹤 */
		private HawkCanvasKeyListener()
		{
		}
		
		/**  */
		public void keyPressed(KeyEvent e)
		{
			boolean isAlt = ((e.getModifiers() & InputEvent.ALT_MASK) != 0);
			
			if (isAlt) {
				switch (e.getKeyCode()) {
				case KeyEvent.VK_LEFT : e.consume(); listener.back   (); break;
				case KeyEvent.VK_RIGHT: e.consume(); listener.forward(); break;
				}
			} else {
				switch (e.getKeyCode()) {
				case KeyEvent.VK_LEFT     :
				case KeyEvent.VK_RIGHT    :
				case KeyEvent.VK_UP       :
				case KeyEvent.VK_DOWN     :
				case KeyEvent.VK_PAGE_DOWN:
				case KeyEvent.VK_PAGE_UP  :
				case KeyEvent.VK_HOME     :
				case KeyEvent.VK_END      :
				case KeyEvent.VK_SPACE    :
					e.consume();
					{
						Point position = getScrollPosition();
						switch (e.getKeyCode()) {
						case KeyEvent.VK_LEFT     : position.x += charScale.width ; break;
						case KeyEvent.VK_RIGHT    : position.x -= charScale.width ; break;
						case KeyEvent.VK_UP       : position.y -= charScale.height; break;
						case KeyEvent.VK_DOWN     : position.y += charScale.height; break;
						case KeyEvent.VK_PAGE_DOWN: position.x += (viewportSize.width - charScale.width); break;
						case KeyEvent.VK_PAGE_UP  : position.x -= (viewportSize.width - charScale.width); break;
						case KeyEvent.VK_HOME     : position.x = 0; position.y = 0; break;
						case KeyEvent.VK_END      : position.x = canvasSize.width - viewportSize.width; position.y = 0; break;
						case KeyEvent.VK_SPACE    : position.x += (viewportSize.width - charScale.width) * (!e.isShiftDown() ? 1 : -1); break;
						}
						setScrollPosition(position.x, position.y);
					}
					break;
				case KeyEvent.VK_ESCAPE:
					e.consume();
					{
						if (listener != null)
							listener.stop();
					}
					break;
				}
			}
		}
	}
	
//### HawkCanvasComponentListener
	/** ݡͥȥϥɥ */
	private class HawkCanvasComponentListener
		extends ComponentAdapter
	{
		/** 󥹥󥹤 */
		private HawkCanvasComponentListener()
		{
		}
		
		/** ѹ */
		public void componentResized(ComponentEvent e)
		{
			boolean reload = false;
			
			synchronized (canvasSize) {
				synchronized (viewportSize) {
					Dimension size = canvas.getSize();
					
					reload = (canvasSize.width > 0 && viewportSize.height != size.height);
					viewportSize.width  = size.width ;
					viewportSize.height = size.height;
					viewportSize.notifyAll();
				}
			}
			
			horizontal.setVisibleAmount (viewportSize.width );
			vertical  .setVisibleAmount (viewportSize.height);
			horizontal.setBlockIncrement(viewportSize.width  - charScale.width );
			vertical  .setBlockIncrement(viewportSize.height - charScale.height);
			
			if (horizontal.added)
				fixScrollbar(horizontal.added, canvasSize.height > viewportSize.height);
			
			if (reload && listener != null && listener.canReload())
				listener.reload(false);
		}
	}
	
//### HawkCanvasMouseListener
	/** ޥ٥ȥϥɥ */
	private class HawkCanvasMouseListener
		extends MouseAdapter
	{
		/** 󥹥󥹤 */
		private HawkCanvasMouseListener()
		{
		}
		
		/** å */
		public void mouseClicked(MouseEvent e)
		{
			e.getComponent().requestFocus();
			
			if (listener == null)
				return;
			
			currentLink  = getLinkURL (e.getX(), e.getY());
			currentImage = getImageURL(e.getX(), e.getY());
			
			if (e.isPopupTrigger() ||
			    ((e.getModifiers() & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK)) {
				
				popupMenu.removeAll();
				
				if (currentLink == null && currentImage == null) {
					menuItems[MENU_MAIN_BACK_INDEX   ].setEnabled(listener.canBack   ());
					menuItems[MENU_MAIN_FORWARD_INDEX].setEnabled(listener.canForward());
					menuItems[MENU_MAIN_STOP_INDEX   ].setEnabled(listener.canStop   ());
					menuItems[MENU_MAIN_RELOAD_INDEX ].setEnabled(listener.canReload ());
					((CheckboxMenuItem)menuItems[MENU_MAIN_OPTION_IMAGE_INDEX   ]).setState(!option.getLoadImage    ());
					((CheckboxMenuItem)menuItems[MENU_MAIN_OPTION_BAR_INDEX     ]).setState(!option.getShowScrollbar());
					((CheckboxMenuItem)menuItems[MENU_MAIN_OPTION_SPINGIF_INDEX ]).setState( option.getSpinGifImage ());
					((CheckboxMenuItem)menuItems[MENU_MAIN_OPTION_SPINJPEG_INDEX]).setState( option.getSpinJpegImage());
					
					appendPopupMenuItem(mainMenuItems);
				}
				if (currentLink != null) {
					appendPopupMenuItem(linkMenuItems);
				}
				if (currentImage != null) {
					appendPopupMenuItem(imageMenuItems);
				}
				
				popupMenu.show(e.getComponent(), e.getX(), e.getY());
				
				e.consume();
				return;
			}
			
			if (currentLink != null) {
				// 󥯾򥯥å줿
				if ((e.getModifiers() & InputEvent.BUTTON1_MASK) == InputEvent.BUTTON1_MASK ||
				    (e.getModifiers() & InputEvent.BUTTON2_MASK) == InputEvent.BUTTON2_MASK) {
					setTemporaryCursor(Cursor.DEFAULT_CURSOR);
					hawkContext.setTemporaryStatus(null);
					
					listener.openHawk(currentLink, null, e.isShiftDown(),
					                  ((e.getModifiers() & InputEvent.BUTTON2_MASK) == InputEvent.BUTTON2_MASK));
				} else {
//System.out.println("no?");
				}
				
				e.consume();
			}
		}
		
		/** ޥФ */
		public void mouseExited(MouseEvent e)
		{
			setTemporaryCursor(Cursor.DEFAULT_CURSOR);
			hawkContext.setTemporaryStatus(null);
			
			if (toolTip != null)
				toolTip.cancel();
		}
	}
	
//### HawkCanvasMouseMotionListener
	/** ޥ⡼ϥɥ */
	private class HawkCanvasMouseMotionListener
		extends MouseMotionAdapter
	{
		/** 󥹥󥹤 */
		private HawkCanvasMouseMotionListener()
		{
		}
		
		/** ޥư */
		public void mouseMoved(MouseEvent e)
		{
			int    cursor = Cursor.DEFAULT_CURSOR;
			String status = null;
			
			synchronized (canvasSize) {
				if (itemMap == null)
					return;
				
				// ġå
				if (toolTip != null)
					toolTip.cancel();
				
				int x = position.x + viewportSize.width - e.getX();
				int y = position.y + e.getY();
				
				String tip = null;
				if ((tip = itemMap.getInfo(x, y)) == null &&
				    (tip = itemMap.getTip (x, y)) != null)
					cursor = Cursor.CROSSHAIR_CURSOR;
				if (tip != null && tip.length() > 0) {
					if (toolTip == null)
						toolTip = new ToolTip(hawkContext, canvas, TIP_DELAY, new Insets(0, 0, TIP_BOTTOM * 2, 0));
					toolTip.showTip(tip, e.getX(), e.getY() + TIP_BOTTOM, viewportSize);
				}
				
				// 󥯾夫ɤå
				synchronized (cursorLock) {
					URL href = getLinkURL(e.getX(), e.getY());
					
					if (href != null) {
						cursor = Cursor.HAND_CURSOR;
						status = href.toString();
					}
				}
			}
			
			e.consume();
			setTemporaryCursor(cursor);
			hawkContext.setTemporaryStatus(status);
		}
	}
	
//### MenuActionListner
	/** ˥塼ѤΥꥹ */
	private class MenuActionListner
		implements ActionListener, ItemListener
	{
		private int index = 0;
		
		/** ˥塼ꥹ  */
		private MenuActionListner(int index)
		{
			this.index = index;
		}
		
		/** ϥɥ */
		public void actionPerformed(ActionEvent e)
		{
			if (listener != null) {
				boolean isShift = ((e.getModifiers() & InputEvent.SHIFT_MASK) != 0);
				boolean isCtrl  = ((e.getModifiers() & InputEvent.CTRL_MASK ) != 0);
				
				/// MENU
				switch (index) {
				case MENU_MAIN_BACK_INDEX   : listener.back   (); break;
				case MENU_MAIN_FORWARD_INDEX: listener.forward(); break;
				case MENU_MAIN_STOP_INDEX   : listener.stop   (); break;
				case MENU_MAIN_RELOAD_INDEX : listener.reload (isCtrl); break;
				case MENU_MAIN_INFO_INDEX   : ; break;
				case MENU_LINK_COPY_INDEX   : copyClipboard(currentLink.toString()); break;
				case MENU_IMAGE_OPEN_INDEX  : listener.openHawk(currentImage, null, isShift, false); break;
				case MENU_IMAGE_COPY_INDEX  : copyClipboard(currentImage.toString()); break;
				}
			}
		}
		
		/** ϥɥ */
		public void itemStateChanged(ItemEvent e)
		{
			boolean selected = (e.getStateChange() == ItemEvent.SELECTED);
			
			/// MENU
			switch (index) {
			case MENU_MAIN_OPTION_IMAGE_INDEX   :
				option.setLoadImage(!selected);
				break;
			case MENU_MAIN_OPTION_BAR_INDEX     :
				setVisibleScrollbar(!selected);
				break;
			case MENU_MAIN_OPTION_SPINGIF_INDEX :
				option.setSpinGifImage(selected);
				break;
			case MENU_MAIN_OPTION_SPINJPEG_INDEX:
				option.setSpinJpegImage(selected);
				break;
			}
		}
	}
	
//### FixedScrollbar
	/** ΥС */
	private class FixedScrollbar
		extends Scrollbar
		implements AdjustmentListener
	{
		private int orientation;
		private int fixOperator;
		private int maximum;
		private int amount;
		private boolean added;
		
		/** 󥹥󥹤 */
		private FixedScrollbar(int orientation)
		{
			super(orientation, 0, 0, 0, 0);
			setEnabled(false);
			this.orientation = orientation;
			this.fixOperator = (orientation == HORIZONTAL ? -1 : 1);
			
			setUnitIncrement (1);
			setBlockIncrement(1);
			
			addAdjustmentListener(this);
		}
		
		/** 祵֤ */
		public Dimension getMaximumSize()
		{
			return getPreferredSize();
		}
		
		/** 祵ꤹ */
		public synchronized void setMaximum(int newMaximum)
		{
			if (newMaximum > amount) {
				int value = getValue();
				
				super.setMaximum(newMaximum);
				
				setValue(value + (maximum - newMaximum) * fixOperator);
			}
			
			maximum = newMaximum;
			fixValue();
		}
		
		/** Ļʬꤹ */
		public synchronized void setVisibleAmount(int newAmount)
		{
			if (newAmount < maximum) {
				int value = getValue();
				
				super.setVisibleAmount(newAmount);
				
				//setValue(value + (newAmount - amount) * fixOperator);
				if (orientation == HORIZONTAL)
					setValue(value + (newAmount - amount) * fixOperator);
			}
			
			amount = newAmount;
			fixValue();
		}
		
		/** Ĵ᤹ */
		private void fixValue()
		{
			boolean enabled = isEnabled();
			
			if (enabled != (maximum > amount)) {
				enabled = (!enabled);
				setEnabled(enabled);
				
				if (enabled) {
					super.setMaximum      (maximum);
					super.setVisibleAmount(amount );
				}
			}
		}
		
		/** 侩֤ */
		public Dimension getPreferredSize()
		{
			if (orientation == HORIZONTAL)
				return new Dimension(0, 16);
			else
				return new Dimension(16, 0);
		}
		
		/** ե뤳Ȥ뤫֤ */
		public boolean isFocusTraversable()
		{
			return false;
		}
		
		/** ͤѹ */
		public void adjustmentValueChanged(AdjustmentEvent e)
		{
			// ٥ȤͤǤϤʤߤͤ򸵤˰֤ꤹ
			// ϡ٥ȯ塢ƤӽФޤǤ˥饰뤿
			movePosition(this, (orientation == HORIZONTAL ? maximum - amount - getValue() : getValue()));
		}
	}
}
