/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.rendering.PostData;
import net.hizlab.kagetaka.token.FormItem;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

/**
 * ԤδĶɽޤ
 * Υ󥿡եͳơĶѹޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.7 $
 */
public interface HawkContext
	extends ImageCreator
{
	/**
	 * ݡ֤ޤ
	 * ȯåꤿϡ
	 * {@link net.hizlab.kagetaka.Reporter} 򥤥ץȤ饹
	 * Υ󥹥󥹤֤ɬפޤ
	 * 
	 * @return    ݡ
	 */
	public abstract Reporter getReporter();
	
	/**
	 * ġ륭åȤ֤ޤ
	 * 
	 * @return    ġ륭å
	 */
	public abstract Toolkit getToolkit();
	
	/**
	 * ꤷ URL ɽޤ
	 * 
	 * @param     url URL
	 * @param     pd  POST Ϥǡ
	 *                POST ǤϤʤ <code>null</code>
	 * @param     newWindow ɥǳ <code>true</code>
	 *                      ʳξ <code>false</code>
	 * @param     extension ĥ⡼ɤǳ <code>true</code>
	 *                      ʳξ <code>false</code>
	 */
	public abstract void openHawk(URL url, PostData pd, boolean newWindow, boolean extension);
	
	/**
	 * ꤵ줿 URL Υ֤ͥޤ
	 * ĶˤäˡǥͥƤɬפޤ
	 * Υ᥽åɤ֤륳ͥϡ³ѤߤǤ⹽ޤ
	 * 
	 * @param     url URL
	 * @param     pd  POST Ϥǡ
	 *                POST ǤϤʤ <code>null</code>
	 * 
	 * @return    URL ͥ
	 * 
	 * @exception IOException IO 顼ȯ
	 */
	public abstract URLConnection getURLConnection(URL url, PostData pd)
		throws IOException;
	
	/**
	 * ꤵ줿ɥȤΥɤԤޤ
	 * ĶˤäˡǥɤԤޤ
	 * ̤ϡΥ᥽åǥåɤ
	 * ΥåɤǥɽԤɬפޤ
	 * 
	 * @param     document ɥȾ
	 * @param     connection ͥ
	 */
	public abstract void download(Document document, URLConnection connection);
	
	/**
	 * ᡼Ѥ륤᡼֤ޤ
	 * 
	 * @param     producer ץǥ塼
	 * 
	 * @return    ᡼
	 */
	public abstract Image createImage(ImageProducer producer);
	
	/**
	 * ᡼Ѥ륤᡼֤ޤ
	 * 
	 * @param     width 
	 * @param     height ⤵
	 * 
	 * @return    ᡼
	 */
	public abstract Image createImage(int width, int height);
	
	/**
	 * ǥȥå֤ޤ
	 * 
	 * @return    ǥȥå
	 */
	public abstract MediaTracker getMediaTracker();
	
	/**
	 * ꡼󥤥᡼ɲäޤ
	 * 
	 * @param     image ꡼󥤥᡼
	 * @param     size ꡼󥤥᡼Υ
	 */
	public abstract void addImage(Image image, Dimension size);
	
	/**
	 * եॢƥɲäޤ
	 * 
	 * @param     item եॢƥ
	 */
	public abstract void addFormItem(FormItem item);
	
	/**
	 * ѥ򥯥ꥢޤ
	 */
	public abstract void cleanCanvas();
	
	
	/**
	 * ѥϰϤꤷƺɽޤ
	 * ɸϱ夫εΥǤ
	 * 
	 * @param     x ѥα顢ɽ֤αüεΥ
	 * @param     y ѥξ夫顢ɽ֤ξüεΥ
	 * @param     width  ɽϰϤ
	 * @param     height ɽϰϤι⤵
	 */
	public abstract void repaint(int x, int y, int width, int height);
	
	/**
	 * ѤιԤȡʸι⤵ꤷޤ
	 * {@link java.awt.Dimension#width} Ԥ
	 * {@link java.awt.Dimension#height} ʸι⤵ɽޤ
	 * 
	 * @param     scale ȹ⤵
	 */
	public abstract void setScale(Dimension scale);
	
	/**
	 * طʤꤷޤ
	 * 
	 * @param     color طʿ
	 */
	public abstract void setBackground(Color color);
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     image طʲ
	 */
	public abstract void setBackground(Image image);
	
	/**
	 * ƥޥåפꤷޤ
	 * 
	 * @param     map ƥޥå
	 */
	public abstract void setItemMap(ItemMap map);
	
	/**
	 * ȥꤷޤ
	 * 
	 * @param     title ȥ
	 */
	public abstract void setTitle(String title);
	
	/**
	 * ơåꤷޤ
	 * 
	 * @param     status ơå
	 */
	public abstract void setStatus(String status);
	
	/**
	 * Ūʥơåꤷޤ
	 * 
	 * @param     status ơå
	 */
	public abstract void setTemporaryStatus(String status);
	
	/**
	 * ꤷޤ
	 * 
	 * @param     cursor 
	 */
	public abstract void setCursor(int cursor);
	
	/**
	 * ӥ塼ݡȤθߤΥ֤ޤ
	 * 
	 * @return    ԥñ̤Υӥ塼ݡȤΥ
	 */
	public Dimension getViewportSize();
	
	/**
	 * ץ֤ޤ
	 */
	public abstract Option getOption();
	
	/**
	 * ꤷ URL ˬ䤷Ȥ뤫ɤ֤ޤ
	 * 
	 * @param     url URL
	 * 
	 * @return    ˬ줿Ȥ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public abstract boolean haveEverVisited(URL url);
	
	/**
	 * åꤷޤ
	 * 
	 * @param     value åɽʸ
	 * @param     url   åȯԤ URL
	 */
	public abstract void setCookie(String value, URL url);
}
