/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.token.Value;

import java.awt.Point;

/** եȾ */
class FloatChain
{
	static final int TOP    = Value.FLOAT_LEFT;
	static final int BOTTOM = Value.FLOAT_RIGHT;
	static final int BOTH   = Value.CLEAR_BOTH;
	
	private Chain top;
	private Chain last;
	
	/** 󥹥󥹤 */
	FloatChain()
	{
		top = last = new Chain(TOP, 0, 0);
	}
	
	/** եȥ˿եȤ֤x ϱ */
	Point allocate(int type, int x, int width, int height,
	               int frameTop, int frameBottom, int maxHeight)
	{
		int[] thick = new int[2];
		
		Chain c = getGap(x, height, frameTop, frameBottom, maxHeight, thick);
		Point p = new Point(Math.max(c.x, x), 0);
		
		// ƱݥǡƱ뤫å
		if (c.x == x && c.type != type && c.back != null && c.x == c.back.x)
			c = c.back;
		
		// frame 礭Ƥʤˡframe ʬη֤褦
		if (type == TOP) {
			p.y = Math.max(thick[0] - frameTop   , 0);
			height += Math.max(frameTop    - thick[0], 0);
		} else {
			p.y = maxHeight - (Math.max(thick[1] - frameBottom, 0) + height);
			height += Math.max(frameBottom - thick[1], 0);
		}
		
		// ϰ֤ɲ
		c = c.append(type, p.x, height);
		
		int odd = 0;
		int end = p.x + width;
		
		// λ֤
		while (c.next != null && c.next.x < end) {
			c = c.next;
			
			// ˤ뽪λ̵֤
			if (c.type == type && c.height < 0) {
				odd += -c.height;
				c.height = 0;
			}
		}
		
		// λ֤ɲ
		c.append(type, end, -(height + odd));
		
		return p;
	}
	
	/** ֤Υեȥ֤x ϱ */
	int getHeight(int type, int x, int frameTop, int frameBottom)
	{
		int top = 0, bottom = 0;
		Chain c = this.top;
		
		while (c.next != null) {
			if (c.type == TOP)
				top    += c.height;
			else
				bottom += c.height;
			
			if (c.next.x > x) {
				switch (type) {
				case TOP   : return Math.max(top    - frameTop   , 0);
				case BOTTOM: return Math.max(bottom - frameBottom, 0);
				case BOTH  : return Math.max(top    - frameTop   , 0) + Math.max(bottom - frameBottom, 0);
				}
				return 0;
			}
			
			c = c.next;
		}
		
		return 0;
	}
	
	/** ְʹߤǡꥵ֤֤x ϱ */
	int getGapPosition(int x, int height, int frameTop, int frameBottom, int maxHeight)
	{
		return Math.max(getGap(x, height, frameTop, frameBottom, maxHeight, null).x, x);
	}
	
	/** ְʹߤǡեȤ̵֤֤x ϱ */
	int getClearPosition(int type, int x)
	{
		Chain c = last;
		
		// ƬФ򤹤
		while (c.x > x) {
			if (c.height < 0 &&
			    (type == BOTH || type == c.type))
				break;
			
			if (c.back == null)
				break;
			
			c = c.back;
		}
		
		return Math.max(c.x, x);
	}
	
	/** եȹ֤ */
	int getWidth()
	{
		return last.x;
	}
	
	/** 礭õx ϱ */
	private Chain getGap(int x, int height, int frameTop, int frameBottom,
	                     int maxHeight, int[] thick)
	{
		Chain c = last;
		int newTop = 0, newBottom = 0;
		
		// ƬФ򤹤
		while (c.x > x) {
			// ǸΥեȤγϰ֤걦¦ƤϤʤ
			if (c.height > 0)
				break;
			
			// last ̤äƤΤǡc.height  +- դʤΤդ뤳
			if (c.type == TOP)
				newTop    -= c.height;
			else
				newBottom -= c.height;
			
			if (maxHeight - Math.max(newTop    - frameTop   , 0)
			              - Math.max(newBottom - frameBottom, 0) < height)
				break;
			
			if (thick != null) {
				thick[0] = newTop;
				thick[1] = newBottom;
			}
			
			if (c.back == null)
				break;
			
			c = c.back;
		}
		
		return c;
	}
	
/*
void dump()
{
	int ht = 0;
	int hb = 0;
	Chain c = top;
	
	while (c != null) {
		if (c.type == TOP)
			ht += c.height;
		else
			hb += c.height;
		
System.out.println("> "+c.x+","+ht+","+hb);
		c = c.next;
	}
}
*/
	
//### Chain
	/** եȥ */
	private class Chain
	{
		private int   type;
		private int   x;
		private int   height;
		private Chain next;
		private Chain back;
		
		/** 󥹥󥹤 */
		private Chain(int type, int x, int height)
		{
			this.type   = type;
			this.x      = x;
			this.height = height;
		}
		
		/** Υμɲäɲä֤ */
		private Chain append(int type, int x, int height)
		{
			// Ʊ֤ɲä줿
			if (type == this.type && x == this.x) {
				this.height += height;
				return this;
			}
			
			Chain c = new Chain(type, x, height);
			c.next = next;
			c.back = this;
			if (next != null)
				next.back = c;
			else
				last = c;
			next = c;
			
			return c;
		}
	}
}
