/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.fclabs.util.Queue;
import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.ColorConverter;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.Transparent;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.IOException;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Stack;
import java.util.Vector;

class Drawkit
{
	private static final int MT_WAIT        = 10000;      // ǥȥåԤ
	private static final int UL_DISC_SIZE   =     6;      // UL ε礭
	private static final int UL_CIRCLE_SIZE =     6;      // UL ε礭
	private static final int UL_SQUARE_SIZE =     5;      // UL ε礭
	
	HawkContext context;                      // 륳ƥ
	
	private Reporter reporter;                // ݡ
	private Option   option;                  // ץ
	
	Document    document;                     // ɥ
	Dimension   viewSize;                     // ɽΥ
	Dimension   size;                         // ѥ
	
	ItemMap     itemMap;                      // ƥޥå
	Status      baseStatus;                   // ΤΥơ
	Status      nextStatus;                   // Υơ
	Status      status;                       // ơ
	
	// üʸꥹ
	CharList    charsSpinRight;               // žʸ
	CharList    charsSpinLtrb;                // ưʸ
	CharList    charsKinsokuHead;             // Ƭػʸ
	CharList    charsKinsokuTail;             // ػʸ
	boolean     swapDecoration;               // ƥȽθ
	
	Image       panel        = null;          // ѥͥ륤᡼
	Dimension   panelSize    = null;          // ѥͥ륤᡼
	Graphics    g            = null;          // Graphics
	Counter     gCounter     = null;          // Graphics Υ
	
	Queue       idQueue      = new Queue ();  // ID 塼
	Vector      ids          = new Vector();  // ID 
	
	// 
	Vector       images       = new Vector();                // 
	Counter      imageCounter = new Counter(0);              // βο
	SyncObserver imageDrawer  = new SyncObserver();          // Ԥ
	
	// եȽ
	Vector      floats       = new Vector();  // ե
	Queue       floatQueue;                   // ե襭塼
	
	// ե
	Vector      formItems    = new Vector();  // եॢƥ
	
	private Stack        statusStack   = new Stack ();
	private int          backImageLeft = 0;
	private MediaTracker mt            = null; // ǥȥå
	
	// Ľѡ®٤夲뤿ˡ󥹥ѿȤ
	private char[] tateCs = new char[1];
	private int    tateW;
	private int    tateMax;
	
	/** 󥹥󥹤 */
	Drawkit(HawkContext context, Document document)
	{
		this.context  = context;
		this.reporter = context.getReporter();
		this.option   = context.getOption  ();
		
		this.document = document;
		this.viewSize = context.getViewportSize();
		this.size     = new Dimension(0, 0);
		this.mt       = context.getMediaTracker();
		this.itemMap  = new ItemMap(context.getReporter());
		
		this.charsSpinRight   = option.getCharsSpinRight  ();
		this.charsSpinLtrb    = option.getCharsSpinLtrb   ();
		this.charsKinsokuHead = option.getCharsKinsokuHead();
		this.charsKinsokuTail = option.getCharsKinsokuTail();
		this.swapDecoration   = option.getSwapDecoration  ();
		
		baseStatus = status = new Status(this);
		status.type = TokenTypes.BODY_START;
	}
	
//### Render 
	/** ߤ¸ */
	void saveStatus(int type)
	{
		statusStack.push(status);
		if (nextStatus == null) {
			status = (Status)status.clone();
			status.type = type;
		} else {
			nextStatus.parent = status;
			status = nextStatus;
			nextStatus = null;
		}
	}
	
	/** ¸Ƥľ᤹ */
	void resetStatus()
	{
		status = (Status)statusStack.pop();
	}
	
	/** ¸Ƥľ᤹ */
	void insertStatus(int type)
	{
		nextStatus = status;
		Status s = (Status)statusStack.peek();
		status = (Status)s.clone();
		status.type = type;
	}
	
	/** ɤ߹ߤλΤԤ */
	void waitImageLoad()
	{
		synchronized (imageCounter) {
			while (imageCounter.current() > 0) {
				try {
					imageCounter.wait(10000);
				} catch (InterruptedException e) {
					// β
					for (int i = 0; i < images.size(); i++) {
						ImageHolder ih = (ImageHolder)images.elementAt(i);
						if (!ih.complete)
							reportMessage(Reporter.INFO, "render.info.image.stop", new String[]{ih.toString()});
					}
					
					throw new StopException("wait to load images");
				}
			}
		}
	}
	
	/** ɤ߹ߤ򥭥󥻥 */
	void stopImageLoad()
	{
		if (imageCounter.current() <= 0)
			return;
		
		for (int i = 0; i < images.size(); i++)
			((ImageHolder)images.elementAt(i)).dispose();
	}
	
	/**
	 * ꥽ޤ
	 */
	void dispose()
	{
		for (int i = 0; i < images.size(); i++)
			((ImageHolder)images.elementAt(i)).dispose();
		images.removeAllElements();
	}
	
//### Box 
	/** ֤򺸤˰ư */
	void createPanel(int width, int height, Status status)
	{
		if (width == 0)
			return;
		
		if (height <= 0)
			height = 1;
//System.out.println("Drawkit.createPanel["+width+","+height+"]");
		
		if (panel != null) {
			commitPanel();
			reportMessage(Reporter.ERROR, "internal.error", new String[]{"Render.createPanel", "panel not commit", ""});
		}
		
		this.panel     = context.createImage(width, height);
		this.panelSize = new Dimension(width, height);
		this.g         = panel.getGraphics();
		this.gCounter  = new Counter(1);
		
		// طʿɤ
		if (baseStatus.backColor != null) {
			g.setColor(baseStatus.backColor);
			g.fillRect(0, 0, width, height);
		}
		
		// طʲߤ
		if (baseStatus.backImage != null) {
			int dx1 = 0, dy1 = 0, dx2 = 0, dy2 = 0;
			int sx1 = 0, sy1 = 0, sx2 = 0, sy2 = 0;
			dx1 = width + backImageLeft;
			do {
				dx2 = dx1;
				dx1 = dx1 - baseStatus.backImageSize.width;
				sx1 = Math.min(0, dx1);
				backImageLeft = baseStatus.backImageSize.width + dx1;
				if (dx1 < 0) {
					sx1 = -dx1;
					dx1 = 0;
				}
				sx2 = sx1 + (dx2 - dx1);
				dy2 = 0;
				sy2 = baseStatus.backImageSize.height;
//System.out.println(dx1+","+dx2+","+sx1+","+sx2);
				do {
					dy1 = dy2;
					dy2 = dy1 + baseStatus.backImageSize.height;
					if (dy2 > height) {
						sy2 -= dy2 - height;
						dy2 =  height;
					}
//System.out.println(dx1+","+dy1+","+dx2+","+dy2+","+sx1+","+sy1+","+sx2+","+sy2);
					drawImageSync(g, baseStatus.backImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2);
				} while (dy2 < height);
			} while (dx1 > 0);
		}
		
		size.width  += width;
		size.height =  Math.max(size.height, height);
	}
	
	/** ѥͥ򥳥ߥå */
	void commitPanel()
	{
		if (panel != null) {
			if (gCounter.decrement() <= 0)
				g.dispose();
			context.addImage(panel, panelSize);
			panel     = null;
			panelSize = null;
			g         = null;
			gCounter  = null;
		}
	}
	
//### 
	/** å */
	void reportMessage(int type, String key, String[] args)
	{
		if (reporter == null)
			return;
		
		reporter.report(type, Resource.getMessage(key, args), 0, 0);
	}
	
	/** URL  */
	URL createURL(String href)
	{
		try {
			return document.createURL(href);
		} catch (SecurityException e) {
			reportMessage(Reporter.WARNING, "render.warning.security", new String[]{href, e.toString()});
		} catch (MalformedURLException e) {
			reportMessage(Reporter.WARNING, "render.warning.href", new String[]{href, e.toString()});
		}
		
		return null;
	}
	
	/**  */
	Image getImage(URL url, String src)
	{
		if (url == null)
			return null;
		
		try {
			return ImageCache.getImage(context, url, src, option.getLoadImage());
		} catch (SecurityException e) {
			reportMessage(Reporter.WARNING, "render.warning.security", new String[]{src, e.toString()});
		} catch (IOException e) {
			reportMessage(Reporter.WARNING, "render.warning.io", new String[]{src, e.toString()});
		}
		
		return null;
	}
	
	/**  */
	int loadImage(Image image, String message)
	{
		mt.addImage(image, 0);
		try {
			mt.waitForID(0, MT_WAIT);
		} catch (InterruptedException e) {
			throw new StopException(message);
		}
		int status = mt.statusID(0, true);
		mt.removeImage(image, 0);
		
		return status;
	}
	
//### 
	/** ʸĤ */
	void drawTextTate(StringBuffer buffer, int begin, int end,
	                  int x, int y, Status status, double space, int letterSpacing)
	{
		tateMax = status.fdFontSize.width;
		
		for (int i = begin; i < end; i++) {
			tateCs[0] = buffer.charAt(i);
//System.out.println(tateCs[0]+","+y+","+space);
			tateW = status.fm.charWidth(tateCs[0]);
			y += (int)(((i * 2) + 1) * space) - (int)((i * 2) * space);
			g.drawChars(tateCs, 0, 1, (tateMax > tateW ? x + ((tateMax - tateW) / 2) : x), y + status.fontBaseFull);
			y += status.fdFontSize.height;
			y += (int)(((i * 2) + 2) * space) - (int)(((i * 2) + 1) * space);
			y += letterSpacing;
		}
	}
	
	/** ʸž */
	void drawTextWithSpin(StringBuffer buffer, int begin, int end,
	                      int x, int y, int width, int height,
	                      Status status, double space, int letterSpacing, char type)
	{
		// եȤΤʤʸž褦Ȥ
		if (width == 0)
			return;
		
		int scrapX, scrapY;
		Color backColor = Color.white;
		Color foreColor = Color.black;
		
//		Image    scrap = context.createImage(width, height);
		Image    scrap = null;
try {
		scrap = context.createImage(width, height);
} catch (IllegalArgumentException e) {
System.out.println("e=["+buffer+"],["+begin+"],["+end+"],["+width+"],["+height+"]");
return;
} catch (NegativeArraySizeException e) {
System.out.println("e=["+buffer+"],["+begin+"],["+end+"],["+width+"],["+height+"]");
return;
}
		Graphics sg    = scrap.getGraphics();
		
		// طʿ white ˤơwhite Ʃˤ
		sg.setColor(backColor);
		sg.fillRect(0, 0, width, height);
		
		// ʿ򤳤ꤷʤΤϡƩѤοȽŤʤǽΤȡ
		// JDK 1.1 ΰǡǤʤХб뤿
		sg.setColor(foreColor  );
		sg.setFont (status.font);
		
		int base = 0;
		if (type == Constant.SPIN_LTRB)
			base = status.fontBaseFull + (status.fdFontSize.height - status.fontBaseFull) / 2;
		
		char c;
		scrapX = 0;
		for (int i = begin; i < end; i++) {
			c = buffer.charAt(i);
			tateCs[0] = c;
			if (type == Constant.SPIN_RIGHT) {
				if ((c <= 0xFF) ||
				    (0xFF61 <= c && c <= 0xFF9F))
					base = status.fontBaseHalf;
				else
					base = status.fontBaseFull;
			}
			scrapX += (int)(((i * 2) + 1) * space) - (int)((i * 2) * space);
			sg.drawChars(tateCs, 0, 1, scrapX, base);
			scrapX += status.fm.charWidth(tateCs[0]);
			scrapX += (int)(((i * 2) + 2) * space) - (int)(((i * 2) + 1) * space);
			scrapX += letterSpacing;
		}
		
		sg.dispose();
		
		int[] bitmap1 = new int[width * height];
		int[] bitmap2 = new int[width * height];
		PixelGrabber pg = new PixelGrabber(scrap, 0, 0, width, height, bitmap1, 0, width);
		try{
			// ѴǼԤƤ⡢̵뤷Ʒ³ƹʤ
			pg.grabPixels(MT_WAIT);
		} catch (InterruptedException e) {}
		
		switch (type) {
		case Constant.SPIN_RIGHT:
			for (scrapX = 0; scrapX < width; scrapX++)
				for (scrapY = 0; scrapY < height; scrapY++)
					bitmap2[scrapX * height + scrapY] = bitmap1[scrapX + (height - scrapY - 1) * width];
			break;
		case Constant.SPIN_LTRB:
			for (scrapX = 0; scrapX < width; scrapX++)
				for (scrapY = 0; scrapY < height; scrapY++)
					bitmap2[scrapX * height + scrapY] = bitmap1[scrapX + scrapY * width];
			break;
		}
		
		// ʸοꤷطʤƩˤ
		int bcc = backColor.getRGB();
		int fcc = status.foreColor.getRGB() | 0xff000000;
		for (int i = 0; i < bitmap2.length; i++)
			if (bitmap2[i] == bcc)
				bitmap2[i] &= 0xffffff;             // Ʃ
			else
				bitmap2[i] = fcc;                   // ʿˤ
		
		// ᡼Ǥϡwidth  height ͤϸ򴹤Ƥ
		
		MemoryImageSource mis = new MemoryImageSource(height, width, bitmap2, 0, height);
		mis.setAnimated(false);
		Image image = context.createImage(mis);
		
		// 褹褦ˤ
		drawImageSync(g, image, x, y, height, width);
		
		// ꥽
		scrap.flush();
		image.flush();
	}
	
	/** Ʊ */
	void drawImageSync(Graphics g, Image image, int x, int y, int width, int height)
	{
		synchronized (imageDrawer) {
			imageDrawer.init(g, x, y, width, height);
			if (!g.drawImage(image, x, y, width, height, imageDrawer)) {
				try {
					imageDrawer.wait(MT_WAIT);
				} catch (InterruptedException e) {
					throw new StopException("wait to draw a image");
				}
			}
		}
	}
	
	/** Ʊ */
	void drawImageSync(Graphics g, Image image,
	                   int dx1, int dy1, int dx2, int dy2,
	                   int sx1, int sy1, int sx2, int sy2)
	{
		synchronized (imageDrawer) {
			imageDrawer.init(g, dx1, dy1, dx2 - dx1, dy2 - dy1);
			if (!g.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, imageDrawer)) {
				try {
					imageDrawer.wait(MT_WAIT);
				} catch (InterruptedException e) {
					throw new StopException("wait to draw a image");
				}
			}
		}
	}
	
	/** ꥹȤ */
	void drawListItem(int x, int y, Status status)
	{
		g.setColor(status.foreColor);
		
		switch (status.listType) {
		case Value.NONE: // ̵
			break;
		case Value.LIST_DISC: // 
			g.fillOval(x + ((status.fdFontSize.width  - UL_DISC_SIZE) / 2),
			           y - ((status.fdFontSize.height + UL_DISC_SIZE) / 2),
			           UL_DISC_SIZE, UL_DISC_SIZE);
			break;
		case Value.LIST_CIRCLE: // 
			g.drawOval(x + ((status.fdFontSize.width  - UL_CIRCLE_SIZE) / 2),
			           y - ((status.fdFontSize.height + UL_CIRCLE_SIZE) / 2),
			           UL_CIRCLE_SIZE, UL_CIRCLE_SIZE);
			break;
		case Value.LIST_SQUARE: // ͳ
			g.fillRect(x + ((status.fdFontSize.width  - UL_SQUARE_SIZE) / 2),
			           y - ((status.fdFontSize.height + UL_SQUARE_SIZE) / 2),
			           UL_SQUARE_SIZE, UL_SQUARE_SIZE);
			break;
		default:
			{
				StringBuffer buffer = new StringBuffer();
				
				switch (status.listType) {
				case Value.LIST_DECIMAL_LEADING_ZERO: // 0 դʿ
					if (status.counterStatus.counterNo < 10)
						buffer.append('0');
					buffer.append(status.counterStatus.counterNo);
					break;
				case Value.LIST_LOWER_ROMAN: // ʸΥ޿ i,ii,iii,iv,v, ...
				case Value.LIST_UPPER_ROMAN: // ʸΥ޿ I,II,III,IV,V, ...
					if (status.counterStatus.counterNo >= 5000) {
						buffer.append(status.counterStatus.counterNo);
					} else {
						int no = status.counterStatus.counterNo;
						int column = 0;
						char[] list = null;
						if (status.listType == Value.LIST_LOWER_ROMAN)
							list = new char[]{'i', 'v', 'x', 'l', 'c', 'd', 'm', '?', '?'};
						else
							list = new char[]{'I', 'V', 'X', 'L', 'C', 'D', 'M', '?', '?'};
						char c1, c5, c10;
						
						if (no <= 0)
							no = 1;
						while (no > 0 && column < 7) {
							c1  = list[column];
							c5  = list[column + 1];
							c10 = list[column + 2];
							switch (no % 10) {
							case 1: buffer.append( c1); break;
							case 2: buffer.append( c1);
							        buffer.append( c1); break;
							case 3: buffer.append( c1);
							        buffer.append( c1);
							        buffer.append( c1); break;
							case 4: buffer.append( c5);
							        buffer.append( c1); break;
							case 5: buffer.append( c5); break;
							case 6: buffer.append( c1);
							        buffer.append( c5); break;
							case 7: buffer.append( c1);
							        buffer.append( c1);
							        buffer.append( c5); break;
							case 8: buffer.append( c1);
							        buffer.append( c1);
							        buffer.append( c1);
							        buffer.append( c5); break;
							case 9: buffer.append(c10);
							        buffer.append( c1); break;
							}
							no = no / 10;
							column += 2;
						}
						buffer.reverse();
					}
					break;
				case Value.LIST_CJK_IDEOGRAPHIC: //  , , , ...
					{
						String list = Resource.getMessage("chars.list.cjk.ideographic", null);
						int no = status.counterStatus.counterNo;
						if (no <= 0)
							no = 1;
						int n, n4 = 1, nx = 0;
						boolean bx = false;
						for (;;) {
							n = no % 10;
							if (n > 0) {
								if (nx > 0 && !bx) {
									buffer.append(list.charAt(nx + 11));
									bx = true;
								}
								if (n4 > 1)
									buffer.append(list.charAt(n4 + 7));
								buffer.append(list.charAt(n - 1));
							}
							
							no /= 10;
							if (no == 0)
								break;
							
							if (++n4 == 5) {
								n4 = 1;
								nx++;
								bx = false;
							}
						}
						buffer.reverse();
					}
					break;
				case Value.LIST_HIRAGANA       : // ʿ̾ ,,,,, ...
				case Value.LIST_KATAKANA       : // Ҳ̾ ,,,,, ...
				case Value.LIST_HIRAGANA_IROHA : // ʿ̾Τ ,,,, ...
				case Value.LIST_KATAKANA_IROHA : // Ҳ̾Τ ,,,, ...
				case Value.LIST_LOWER_GREEK    : // ʸθ奮ꥷʸ
					{
						String key = null;
						switch (status.listType) {
						case Value.LIST_HIRAGANA       : key = "chars.list.hiragana"      ; break;
						case Value.LIST_KATAKANA       : key = "chars.list.katakana"      ; break;
						case Value.LIST_HIRAGANA_IROHA : key = "chars.list.hiragana.iroha"; break;
						case Value.LIST_KATAKANA_IROHA : key = "chars.list.katakana.iroha"; break;
						case Value.LIST_LOWER_GREEK    : key = "chars.list.lower.greek"   ; break;
						}
						String list = Resource.getMessage(key, null);
						int no = status.counterStatus.counterNo - 1;
						if (no < 0)
							no = 0;
						if (no < list.length())
							buffer.append(list.charAt(no));
						else
							buffer.append(status.counterStatus.counterNo);
					}
					break;
				case Value.LIST_LOWER_LATIN:
				case Value.LIST_UPPER_LATIN:
				case Value.LIST_LOWER_ALPHA:
				case Value.LIST_UPPER_ALPHA:
					{
						int no = status.counterStatus.counterNo;
						if (no <= 0)
							no = 1;
						boolean lower = (status.listType == Value.LIST_LOWER_LATIN ||
						                 status.listType == Value.LIST_LOWER_ALPHA);
						while (no > 0) {
							buffer.append((char)(((no % 26) - 1) + (lower ? 'a' : 'A')));
							no = no / 26;
						}
						buffer.reverse();
					}
					break;
				case Value.LIST_DECIMAL: // ʿ
				default:
					buffer.append(status.counterStatus.counterNo);
					break;
				}
				
				int letterSpacing = 0;
				if (status.letterSpacing != null)
					letterSpacing = status.letterSpacing.getValue(status.fd, status.fdFontSize.width, Value.DATA_VERTICAL);
				
				char c = 0, s = 0;
				// Ǹդ . ղ
				if (buffer.length() > 0) {
					c = buffer.charAt(0);
					if ((c <= 0xFF) ||
					    (0xFF61 <= c && c <= 0xFF9F) ||
					    charsSpinRight.contains(c))
						s = '1';
					else
						s = '2';
					buffer.append(Resource.getMessage("chars.value.list." + s, null));
				}
				
				// ׻
				int w = 0, length = buffer.length();
				StringBuffer spin = new StringBuffer();
				for (int i = 0; i < length; i++) {
					c = buffer.charAt(i);
					
					if ((c <= 0xFF) ||
					    (0xFF61 <= c && c <= 0xFF9F) ||
					    charsSpinRight.contains(c))
						s = Constant.SPIN_RIGHT;
					else if (charsSpinLtrb.contains(c))
						s = Constant.SPIN_LTRB;
					else
						s = Constant.SPIN_NONE;
					
					spin.append(s);
					if (s == Constant.SPIN_NONE)
						w += status.fdFontSize.height;
					else
						w += status.fm.charWidth(c);
					w += letterSpacing;
				}
				
				// 
				g.setColor(status.foreColor);
				g.setFont (status.font     );
				y -= (w + Constant.LIST_GAP);
				w = 0;
				char lastType = 0, nowType = 0;
				int  lastIndex = 0;
				for (int i = 0; i <= length; i++) {
					if (i < length)
						nowType = spin.charAt(i);
					else
						nowType = 0;
					
					if (lastType != nowType) {
						if (lastType == Constant.SPIN_NONE)
							drawTextTate(buffer, lastIndex, i, x, y, status, 0, letterSpacing);
						else
							drawTextWithSpin(buffer, lastIndex, i,
							                 x, y, w, status.fdFontSize.height,
							                 status, 0, letterSpacing, lastType);
						
						y += w;
						w =  0;
						lastType  = nowType;
						lastIndex = i;
					}
					
					if (i == length)
						break;
					
					if (nowType == Constant.SPIN_NONE)
						w += status.fdFontSize.height;
					else
						w += status.fm.charWidth(buffer.charAt(i));
					w += letterSpacing;
				}
			}
		}
		
		status.counterStatus.counterNo++;
	}
}
