/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.util.ContentType;

import java.net.URL;
import java.net.MalformedURLException;

/**
 * ɥΤɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class Document
{
	/** 󥿡ͥåȥ */
	public static final int ZONE_INTERNET = 0;
	/** 륾 */
	public static final int ZONE_LOCAL    = 1;
	
	private URL         documentUrl;
	private URL         baseUrl;
	private int         zone;
	private ContentType contentType;
	private String      encoding;
	private int         contentLength;
	private int         media;
	
	/**
	 * ɥȤΥ󥹥󥹤ޤ
	 * 
	 * @param     url           ɥȤ URL
	 * @param     contentType   ƥĥ
	 * @param     encoding      󥳡ǥ
	 * @param     contentLength ƥĤ礭
	 *                          ʾ <code>-1</code>
	 * @param     media         ǥ
	 */
	public Document(URL url, ContentType contentType, String encoding, int contentLength,
	                int media)
	{
		this.documentUrl   = url;
		this.baseUrl       = url;
		this.contentType   = contentType;
		this.encoding      = encoding;
		this.contentLength = contentLength;
		this.media         = media;
		
		if (url.getProtocol().compareTo("file") == 0)
			zone = ZONE_LOCAL;
	}
	
	/**
	 * ɥȤ URL ֤ޤ
	 * 
	 * @return    ɥȤ URL
	 */
	public URL getURL()
	{
		return documentUrl;
	}
	
	/**
	 * ƥĥפ֤ޤ
	 * 
	 * @return    ƥĥ
	 */
	public ContentType getContentType()
	{
		return contentType;
	}
	
	/**
	 * ɥȤΥ󥳡ǥ󥰤֤ޤ
	 * 
	 * @return    ɥȤΥ󥳡ǥ
	 */
	public String getEncoding()
	{
		return encoding;
	}
	
	/**
	 * ɥȤΥ󥳡ǥ󥰤ꤷޤ
	 * 
	 * @param     encoding ɥȤΥ󥳡ǥ
	 */
	public void setEncoding(String encoding)
	{
		this.encoding = encoding;
	}
	
	/**
	 * ƥĤĹ֤ޤ
	 * 
	 * @return    ƥĤĹ
	 */
	public int getContentLength()
	{
		return contentLength;
	}
	
	/**
	 * ƥĤĹꤷޤ
	 * 
	 * @param     length ƥĤĹ
	 */
	public void setContentLength(int length)
	{
		this.contentLength = length;
	}
	
	/**
	 * ١ URL ֤ޤ
	 * 
	 * @return    ١ URL
	 */
	public URL getBaseURL()
	{
		return baseUrl;
	}
	
	/**
	 * ١ URL ѹޤ
	 * 
	 * @param     url ١ URL
	 */
	public void setBaseURL(URL url)
	{
		baseUrl = url;
	}
	
	/**
	 * ǥפ֤ޤ
	 * 
	 * @return    ǥ
	 */
	public int getMedia()
	{
		return media;
	}
	
	/**
	 * ǥפꤷޤ
	 * 
	 * @param     media ǥ
	 */
	public void setMedia(int media)
	{
		this.media = media;
	}
	
	/**
	 * ɥȤ URL ١ URL ֤ޤ
	 * 
	 * @param     href ѥ
	 * 
	 * @return    ɥȤ URL ١ˤ URL
	 * 
	 * @exception MalformedURLException ѥʾ
	 * @exception SecurityException ƥȿξ
	 */
	public URL createURL(String href)
		throws MalformedURLException, SecurityException
	{
		URL url = new URL(baseUrl, href);
		
		if (zone != ZONE_LOCAL && url.getProtocol().compareTo("file") == 0)
			throw new SecurityException("Can not access to local file");
		
		return url;
	}
}
