/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.awt.image.OffscreenObserver;
import net.hizlab.kagetaka.token.FormItem;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.ImageObserver;
import java.util.Vector;

/**
 * 襭ѥ󶡤ޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
class Canvas
	extends Container
{
	/** @serial ե꡼ */
	private Object    offscreenLock     = new Object();
	/** @serial ե꡼ */
	private Image     offscreen         = null;
	/** @serial ե꡼礭 */
	private Dimension offscreenSize     = null;
	/** @serial ե꡼󥰥եå */
	private Graphics  offscreenGraphics = null;
	/** @serial ե꡼Ѥߤ x  */
	private int       offscreenPointer  = 0;
	/** @serial ե꡼μ褹ǥå */
	private int       offscreenIndex    = 0;
	/** @serial ᡼ */
	private Vector    images            = new Vector();
	/** @serial ᡼ */
	private Vector    imageSizes        = new Vector();
	/** @serial 褹뱦ΰ */
	private Point     position          = new Point(0, 0);
	/** @serial ᡼ */
	private Vector    formItems         = new Vector();
	
	/** @serial طʿ */
	private Color     backColor         = Color.white;
	/** @serial طʲ */
	private Image     backImage         = null;
	/** @serial طʲ */
	private Dimension backImageSize     = null;
	
	/**
	 * 襭ѥޤ
	 */
	Canvas()
	{
		setLayout(null);
		
		// ꥹʤϿ
		addComponentListener(
			new ComponentAdapter()
			{
				/** ѹ */
				public void componentResized(ComponentEvent e)
				{
					synchronized (offscreenLock) {
						if (offscreenSize != null) {
							if (offscreenSize.equals(getSize()))
								return;
							
							clearOffscreen();
							repaint();
						}
					}
				}
				
				/** 줿Ȥ */
				public void componentHidden(ComponentEvent e)
				{
					clearOffscreen();
				}
			}
		);
	}
	
	/**
	 * ꡼󥤥᡼ɲäޤ
	 * 
	 * @param     image ꡼󥤥᡼
	 * @param     size ꡼󥤥᡼Υ
	 */
	void addImage(Image image, Dimension size)
	{
		synchronized (images) {
			images    .addElement(image);
			imageSizes.addElement(size );
		}
		
		synchronized (offscreenLock) {
			if (isShowing() &&
			    (offscreen == null || offscreenPointer > 0))
				repaint();
		}
	}
	
	/**
	 * եॢƥɲäޤ
	 * 
	 * @param     item եॢƥ
	 */
	void addFormItem(FormItem item)
	{
		synchronized (images) {
			formItems.addElement(item);
			
			if (offscreenSize == null)
				return;
			
			Point     pos  = item.getPosition();
			Dimension size = item.getSize    ();
			if (position.x <= pos.x + size.width  &&
			    position.y <= pos.y + size.height &&
			    position.x + offscreenSize.width  >= pos.x &&
			    position.y + offscreenSize.height >= pos.y) {
				Component c = item.getComponent();
				add(c);
				c.setBounds(offscreenSize.width - pos.x + position.x - size.width,
				            pos.y - position.y,
				            size.width,
				            size.height);
			}
		}
	}
	
	/**
	 * ѥϰϤꤷƺɽޤ
	 * ɸϱ夫εΥǤ
	 * 
	 * @param     x ѥα顢ɽ֤αüεΥ
	 * @param     y ѥξ夫顢ɽ֤ξüεΥ
	 * @param     width  ɽϰϤ
	 * @param     height ɽϰϤι⤵
	 */
	void repaintImage(int x, int y, int width, int height)
	{
//System.out.println(x+","+y+","+width+","+height);
		if (!isShowing())
			return;
		
		synchronized (offscreenLock) {
			if (offscreen == null) {
				repaint();
				return;
			}
			
			// ϰ
			int right  = offscreenSize.width - (x - position.x);
			int left   = right - width;
			int top    = y - position.y;
			int bottom = top + height;
			
			if (right  < 0 || offscreenSize.width  <= left ||
			    bottom < 0 || offscreenSize.height <= top)
				return;
			
			synchronized (images) {
				int               x1    = offscreenSize.width + position.x;
				int               x2    = x1;
				int               y2    = y + height;
				boolean           first = true;
				int               max   = images.size();
				Dimension         s     = null;
				OffscreenObserver oo    = null;
				boolean           sync  = false;
				
				for (int i = 0; x1 > 0 && i < max; i++) {
					s = (Dimension)imageSizes.elementAt(i);
					x2 =  x1;
					x1 -= s.width;
					
					if (x1 > offscreenSize.width)
						continue;
					
					if (!sync) {
						oo   = new OffscreenObserver(this, offscreenGraphics);
						oo.y = top;
					}
					
					// ޤŤʤäƤʤʽŤʤ꽪äϡǤ for ȴƤ
					if (right <= x1)
						continue;
					
					if (x1 <= left) {
						// ǽäƤ
						oo.x = left;
						
						if (first)
							// äݤäƤ
							sync = offscreenGraphics.drawImage((Image)images.elementAt(i),
							                                   oo.x, top, right, bottom,
							                                   left - x1, y, left - x1 + width, y2,
							                                   oo);
						else
							// ĤʤäƤǽäƤʱӽФƤ
							sync = offscreenGraphics.drawImage((Image)images.elementAt(i),
							                                   oo.x, top, x2, bottom,
							                                   left - x1, y, s.width, y2,
							                                   oo);
						break;
					} else {
						// ޤ³Ƥ
						oo.x = x1;
						
						if (first) {
							// ǻϤޤ꼡³ƤʺӽФƤ
							sync = offscreenGraphics.drawImage((Image)images.elementAt(i),
							                                   oo.x, top, right, bottom,
							                                   0, y, right - x1, y2,
							                                   oo);
							first = false;
						} else
							// Ĥʤ꼡³ƤʺӽФƤ
							sync = offscreenGraphics.drawImage((Image)images.elementAt(i),
							                                   oo.x, top, x2, bottom,
							                                   0, y, s.width, y2,
							                                   oo);
					}
				}
			}
			
			// եॢƥ
			if (formItems.size() > 0)
				paintFormItem();
			
			Graphics g = getGraphics();
			if (g != null)
				try {
					g.drawImage(offscreen, 0, 0, this);
				} finally {
					g.dispose();
				}
			else
				repaint();
		}
	}
	
	/**
	 * 򥯥ꥢޤ
	 */
	void cleanScreen()
	{
		synchronized (images) {
			if (offscreenSize != null)
				offscreenPointer = offscreenSize.width;
			offscreenIndex = 0;
			for (int i = images.size() - 1; i >= 0; i--)
				((Image)images.elementAt(i)).flush();
			images    .removeAllElements();
			imageSizes.removeAllElements();
			formItems .removeAllElements();
			removeAll();
			position.x = 0;
			position.y = 0;
			setBackground(Color.white);
			setBackground((Image)null);
		}
	}
	
	/**
	 * 褹륤᡼ΰ֤ѹޤ
	 * 
	 * @param     x 夫εΥ
	 * @param     y 夫εΥ
	 */
	void movePosition(int x, int y)
	{
		if (position.x == x && position.y == y)
			return;
		
		synchronized (images) {
			if (offscreenSize == null)
				return;
			
			position.x = x;
			position.y = y;
			
			// 褵褦ˡݥ󥿤᤹
			offscreenPointer = offscreenSize.width + position.x;
			offscreenIndex   = 0;
			
			// եॢƥ֤
			allocateFormItems();
		}
		
		Graphics g = getGraphics();
		if (g != null)
			try {
				paint(g);
			} finally {
				g.dispose();
			}
		else
			repaint();
	}
	
//### Override
	/**
	 * 褷ޤ
	 * 
	 * @param     g Graphics
	 */
	public void update(Graphics g)
	{
		paint(g);
	}
	
	/**
	 * 褷ޤ
	 * 
	 * @param     g Graphics
	 */
	public void paint(Graphics g)
	{
		synchronized (offscreenLock) {
			// ե꡼Хåե̵Ϻ
			if (offscreen == null) {
				Dimension size = getSize();
				
				offscreen         = createImage(size.width, size.height);
				offscreenSize     = size;
				offscreenGraphics = offscreen.getGraphics();
				offscreenPointer  = offscreenSize.width + position.x;
				offscreenIndex    = 0;
				
				// եॢƥ֤
				allocateFormItems();
			}
			
			// 襤᡼򥳥ԡ
			if (offscreenPointer > 0) {
				synchronized (images) {
					int               max  = images.size();
					Dimension         s    = null;
					OffscreenObserver oo   = null;
					boolean           sync = false;
					int x2, y2;
					
					for (; offscreenPointer > 0 && offscreenIndex < max; offscreenIndex++) {
						s = (Dimension)imageSizes.elementAt(offscreenIndex);
						offscreenPointer -= s.width;
						
						if (offscreenPointer >= offscreenSize.width)
							continue;
						
						if (!sync)
							oo = new OffscreenObserver(this, offscreenGraphics);
						
						oo.x = offscreenPointer;
						x2   = offscreenPointer + s.width;
						y2   = Math.min(s.height - position.y, offscreenSize.height);
						sync = offscreenGraphics.drawImage((Image)images.elementAt(offscreenIndex),
						                                   oo.x, 0, x2, y2,
						                                   0, position.y,
						                                   s.width, Math.min(s.height, offscreenSize.height + position.y),
						                                   oo);
						// ¦;򤬤硢طʤԤ
						if (y2 < offscreenSize.height)
							drawBackground(oo.x, y2, x2, offscreenSize.height);
					}
				}
				
				// ¦;򤬤硢طʤԤ
				if (offscreenPointer > 0)
					drawBackground(0, 0, offscreenPointer, offscreenSize.height);
			}
			
			// եॢƥ
			if (formItems.size() > 0)
				paintFormItem();
			
			g.drawImage(offscreen, 0, 0, this);
		}
	}
	
	/**
	 * طʿꤷޤ
	 * 
	 * @param     color طʿ
	 */
	public void setBackground(Color color)
	{
		super.setBackground(color);
		this.backColor = color;
		
		if (isShowing())
			repaint();
	}
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     image طʲ
	 */
	public void setBackground(Image image)
	{
		this.backImage = image;
		if (image != null)
			backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
		
		if (isShowing())
			repaint();
	}
	
	/**
	 * ե뤳Ȥ뤫֤ޤ
	 * ŪˤΥڥϡեܡɤˤǽʤΤǡ
	 *  <code>true</code> ֤ޤ
	 * 
	 * @return    ե뤳ȤǤ뤫
	 */
	public boolean isFocusTraversable()
	{
		return true;
	}
	
	/**
	 * ΥѥΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	protected String paramString()
	{
		String str = super.paramString();
		return str;
	}
	
//### private
	/** ե꡼Хåե򥯥ꥢ */
	private void clearOffscreen()
	{
		synchronized (offscreenLock) {
			if (offscreen != null) {
				offscreenGraphics.dispose();
				offscreen        .flush  ();
			}
			
			offscreen         = null;
			offscreenSize     = null;
			offscreenGraphics = null;
			offscreenPointer  = 0;
			offscreenIndex    = 0;
		}
	}
	
	/** ϰϤطʿطʲԤ - ºݤ x,y ǻ( 0,0) */
	private void drawBackground(int x1, int y1, int x2, int y2)
	{
//System.out.println("a="+x1+","+y1+","+x2+","+y2);
		
		if (backImage == null) {
			offscreenGraphics.setColor(backColor);
			offscreenGraphics.fillRect(x1, y1, x2 - x1, y2 - y1);
		} else {
			int sx1 = 0, sy1 = 0, sx2 = 0, sy2 = 0;
			int dx1 = 0, dy1 = 0, dx2 = 0, dy2 = 0;
			
			dx1 = ((position.x + (offscreenSize.width - x2)) % backImageSize.width) + x2;
			int offsetY = ((position.y + y1) % backImageSize.width);
			do {
				// x Ĵ
				sx1 =  0;
				sx2 =  backImageSize.width;
				dx2 =  dx1;
				dx1 -= backImageSize.width;
				// ¦ˤϤ߽ФƤʤå
				if (dx2 > x2) {
					sx2 -= dx2 - x2;
					dx2 =  x2;
				}
				// ¦ˤϤ߽ФƤʤå
				if (dx1 < x1) {
					sx1 = x1 - dx1;
					dx1 = x1;
				}
				// y Ĵ
				sy2 = backImageSize.height;
				dy2 = y1 - offsetY;
//System.out.println("d="+dx1+","+dx2+","+sx1+","+sx2);
				do {
					sy1 =  0;
					dy1 =  dy2;
					dy2 += backImageSize.height;
					// ¦ˤϤ߽ФƤʤå
					if (dy1 < y1) {
						sy1 = y1 - dy1;
						dy1 = y1;
					}
					// ¦ˤϤ߽ФƤʤå
					if (dy2 > y2) {
						sy2 -= dy2 - y2;
						dy2 =  y2;
					}
//System.out.println(dx1+","+dy1+","+dx2+","+dy2+","+sx1+","+sy1+","+sx2+","+sy2);
					offscreenGraphics.drawImage(backImage, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, this);
				} while (dy2 < y2);
			} while (dx1 > x1);
		}
	}
	
	/** եॢƥෲ */
	private void allocateFormItems()
	{
		for (int i = formItems.size() - 1; i >= 0; i--)
			allocateFormItem((FormItem)formItems.elementAt(i));
	}
	
	/** եॢƥ */
	private void allocateFormItem(FormItem item)
	{
		Point     pos  = item.getPosition ();
		Dimension size = item.getSize     ();
		Component c    = item.getComponent();
		
		if (position.x <= pos.x + size.width  &&
		    position.y <= pos.y + size.height &&
		    position.x + offscreenSize.width  >= pos.x &&
		    position.y + offscreenSize.height >= pos.y) {
			if (c.getParent() == null)
				add(c);
			c.setBounds(offscreenSize.width - pos.x + position.x - size.width,
			            pos.y - position.y,
			            size.width,
			            size.height);
		} else {
			if (c.getParent() != null)
				remove(c);
		}
	}
	
	/** եॢƥ */
	private void paintFormItem() {
		Component cs[] = getComponents();
		
		Graphics  g;
		Component c;
		Rectangle r;
		for (int i = cs.length - 1; i >= 0; i--) {
			if ((c = cs[i]) != null) {
				r = c.getBounds();
				g = offscreenGraphics.create(r.x, r.y, r.width, r.height);
				
				try {
					c.paintAll(g);
				} finally {
					g.dispose();
				}
			}
		}
	}
}
