/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.Value;

import java.util.Hashtable;

/**
 * ʣʸפθǤޤ(/)
 */
class Caddy
{
	Paragraph paragraph;
	boolean   ruby;
	
	private Drawkit   drawkit;
	private Wadge     wadge     = null;
	private Wadge     baseWadge;
	
	// 
	private int   rubyMode  = 0;
	private Wadge rubyWadge = null;
	
	int   width  = 0;
	int   height = 0;
	int   offset = 0;
	int   pitch  = 0;
	Caddy next   = null;
	
	/** 󥹥󥹤 */
	Caddy(Paragraph paragraph, boolean ruby)
	{
		this.paragraph = paragraph;
		this.ruby      = ruby;
		
		drawkit   = paragraph.box.drawkit;
		baseWadge = new Wadge(this, ruby ? Wadge.BASE : Wadge.NORMAL, null);
		wadge     = baseWadge;
	}
	
	/** ʸɲ */
	void append(String text, int begin, int end)
	{
		if (wadge != null)
			wadge.append(text, begin, end);
	}
	
	/** ɲ */
	void append(String src, String alt, Value width, Value height, int border, int floatType)
	{
		if (wadge != null)
			wadge.append(src, alt, width, height, border, floatType);
	}
	
	/** եȤɲ */
	void append(Box box)
	{
		if (wadge != null)
			wadge.append(box);
	}
	
	/** եॢƥɲ */
	void append(FormItem item)
	{
		if (wadge != null)
			wadge.append(item);
	}
	
	/** ӤΥ⡼ɤѹ */
	void setRuby(int mode)
	{
		if (rubyMode == mode)
			return;
		
		switch (mode) {
		case Constant.RUBY_RB:
			wadge = baseWadge;
			break;
		case Constant.RUBY_RP:
			wadge = null;
			break;
		case Constant.RUBY_RT:
			if (rubyWadge == null)
				rubyWadge = new Wadge(this, Wadge.RUBY, baseWadge);
			wadge = rubyWadge;
			break;
		case Constant.RUBY_END:
			break;
		}
		
		rubyMode = mode;
	}
	
	/** ơѹ줿 */
	void statusChanged()
	{
		if (wadge == null)
			return;
		
		wadge.statusChanged();
	}
	
	/**  */
	void commit()
	{
//System.out.println("Caddy.commit");
		if (ruby) {
			if (rubyMode < Constant.RUBY_END)
				return;
			baseWadge.commit();
			if (rubyWadge != null)
				rubyWadge.commit();
			rubyMode = Constant.RUBY_COMMITED;
		} else {
			baseWadge.commit();
		}
		
		paragraph.lineWidth  =  Math.max(paragraph.lineWidth , width );
		paragraph.lineHeight += height;
		paragraph.lineOffset =  Math.max(paragraph.lineOffset, offset);
		paragraph.linePitch  =  Math.max(paragraph.linePitch , pitch );
	}
	
	/** Ԥ */
	void rearrange(int newHeight)
	{
		if (baseWadge != null)
			baseWadge.rearrange(newHeight);
		if (rubyWadge != null)
			rubyWadge.rearrange(newHeight);
		
		paragraph.lineWidth  =  Math.max(paragraph.lineWidth , width );
		paragraph.lineHeight += height;
		paragraph.lineOffset =  Math.max(paragraph.lineOffset, offset);
		paragraph.linePitch  =  Math.max(paragraph.linePitch , pitch );
	}
	
	/** ߹Ԥ */
	void draw(Position p)
	{
//System.out.println("Caddy.draw");
		if (ruby) {
			// ӤλƤʤ褷ʤ
			if (rubyMode != Constant.RUBY_COMMITED)
				return;
			
			baseWadge.draw(p, height);
			if (rubyWadge != null)
				rubyWadge.draw(p, height);
			
			rubyMode = Constant.RUBY_DREW;
		} else {
			baseWadge.draw(p, 0);
		}
	}
	
	/**
	 * ʸɽ֤ޤ
	 * 
	 * @return    ʸɽ
	 */
	public String toString()
	{
		return baseWadge.toString();
	}
}
