/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.rendering;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.TokenTypes;
import net.hizlab.kagetaka.token.Value;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.util.Vector;

class Box
	implements DelayRectangle
{
	private static final int CUR = 0;
	private static final int MIN = 1;
	private static final int MAX = 2;
	private static final int FIX = 3;
	private static final int PER = 4;
	
	Drawkit drawkit;
	Status  status;                           //  BOX Υơ
	private Box       origin;                 // 縵ο(BODY or TD)
	private Box       parent;                 // Ƥ BOX
	
	private boolean   fixedBlock;             // ʬȤɤ
	private int       level = - 1;            // BOX Υͥȥ٥
	private Insets    frame;                  // Ȥ礭
	private Dimension preferredSize;          // 侩
	
	private Insets border  = null;            // ܡ
	private Insets padding = new Insets(0, 0, 0, 0);         // ѥǥ󥰤
	private Insets margin  = new Insets(0, 0, 0, 0);         // ޡ
	
	private int     width         = 0;        // ܥå
	private int     height        = 0;        // ܥåι⤵
	private int     innerWidth    = 0;        // ºݤƥĤVALIGN ѡ
	private int     maxHeight     = 0;        // ˹Ȥι⤵
	
	// å
	private boolean heightPercent = false;    // λ꤬ѡȤɤ
	private boolean heightFixed   = false;    // θ꤫ɤ
	private int     frameWidth    = 0;        // ե졼
	private int     frameHeight   = 0;        // ե졼ι⤵
	
	// TOP BOX 䤽ϢΤɬ
	private int     topOffset   = 0;          // ȥåץܥåΰ
	private Vector  delayPanels = null;       // ȥåľ̤ Box ꥹ
	private boolean dummyBox    = false;      // ȥåľ˺줿ߡ Box
	
	// ꥸ BOX ˤΤɬ
	private FloatChain floatChain = null;     // եȾ
	
	// եȤξ Wadge 饢
	Point   floatOffset;                      // եȰ
	int     floatDelayX;                      // եȻѸ X 
	int     floatDelayY;                      // եȻѸ Y 
	int     drawWidth;                        // ɬפ
	int     drawHeight;                       // ɬפʹ⤵
	
	// ơ֥
	private Cell[][] cells = null;            // 
	private int colNum     = 0;               // Կ
	private int rowNum     = 0;               // 
	private int verticalSpacing   = 0;        // ֤
	private int horizontalSpacing = 0;        // ιԴ֤
	private int totalMinHeight    = 0;        // κ⤵ιסʥ֤ϴޤޤʤ
	private int totalMaxHeight    = 0;        // κ⤵ιסʥ֤ϴޤޤʤ
	private int [] curHeights;
	private int [] minHeights;
	private int [] maxHeights;
	private int [] fixHeights;
	private int [] perHeights;
	private boolean   tableHasFixed;
	private boolean   tableHasPercent;
	
	private Point  drawOffset   = new Point (0, 0);          // ֥եå
	private Insets originOffset = new Insets(0, 0, 0, 0);    // ꥸ󤫤Υեå
	
	private Vector    contents   = null;      // Ҥ BOX
	private Box       lastBox    = null;      // Ǹ˺Ҥ BOX
	private Paragraph paragraph  = null;      // Ǹ
	private Status    listStatus = null;      // ꥹ LI 
	
	/**  BOX  */
	Box(Drawkit drawkit)
	{
		this(drawkit, null, null);
		
		// ȥåץ٥Υܥåγ
		if (level == 0 && frame.right > 0) {
			drawkit.createPanel(frame.right, 1, status);
			drawkit.commitPanel();
		}
	}
	
	/**  BOX  */
	private Box(Drawkit drawkit, Box parent, Box last)
	{
		if (parent == null)
			origin = parent = this;
		
		this.drawkit    = drawkit;
		this.status     = drawkit.status;
		this.origin     = (parent.status.isTable ? this : parent.origin);
		this.parent     = parent;
		this.level      = parent.level + 1;
		this.fixedBlock = (level <= 1 || parent.status.isTable);
		if (status.floatType != Value.FLOAT_NONE) {
			this.origin      = this;
			this.floatOffset = new Point(0, 0);
		}
		
		frame = new Insets(0, 0, 0, 0);
		if (!parent.status.isTable && status.margin  != null) {
			int baseWidth  = (level == 0 ? drawkit.viewSize.width  : 0);
			int baseHeight = (level == 0 ? drawkit.viewSize.height : 0);
			
			if (status.margin.top    != null) frame.top    += (margin.top    =          status.margin.top   .getValue(status.fd, baseHeight, Value.DATA_VERTICAL  ));
			if (status.margin.right  != null) frame.right  += (margin.right  = Math.max(status.margin.right .getValue(status.fd, baseWidth , Value.DATA_HORIZONTAL) - (last != null ? last.margin.left : 0), 0));
			if (status.margin.bottom != null) frame.bottom += (margin.bottom =          status.margin.bottom.getValue(status.fd, baseHeight, Value.DATA_VERTICAL  ));
			if (status.margin.left   != null) frame.left   += (margin.left   =          status.margin.left  .getValue(status.fd, baseWidth , Value.DATA_HORIZONTAL));
		}
		if (status.border  != null) {
			status.border.setBaseSize(status.fd);
			border = status.border.getWidths();
			frame.top    += border.top   ;
			frame.right  += border.right ;
			frame.bottom += border.bottom;
			frame.left   += border.left  ;
		}
		if (status.padding != null) {
			if (status.padding.top    != null) frame.top    += (padding.top    = status.padding.top   .getValue(status.fd, 0, Value.DATA_VERTICAL  ));
			if (status.padding.right  != null) frame.right  += (padding.right  = status.padding.right .getValue(status.fd, 0, Value.DATA_HORIZONTAL));
			if (status.padding.bottom != null) frame.bottom += (padding.bottom = status.padding.bottom.getValue(status.fd, 0, Value.DATA_VERTICAL  ));
			if (status.padding.left   != null) frame.left   += (padding.left   = status.padding.left  .getValue(status.fd, 0, Value.DATA_HORIZONTAL));
		}
		
		heightPercent = (status.height != null && status.height.getUnit() == Value.UNIT_PERCENT);
		heightFixed   = (status.height != null && status.height.getUnit() != Value.UNIT_PERCENT);
		frameWidth    = frame.left + frame.right;
		frameHeight   = frame.top + frame.bottom;
		
		if (level == 0)
			preferredSize = new Dimension(0, drawkit.viewSize.height - frameHeight);
		else
			preferredSize = new Dimension(
				(status.width  != null ? status.width .getValue(status.fd, 0, Value.DATA_HORIZONTAL)
				                       : 0),
				(parent.status.isTable ? (status.height != null && status.height.getUnit() != Value.UNIT_PERCENT
				                         ? status.height.getValue(status.fd, 0, Value.DATA_VERTICAL)
				                         : 1)
				                       : (status.height != null
				                         ? status.height.getValue(status.fd, parent.preferredSize.height - (status.isTable ? 0 : frameHeight), Value.DATA_VERTICAL)
				                         : parent.preferredSize.height - (status.isTable ? 0 : frameHeight)))
			);
		
		if (status.isTable) {
			// ֤׻
			verticalSpacing   = (status.borderVerticalSpacing   != null
			                     ? status.borderVerticalSpacing  .getValue(status.fd, 0, Value.DATA_VERTICAL  )
			                     : 2);
			horizontalSpacing = (status.borderHorizontalSpacing != null
			                     ? status.borderHorizontalSpacing.getValue(status.fd, 0, Value.DATA_HORIZONTAL)
			                     : 2);
			if (heightFixed && border != null) {
				preferredSize.width  = Math.max(preferredSize.width  - (border.left + border.right), 0);
				preferredSize.height = Math.max(preferredSize.height - (border.top + border.bottom), 0);
			}
		}
	}
	
	/** BOX ˴ʸߤϥȥåץ٥ BOX ƤФʤ */
	void dispose()
	{
		// ȥåץ٥ΥܥåĤ
		if (level == 0) {
			if (delayPanels != null)
				drawWithQueue(false, Math.max(floatChain.getWidth() - topOffset, 0));
			
			if (frame.left > 0) {
				drawkit.createPanel(frame.left, 1, status);
				drawkit.commitPanel();
			}
		}
//if (floatChain != null)
//floatChain.dump();
	}
	
	/** ܥåܥå֤ */
	Box createBox()
	{
		boolean noFloat = (drawkit.status.floatType == Value.FLOAT_NONE);
		
		if (noFloat) {
			commitParagraph();
			
			lastBox = new Box(drawkit, this, lastBox);
			
			// ꥹǤ򡢼 BOX ذѤ
			if (noFloat && listStatus != null) {
				lastBox.listStatus = listStatus;
				listStatus = null;
			}
			
			if (contents == null)
				contents = new Vector();
			contents.addElement(lastBox);
			
			return lastBox;
		} else {
			Box box = null;
			
			// ȥåľΥեȥܥåϡΥܥåǥåפ2 ٥벼
			if (level == 0) {
				drawkit.insertStatus(TokenTypes._BLOCK_START);
				drawkit.status.checkStatus();
				statusChanged();
				
				box = createBox();
				box.dummyBox = true;
				
				drawkit.saveStatus(TokenTypes.UNKNOWN);
				drawkit.status.checkStatus();
				box.statusChanged();
				return box.createBox();
			}
			
			box = lastBox = new Box(drawkit, this, lastBox);
			
			checkParagraph();
			paragraph.appendFloat(box);
			
			return box;
		}
	}
	
	/** ܥå򥳥ߥåȤοƤΥܥå֤ */
	Box commitBox()
	{
		commitParagraph();
		if (status.isTable && lastBox != null)
			lastBox.status.isVertical = false;
		
		// ʬΥ׻
		if (contents != null) {
			if (status.isTable)
				doCountSizeTable ();
			else
				doCountSizeNormal();
		} else if (status.isHorizontalRule) {
			doCountSizeHR();
		}
		
		// ȥåסBODY ľΥ֥å˥ܥåξ
		if (level == 1) {
			// BODY ϰ֤Υեå
			originOffset.right  = parent.topOffset;
			originOffset.top    = parent.frame.top;
			originOffset.bottom = parent.frame.bottom;
			
			// 礭
			rearrange(preferredSize.height + (status.isTable ? 0 : frameHeight),
			          parent.preferredSize.height);
			
			// ơ֥ʳϡȥåץ٥̤äѤˤ
			if (!status.isTable && status.height == null) {
				int diff;
				if ((diff = Math.max(preferredSize.width  - width , 0)) > 0) { width  += diff; drawWidth  += diff; }
				if ((diff = Math.max(preferredSize.height - height, 0)) > 0) { height += diff; drawHeight += diff; }
			}
			
			// ⤵̥꾮ȤΤߥ󥿥󥰡󤻤Ԥ
			if (status.align == Value.ALIGN_CENTER || status.align == Value.ALIGN_RIGHT) {
				int parentHeight = parent.preferredSize.height - frameHeight;
				if (parentHeight < drawkit.viewSize.height &&
				    parentHeight > height) {
					int offset = 0;
					
					switch (parent.status.align) {
					case Value.ALIGN_CENTER: offset = (parentHeight - height) / 2; break;
					case Value.ALIGN_RIGHT : offset = (parentHeight - height);     break;
					}
					
					drawOffset.y += offset;
					height       += offset;
					drawHeight   += offset;
				}
			}
			
			// BODY μΥѥͥγϰ֤ư
			parent.topOffset += drawWidth;
			
			// 
			if (drawWidth > 0 && drawHeight > 0 || origin.floatChain != null) {
				// ߤΥѥͥνλ֤˥եȥܥåŤʤäƤϡ塼ɲ
				if (origin.floatChain != null &&
				    origin.floatChain.getHeight(FloatChain.BOTH,
				                                originOffset.right + drawWidth,
				                                originOffset.top,
				                                originOffset.bottom) > 0) {
					if (parent.delayPanels == null)
						parent.delayPanels = new Vector();
					parent.delayPanels.addElement(this);
				} else {
					drawWithQueue(true, 0);
				}
			}
		}
		
		// 䴰줿ܥåξ硢οƤ⥳ߥåȤ
		if (parent.dummyBox) {
			drawkit.resetStatus();
			drawkit.status.checkStatus();
			parent.statusChanged();
			return parent.commitBox();
		}
		
		return parent;
	}
	
	/** ơѹ줿 */
	void statusChanged()
	{
		if (paragraph != null)
			paragraph.statusChanged();
	}
	
	/** Ԥ */
	void rearrange(int newHeight, int parentHeight)
	{
//System.out.println("Box.rearrange,"+level+","+Integer.toHexString(this.hashCode())+","+Integer.toHexString(parent.hashCode()));
		if (contents == null && !status.isHorizontalRule)
			return;
		
		// ե졼ʬ
		newHeight    -= frameHeight;
		parentHeight -= frameHeight;
		
		// ʬȤ origin ξϥեåȤ򥯥ꥢ
		if (origin == this) {
			originOffset.right = originOffset.top = originOffset.bottom = 0;
			floatChain = null;
		}
		// ơ֥ΥʳξǡξϤ˽
		if (!parent.status.isTable && heightFixed)
			newHeight = preferredSize.height;
		
		// ߤػߤξ硢եȤ褱뤿˥ޡ礹ɬפ
		if (status.clearType  != Value.CLEAR_NONE &&
		    origin.floatChain != null) {
			int right = origin.floatChain.getClearPosition(status.clearType, originOffset.right)
			          - originOffset.right;
			if (right > margin.right) {
				right -= margin.right;
				margin.right += right;
				frame .right += right;
				frameWidth   += right;
			}
		}
		
		int offset = 0;
		
		// ơ֥ξ硢եȤ褱ɬפ
		if (status.isTable &&
		    status.floatType  == Value.FLOAT_NONE &&
		    origin.floatChain != null) {
			offset = getFloatGap(offset - frame.right,
			                     (heightFixed ? newHeight : height),
			                     parentHeight)
			       + frame.right;
			
			if (offset > 0)
				drawOffset.x += offset;
			drawOffset.y =  origin.floatChain.getHeight(FloatChain.TOP,
			                                            originOffset.right + offset,
			                                            originOffset.top,
			                                            originOffset.bottom);
			if (!heightFixed)
				newHeight -= Math.max(origin.floatChain.getHeight(FloatChain.BOTH,
				                                                  originOffset.right  + offset,
				                                                  originOffset.top,
				                                                  originOffset.bottom)
				                      - (parentHeight - newHeight), 0);
		}
		
		// եȤξϡ礭ǽʸ¤̤
		if (status.floatType != Value.FLOAT_NONE)
			newHeight = Math.min(newHeight, maxHeight);
		
		width  = 0;
		height = 0;
		
		if (status.isTable)
			rearrangeTable (newHeight);
		else if (status.isHorizontalRule)
			rearrangeHR    (newHeight);
		else
			rearrangeNormal(newHeight);
		
		drawWidth  = width  + frameWidth + offset;
		drawHeight = height + frameHeight;
		
		innerWidth = width;
	}
	
	/** ʺ夫εΥ */
	private void draw(int x, int y)
	{
		if (((frame.right + width  + frame.left) == 0 ||
		     (frameHeight + height) == 0) &&
		    origin.floatChain == null)
			return;
		
		x -= drawOffset.x;
		y += drawOffset.y;
		
		if (level > 0) {
			// طʿɤ
			if (status.backColor != null) {
				int w = width  + padding.left + padding.right;
				int h = height + padding.top  + padding.bottom;
				if (w > 0 && h > 0) {
					drawkit.g.setColor(status.backColor);
					drawkit.g.fillRect(x - frame.right - width - padding.left,
					                   y + (frame.top - padding.top),
					                   w, h);
				}
			}
		}
		
		// ܡ
		if (border != null) {
			if (!status.isHorizontalRule) {
				status.border.draw(drawkit.g,
				                   x - frame.right - width - padding.left - border.left,
				                   y + margin.top,
				                   x - margin.right,
				                   y + frame.top + height + padding.bottom + border.bottom,
				                   status.foreColor);
			} else {
				// ʿȤ
				int h = status.hrHeight.getValue(status.fd, height, Value.DATA_VERTICAL);
				int offset = 0;
				
				// ⤵̥꾮ȤΤߥ󥿥󥰡󤻤Ԥ
				if ((status.align == Value.ALIGN_CENTER || status.align == Value.ALIGN_RIGHT) &&
				    height < drawkit.viewSize.height) {
					switch (status.align) {
					case Value.ALIGN_CENTER: offset = (height - h) / 2; break;
					case Value.ALIGN_RIGHT : offset = (height - h);     break;
					}
				}
				
				status.border.draw(drawkit.g,
				                   x - frame.right - width - padding.left - border.left,
				                   y + offset + margin.top,
				                   x - margin.right,
				                   y + offset + frame.top + h + padding.bottom + border.bottom,
				                   status.foreColor);
			}
		}
		
		if (contents == null)
			return;
		
		x -= frame.right;
		y += frame.top;
		
		// ·
		switch (status.valign) {
		case Value.VALIGN_BOTTOM: x -= (width - innerWidth);     break;
		case Value.VALIGN_TOP   : break;
		default                 : x -= (width - innerWidth) / 2; break;
		}
		
		// 
		Object o;
		int    offset;
		Box    box;
		for (int i = 0; i < contents.size(); i++) {
			o = contents.elementAt(i);
			if (o instanceof Box) {
				box = (Box)o;
				offset = 0;
				
				if ((status.align == Value.ALIGN_CENTER || status.align == Value.ALIGN_RIGHT) &&
				    (level > 1 || drawkit.viewSize.height > box.height + box.frameHeight)) {
					int h = (level == 1 ? Math.min(height, drawkit.viewSize.height) : height);
					h -= getFloatHeight(box.drawOffset.x, FloatChain.BOTH);
					// 󥿥󥰡󤻤Ԥ
					switch (status.align) {
					case Value.ALIGN_CENTER: offset = (h - (box.height + box.frameHeight)) / 2; break;
					case Value.ALIGN_RIGHT : offset = (h - (box.height + box.frameHeight));     break;
					}
				}
				
				box.draw(x, y + offset);
			} else {
				((Paragraph)o).draw(x, y);
			}
		}
	}
	
	/** 塼Τޤ */
	private void drawWithQueue(boolean current, int addWidth)
	{
		int w = addWidth, h = 0;
		
		if (current) {
			w += drawWidth;
			h += drawHeight;
		}
		
		// 塼礭ɲ
		if (parent.delayPanels != null) {
			Box box;
			for (int i = 0; i < parent.delayPanels.size(); i++) {
				box = (Box)parent.delayPanels.elementAt(i);
				w += box.width + box.frameWidth;
				h =  Math.max(h, box.height + box.frameHeight);
			}
		}
		
		// ѥͥ
		drawkit.createPanel(w, h + parent.frameHeight, status);
		
		// եȤΤϢ³Ƥܥå
		if (parent.delayPanels != null) {
			Box box;
			for (int i = 0; i < parent.delayPanels.size(); i++) {
				box = (Box)parent.delayPanels.elementAt(i);
				box.draw(w, parent.frame.top);
				w -= box.drawWidth;
			}
			parent.delayPanels = null;
		}
		
		// ȥܥå
		if (current)
			draw(w, parent.frame.top);
		
		// եȤٱ¹
		if (drawkit.floatQueue != null) {
			DelayRectangle dl;
			
			while ((dl = (DelayRectangle)drawkit.floatQueue.get()) != null)
				dl.drawDelay();
			
			drawkit.floatQueue = null;
		}
		
		// ѥͥ򥳥ߥå
		drawkit.commitPanel();
	}
	
	/** ٱ򳫻 */
	public void drawDelay()
	{
		draw(floatDelayX, floatDelayY);
	}
	
	/** ѡȤ褹 */
	int resolvePercent(int height)
	{
		if (!heightPercent)
			return height;
		
		return height * status.height.getNumber().intValue() / 100;
	}
	
	/** եȤɲáParagraph  */
	Point addFloat(int offset, int width, int height, int type, int maxHeight)
	{
		if (origin.floatChain == null)
			origin.floatChain = new FloatChain();
		
		offset += originOffset.right + frame.right;
		Point pos = origin.floatChain.allocate(type, offset, width, height,
		                                       originOffset.top    + frame.top,
		                                       originOffset.bottom + frame.bottom,
		                                       maxHeight);
		pos.x -= originOffset.right + frame.right;
		
		return pos;
	}
	
	/** ֤Υեȥ֤ */
	int getFloatHeight(int offset, int type)
	{
		if (origin.floatChain == null)
			return 0;
		
		return origin.floatChain.getHeight(type,
		                                   originOffset.right  + frame.right + offset,
		                                   originOffset.top    + frame.top,
		                                   originOffset.bottom + frame.bottom);
	}
	
	/** ְʹߤǡꥵ֤֤ */
	int getFloatGap(int offset, int newHeight, int maxHeight)
	{
		if (origin.floatChain == null)
			return offset;
		
		offset += originOffset.right + frame.right;
		offset =  origin.floatChain.getGapPosition(offset, newHeight,
		                                           originOffset.top    + frame.top,
		                                           originOffset.bottom + frame.bottom,
		                                           maxHeight);
		offset -= originOffset.right + frame.right;
		
		return offset;
	}
	
//### 
	/** ʸ */
	void appendString(String text)
	{
		checkParagraph();
		paragraph.appendString(text);
	}
	
	/** Ѥ߹Ԥ */
	void appendNewLine()
	{
		checkParagraph();
		paragraph.newLine();
	}
	
	/** Ԥɲ */
	void createNewRow()
	{
		if (lastBox != null)
			lastBox.status.isVertical = false;
	}
	
	/** ɲ */
	void appendImage(String src, String alt, Value width, Value height, int border, int floatType)
	{
		checkParagraph();
		paragraph.appendImage(src, alt, width, height, border, floatType);
	}
	
	/** եॢƥɲ */
	void appendForm(FormItem item)
	{
		checkParagraph();
		paragraph.appendForm(item);
	}
	
	/** ӤΥ⡼ɤѹ */
	void setRuby(int mode)
	{
		checkParagraph();
		paragraph.setRuby(mode);
	}
	
	/** ꥹȤ */
	void setListItem()
	{
		listStatus = drawkit.status;
	}
	
//### Private
	/** 뤫å̵Ϻ */
	private void checkParagraph()
	{
		if (paragraph != null)
			return;
		
		paragraph = new Paragraph(this, listStatus, preferredSize.height);
		
		if (!status.isTable) {
			if (contents == null)
				contents = new Vector();
			contents.addElement(paragraph);
			lastBox    = null;
			listStatus = null;
		}
	}
	
	/** ̤κǽԤ */
	private void commitParagraph()
	{
//System.out.println("Box.commitParagraph");
		if (paragraph == null)
			return;
		
		paragraph.commit();
		paragraph = null;
	}
	
	/** ʬơ֥롦ʿʳξΥ׻ */
	private void doCountSizeNormal()
	{
		Object    o;
		Box       box;
		Paragraph paragraph;
		int       w;
		
		for (int i = 0; i < contents.size(); i++) {
			o = contents.elementAt(i);
			if (o instanceof Box) {
				box       = (Box)o;
				width     = Math.max(width , box.drawOffset.x + box.width  + box.frameWidth );
				height    = Math.max(height, box.drawOffset.y + box.height + box.frameHeight);
				maxHeight = Math.max(maxHeight, box.maxHeight + box.frameHeight);
			} else {
				paragraph = (Paragraph)o;
				width     = Math.max(width    , paragraph.width + paragraph.drawOffsetX);
				height    = Math.max(height   , paragraph.height   );
				maxHeight = Math.max(maxHeight, paragraph.maxHeight);
			}
		}
		
		// եȥܥåϡޤ᤿
		if (floatChain != null)
			width = Math.max(width, floatChain.getWidth());
	}
	
	/**  ʬʿξΥ׻ */
	private void doCountSizeHR()
	{
		width     = preferredSize.width;
		height    = status.hrHeight.getValue(status.fd, 0, Value.DATA_VERTICAL);
		maxHeight = height;
	}
	
	/**  ʬơ֥ξΥ׻ */
	private void doCountSizeTable()
	{
		int cellNum = contents.size();
		
		Row row;
		Box box;
		Cell cell = null;
		int i, j, k, c, r, min, max, fix, per, oddMin, oddMax, oddFix, oddPer;
		
		// ơ֥Υο
		colNum = rowNum = 0;
		row = new Row();
		for (i = 0; i < cellNum; i++) {
			box = (Box)contents.elementAt(i);
			row.add(box.status.colSpan, box.status.rowSpan);
			if (!box.status.isVertical) {
				colNum = Math.max(colNum, row.col);
				rowNum++;
				row = row.next();
			}
		}
		while (row.col > 0) {
			colNum = Math.max(colNum, row.col);
			rowNum++;
			if ((row = row.next) == null)
				break;
		}
//System.out.println("table.count=["+rowNum+"],["+colNum+"]");
		
		// ⤵η׻ΤΥǡ
		cells = new Cell[rowNum][colNum];
		c = r = 0;
		BUILD:
		for (i = 0; i < cellNum; i++) {
			box = (Box)contents.elementAt(i);
			cell = new Cell(cell, box, c, r);
			for (j = 0; j < cell.rowSpan; j++)
				for (k = 0; k < cell.colSpan; k++)
					cells[r + j][c + k] = cell;
			c += cell.colSpan;
			if (!box.status.isVertical)
				c = colNum;
			
			// ΥǼ֤ذư
			for (;;) {
				if (c == colNum) {
					c = 0;
					if (++r == rowNum)
						break BUILD;
				} else if (cells[r][c] != null) {
					c++;
				} else {
					break;
				}
			}
		}
//for (r = 0; r < rowNum; r++)
//for (c = 0; c < colNum; c++)
//if (cells[r][c] != null)
//System.out.println("["+r+"],["+c+"],["+Integer.toHexString(cells[r][c].hashCode())+"]");
//else
//System.out.println("["+r+"],["+c+"],[null]");
		
		curHeights = new int[colNum];
		minHeights = new int[colNum];
		maxHeights = new int[colNum];
		perHeights = new int[colNum];
		fixHeights = new int[colNum];
		
		// ơ֥κǾȺ׻
		for (c = colNum - 1; c >= 0; c--) {
			min = max = 1; fix = per = oddMin = oddMax = oddFix = oddPer = 0;
			
			// ʣˤޤäƤʤ뤫Ǿ
			for (r = 0; r < rowNum; r++) {
				if ((cell = cells[r][c]) == null || cell.row != r || cell.colSpan != 1)
					continue;
				
				min = Math.max(min, cell.min);
				max = Math.max(max, cell.max);
				fix = Math.max(fix, cell.fix);
				per = Math.max(per, cell.per);
			}
//System.out.println("["+r+"]["+c+"] "+min+","+max+","+fix+","+per);
			
			if (max < min) max = min;
			if (fix > 0 && fix < min) fix = min;
			
			// ʣˤޤäƤ륻κǾ
			for (r = 0; r < rowNum; r++) {
				if ((cell = cells[r][c]) == null || cell.row != r || cell.colSpan == 1)
					continue;
				
				cell.min -= min;
				cell.max -= max;
				cell.fix -= fix;
				cell.per -= per;
				
				if (cell.col == c) {
					// ǽ;꤬뤫ɤå
					oddMin = Math.max(oddMin, cell.min);
					oddMax = Math.max(oddMax, cell.max);
					oddFix = Math.max(oddFix, cell.fix);
					oddPer = Math.max(oddPer, cell.per);
				} else {
					// ʣˤޤ륻Ρ֤
					cell.min -= verticalSpacing;
					cell.max -= verticalSpacing;
					cell.fix -= verticalSpacing;
					cell.per -= verticalSpacing;
				}
			}
			
			minHeights[c] = min;
			maxHeights[c] = (fix > 0 ? fix : max);
			fixHeights[c] = fix;
			perHeights[c] = per;
			
			// ֤
			if (oddFix > 0) correctOddHeights(FIX, c);
			if (oddMax > 0) correctOddHeights(MAX, c);
			if (oddMin > 0) correctOddHeights(MIN, c);
			if (oddPer > 0) correctOddHeights(PER, c);
			
			if (!tableHasFixed   && (fix > 0 || oddFix > 0))
				tableHasFixed   = true;
			if (!tableHasPercent && (per > 0 || oddPer > 0))
				tableHasPercent = true;
		}
		
		for (c = 0; c < colNum; c++) {
			totalMinHeight += minHeights[c];
			totalMaxHeight += maxHeights[c];
		}
		
		// 󤫤 100% 򻻽Ф祵
		if (tableHasPercent) {
			per = 0;
			for (c = 0; c < colNum; c++)
				if (perHeights[c] > 0)
					per = Math.max(maxHeights[c] * 100 / perHeights[c], per);
			totalMaxHeight = Math.max(totalMaxHeight, per);
		}
		
		int vs = verticalSpacing * (colNum + 1);
		
		min = totalMinHeight + vs;
		
		width     = 1;                          //  rearrange Τɬפʤ
		height    = (heightFixed ? Math.max(min, preferredSize.height) : min);
		maxHeight = totalMaxHeight + vs;
//System.out.println("## tmin=["+totalMinHeight+"],tmax=["+totalMaxHeight+"],vs=["+vs+"],cur=["+height+"],max=["+maxHeight+"]");
	}
	
	/** ʬơ֥롦ʿʳξ礭Ʒ׻ */
	private void rearrangeNormal(int newHeight)
	{
//System.out.println("Box.rearrangeNormal,"+level+","+Integer.toHexString(this.hashCode())+","+Integer.toHexString(parent.hashCode()));
		Object    o;
		Box       box;
		Paragraph paragraph;
		int       offset = 0;
		int       h;
		int       oddHeight = 0;
		Point     pos;
		
		for (int i = 0; i < contents.size(); i++) {
			o = contents.elementAt(i);
			if (o instanceof Box) {
				box = (Box)o;
				
				// ⤵ % ξ⤵ؤȽ
				h = box.resolvePercent(newHeight);
				if (level > 1 && h > newHeight)
					h = newHeight;
				
				box.drawOffset.x = offset;
				
				box.originOffset.right  = originOffset.right  + frame.right + offset;
				box.originOffset.top    = originOffset.top    + frame.top;
				box.originOffset.bottom = originOffset.bottom + frame.bottom;
				
				// ܥåƷ׻
				box.rearrange(h, newHeight);
				
				// box.drawOffset.x  rearrange ˽뤫⤷ʤΤǡ offset 
				offset = box.drawOffset.x + box.width + box.frameWidth;
			} else {
				paragraph = (Paragraph)o;
				
				paragraph.drawOffsetX = offset;
				paragraph.rearrange(newHeight, (origin.floatChain != null));
				offset += paragraph.width;
			}
		}
		
		doCountSizeNormal();
		height = Math.max(height, newHeight);
	}
	
	/** ʬʿξ礭Ʒ׻ */
	private void rearrangeHR(int newHeight)
	{
		width  = preferredSize.width;
		height = newHeight;
	}
	
	/** ʬơ֥ξ Box 礭Ʒ׻ */
	private void rearrangeTable(int newHeight)
	{
//System.out.println("Box.rearrangeTable,"+level+","+Integer.toHexString(this.hashCode())+","+Integer.toHexString(parent.hashCode()));
//System.out.println("level=["+level+"],max=["+totalMaxHeight+"],min=["+totalMinHeight+"],new=["+newHeight+"]");
		Cell cell;
		int c, r, diff, offset;
		
		int totalWidth = 0, totalHeight = 0;
		
		// Ȥ䥻̵֤뤷ι⤵
		newHeight -= verticalSpacing * (colNum + 1);
		
		boolean smaller = (newHeight >= totalMaxHeight);
		
		// ѡȤͤȤƳ
		if (tableHasPercent) {
			int percentHeight = ((!heightPercent && !heightFixed && totalMaxHeight < newHeight)
			                    ? totalMaxHeight : newHeight);
			for (c = 0; c < colNum; c++)
				if (perHeights[c] > 0)
					maxHeights[c] = Math.max(percentHeight * perHeights[c] / 100, minHeights[c]);
		}
		
		if (!heightPercent && !heightFixed && totalMaxHeight <= newHeight) {
			// ꤵƤʤ׵᥵꾮ơ֥ξ硢祵Ŭ
			for (c = 0; c < colNum; c++) {
				curHeights[c] =  maxHeights[c];
				totalHeight   += maxHeights[c];
			}
			newHeight = totalMaxHeight;
		} else {
			// ǾͤŬ
			for (c = 0; c < colNum; c++) {
				curHeights[c] = minHeights[c];
				totalHeight  += minHeights[c];
			}
			
//System.out.println("1 total=["+totalHeight+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("1 c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
			// ѡȤŬ
			if (tableHasPercent && totalHeight < newHeight) {
				for (c = 0; c < colNum && totalHeight < newHeight; c++) {
					if (perHeights[c] == 0 || maxHeights[c] <= curHeights[c])
						continue;
					
					diff = maxHeights[c] - curHeights[c];
					if (diff + totalHeight > newHeight)
						diff = newHeight - totalHeight;
					
					curHeights[c] += diff;
					totalHeight   += diff;
				}
			}
//System.out.println("2 total=["+totalHeight+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("2 c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
			
			// ͤŬ
			if (tableHasFixed && totalHeight < newHeight) {
				for (c = 0; c < colNum; c++) {
					if (fixHeights[c] == 0 || perHeights[c] > 0 || maxHeights[c] <= curHeights[c])
						continue;
					
					diff = maxHeights[c] - curHeights[c];
					
					curHeights[c] += diff;
					totalHeight   += diff;
				}
			}
//System.out.println("3 total=["+totalHeight+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("3 c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
		}
		
		// ơ֥륵ޤǳĴ
		if (totalHeight < newHeight ||
		    (totalHeight > newHeight && totalHeight > totalMinHeight))
			totalHeight = correctColHeights(CUR, totalHeight, newHeight - totalHeight, 0, colNum);
//System.out.println("# total=["+totalHeight+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("# c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
		
if (totalHeight < newHeight)
System.out.println("### table height = req=["+newHeight+"],fix=["+totalHeight+"]");
//System.out.println("max=["+totalMaxHeight+"],fix=["+totalHeight+"]");
		
		// ٤ƤΥ˹⤵
		for (c = 0; c < colNum; c++)
			for (r = 0; r < rowNum; r++)
				if ((cell = cells[r][c]) != null && cell.row == r)
					cell.height += curHeights[c];
		
		// ٤ƤΥФꤷ⤵Ŭ
		offset = verticalSpacing;
		for (c = 0; c < colNum; c++) {
			for (r = 0; r < rowNum; r++) {
				if ((cell = cells[r][c]) == null || cell.col != c || cell.row != r)
					continue;
				cell.initializeWidth(offset);
			}
			offset += (curHeights[c] + verticalSpacing);
		}
		
		// ֤򤽤
		int[] widths = new int[rowNum];
		int max, oddMax;
		for (r = 0; r < rowNum; r++) {
			max = 1; oddMax = 0;
			
			// ʣԤˤޤäƤʤ뤫
			for (c = 0; c < colNum; c++) {
				if ((cell = cells[r][c]) == null || cell.col != c || cell.rowSpan != 1)
					continue;
				
//System.out.println(r+","+c+","+cell.width);
				max = Math.max(max, cell.width);
			}
			
			// ʣԤˤޤäƤ륻
			for (c = 0; c < colNum; c++) {
				if ((cell = cells[r][c]) == null || cell.col != c || cell.rowSpan == 1)
					continue;
				
				cell.width -= max;
				
				if (cell.row + cell.rowSpan - 1 == r) {
					// ǸιԤ;꤬뤫ɤå
					oddMax = Math.max(oddMax, cell.width);
				} else {
					// ʣˤޤ륻Ρ֤
					cell.width -= horizontalSpacing;
				}
			}
			
			widths[r] = max;
			
			if (oddMax > 0)
				correctOddWidths(r, widths);
		}
		
//for (r = 0; r < rowNum; r++)
//System.out.println("["+r+"]=["+widths[r]+"]");
		// Ԥκ
		offset = horizontalSpacing;
		for (r = 0; r < rowNum; r++) {
			for (c = 0; c < colNum; c++) {
				if ((cell = cells[r][c]) == null || cell.col != c)
					continue;
				
				if (cell.row == r)
					cell.box.drawOffset.x = offset;
				else
					cell.box.width += horizontalSpacing;
				cell.box.width += widths[r];
			}
			totalWidth += widths[r];
			offset     += (widths[r] + horizontalSpacing);
		}
		
		width  = totalWidth  + horizontalSpacing * (rowNum + 1);
		height = totalHeight + verticalSpacing   * (colNum + 1);
		
		curHeights = null;
		minHeights = null;
		maxHeights = null;
		fixHeights = null;
		perHeights = null;
		
//System.out.println("table.size=["+width+"],["+height+"]");
	}
	
	/** ʣ祻;äʬ򡢤äȤ;ä뤫ʬۤ */
	private void correctOddHeights(int type, int c)
	{
		Cell cell;
		int r, n = 0, odd, colSpan;
		
		for (;;) {
			// ­ʬʤ
			odd = 0;
			for (r = 0; r < rowNum; r++) {
				if ((cell = cells[r][c]) == null || cell.row != r || cell.col != c || cell.colSpan == 1)
					continue;
				
				switch (type) {
				case MIN: n = cell.min; break;
				case MAX: n = cell.max; break;
				case FIX: n = cell.fix; break;
				case PER: n = cell.per; break;
				}
				odd = Math.max(odd, n);
			}
			
			if (odd == 0)
				break;
			
			// ;äƤ륻ǡϢ뤷Ƥ륻ο־ʤ򸡺
			colSpan = colNum;
			for (r = 0; r < rowNum; r++) {
				if ((cell = cells[r][c]) == null || cell.row != r || cell.col != c || cell.colSpan == 1)
					continue;
				
				switch (type) {
				case MIN: n = cell.min; break;
				case MAX: n = cell.max; break;
				case FIX: n = cell.fix; break;
				case PER: n = cell.per; break;
				}
				if (n == odd)
					colSpan = Math.min(colSpan, cell.colSpan);
			}
			
			// ʬ
			correctColHeights(type, 0, odd, c, c + colSpan);
		}
	}
	
	/** ­ʬΨ˽˳Ƥ */
	private int correctColHeights(int type, int totalHeight, int odd, int start, int end)
	{
		Cell cell;
		int c, r, diff = 0, part;
		int trapCounter = 0;
		
//System.out.println(">> type=["+type+"],start=["+start+"],end=["+end+"]");
//System.out.println("> type=["+type+"],total=["+totalHeight+"],odd=["+odd+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("> type=["+type+"],c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
		
		int cellNum  = 0;
		int total    = 0;
		int maxTotal = 0;
		
		// MAX ξ硢ʬо % ͭä餽Ψ˽
		if (type == MAX) {
			for (c = start; c < end; c++) {
				total += maxHeights[c];
				
				if (perHeights[c] == 0)
					continue;
				
				cellNum++;
				maxTotal += perHeights[c];
			}
			if (cellNum > 0) {
//System.out.println("correct 1: cellNum=["+cellNum+"],total=["+total+"],maxTotal=["+maxTotal+"],odd=["+odd+"]");
				if (maxTotal < 100)
					maxTotal = 100;
				
				total += odd;
				
				for (c = start; c < end; c++) {
					if (perHeights[c] == 0)
						continue;
					
					part = total * perHeights[c] / maxTotal;
					if (part > minHeights[c])
						diff = part - maxHeights[c];
					else
						diff = minHeights[c] - maxHeights[c];
					
					odd      -= diff;
//System.out.println(part+","+diff+","+odd);
					total    -= part;
					maxTotal -= perHeights[c];
					
					if (diff != 0)
						totalHeight = correctWork(type, c, totalHeight, diff);
				}
			}
//System.out.println("= type=["+type+"],total=["+totalHeight+"],odd=["+odd+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("= type=["+type+"],c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
		}
		
		boolean all = (type == PER);            // оݤˤ true
		
		while (odd != 0) {
			// 顼ѡʤʤ˥롼פǽϤʤ
			if (++trapCounter > 1000)
				throw new RuntimeException("internal error (table col correct)");
			
//System.out.println(odd);
			cellNum = total = maxTotal = 0;
			
			// 򸡺
			for (c = start; c < end; c++) {
				if ((!all && type != MIN && (fixHeights[c] > 0 || perHeights[c] > 0)) ||
				    (!all && type == MIN && minHeights[c] == maxHeights[c]) ||
				    (odd < 0 && (type == MAX ? maxHeights[c] : curHeights[c]) == minHeights[c]))
					continue;
				
				cellNum++;
				
				switch (type) {
				case CUR: total += curHeights[c]; break;
				case MIN: total += minHeights[c]; break;
				case MAX: total += maxHeights[c]; break;
				case FIX: total += fixHeights[c]; break;
				case PER: total += perHeights[c]; break;
				}
				
				maxTotal += maxHeights[c];
			}
			
			if (cellNum == 0) {
				if (all)
					break;
				all = true;
				continue;
			}
//System.out.println("correct 2: cellNum=["+cellNum+"],total=["+total+"],maxTotal=["+maxTotal+"],odd=["+odd+"]");
			
			total += odd;
			
			// Ψ˽ʬ
			for (c = start; c < end && odd != 0; c++) {
				if ((!all && type != MIN && (fixHeights[c] > 0 || perHeights[c] > 0)) ||
				    (!all && type == MIN && minHeights[c] == maxHeights[c]) ||
				    (odd < 0 && (type == MAX ? maxHeights[c] : curHeights[c]) == minHeights[c]))
					continue;
				
				part = total * maxHeights[c] / maxTotal;
				
				switch (type) {
				case CUR:
					if (part >= minHeights[c])
						diff = part - curHeights[c];
					else
						diff = minHeights[c] - curHeights[c];
					break;
				case MIN:
					if (all || part <= maxHeights[c])
						diff = part - minHeights[c];
					else
						diff = maxHeights[c] - minHeights[c];
					break;
				case MAX:
					if (part >= minHeights[c])
						diff = part - maxHeights[c];
					else
						diff = minHeights[c] - maxHeights[c];
					break;
				case FIX: diff = part - fixHeights[c]; break;
				case PER: diff = part - perHeights[c]; break;
				}
				
				odd      -= diff;
//System.out.println(diff+","+part+","+odd);
				total    -= part;
				maxTotal -= maxHeights[c];
				
				if (diff != 0)
					totalHeight = correctWork(type, c, totalHeight, diff);
			}
		}
		
//System.out.println("< type=["+type+"],total=["+totalHeight+"],odd=["+odd+"]");
//for (c = 0; c < colNum; c++)
//System.out.println("< type=["+type+"],c=["+c+"],cur=["+curHeights[c]+"],min=["+minHeights[c]+"],max=["+maxHeights[c]+"],fix=["+fixHeights[c]+"],per=["+perHeights[c]+"]");
		return totalHeight;
	}
	
	/** ⤵Ϣ⽤ */
	private int correctWork(int type, int c, int totalHeight, int diff)
	{
		Cell cell;
		
		switch (type) {
		case CUR:
			curHeights[c] += diff;
			totalHeight   += diff;
			return totalHeight;
		case MIN:
			minHeights[c] += diff;
			if (maxHeights[c] < minHeights[c])
				maxHeights[c] = minHeights[c];
			break;
		case MAX:
			if (fixHeights[c] == 0)
				maxHeights[c] += diff;
			break;
		case FIX:
			fixHeights[c] += diff;
			maxHeights[c] =  Math.max(fixHeights[c], minHeights[c]);
			break;
		case PER:
			perHeights[c] += diff;
			break;
		}
		
		// ʣˤޤäƤ륻
		for (int r = 0; r < rowNum; r++) {
			if ((cell = cells[r][c]) == null || cell.row != r || cell.colSpan == 1)
				continue;
			
			switch (type) {
			case MIN: cell.min -= diff; break;
			case MAX: cell.max -= diff; break;
			case FIX: cell.fix -= diff; break;
			case PER: cell.per -= diff; break;
			}
		}
		
		return totalHeight;
	}
	
	/** ƹԤΨ˽ʬ */
	private void correctOddWidths(int r, int[] widths)
	{
		Cell cell;
		int c, i, odd, rowSpan, total, maxTotal, part, diff;
		
		for (;;) {
			// ­ʬʤ
			odd = 0;
			for (c = 0; c < colNum; c++) {
				if ((cell = cells[r][c]) == null || cell.col != c || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != r)
					continue;
				
				odd = Math.max(odd, cell.width);
			}
			
			if (odd == 0)
				break;
			
			// ;äƤ륻ǡϢ뤷Ƥ륻ο־ʤ򸡺
			rowSpan = rowNum;
			for (c = 0; c < colNum; c++) {
				if ((cell = cells[r][c]) == null || cell.col != c || cell.rowSpan == 1 || cell.row + cell.rowSpan - 1 != r)
					continue;
				
				if (cell.width == odd)
					rowSpan = Math.min(rowSpan, cell.rowSpan);
			}
			
			maxTotal = 0;
			
			// Ԥ׻
			for (i = r - rowSpan + 1; i <= r; i++)
				maxTotal += widths[i];
			
			total = maxTotal + odd;
			
			// ԤΨ˽ʬ
			for (i = r - rowSpan + 1; i <= r; i++) {
				part      =  total * widths[i] / maxTotal;
				diff      =  part - widths[i];
				total     -= part;
				maxTotal  -= widths[i];
				widths[i] =  part;
				
				for (c = 0; c < colNum; c++) {
					if ((cell = cells[i][c]) == null || cell.col != c || cell.rowSpan == 1)
						continue;
					
					cell.width -= diff;
				}
			}
		}
	}
	
//### Row
	/** ơ֥ι */
	private class Row
	{
		private int col;
		private Row next;
		
		/** 󥹥󥹤 */
		private Row()
		{
		}
		
		/** ɲ */
		private void add(int c, int r)
		{
			col += c;
			if (r > 1) {
				Row row = this;
				while (r-- > 1) {
					row = row.next();
					row.add(c, 1);
				}
			}
		}
		
		/**  */
		private Row next()
		{
			if (next != null)
				return next;
			
			return next = new Row();
		}
	}
	
//### Cell
	/** ơ֥Υ */
	private class Cell
	{
		private Cell    next;
		private Box     box;
		private int     col;                    //  0-
		private int     row;                    // Ϲ 0-
		private int     colSpan;                // Ϣ 1-
		private int     rowSpan;                // Ϣ 1-
		private int     workRowSpan;
		private int     min;                    // Ǿ⤵
		private int     max;                    // ⤵
		private int     fix;                    // ⤵
		private int     per;                    // ѡ
		private int     width;                  // ǽŪ˷ꤵ줿
		private int     height;                 // ǽŪ˷ꤵ줿⤵
		
		/** 󥹥󥹤 */
		private Cell(Cell before, Box box, int col, int row)
		{
			if (before != null)
				before.next = this;
			this.box = box;
			this.col = col;
			this.row = row;
			
			colSpan = box.status.colSpan;
			rowSpan = box.status.rowSpan;
			
			min = Math.max(box.height    + box.frameHeight, 1  );
			max = Math.max(box.maxHeight + box.frameHeight, min);
			if (box.heightFixed)
				fix = Math.max(box.preferredSize.height, 1);
			if (box.heightPercent)
				per = Math.max(box.status.height.getNumber().intValue(), 1);
			
			workRowSpan = rowSpan;
			
			height = verticalSpacing * (colSpan - 1);
		}
		
		/** Boxʥˤ˹⤵ŬѤ */
		private void initializeWidth(int offsetY)
		{
			box.height       = height - box.frameHeight;
			box.drawOffset.y = offsetY;
			box.rearrange(height, height);
			width = box.width + box.frameWidth;
			box.width = - box.frameWidth;
		}
	}
}
