/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.protocol.resource;

import net.hizlab.kagetaka.Resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

/**
 * <code>about</code> ץȥΥͥɽޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class ResourceURLConnection
	extends URLConnection
{
	private static final String RESOURCE = "net.hizlab.kagetaka.protocol.resource.Resource";
	
	private String type;
	private byte[] data;
	private IOException exception;
	
	/** 󥹥󥹤 */
	ResourceURLConnection(URL url)
	{
		super(url);
	}
	
	/**
	 *  URL Ȥ꥽ؤ̿󥯤Ωޤ
	 * (̿󥯤ΩƤʤ)
	 * 
	 * @exception IOException ³γΩ I/O 顼ȯ
	 */
	public synchronized void connect()
		throws IOException
	{
		if (connected)
			return;
		
		String jarPath = url.getHost();
		if (jarPath == null || jarPath.length() == 0) {
			String key = url.getFile().substring(1).replace('/', '.');
			type = Resource.getMessage       (RESOURCE, key + ".type", null);
			data = Resource.getBinaryResource(RESOURCE, key + ".path");
		}
		
		connected = true;
	}
	
	/**
	 * <code>content-type</code> إåեɤ֤ͤޤ
	 * 
	 * @return    URL Ȥ꥽ξμࡣ
	 *            ξ <code>null</code>
	 */
	public String getContentType()
	{
		if (!connected) {
			try {
				connect();
			} catch (IOException e) {
				exception = e;
			}
		}
		
		return type;
	}
	
	/**
	 * ³Ϥϥȥ꡼֤ޤ
	 * 
	 * @return    ³Ϥϥȥ꡼
	 * 
	 * @exception IOException ϥȥ꡼κ I/O 顼ȯ
	 */
	public synchronized InputStream getInputStream()
		throws IOException
	{
		if (!connected)
			connect();
		else if (exception != null)
			throw exception;
		
		if (data == null)
			throw new IOException("resource not found");
		
		return new ByteArrayInputStream(data);
	}
}
