/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.java2.bridge;

import net.hizlab.kagetaka.java2.WheelListener;
import net.hizlab.kagetaka.java2.WheelWrapper;

import java.awt.Component;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;

/**
 * ɥåɥɥåפºݤ˼¹Ԥ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class WheelCaller
	extends WheelWrapper
{
	/**
	 * 󥹥󥹤ޤ
	 */
	public WheelCaller()
	{
	}
	
	/**
	 * ޥۥ򥵥ݡȤ褦ˡݡͥȤ˥ꥹʤϿޤ
	 * 
	 * @param     c ݡͥ
	 * @param     l ꥹ
	 */
	public void addWheelListener(Component c, WheelListener l)
	{
		c.addMouseWheelListener(new Listener(l));
	}
	
//### Listener
	/** ɥåץåȥꥹ */
	private class Listener
		implements MouseWheelListener
	{
		private WheelListener listener;
		
		/** 󥹥󥹤 */
		private Listener(WheelListener l)
		{
			this.listener = l;
		}
		
		/** ޥۥ뤬ž */
		public void mouseWheelMoved(MouseWheelEvent e)
		{
			e.consume();
			if (e.getScrollType() == MouseWheelEvent.WHEEL_UNIT_SCROLL)
				listener.spin(WheelListener.UNIT_SCROLL , e.getUnitsToScroll(), e.getModifiers());
			else
				listener.spin(WheelListener.BLOCK_SCROLL, e.getWheelRotation(), e.getModifiers());
		}
	}
}
