/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.java2.bridge;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.SystemFlavorMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/**
 * եΥɥåפ򥵥ݡȤե졼ХޥåפǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
class FileFlavorMap
	implements FlavorMap
{
	static final String KEY_TEXT           = "TEXT";
	static final String KEY_FILE_NAME      = "FileName";
	static final String KEY_FILE_NAME_WIDE = "FileNameW";
	static final String HPN_TEXT           = null;
	static final String HPN_FILE_NAME      = "File Name";
	static final String HPN_FILE_NAME_WIDE = "File Name Wide";
	
	private Map nativeToFlavor;
	private Map flavorToNative;
	
	/** 󥹥󥹤 */
	FileFlavorMap()
	{
		this(SystemFlavorMap.getDefaultFlavorMap().getFlavorsForNatives(null));
	}
	
	/** 󥹥󥹤 */
	FileFlavorMap(Map map)
	{
		nativeToFlavor = new HashMap(map.size());
		flavorToNative = new HashMap(map.size());
		
		Object key;
		DataFlavor f;
		for (Iterator it = map.keySet().iterator(); it.hasNext(); ) {
			key = it.next();
			f = new DataFlavorEx((DataFlavor)map.get(key));
			nativeToFlavor.put(key, f);
			flavorToNative.put(f, key);
		}
		
		// եɥåѤΥե졼Фɲ
		String[][] additional =
		{
			{KEY_TEXT          , "text/plain; class=java.io.InputStream"                               , HPN_TEXT          },
			{KEY_FILE_NAME     , "text/plain; class=java.io.InputStream"                               , HPN_FILE_NAME     },
			{KEY_FILE_NAME_WIDE, "text/plain; charset=UnicodeLittleUnmarked; class=java.io.InputStream", HPN_FILE_NAME_WIDE}
		};
		for (int i = 0; i < additional.length; i++) {
			key = additional[i][0];
			
			// Ǥ¸ߤϺ
			if (nativeToFlavor.containsKey(key)) {
				flavorToNative.remove(nativeToFlavor.get(key));
				nativeToFlavor.remove(key);
			}
			
			// ɲ
			f = new DataFlavorEx(additional[i][1], additional[i][2]);
			nativeToFlavor.put(key, f);
			flavorToNative.put(f, key);
		}
	}
	
	/** ե졼Фͥƥ̾ */
	public synchronized Map getNativesForFlavors(DataFlavor[] flavors)
	{
		if (flavors == null)
			return new HashMap(flavorToNative);
		
		if (flavors.length == 0)
			return null;
		
		Map map = new HashMap(flavors.length);
		
		DataFlavor f;
		String     n;
		for (int i = 0; i < flavors.length; i++) {
			f = flavors[i];
//System.out.println("#n2f["+i+"]=["+f+"]");
			
			if ((n = (String)flavorToNative.get(f)) == null) {
				String emts = SystemFlavorMap.encodeJavaMIMEType(f.getMimeType());
				
				map.put(f, emts);
				
				nativeToFlavor.put(emts, f);
				flavorToNative.put(f, emts);
			} else {
				map.put(f, n);
			}
		}
		
		return map;
	}
	
	/** ͥƥ̾ե졼Ф */
	public synchronized Map getFlavorsForNatives(String[] natives)
	{
		if (natives == null)
			return new HashMap(flavorToNative);
		
		if (natives.length == 0)
			return new HashMap();
		
		Map map = new HashMap(natives.length);
		
		DataFlavor f;
		String     n;
		for (int i = 0; i < natives.length ; i++) {
			n = natives[i];
//System.out.println("#f2n["+i+"]=["+n+"]");
			
			if ((f = getFlavorsForNatives(n)) != null)
				map.put(n, f);
		}
		
		return map;
	}
	
	/** ͥƥ̾ե졼Ф */
	public synchronized DataFlavor getFlavorsForNatives(String n)
	{
		DataFlavor f;
		
		if ((f = (DataFlavor)nativeToFlavor.get(n)) == null) {
			if (!SystemFlavorMap.isJavaMIMEType(n))
				return null;
			
			String mts = SystemFlavorMap.decodeJavaMIMEType(n);
			
			try {
				f = new DataFlavor(mts);
			} catch (Exception e) {
System.out.println("Exception \"" + e.getClass().getName() + ": " + e.getMessage()  + "\"while constructing DataFlavor for: " + mts);
				return null;
			}
			
			nativeToFlavor.put(n, f);
			flavorToNative.put(f, n);
		}
		
		return f;
	}
	
//### DataFlavorEx
	/** ɽʸ⼱̤ǡե졼 */
	private class DataFlavorEx
		extends DataFlavor
	{
		/** 󥹥󥹤 */
		private DataFlavorEx(DataFlavor f)
		{
			super(f.getMimeType(), f.getHumanPresentableName());
		}
		
		/** 󥹥󥹤 */
		private DataFlavorEx(String mimeType, String humanPresentableName)
		{
			super(mimeType, humanPresentableName);
		}
		
		/** ɽʸޤ */
		public boolean equals(DataFlavor that)
		{
			if (!super.equals(that))
				return false;
			
			String thisName = this.getHumanPresentableName();
			String thatName = that.getHumanPresentableName();
			if ((thisName == null && thatName == null) ||
			    (thisName != null && thatName != null && thisName.compareTo(thatName) == 0))
				return true;
			
			return false;
		}
		
		/** ϥå女ɤ֤ */
		public int hashCode()
		{
			int total = super.hashCode();
			
			total += getHumanPresentableName().hashCode();
			
			return (total != 0) ? total : 25324987;
		}
	}
}
