/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.java2.bridge;

import net.hizlab.kagetaka.java2.DnDListener;
import net.hizlab.kagetaka.java2.DnDWrapper;

import java.awt.Component;
import java.awt.dnd.DnDConstants;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorMap;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.File;
import java.io.Reader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.List;

/**
 * ɥåɥɥåפºݤ˼¹Ԥ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class DnDCaller
	extends DnDWrapper
{
	private static final int ACTION = DnDConstants.ACTION_COPY_OR_MOVE | DnDConstants.ACTION_LINK;
	
	private static FlavorMap flavorMap = new FileFlavorMap();
	
	/**
	 * 󥹥󥹤ޤ
	 */
	public DnDCaller()
	{
	}
	
	/**
	 * ɥåɥɥåפ򥵥ݡȤ褦ˡݡͥȤ
	 * ꥹʤϿޤ
	 * 
	 * @param     c ݡͥ
	 * @param     l ꥹ
	 */
	public void addDnDListener(Component c, DnDListener l)
	{
		new DropTarget(c, ACTION, new DropListener(l), true, flavorMap);
	}
	
//### DropListener
	/** ɥåץåȥꥹ */
	private class DropListener
		implements DropTargetListener
	{
		private DnDListener listener;
		
		/** 󥹥󥹤 */
		private DropListener(DnDListener l)
		{
			this.listener = l;
		}
		
		/** ɥåä */
		public void dragEnter(DropTargetDragEvent dtde)
		{
			if (!listener.isActive())
				dtde.rejectDrag();
		}
		
		/** ɥåư */
		public void dragOver(DropTargetDragEvent dtde)
		{
			if (!listener.isActive())
				dtde.rejectDrag();
		}
		
		/** ɥå̤ѹ줿 */
		public void dropActionChanged(DropTargetDragEvent dtde)
		{
		}
		
		/** ɥåФƹԤä */
		public void dragExit(DropTargetEvent dte)
		{
		}
		
		/** ɥåפ줿 */
		public void drop(DropTargetDropEvent dtde)
		{
			if (!listener.isActive()) {
				dtde.rejectDrop();
				return;
			}
			
			dtde.acceptDrop(DnDConstants.ACTION_COPY);
			
			String value = null;
			
			try {
				Transferable t = dtde.getTransferable();
				
				// ե졼Ф
				DataFlavor[] fs = t.getTransferDataFlavors();
				DataFlavor f = null;
				for (int i = 0; i < fs.length; i++) {
//System.out.println("#fs["+i+"]=["+fs[i].getMimeType()+"; hpn="+fs[i].getHumanPresentableName()+"]");
					if (fs[i].getHumanPresentableName().compareTo(FileFlavorMap.HPN_FILE_NAME_WIDE) == 0) {
						f = fs[i];
						break;
					}
				}
				if (f == null)
					f = DataFlavor.selectBestTextFlavor(fs);
				if (f == null)
					f = t.getTransferDataFlavors()[0];
//System.out.println("@flavor=["+f.getMimeType()+"; hpn="+f.getHumanPresentableName()+"]");
				
				// ǡ
				Object data = null;
				try {
					data = t.getTransferData(f);
				} catch (UnsupportedFlavorException e) {
					return;
				} catch (IOException e) {
					return;
				}
				
				// ǡμऴȤˡƤ
				if (data instanceof InputStream ||
				    data instanceof Reader) {
					BufferedReader br = null;
					
					if (data instanceof InputStream) {
						InputStreamReader isr = null;
						String encoding = f.getParameter("charset");
						if (encoding != null) {
							try {
								isr = new InputStreamReader((InputStream)data, encoding);
							} catch (UnsupportedEncodingException e) {}
						}
						if (isr == null)
							isr = new InputStreamReader((InputStream)data);
						br = new BufferedReader(isr);
					} else {
						br = new BufferedReader((Reader)data);
					}
					
					try {
						char[] buffer = new char[8192];
						StringBuffer sb = new StringBuffer();
						int len;
						while ((len = br.read(buffer, 0, 8192)) != -1)
							sb.append(buffer, 0, len);
						br.close();
						value = sb.toString();
					} catch (IOException e) {
System.out.println(e);
e.printStackTrace(System.out);
					}
				} else if (data instanceof String) {
					value = (String)data;
				} else if (data instanceof List) {
					List list = (List)data;
					if (list.size() > 0)
						value = list.get(0).toString();
				}
			} finally {
				dtde.dropComplete(true);
			}
			
			if (value == null)
				return;
			
			listener.drop(value);
//System.out.println("@["+value+"],exists="+(new File(value)).exists());
		}
	}
}
