/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.IOException;

/**
 * ǡɤ߹˥ꥹʤ𤹤륤ץåȥȥ꡼ե륿Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class CounterInputStream
	extends FilterInputStream
{
	private CounterListener listener;
	
	private boolean marked    = false;
	private long    length    = 0;
	private long    temporary = 0;
	
	int  i;
	long l;
	
	/**
	 * ɤ߹Хȿ򥫥Ȥ륤ץåȥȥ꡼ޤ
	 * 
	 * @param     is ץåȥȥ꡼
	 * @param     listener ꥹ
	 */
	public CounterInputStream(InputStream is, CounterListener listener)
	{
		super(is);
		this.listener = listener;
	}
	
	/**
	 * ϥȥ꡼फ鼡ΥХȥǡɤ߹ߤޤ
	 * 
	 * @return    ΥХȥǡ⤷ȥ꡼νüФ줿
	 *            <code>-1</code>
	 * 
	 * @exception I/O 顼ȯ硣
	 */
	public int read()
		throws IOException
	{
		i = super.read();
		if (i != -1)
			append(1);
		return i;
	}
	
	/**
	 * ϥȥ꡼फХ˺
	 * <code>byte.length</code> ХȤΥǡɤ߹ߤޤ
	 * 
	 * @param     b ǡɤ߹ޤХåե
	 * 
	 * @return    Хåեɤ߹ޤ줿Хȿ
	 *            ⤷ȥ꡼νüãɤ߹ǡʤ
	 *            <code>-1</code>
	 * 
	 * @exception I/O 顼ȯ硣
	 */
	public int read(byte[] b)
		throws IOException
	{
		i = super.read(b);
		if (i > 0)
			append(i);
		return i;
	}
	
	/**
	 * ϥȥ꡼फХ˺
	 * <code>len</code> ХȤΥǡɤ߹ߤޤ
	 * 
	 * @param     b ǡɤ߹ޤХåե
	 * @param     off ǡγϰ֤򼨤եå
	 * @param     len ɤ߹ХȤκ
	 * 
	 * @return    Хåեɤ߹ޤ줿Хȿ
	 *            ⤷ȥ꡼νüãɤ߹ǡʤ
	 *            <code>-1</code>
	 * 
	 * @exception I/O 顼ȯ硣
	 */
	public int read(byte[] b, int off, int len)
		throws IOException
	{
		i = super.read(b, off, len);
		if (i > 0)
			append(i);
		return i;
	}
	
	/**
	 * ϥȥ꡼फΥǡФ
	 * <code>n</code> ХȤåפƥǡΤƤޤ
	 * 
	 * @param     n åפХȿ
	 * 
	 * @return    ºݤ˥åפ줿Хȿ
	 * 
	 * @exception I/O 顼ȯ硣
	 */
	public long skip(long n)
		throws IOException
	{
		l = super.skip(n);
		if (l > 0)
			append(l);
		return l;
	}
	
	/**
	 * ϥȥ꡼θ֤߰˥ޡդޤ
	 * 
	 * @param     readlimit ޡ̵֤ˤʤɤ߹߲ǽʺХȿ
	 */
	public synchronized void mark(int readlimit)
	{
		super.mark(readlimit);
		if (readlimit > 0)
			marked = true;
		else
			marked = false;
		length += temporary;
		temporary = 0;
	}
	
	/**
	 * ϥȥ꡼غǸ {@link #mark(int)} ᥽åɤ
	 * ƤӽФ줿ȤΥޡ֤ؤΥȥ꡼ΰ֤ꤷޤ
	 * 
	 * @exception ȥ꡼˥ޡդƤʤä硢
	 *            ޤϥޡ̵ˤʤäƤ
	 */
	public synchronized void reset()
		throws IOException
	{
		try {
			super.reset();
		} catch (IOException e) {
			marked = false;
			length += temporary;
			temporary = 0;
			throw e;
		}
		
		if (listener != null && temporary > 0)
			listener.changeLength(length);
		
		temporary = 0;
	}
	
	/** Ĺɲäޤ */
	private void append(long add)
	{
		if (marked)
			temporary += add;
		else
			length    += add;
		
		if (listener != null)
			listener.changeLength(temporary + length);
	}
}
