/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.io;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.EOFException;
import java.io.IOException;

/**
 * Хʥեɤ߹िΥ饹Ǥ
 * ޡꥻåȤϥݡȤƤޤ
 * ޤåɥդǤϤʤΤǡʣΥåɴ֤
 * Ʊ˻ѤϡƱ˵ĤƤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class BinaryInputStream
	extends FilterInputStream
{
	private byte[] buffer;
	private long   offset;
	
	/**
	 * ꤵ줿ץåȥȥ꡼򸵤ˤ󥹥󥹤ޤ
	 * 
	 * @param     in         ץåȥȥ꡼
	 * @param     bufferSize Хåե
	 */
	public BinaryInputStream(InputStream in, int bufferSize)
	{
		super(in);
		this.buffer = new byte[bufferSize];
	}
	
	/**
	 * ΥХϥȥ꡼फ顢ǡμΥХȤɤ߹ߤޤ
	 * ΥХȤϡ<code>0</code>  <code>255</code> ϰϤ
	 * <code>int</code> Ȥ֤ޤ
	 * ȥ꡼νãƥХȤʤϡ
	 *  <code>-1</code> ֤ޤ
	 * Υ᥽åɤϡϥǡɤ߹ޤ褦ˤʤ뤫
	 * ȥ꡼ν꤬Ф뤫
	 * ޤ㳰ޤǥ֥åޤ 
	 * 
	 * @return    ǡμΥХȡ
	 *            ȥ꡼νã <code>-1</code>
	 */
	public int read()
		throws IOException
	{
		int b = in.read();
		
		if (b != -1)
			offset++;
		
		return b;
	}
	
	/**
	 * ΥХϥȥ꡼फХȤɤ߼äơ
	 * ꤵ줿Х˻ΥեåȤޤ
	 * 
	 * @param     b   žХåե
	 * @param     off ХȤγǼϥեå
	 * @param     len ɤ߹ХȤκ
	 * 
	 * @return    ɤ߹ޤХȿ
	 *            ȥ꡼νã <code>-1</code>
	 */
	public int read(byte[] b, int off, int len)
		throws IOException
	{
		int length = in.read(b, off, len);
		
		offset += length;
		
		return length;
	}
	
	/**
	 * ꤵ줿ȥ륨ǥͤȤɤ߹ߤޤ
	 * 
	 * @param     size 
	 * 
	 * @return    ɤ߹
	 * 
	 * @exception EOFException ꥵ˥եνü­
	 */
	public long readNumber(int size)
		throws IOException
	{
		int length = 0;
		for (int p = 0; p < size; p += length)
			if ((length = in.read(buffer, p, size)) == -1)
				throw new EOFException();
		
		offset += size;
		
		return byteToLong(buffer, 0, size);
	}
	
	/**
	 * NULL üޤǤʸȤɤ߹ߤޤ
	 * 
	 * @param     encoding 󥳡ǥ
	 * 
	 * @return    ɤ߹ʸ
	 * 
	 * @exception EOFException NULL üʸ˥եνü­
	 */
	public String readString(String encoding)
		throws IOException
	{
		ByteArrayOutputStream os = new ByteArrayOutputStream(buffer.length);
		
		int data = 0;
		for (;;) {
			if ((data = in.read()) == -1)
				throw new EOFException();
			if (data == 0)
				break;
			os.write(data);
		}
		os.close();
		
		offset += os.size();
		
		if (encoding == null)
			return os.toString();
		else
			return os.toString(encoding);
	}
	
	/**
	 * Хʬåפޤ
	 * 
	 * @param     size åפХȿ
	 * 
	 * @return    ºݤ˥åפХȿ
	 */
	public long skip(long size)
		throws IOException
	{
		if (size <= 0)
			return 0;
		
		long length, total = 0;
		for (;;) {
			length = in.skip(size);
			if ((total += length) >= size)
				break;
			size -= length;
		}
		
		offset += total;
		return total;
	}
	
	/**
	 * ߤɤ߹֤֤ޤ
	 * 
	 * @return    ɤ߹
	 */
	public long getOffset()
	{
		return offset;
	}
	
	/**
	 * Хȥ륨ǥȤ long Ѵޤ
	 * 
	 * @param     b   ѴΥХ
	 * @param     off ϰ
	 * @param     len Ĺ
	 * 
	 * @return    Ѵ줿
	 */
	public static long byteToLong(byte[] b, int off, int len)
	{
		long value = 0;
		
		for (int i = off + len - 1; i >= off ; i--)
			value = (value << 8) | (0xFF & b[i]);
		
		return value;
	}
}
