/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.history;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.LayoutUtils;
import net.hizlab.kagetaka.bookmarks.Bookmark;
import net.hizlab.kagetaka.bookmarks.BookmarkManager;
import net.hizlab.kagetaka.viewer.HawkViewer;
import net.hizlab.kagetaka.viewer.HawkWindow;
import net.hizlab.kagetaka.viewer.ViewerOption;
import net.hizlab.kagetaka.viewer.WindowManager;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.InputEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Vector;

/**
 * 򥨥ǥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class HistoryEditor
	extends Frame
	implements HawkWindow
{
	private static final String RESOURCE = "net.hizlab.kagetaka.history.Resource";
	private static final int    MARGIN   = 3;
	
	private static final int MENU_OPEN     = 0;
	private static final int MENU_COPY     = 1;
	private static final int MENU_BOOKMARK = 2;
	private static final int MENU_DELETE   = 3;
	
	private static final int MENU_SIZE     = 4;
	
	/** @serial å֥ */
	private Object     lock = new Object();
	/** @serial ץ */
	private ViewerOption    option;
	/** @serial ޥ͡ */
	private HistoryManager  hm;
	/** @serial ֥åޡޥ͡ */
	private BookmarkManager bm;
	/** @serial ɥޥ͡ */
	private WindowManager   wm;
	/** @serial ꥹ */
	private List       list;
	/** @serial ƥȥ٥ */
	private Label      text;
	/** @serial URL ٥ */
	private Label      url;
	/** @serial ˬ */
	private Label      first;
	/** @serial ǽˬ */
	private Label      last;
	/** @serial ˬ */
	private Label      count;
	/** @serial ꥹ */
	private History[]  histories;
	/** @serial ꥹȤΥ */
	private int        size;
	/** @serial ƥȥ˥塼 */
	private PopupMenu  popupMenu;
	/** @serial ˥塼 */
	private MenuItem[] menuItems;
	
	/** 򥨥ǥ */
	HistoryEditor(ViewerOption option)
	{
		this.option = option;
		this.hm     = option.getHistoryManager ();
		this.bm     = option.getBookmarkManager();
		this.wm     = WindowManager.getInstance();
		setTitle     (getMessage("title" ));
		setResizable (true                );
		setForeground(SystemColor.textText);
		setBackground(SystemColor.text    );
		setFont      (new Font("Dialog", Font.PLAIN, 12));
		
		Image image = Resource.getImageResource(RESOURCE, "historyeditor.icon", getToolkit());
		if (image != null)
			setIconImage(image);
		
		// ᥤѥͥ
		GridBagLayout gbl    = new GridBagLayout();
		Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
		setLayout(gbl);
		
		LayoutUtils.addGridBag(this, list  = new List (10                        ), gbl, 0, 0, 3, 1, 1, 1, GridBagConstraints.BOTH      , GridBagConstraints.CENTER, insets);
		LayoutUtils.addGridBag(this,         new Label(getMessage("label.detail")), gbl, 0, 1, 1, 5, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.NORTH , insets);
		insets.bottom = 0;
		LayoutUtils.addGridBag(this, text  = new Label(                          ), gbl, 1, 1, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		insets.top = 0;
		LayoutUtils.addGridBag(this, url   = new Label(                          ), gbl, 1, 2, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		LayoutUtils.addGridBag(this,         new Label(getMessage("label.first" )), gbl, 1, 3, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
		LayoutUtils.addGridBag(this, first = new Label(                          ), gbl, 2, 3, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		LayoutUtils.addGridBag(this,         new Label(getMessage("label.last"  )), gbl, 1, 4, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
		LayoutUtils.addGridBag(this, last  = new Label(                          ), gbl, 2, 4, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		insets.bottom = MARGIN;
		LayoutUtils.addGridBag(this,         new Label(getMessage("label.count" )), gbl, 1, 5, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST  , insets);
		LayoutUtils.addGridBag(this, count = new Label(                          ), gbl, 2, 5, 1, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.WEST  , insets);
		
		// ˥塼
		popupMenu = new PopupMenu(getMessage("menu"));
		menuItems = new MenuItem[MENU_SIZE];
		createMenuItem(MENU_OPEN    );
		popupMenu.addSeparator();
		createMenuItem(MENU_COPY    );
		createMenuItem(MENU_BOOKMARK);
		popupMenu.addSeparator();
		createMenuItem(MENU_DELETE  );
		add(popupMenu);                         // list ˤɲäʤʽͤ
		
		// ꥹʤϿ
		KeyListener findKeyListener;
		addKeyListener(findKeyListener =
			new KeyAdapter()
			{
				/** 줿 */
				public void keyPressed(KeyEvent e)
				{
					boolean isCtrl = ((e.getModifiers() & InputEvent.CTRL_MASK) != 0);
					
					// Ctrl + W Ĥ
					if (e.getKeyCode() == KeyEvent.VK_W && isCtrl) {
						closeWindow();
						return;
					}
					
					// Ctrl + Q ǽλ
					if (e.getKeyCode() == KeyEvent.VK_Q && isCtrl) {
						wm.exit();
						return;
					}
				}
			}
		);
		addWindowListener(
			new WindowAdapter()
			{
				/** ɥ줿Ȥ */
				public void windowOpened(WindowEvent e)
				{
					wm.addWindow(HistoryEditor.this);
				}
				
				/** ɥĤ褦ȤȤ */
				public void windowClosing(WindowEvent e)
				{
					closeWindow();
				}
				
				/** ɥĤ줿Ȥ */
				public void windowClosed(WindowEvent e)
				{
					wm.removeWindow(HistoryEditor.this);
					
					// ץ¸
					Point position = getLocation();
					if (position.x >= 0 || position.y >= 0) {
						HistoryEditor.this.option.setHistoryWindowPosition(position);
						HistoryEditor.this.option.setHistoryWindowSize    (HistoryEditor.this.getSize());
					}
				}
			}
		);
		
		list.addItemListener(
			new ItemListener()
			{
				/** 򤵤줿 */
				public void itemStateChanged(ItemEvent e)
				{
					int index = list.getSelectedIndex();
					if (index < 0)
						return;
					
					text .setText(histories[index].getTitle  ());
					url  .setText(histories[index].getURLText());
					first.setText((new Date(histories[index].getFirstVisit())).toString());
					last .setText((new Date(histories[index].getLastVisit ())).toString());
					count.setText(String.valueOf(histories[index].getVisitCount()));
				}
			}
		);
		list.addKeyListener(
			new KeyAdapter()
			{
				/** 줿 */
				public void keyPressed(KeyEvent e)
				{
					// ENTER ǳ
					if (e.getKeyCode() == KeyEvent.VK_ENTER) {
						openHistory();
						e.consume();
						return;
					}
				}
			}
		);
		list.addMouseListener(
			new MouseAdapter()
			{
				/** å */
				public void mouseClicked(MouseEvent e)
				{
					// å
					if (e.isPopupTrigger() ||
					    ((e.getModifiers() & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK)) {
						Font font = menuItems[MENU_OPEN].getFont();
						menuItems[MENU_OPEN].setFont(new Font(font.getName(), Font.BOLD, font.getSize()));
						
						popupMenu.show(e.getComponent(), e.getX(), e.getY());
						e.consume();
						return;
					}
					
					// ֥륯å
					if (((e.getModifiers() & InputEvent.BUTTON1_MASK) == InputEvent.BUTTON1_MASK) &&
					    e.getClickCount() == 2) {
						openHistory();
						e.consume();
						return;
					}
				}
			}
		);
		
		// ٤ƤΥȥ˥ꥹʡɲ
		list.addKeyListener(findKeyListener);
		
		doLayout();
		
		// ֤
		{
			setSize(option.getHistoryWindowSize());
			
			Point position = option.getHistoryWindowPosition();
			if (position != null) {
				setLocation(position);
			} else {
				Dimension size        = getSize();
				Dimension desktopSize = getToolkit().getScreenSize();
				setLocation((desktopSize.width  - size.width ) / 2,
				            (desktopSize.height - size.height) / 2);
			}
		}
		
		// ƥȥΥǥեȤ
		setForeground(SystemColor.controlText);
		setBackground(SystemColor.control    );
		histories = hm.getHistories(true);
		size      = histories.length;
		for (int i = 0; i < size; i++)
			list.add(histories[i].getTitle());
		text.setFont(new Font("Dialog", Font.BOLD, 12));
	}
	
	/** ˥塼ܤ */
	private void createMenuItem(int index)
	{
		String menuKey = null;
		
		/// MENU
		switch (index) {
		case MENU_OPEN    : menuKey = "menu.open"    ; break;
		case MENU_COPY    : menuKey = "menu.copy"    ; break;
		case MENU_BOOKMARK: menuKey = "menu.bookmark"; break;
		case MENU_DELETE  : menuKey = "menu.delete"  ; break;
		default:
			//### ERROR
			return;
		}
		
		MenuItem mi = new MenuItem(getMessage(menuKey));
		mi.setEnabled(true);
		mi.addActionListener(new MenuActionListner(index));
		menuItems[index] = mi;
		popupMenu.add(mi);
	}
	
	/** ꥽ʸ */
	private String getMessage(String key)
	{
		if (key == null)
			return "";
		
		return Resource.getMessage(RESOURCE, "historyeditor." + key, null);
	}
	
//### HawkWindow
	/**
	 * ɥĤޤ
	 */
	public void closeWindow()
	{
		dispose();
	}
	
	/**
	 * Υ᥽åɤľܸƤӽФƤϹԤޤ
	 * ˡ{@link WindowManager#addWindow(HawkWindow)}
	 * ƤӽФɬפޤ
	 */
	public void addWindowMenu(HawkWindow window)
	{
	}
	
	/**
	 * Υ᥽åɤľܸƤӽФƤϹԤޤ
	 * ˡ{@link WindowManager#removeWindow(HawkWindow)}
	 * ƤӽФɬפޤ
	 */
	public void removeWindowMenu(int index)
	{
	}
	
	/**
	 * Υ᥽åɤľܸƤӽФƤϹԤޤ
	 * ˡ{@link WindowManager#changeWindow(HawkWindow)}
	 * ƤӽФɬפޤ
	 */
	public void changeWindowMenu(int index, HawkWindow window)
	{
	}
	
	/**
	 * Υ᥽åɤľܸƤӽФƤϹԤޤ
	 * ˡ{@link WindowManager#addToBookmark(Bookmark, Bookmark)}
	 * ƤӽФɬפޤ
	 */
	public void addToBookmark(Bookmark parent, Bookmark bookmark)
	{
	}
	
	/**
	 * Υ᥽åɤľܸƤӽФƤϹԤޤ
	 * ˡ{@link WindowManager#bookmarkChanged()}
	 * ƤӽФɬפޤ
	 */
	public void bookmarkChanged()
	{
	}
	
//### private
	/**  */
	private void openHistory()
	{
		synchronized (lock) {
			int index = list.getSelectedIndex();
			if (index < 0)
				return;
			
			HawkViewer viewer = wm.getActiveViewer();
			if (viewer == null)
				return;
			
			viewer.open(histories[index].getURL(), null);
			
			if (index != 0) {
				History h = histories[index];
				list.remove (index);
				list.addItem(h.getTitle(), 0);
				list.select (index);
				System.arraycopy(histories, 0, histories, 1, index);
				histories[0] = h;
			}
		}
	}
	
	/** 򥳥ԡ */
	private void copyHistory()
	{
		synchronized (lock) {
			int index = list.getSelectedIndex();
			if (index < 0)
				return;
			
			copyClipboard(histories[index].getURLText());
		}
	}
	
	/** ֥åޡɲ */
	private void bookmarkHistory()
	{
		synchronized (lock) {
			int index = list.getSelectedIndex();
			if (index < 0)
				return;
			
			Bookmark parent   = bm.getRootBookmark();
			Bookmark bookmark = new Bookmark(histories[index].getTitle  (),
			                                 histories[index].getURLText());
			parent.addBookmark(bookmark);
			wm.addToBookmark(parent, bookmark);
		}
	}
	
	/**  */
	private void deleteHistory()
	{
		synchronized (lock) {
			int index = list.getSelectedIndex();
			if (index < 0)
				return;
			
			size--;
			list.remove(index);
			hm  .remove(histories[index]);
			if (index < size)
				System.arraycopy(histories, index + 1, histories, index, size - index);
			histories[size] = null;
			text .setText("");
			url  .setText("");
			first.setText("");
			last .setText("");
			count.setText("");
		}
	}
	
	/** åץܡɤ˥ԡ */
	private void copyClipboard(String value)
	{
		Clipboard       clipboard = getToolkit().getSystemClipboard();
		StringSelection data      = new StringSelection(value);
		clipboard.setContents(data, data);
	}
	
	
//### MenuActionListner
	/** ˥塼ѤΥꥹ */
	private class MenuActionListner
		implements ActionListener
	{
		private int index = 0;
		
		/** ˥塼ꥹ  */
		private MenuActionListner(int index)
		{
			this.index = index;
		}
		
		/** ϥɥ */
		public void actionPerformed(ActionEvent e)
		{
			switch (index) {
			case MENU_OPEN    : openHistory    (); break;
			case MENU_COPY    : copyHistory    (); break;
			case MENU_BOOKMARK: bookmarkHistory(); break;
			case MENU_DELETE  : deleteHistory  (); break;
			}
		}
	}
}
