/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.form;

import net.hizlab.kagetaka.awt.tate.List;

import java.util.Vector;

/**
 * <code>SELECT</code> ƥʣɽɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
class ItemList
	extends ItemSelect
{
	private List   list;
	private Vector values = new Vector();
	private Vector indexs = new Vector();
	private int    index  = -1;
	
	/** ꥹȤ */
	ItemList(Form form, int type, String name, List c)
	{
		super(form, type, name, c);
		this.list = c;
	}
	
	/** ͤɲ */
	void addValue(String value, String label, boolean selected)
	{
		list.addItem(label);
		values.addElement(value);
		if (selected) {
			list.select(index = values.size() - 1);
			indexs.addElement(Boolean.TYPE);
		} else {
			indexs.addElement(Boolean.FALSE);
		}
	}
	
	/** ʣǤ뤫 */
	boolean getMultipleMode()
	{
		return list.getMultipleMode();
	}
	
	/** ͤ */
	String getValue()
	{
		int index = list.getSelectedIndex();
		if (index == -1)
			return null;
		
		return (String)values.elementAt(index);
	}
	
	/** ͤ */
	String[] getValues()
	{
		int[] indexs = list.getSelectedIndexs();
		if (indexs == null || indexs.length == 0)
			return null;
		
		String[] v = new String[indexs.length];
		for (int i = 0; i < indexs.length; i++)
			v[i] = (String)values.elementAt(indexs[i]);
		
		return v;
	}
	
	/** ͤꥻå */
	void reset()
	{
		if (list.getMultipleMode()) {
			int size = values.size();
			for (int i = 0; i < size; i++)
				if (((Boolean)indexs.elementAt(i)).booleanValue())
					list.select(i);
				else
					list.deselect(i);
		} else {
			list.select(index);
		}
	}
}
