/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.form;

import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.rendering.HawkContext;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.token.FormItem;
import net.hizlab.kagetaka.token.StartToken;

/**
 * եб뤿Υϥɥ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class FormManager
	extends net.hizlab.kagetaka.token.FormManager
{
	private HawkContext context;
	private Document    document;
	private Form        form;
	
	/**
	 * եޥ͡ޤ
	 * 
	 * @param     context  륳ƥ
	 * @param     document ɥȾ
	 */
	public FormManager(HawkContext context, Document document)
	{
		this.context  = context;
		this.document = document;
	}
	
	/** {@inheritDoc} */
	public void beginForm(StartToken token)
	{
		form = new Form(context, document, token);
	}
	
	/** {@inheritDoc} */
	public void endForm()
	{
		if (form == null)
			return;
		
		form.close();
		form = null;
	}
	
	/** {@inheritDoc} */
	public FormItem addFormItem(StartToken token)
	{
		if (form == null)
			return null;
		
		return form.addItem(token);
	}
	
	/** {@inheritDoc} */
	public void beginSelect(StartToken token)
	{
		if (form == null)
			return;
		
		form.beginSelect(token);
	}
	
	/** {@inheritDoc} */
	public FormItem endSelect()
	{
		if (form == null)
			return null;
		
		return form.endSelect();
	}
	
	/** {@inheritDoc} */
	public void addOption(StartToken token)
	{
		if (form == null)
			return;
		
		form.addOption(token);
	}
	
	/** {@inheritDoc} */
	public FormItem addTextarea(StartToken token)
	{
		if (form == null)
			return null;
		
		return form.addTextarea(token);
	}
}
