/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.form;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

/**
 * ܥʤɤνԤ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
abstract class Action
	implements ActionListener, KeyListener, MouseListener
{
	final Form    form;
	final Item    origin;
	final boolean location;
	
	/**  */
	Action(Form form, Item origin, boolean location)
	{
		this.form     = form;
		this.origin   = origin;
		this.location = location;
	}
	
	/** ¹ */
	abstract void doAction(int x, int y);
	
	/** ȯ */
	public void actionPerformed(ActionEvent e)
	{
		doAction(0, 0);
	}
	
	/** פ줿 */
	public void keyTyped(KeyEvent e)
	{
		if (e.getModifiers() == 0 && e.getKeyChar() == ' ')
			doAction(0, 0);
	}
	
	/** 줿 */
	public void keyPressed(KeyEvent e)
	{
		if (e.getModifiers() == 0 && e.getKeyCode() == KeyEvent.VK_ENTER)
			doAction(0, 0);
	}
	
	/** Υ줿 */
	public void keyReleased(KeyEvent e)
	{
	}
	
	/** ޥå줿 */
	public void mouseClicked(MouseEvent e)
	{
		if (!e.getComponent().isEnabled())
			return;
		if (e.getModifiers() == InputEvent.BUTTON1_MASK)
			doAction(e.getX(), e.getY());
	}
	
	/** ޥ줿 */
	public void mousePressed(MouseEvent e)
	{
	}
	
	/** ޥ줿 */
	public void mouseReleased(MouseEvent e)
	{
	}
	
	/** ޥä */
	public void mouseEntered(MouseEvent e)
	{
	}
	
	/** ޥФ */
	public void mouseExited(MouseEvent e)
	{
	}
}
