/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.cookie;

import java.net.URL;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * åδʰץޥ͡㥯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class CookieFactory
	extends CookieStore
{
	/** åɥᥤƤϥåơ֥ */
	protected Hashtable hash = new Hashtable();
	/** åν񼰤̩˲᤹ */
	protected boolean   strict;
	
	/**
	 * åʰץޥ͡ޤ
	 */
	public CookieFactory()
	{
	}
	
	/**
	 * ꤵ줿 URL 륯åϤ֤ޤ
	 * 
	 * @param     url å URL
	 * 
	 * @return    륯å
	 *            åɬפʤ <code>null</code>
	 */
	public synchronized String getCookie(URL url)
	{
		Vector list = null;
		String host = url.getHost();
		Cookie c    = (Cookie)hash.get(host);
		
		// ۥ̾פ륯å
		if (c != null) {
			list = new Vector();
			do {
				list.addElement(c);
			} while ((c = c.next) != null);
		}
		
		// ۥ̾ΥѡȤο
		int count = 0;
		for (int i = host.length() - 1; i >= 0; i--)
			if (host.charAt(i) == '.')
				count++;
		
		int p;
		for (int i = count - 2; i >= 0; i--) {
			// ǽ . ľޤǼ
			host = host.substring(host.indexOf('.', 1));
			
			if ((c = (Cookie)hash.get(host)) != null) {
				if (list == null)
					list = new Vector();
				do {
					list.addElement(c);
				} while ((c = c.next) != null);
			}
		}
		
		return (list == null ? null : getCookieString(list, url));
	}
	
	/**
	 * ꤷåꡢ¸ޤ
	 * 
	 * @param     data <code>Set-Cookie</code> إåʸ
	 * @param     url  åȯԤ URL
	 */
	public synchronized void setCookie(String data, URL url)
	{
		if (url.getProtocol().compareTo("file") == 0 ||
		    url.getHost() == null ||
		    url.getHost().length() == 0)
			return;
		
		try {
			appendCookie(new Cookie(data, url, strict));
		} catch (ParseException e) {
System.out.println(e);
			//### ERROR
		}
	}
	
	/**
	 * å¤ɲäޤ
	 * 
	 * @param     cookie ɲä륯å
	 */
	protected void appendCookie(Cookie cookie)
	{
		String domain = cookie.getDomain();
		Cookie parent = (Cookie)hash.get(domain);
		if (parent == null) {
			hash.put(domain, cookie);
		} else {
			// name ȥѥ νʣʤå
			String name = cookie.getName();
			String path = cookie.getPath();
			Cookie c = parent;
			
			for (;;) {
				if (name.compareTo(c.getName()) == 0 &&
				    path.compareTo(c.getPath()) == 0) {
					long expires = c.getExpires();
					if (expires == -1 || expires >= System.currentTimeMillis()) {
						// åι
						if (c.prev == null) {
							// Ƭʤñȡˤξ
							if (c.next != null) {
								cookie.next      = c.next;
								cookie.next.prev = cookie;
							}
							hash.put(domain, cookie);
						} else {
							// Ƭʳξ
							cookie.prev      = c.prev;
							cookie.prev.next = cookie;
							if (c.next != null) {
								cookie.next      = c.next;
								cookie.next.prev = cookie;
							}
						}
					} else {
						// åκ
						if (c.prev == null) {
							if (c.next != null) {
								// Ƭξ
								c = c.next;
								c.prev.next = null;
								c.prev      = null;
								hash.put(domain, c);
							} else {
								// ñȤξ
								hash.remove(domain);
							}
						} else {
							if (c.next != null) {
								// ξ
								c.prev.next = c.next;
								c.next.prev = c.prev;
								c.prev = c.next = null;
							} else {
								// ξ
								c.prev.next = null;
								c.prev      = null;
							}
						}
					}
					
					return;
				}
				
				if (c.next == null)
					break;
				c = c.next;
			}
			
			// Ǹɲ
			c.next      = cookie;
			cookie.prev = c;
		}
	}
	
	/** åΥꥹȤʸ */
	private String getCookieString(Vector list, URL url)
	{
		int    size = list.size();
		int    good = size;
		long   now  = System.currentTimeMillis();
		Cookie c;
		
		// ͭ¤Υå
		for (int i = 0; i < size; i++) {
			c = (Cookie)list.elementAt(i);
			if (c.getExpires() != -1 && c.getExpires() < now) {
				if (--good == 0)
					return null;
				list.setElementAt(null, i);
			}
		}
		
		// ѥΥå
		String    path = url.getFile();
		Hashtable pathHash = null;
		for (int i = 0; i < size; i++) {
			if ((c = (Cookie)list.elementAt(i)) == null)
				continue;
			
			if (!c.isTargetPath(path)) {
				if (--good == 0)
					return null;
				list.setElementAt(null, i);
			}
			
			if (pathHash == null)
				pathHash = new Hashtable();
			pathHash.put(c.getPath(), "");
		}
		if (pathHash == null)
			return null;
		
		// ѥĹ˼
		int pathNum = pathHash.size();
		int length = -1, index = 0;
		String[] pathList  = new String[pathNum];
		int   [] pathLen   = new int   [pathNum];
		int      pathIndex = 0;
		for (Enumeration e = pathHash.keys(); e.hasMoreElements(); ) {
			path = (String)e.nextElement();
			pathList[pathIndex] = path;
			pathLen [pathIndex] = path.length();
			if (length < pathLen[pathIndex]) {
				length = pathLen[pathIndex];
				index  = pathIndex;
			}
			pathIndex++;
		}
		
		// ѥĹ˼Ф
		StringBuffer sb = null;
		for (;;) {
			path = pathList[index];
			
			for (int i = 0; i < size; i++) {
				if ((c = (Cookie)list.elementAt(i)) == null)
					continue;
				
				if (path.compareTo(c.getPath()) == 0) {
					if (sb == null)
						sb = new StringBuffer();
					else
						sb.append("; ");
					sb.append(c.getFullValue());
					
					if (--good == 0)
						return sb.toString();
					list.setElementAt(null, i);
				}
			}
			
			// Ĺѥ򸡺
			pathLen[index] = -1;
			length = -1;
			for (int i = 0; i < pathList.length; i++) {
				if (length < pathLen[i]) {
					length = pathLen[i];
					index  = i;
				}
			}
		}
	}
}
