/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;
import net.fclabs.util.Queue;

import java.io.InputStream;
import java.io.IOException;
import java.util.Stack;

/**
 * ȡɤ߹ߤʤ顢άƤȡʤɤä
 * Ĵ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class TokenCoordinator
{
	private Document document = null;         // ɥȾ
	private Parser   parser   = null;         // ѡ
	private Reporter reporter = null;         // 顼ݡ
	
	/**
	 * ꤵ줿ѡ顢ȡɤ߹Ĵ뤿
	 * ǥ͡ޤ
	 * 
	 * @param     document ɥȾ
	 * @param     parser ȡɤ߹िΥѡ
	 * @param     reporter 顼ݡ
	 */
	public TokenCoordinator(Document document, Parser parser, Reporter reporter)
	{
		FilterParser p = null;
		
		p = new Abbreviation();
		p.setParser(document, parser, reporter);
		parser = p;
		
		this.document = document;
		this.parser   = parser;
		this.reporter = reporter;
	}
	
	/**
	 * ǡեϤϰ֤ƬΥȡ֤ޤ
	 * ʾȡ̵ϡ<code>null</code> ֤ޤ
	 * 
	 * @return    Ϥ̤ƬΥȡ
	 *            ȡ¸ߤʤ <code>null</code>
	 */
	public synchronized Token next()
	{
		return nextToken(parser);
	}
	
	/** parser 鼡Υȡɤ߹ */
	private Token nextToken(Parser parser)
	{
		try {
			return parser.next();
		} catch (IOException e) {
			reportMessage(Reporter.ERROR,
			              "tc.error.ioerror",
			              new String[]{e.toString()}, null);
		} catch (ParseException e) {
			reportMessage(Reporter.ERROR,
			              "tc.error.parseerror",
			              new String[]{e.toString()}, null);
		} catch (Exception e) {
			reportMessage(Reporter.ERROR,
			              "tc.error.unknownerror",
			              new String[]{e.toString()}, null);
			e.printStackTrace();
		}
		
		return null;
	}
	
	/** å */
	private void reportMessage(int type, String key, String[] args, Token token)
	{
		if (reporter == null)
			return;
		
		reporter.report(type,
		                Resource.getMessage(key, args),
		                (token == null ? 0 : token.getLineNumber  ()),
		                (token == null ? 0 : token.getColumnNumber()));
	}
	
//### Abbreviation
	/** ά줿ȡ䴰 */
	private class Abbreviation
		extends FilterParser
	{
		private Queue fixedTokenQueue   = new Queue();         // ĴѤߥȡԤ
		private Queue unfixedTokenQueue = new Queue();         // ̤ĴҤΥȡԤ
		
		private boolean    alreadyEnd  = false; // ˽λ
		private boolean    isFrameset  = false; // ե졼ॻåȤ
		private StartToken bottomToken = null;  // åκǲ̤Υȡ
		
		// 
		private Stack createToken = new Stack();
		
		/** ͣΥ󥹥ȥ饯 */
		private Abbreviation()
		{
		}
		
		/** {@inheritDoc} */
		public String getParserName()
		{
			return "AbbreviationCoordinator";
		}
		
		/** {@inheritDoc} */
		public String getParserDescription()
		{
			return "ά줿ȡ䤤ޤ";
		}
		
		/** {@inheritDoc} */
		public Token next()
			throws ParseException, IOException
		{
			if (alreadyEnd)
				return null;
			
			Token token = null;
			
			READ_TOKEN:
			{
				for (;;) {
					// ĴѤߥȡԤˤС֤
					if ((token = (Token)fixedTokenQueue.get()) != null)
						break READ_TOKEN;
					
					// ѡȡɤ߹
					if ((token = readNextToken()) == null)
						return null;
					
					// פå
					switch (token.getType()) {
					case TokenTypes.DTD:
					case TokenTypes.COMMENT:
					case TokenTypes.PI:
						continue;
					}
					
					// ǲ̤Υȡ󤬶ξ
					if (bottomToken == null) {
						// ƥȤǶξ̵뤹
						if (token instanceof TextToken) {
							TextToken textToken = (TextToken)token;
							if (!textToken.hasCharacters())
								continue;
						}
						
						// HTML ξϤ֤
						if (token.getType() == TokenTypes.HTML_START) {
							bottomToken = (StartToken)token;
							return token;
						}
						// HTML ʳξϡHTML ɤ߹ȡ򥭥塼ɲ
						unfixedTokenQueue.put(token);
						bottomToken = TokenManager.createStartToken(document, reporter, 0, 0, TokenTypes.HTML_START, true);
						reportMessage(Reporter.WARNING,
						              "tc.warning.nohtml",
						              new String[]{bottomToken.getName()}, bottomToken);
						return bottomToken;
					}
					
					// ե졼ξ NOFRAMES ɤФ
					if (token.getType() == TokenTypes.NOFRAMES_START) {
						skipToken(TokenTypes.NOFRAMES_START, TokenTypes.NOFRAMES_END);
						continue;
					}
					
					// ȡμĴ
					if (token instanceof TextToken ) { token = fixedTextToken ((TextToken )token); } else
					if (token instanceof StartToken) { token = fixedStartToken((StartToken)token); } else
					if (token instanceof EndToken  ) { token = fixedEndToken  ((EndToken  )token); } else
					if (token instanceof MiscToken ) { continue;                                   } else
					{
						reportMessage(Reporter.WARNING,
						              "tc.warning.unknowntoken",
						              new String[]{token.toString()}, token);
						continue;
					}
					
					if (token != null)
						break READ_TOKEN;
				}
			}
			
			
			// λξϺǲ̤Υȡ򤽤οƤѹ
			if (token instanceof EndToken) {
				bottomToken = bottomToken.getParent();
				
				// getParent()  null ֤ΤϡǾ̤ HTML ξ
				if (bottomToken == null) {
					alreadyEnd = true;
					return token;
				}
			}
			
			bottomToken.includeToken(token);        // ƻҤ
			
			// ϥξϺǲ̤Υȡ򿷤ȡѹ
			if (token instanceof StartToken && !TokenTypes.isEmpty(token.getType()))
				bottomToken = (StartToken)token;
			
			return token;
		}
		
		/** ˽򤹤٤ȡ֤ */
		private Token readNextToken()
			throws ParseException, IOException
		{
			// ̤ĴȡԤˤС֤
			Token token = (Token)unfixedTokenQueue.get();
			if (token != null)
				return token;
			
			// ѡȡɤ߹
			return nextToken(super.parser);
		}
		
		/** ƥȥȡĴ򤷡ƬΥȡ֤ */
		private Token fixedTextToken(TextToken currentToken)
		{
			StartToken token       = null;
			StartToken parentToken = bottomToken;
			
			// ƤƥȥȡƤ
			if (TokenTypes.canHaveText(parentToken.getType()))
				return currentToken;
			
			// ʸξ
			if (!currentToken.hasCharacters())
				return null;
			
			// Ūˤϲۥ֥åȡäƤߤ
			int completeType = TokenTypes._BLOCK_START;
			int parentType   = parentToken.getType();
			
			// Ƥ RUBY ȡξ RB ȡäƤߤ
			if (parentType == TokenTypes.RUBY_START)
				completeType = TokenTypes.RB_START;
			
			// Ƥ UL/OL ȡξ LI ȡäƤߤ
			else
			if (parentType == TokenTypes.UL_START ||
			    parentType == TokenTypes.OL_START)
				completeType = TokenTypes.LI_START;
			
			token = TokenManager.createStartToken(document,
			                                      reporter,
			                                      currentToken.getLineNumber(),
			                                      currentToken.getColumnNumber(),
			                                      completeType,
			                                      true);
			
			if (token != null && parentToken.isContents(token)) {
				// Ƥ䴰Ƥ
				reportMessage(Reporter.WARNING,
				              "tc.warning.completestart",
				              new String[]{token.getName()}, token);
				
				fixedTokenQueue.put(currentToken);
				return token;
			}
			
			// ˤϥƥȥȡ֤ʤ
			reportMessage(Reporter.WARNING,
			              "tc.warning.invalidposition",
			              new String[]{currentToken.getName()}, currentToken);
			return null;
		}
		
		/** ϥȡĴ򤷡ƬΥȡ֤ */
		private Token fixedStartToken(StartToken currentToken)
		{
			StartToken token       = currentToken;
			StartToken parentToken = null;
			int        popLevel    = 0;
			StartToken createLi    = null;
			
			// ɲäȡ󤬡¸ΥåΤɤ˴ޤळȤ뤫
			// ååʽλȡ󤬾άƤ륱б
			STACK_CHECK:
			for (;;) {
				parentToken = bottomToken;
				popLevel    = -1;
				
				// ɲäȡ󤬿ƥȡɲäǤʤå
				do {
					popLevel++;
					if (parentToken.isContents(token))
						break STACK_CHECK;
					
					// Ƥ UL/OL ʤ LI äĴ٤
					if (parentToken.getType() == TokenTypes.UL_START ||
					    parentToken.getType() == TokenTypes.OL_START) {
						if (createLi == null)
							createLi = TokenManager.createStartToken(document,
							                                         reporter,
							                                         currentToken.getLineNumber(),
							                                         currentToken.getColumnNumber(),
							                                         TokenTypes.LI_START,
							                                         true);
						
						if (createLi.isContents(token)) {
							createToken.push(createLi);
							break STACK_CHECK;
						}
					}
					
					// ʬ TD/TH ʤơTRˤäƤߤ
					if (token == currentToken) {
						switch (token.getType()) {
						case TokenTypes.TD_START:
						case TokenTypes.TH_START:
							StartToken st =  token.getDefaultParentToken();
							if (parentToken.isContents(st)) {
								createToken.push(st);
								break STACK_CHECK;
							}
						}
					}
					
					// Ƥľ˰ư
				} while ((parentToken = parentToken.getParent()) != null);
				
				// ɲäȡ󤬿ƤΤɤˤɲäǤʤ硢ƤäƤߤ
				token = token.getDefaultParentToken();
				if (token == null) {
					reportMessage(Reporter.WARNING,
					              "tc.warning.invalidposition",
					              new String[]{currentToken.getName()}, currentToken);
					if (!createToken.empty())
						createToken.removeAllElements();
					return null;
				}
				createToken.push(token);
			}
			
			Token topToken = null;
			
			// λάƤ硢λ䤦
			if (popLevel > 0)
				topToken = complementEndToken(popLevel, currentToken);
			
			// ϥάƤ硢ϥ䤦
			if (!createToken.empty()) {
				while (!createToken.empty()) {
					token = (StartToken)createToken.pop();
					reportMessage(Reporter.WARNING,
					              "tc.warning.completestart",
					              new String[]{token.getName()}, token);
					if (topToken == null)
						topToken = token;
					else
						fixedTokenQueue.put(token);
				}
				createToken.removeAllElements();
			}
			
			if (topToken == null)
				topToken = currentToken;
			else
				fixedTokenQueue.put(currentToken);
			
			return topToken;
		}
		
		/** λȡĴ򤷡ƬΥȡ֤ */
		private Token fixedEndToken(EndToken currentToken)
		{
			StartToken parentToken = bottomToken;
			int type     = currentToken.getType();
			int popLevel = 0;
			
			// λȡ󤬡¸ΥåΤɤΥڥ
			// ååʽλȡ󤬾άƤ륱б
			for (;;) {
				if (parentToken.getEndTokenType() == type)
					break;
				
				// ľοƤ˽°Ǥ뤫Ĵ٤
				if (isTopContainer(parentToken.getType(), type) ||
				    (parentToken = parentToken.getParent()) == null) {
					reportMessage(Reporter.WARNING,
					              "tc.warning.nostart",
					              new String[]{currentToken.getName()}, currentToken);
					return null;
				}
				popLevel++;
			}
			
			// λάƤ硢λ䤤Ƭ֤
			if (popLevel > 0) {
				Token topToken = complementEndToken(popLevel, currentToken);
				fixedTokenQueue.put(currentToken);
				return topToken;
			}
			
			return currentToken;
		}
		
		/** ꤵ줿åοʬνλѤԤ졢Ƭ֤ */
		private Token complementEndToken(int level, Token currentToken)
		{
			Token      topToken    = null;
			StartToken parentToken = bottomToken;
			EndToken   endToken    = null;
			
			// λάƤΤǡλ䤦
			while (level-- > 0) {
				endToken = parentToken.getEndToken(currentToken);
				reportMessage(Reporter.WARNING,
				              "tc.warning.completeend",
				              new String[]{endToken.getName()}, endToken);
				
				if (topToken == null)
					topToken = endToken;
				else
					fixedTokenQueue.put(endToken);
				
				if ((parentToken = parentToken.getParent()) == null)
					break;
			}
			
			return topToken;
		}
		
		/** ꤵ줿ȡ󤬥ȥåפΥƥʥȡ󤫤ɤ֤ */
		private boolean isTopContainer(int parentToken, int token)
		{
			if (parentToken == TokenTypes.RUBY_START  && TokenTypes.isRubyItem (token))
				return true;
			if (parentToken == TokenTypes.TABLE_START && TokenTypes.isTableItem(token))
				return true;
			if (parentToken == TokenTypes.FORM_START  && TokenTypes.isFormItem (token))
				return true;
			
			return false;
		}
		
		/** бȡɤФ */
		private void skipToken(int start, int end)
			throws ParseException, IOException
		{
			Token token;
			int   type;
			int   level = 1;
			
			while ((token = (Token)fixedTokenQueue.get()) != null ||
				   (token = readNextToken             ()) != null) {
				
				type = token.getType();
				if (type == start)
					level++;
				else if (type == end && --level == 0)
					return;
			}
			
			return;
		}
	}
}
