/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;

import java.io.BufferedReader;
import java.io.IOException;

/**
 * Υե򡢥ɤ߹꡼Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class TagReader
{
	private BufferedReader br       = null;   // ꡼
	private Reporter       reporter = null;   // 顼ݡ
	
	private String line   = "";               // ɹι
	private int    offset = 0;                // ɹιԤΥȰ
	private int    length = 0;                // ɹιԤĹ
	private int    lineNumber = 0;            // ɤ߹Կ
	private int    columnNumber = 1;          // ɤ߹ιԤΥֹ
	private Tag    nextTag = null;
	
	/**
	 * Υǡե򥿥ʬ򤷤ɤ߹꡼
	 * ޤ
	 * 
	 * @param     br ϤǡΥХåե꡼
	 * @param     reporter 顼ݡ
	 */
	public TagReader(BufferedReader br, Reporter reporter)
	{
		this.br       = br;
		this.reporter = reporter;
	}
	
	/**
	 * ǡեϤϰ֤ƬΥȡ֤ޤ
	 * 
	 * @return    Ϥ̤ƬΥȡ
	 *            ȡ¸ߤʤ <code>null</code>
	 * 
	 * @exception ParseException ˥顼ȯ
	 * @exception IOException    IO 顼ȯ
	 */
	public Tag readTag()
		throws ParseException, IOException
	{
		if (nextTag != null) {
			Tag tag = nextTag;
			nextTag = null;
			return tag;
		}
		
		if (line == null)
			return null;
		
		StringBuffer sb = null;
		String data = null;
		
		int startLineNumber = lineNumber, startColumnNumber = columnNumber;
		int p;
		
		int type = Tag.MISC;
		String start, end;
		int endPosition = 0, nextPosition = 0;
		
		if (startsWith("<![CDATA[")) {
			// CDATA ξ
			type  = Tag.TEXT;
			start = "<![CDATA[";
			end   = "]]>";
			nextPosition = 3;
		} else
		if (startsWith("<!--")) {
			// Ȥξ
			type  = Tag.COMMENT;
			start = "<!--";
			end   = "-->";
			endPosition = 3;
		} else
		if (startsWith("<?")) {
			// ̤Υξ
			type  = Tag.PI;
			start = "<?";
			end   = "?>";
			endPosition = 2;
		} else
		if (startsWith("<!")) {
			// DTD ξ
			type  = Tag.DTD;
			start = "<!";
			end   = ">";
			endPosition = 1;
		} else
		if (startsWith("<")) {
			// ̤Υξ
			type  = Tag.TAG;
			start = "<";
			end   = ">";
			endPosition = 1;
		} else {
			// ƥȤξ
			type  = Tag.TEXT;
			start = null;
			end   = "<";
		}
		
		for (;;) {
			if (offset < length) {
				p = line.indexOf(end, offset);
				if (p != -1) {
					// λʸĤä
					p += endPosition;
					if (sb == null) {
						data = line.substring(offset, p);
					} else {
						sb.append(line.substring(offset, p));
						data = sb.toString();
					}
					calculateColumnNumber(p + nextPosition);
					offset = p + nextPosition;
					break;
				}
			}
			
			// ߹ԤλĤХåեɲäƼιԤɤ߹
			if (sb == null)
				sb = new StringBuffer();
			if (offset < length)
				sb.append(line.substring(offset));
			sb.append((char)0x0A);
			
			if (!readLine())
				break;
		}
		
		// λʸĤʤä ( sb != null)
		if (data == null) {
			data = sb.toString();
			if (start != null && reporter != null)
				reporter.report(Reporter.WARNING,
				                Resource.getMessage("tagreader.warning.bracket.notclose",
				                                    new String[]{start, end}),
				                startLineNumber,
				                startColumnNumber);
		}
		
		return new Tag(reporter, startLineNumber, startColumnNumber, type, data);
	}
	
	/** ꤵ줿λޤǤȤ֤ */
	public String readContent(String name, boolean pair)
		throws ParseException, IOException
	{
		if (line == null)
			return null;
		
		StringBuffer sb = new StringBuffer();
		int p;
		int startLineNumber = 0, startColumnNumber = 0;
		String end = null;
		
		for (;;) {
			if (offset < length) {
				if (pair)
					p = line.indexOf("</", offset);
				else
					p = line.indexOf('<' , offset);
				
				if (p != -1) {
					// </, < Ĥä
					calculateColumnNumber(p);
					startLineNumber   = lineNumber;
					startColumnNumber = columnNumber;
					sb.append(line.substring(offset, p));
					
					if (!pair) {
						offset = p;
						return sb.toString();
					}
					
					columnNumber += 2;
					offset = p + 2;
					p = line.indexOf(">", offset);
					if (p != -1) {
						// > Ĥä
						end = line.substring(offset, p);
						calculateColumnNumber(p + 1);
						offset = p + 1;
					} else {
						// > ƱԤ˸ĤʤΤǡιԤɤ߹
						StringBuffer endb = new StringBuffer();
						endb.append(line.substring(offset));
						endb.append((char)0x0A);
						for (;;) {
							if (!readLine())
								break;
							p = line.indexOf(">");
							if (p != -1) {
								endb.append(line.substring(0, p));
								calculateColumnNumber(p + 1);
								offset = p + 1;
								break;
							}
							endb.append(line);
							endb.append((char)0x0A);
						}
						end = endb.toString();
					}
					
					// бĤξ硢Ĥޤɤ߹ǤޤäΤǡƺ
					if (end.trim().toLowerCase().compareTo(name) == 0) {
						nextTag = new Tag(reporter, startLineNumber, startColumnNumber, Tag.TAG, "</" + end + ">");
						return sb.toString();
					}
					
					sb.append("</");
					sb.append(end);
					sb.append('>');
				}
				sb.append(line.substring(offset));
			}
			
			sb.append((char)0x0A);
			
			if (!readLine())
				break;
		}
		
		return sb.toString();
	}
	
	/** ιԤɤ߹ */
	private boolean readLine()
		throws IOException
	{
		if ((line = br.readLine()) == null) {
			offset = 0;
			length = 0;
			return false;
		}
		
		lineNumber++;
		columnNumber = 1;
		offset = 0;
		length = line.length();
		
		return true;
	}
	
	/** ֤׻ */
	private void calculateColumnNumber(int end)
	{
		char c;
		for (int i = offset; i < end; i++) {
			c = line.charAt(i);
			if (c <= 0xFF || (0xFF61 <= c && c <= 0xFF9F))
				columnNumber += 1;
			else
				columnNumber += 2;
		}
	}
	
	/** ХåեƬꤵ줿ʸǻϤޤäƤ뤫 */
	private boolean startsWith(String value)
	{
		return ((offset < length) && line.startsWith(value, offset));
	}
	
	/**
	 * ꡼򥯥Υ꥽ޤ
	 * 
	 * @exception IOException IO 顼ȯ
	 */
	public void close()
		throws IOException
	{
		br.close();
	}
}
