/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.TextFormat;

import java.util.Hashtable;

/**
 * ΥȥƥȤɽ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Tag
{
	/**  */
	public static final int TAG     = 1;
	/** ƥ */
	public static final int TEXT    = 2;
	/** DTD */
	public static final int DTD     = 3;
	/**  */
	public static final int COMMENT = 4;
	/** ̿ */
	public static final int PI      = 5;
	/** ¾ */
	public static final int MISC    = 0;
	
	private Reporter reporter     = null;     // 顼ݡ
	private int      lineNumber   = 0;        // γϹԿ
	private int      columnNumber = 0;        // γϥ
	private int      type         = MISC;     // 
	private String   rawData      = null;     // ʸ
	private int      dataStart    = 0;        // ¦ʸγ
	private int      dataEnd      = 1;        // ¦ʸνλ
	
	private String    element    = null;      // ̾
	private boolean   isEndTag   = false;     // λɤ
	private boolean   isEmpty    = false;     // Ǥɤ
	private Hashtable attributes = null;      // °̾°ͤΥڥ
	
	/**
	 * ꤵ줿ʸϤƥȤɽ
	 * 󥹥󥹤ޤ
	 * value Ƭ &lt; ǻϤޤäƤϥȤƲϤ졢
	 * ʳξϥƥȤȤޤ
	 * <p>
	 * ιֹȥ֤ϡ顼ӷٹΥåѤޤ
	 * åֹȥ֤ɽ뤿ˡ
	 * ʸβԥɤ LF (0x0A) 줷Ƥɬפޤ
	 * 
	 * @param     reporter 顼ݡ
	 * @param     line ֹ (<code>1</code> )
	 * @param     column  (<code>1</code> )
	 * @param     type 
	 * @param     value Ϥʸ
	 * 
	 * @exception ParseException ˥顼ȯ
	 */
	public Tag(Reporter reporter, int line, int column, int type, String value)
		throws ParseException
	{
		this.reporter     = reporter;
		this.lineNumber   = line;
		this.columnNumber = column;
		this.type         = type;
		this.rawData      = value;
		
		int start = 0, end = value.length();
		
		// ʳξ
		if (type == TAG) {
			// ϥξ
			if (value.compareTo("<>") == 0)
				return;
			
			// λξ
			if (value.compareTo("</>") == 0) {
				this.isEndTag = true;
				return;
			}
			
			start++;                                // ǽ < ̵뤹
			
			// </ Τ褦ʽλξ
			if (end > 1 && value.charAt(1) == '/') {
				start++;
				this.isEndTag = true;
			}
			
			// νλ֤Ĵ
			if (value.charAt(end - 1) == '>') {
				// Ǹ > ̵뤹
				end--;
				
				// ǡ<.*/ˤξʺǸ > ϴ̵
				if (!isEndTag &&
				    end >= 2 &&
				    value.charAt(end - 1) == '/') {
					this.isEmpty = true;
					end--;
				}
			} else {
				addWarning("tag.warning.bracket.notclose", end);
			}
		} else if (type == PI && startsWordWith(value, "<?xml", 2)) {
			start += 2;
			end   -= 2;                           // ?> ʬ
		} else {
			dataEnd   = value.length();
			switch (type) {
			case DTD    : dataStart = 2; dataEnd -= 1; break;
			case COMMENT: dataStart = 4; dataEnd -= 3; break;
			case PI     : dataStart = 2; dataEnd -= 2; break;
			case MISC   : dataStart = 2; dataEnd -= 2; break;
			}
			return;
		}
		dataStart = start;
		dataEnd   = end;
		
		char c;
		String attribute = null, keyword, s;
		boolean removeCrlf  = false;
		boolean existEquals = false;
		boolean moveCurrent = false;
		int current = start;
		
		token:
		while (current < end) {
			// ɤФ
			while (value.charAt(current) <= 0x20)
				if (++current >= end)
					break token;
			
			start = current;
			c = value.charAt(start);
			if (c == '"' || c == '\'') {
				// "xxx" or 'xxx' ξ
				start++;
				current = value.indexOf(c, start);
				if (current == -1) {
					current = end;
					if (c == '"')
						addWarning("tag.warning.doublequotation.notclose", current);
					else
						addWarning("tag.warning.apostrophe.notclose", current);
				} else {
					moveCurrent = true;
					removeCrlf  = true;
				}
			} else if (c == '=') {
				// °̾ = °
				if (attribute == null || existEquals) {
					addWarning("tag.warning.equals.invalidposition", current);
				} else {
					existEquals = true;
				}
				current++;
				continue token;
			} else {
				// ζڤ򸡺
				while (++current < end) {
					c = value.charAt(current);
					/*
					// Τɡߤ
					switch (c) {
					case '.':
					case ':':
					case '-':
					case '_':
						continue;
					default:
						if (('A' <= c && c <= 'Z') ||
						    ('a' <= c && c <= 'z') ||
						    ('0' <= c && c <= '9'))
							continue;
						if (c >= 0x80)
							continue;                   // 绨Ĥˡ
					}
					break;
					*/
					
					// ʤ绨 <--
					if (c <= 0x20 || (!existEquals && c == '='))
						break;
					// -->
				}
			}
			
			s = value.substring(start, current);
			// " ǰϤޤ줿ʸβԤ
			if (removeCrlf) {
				StringBuffer sb = new StringBuffer();
				int p1 = 0, p2;
				for (p2 = 0; p2 < s.length(); p2++) {
					if (s.charAt(p2) < 0x20) {
						if (p1 < p2)
							sb.append(s.substring(p1, p2));
						p1 = p2 + 1;
					}
				}
				if (p1 < p2)
					sb.append(s.substring(p1, p2));
				s = sb.toString();
				removeCrlf = false;
			}
			keyword = TextFormat.convertXhtml(reporter, lineNumber, columnNumber,
			                                  s,
			                                  true, true, false, true);
			
			// ֤ˤꡢ̾°̾°ͤ
			if (this.element == null) {
				// ̤̾ξϡ̾Ȥ
				this.element = keyword;
			} else if (attribute == null) {
				// ̾ꤵ졢°̤̾ξ°̾ȤƤ
				attribute = keyword;
			} else {
				if (existEquals) {
					// ľ = ξϡ°ͤʤΤǡ°Υڥ¸
					addAttribute(attribute, keyword);
					attribute = null;
				} else {
					// ľ = Ǥ̵ϡľΥɤ
					// °̾ξά줿°ͤȤ¸
					// ɤ°̾ȤƤ
					addAttribute(attribute, attribute);
					attribute = keyword;
				}
				existEquals = false;
			}
			
			if (moveCurrent) {
				current++;                          // λ(", ') 򼡤
				moveCurrent = false;
			}
		}
		
		// °̾ǽλƤ硢°̾άƤ°
		if (attribute != null)
			addAttribute(attribute, attribute);
	}
	
	/** ʸ󤬻ꤵɤǻϤޤ뤫 */
	private boolean startsWordWith(String src, String word, int end)
	{
		if (!src.startsWith(word))
			return false;
		
		int wordLength = word.length();
		if (src.length() <= wordLength + end)   // word("<?abc") + end("?>")
			return true;
		
		char c = src.charAt(word.length());
		switch (c) {
		case 0x0009:  // 
		case 0x000A:  // 
		case 0x0020:  // ڡ
		case 0x000D:  // 
		case 0x000C:  // Form feed
		case 0x200B:  // Zero-width space
			return true;
		}
		
		return false;
	}
	
	/**
	 * פ֤ޤ
	 * 
	 * @return    
	 */
	public int getType()
	{
		return type;
	}
	
	/**
	 * ǤϤʤ硢ƥȤ֤ޤ
	 * 
	 * @return    ξ <code>null</code>
	 */
	public String getText()
	{
		return rawData;
	}
	
	/**
	 * ǰϤޤ줿¦ʸ֤ޤ
	 * 
	 * @return    ǰϤޤ줿¦ʸ
	 */
	public String getInnerText()
	{
		return rawData.substring(dataStart, dataEnd);
	}
	
	/**
	 * ξ硢֤̾ޤ
	 * 
	 * @return    Ǥ̵䡢ξ <code>null</code>
	 */
	public String getElement()
	{
		return element;
	}
	
	/**
	 * ̾ꤷޤ
	 * 
	 * @param     element ̾
	 */
	public void setElement(String element)
	{
		this.element = element;
	}
	
	/**
	 * λɤ֤ޤ
	 * 
	 * @return    λξ <code>true</code>ʳ <code>false</code>
	 */
	public boolean isEndTag()
	{
		return isEndTag;
	}
	
	/**
	 * ɤ֤ޤ
	 * 
	 * @return    ξ <code>true</code>ʳ <code>false</code>
	 */
	public boolean isEmpty()
	{
		return isEmpty;
	}
	
	/** °Υڥɲ */
	private void addAttribute(String key, String value)
	{
		if (attributes == null)
			attributes = new Hashtable();
		attributes.put(key, value);
	}
	
	/**
	 * °Υڥ֤ޤ
	 * 
	 * @return    °ΥڥĤʤ <code>null</code>
	 */
	public Hashtable getAttribute()
	{
		return attributes;
	}
	
	/**
	 * ʸɽ֤ޤ
	 * 
	 * @return    ʸɽ
	 */
	public String toString()
	{
		return rawData;
	}
	
	/** ٹɲä */
	private void addWarning(String key, int offset)
	{
		if (reporter == null)
			return;
		
		int line = lineNumber, column = columnNumber;
		int length = rawData.length();
		char c;
		
		for (int i = 0; i < offset; i++) {
			c = rawData.charAt(i);
			if (c == 0x0A) {
				line++;
				column = 1;
			} else if (c <= 0xFF || (0xFF61 <= c && c <= 0xFF9F)) {
				column += 1;
			} else {
				column += 2;
			}
		}
		
		reporter.report(Reporter.WARNING,
		                Resource.getMessage(key, null),
		                line,
		                column);
	}
	
	/**
	 * γϹԿ֤ޤ
	 * 
	 * @return    γϹԿ
	 */
	public int getLineNumber()
	{
		return lineNumber;
	}
	
	/**
	 * γϥ֤ޤ
	 * 
	 * @return    γϥ
	 */
	public int getColumnNumber()
	{
		return columnNumber;
	}
}
