/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Reporter;
import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.rendering.Document;
import net.hizlab.kagetaka.util.Environment;

import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;

/**
 * ǡեϤ뤿Υѡ륯饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.3 $
 */
public class ParserManager
{
	private static Hashtable parsers = new Hashtable();
	
	/** Ū */
	static {
		String names = null;
		
		// ꥽꤫Ͽ
		names = Resource.getMessage("parser.list", null);
		if (names != null) {
			StringTokenizer st = new StringTokenizer(names, ",; ");
			while (st.hasMoreTokens())
				addParser(st.nextToken());
		}
		
		// ƥץѥƥϿ
		if (!Environment.isApplet) {
			try {
				names = System.getProperty("net.hizlab.kagetaka.parsers", null);
				if (names != null) {
					StringTokenizer st = new StringTokenizer(names, ",; ");
					while (st.hasMoreTokens())
						addParser(st.nextToken());
				}
			} catch (SecurityException e) {
			}
		}
	}
	
	/** ߡ */
	private ParserManager()
	{
	}
	
	/**
	 * ϿѤߤΥѡ֤ޤ
	 * 
	 * @return    ѡ
	 */
	public static ParserInfo[] getParserList()
	{
		synchronized (parsers) {
			ParserInfo[] list = new ParserInfo[parsers.size()];
			int index = 0;
			for (Enumeration e = parsers.elements(); e.hasMoreElements(); )
				list[index++] = (ParserInfo)e.nextElement();
			return list;
		}
	}
	
	/**
	 * ̾˳ѡ֤ޤ
	 * 
	 * @param     name ѡΥ饹̾
	 * 
	 * @return    ѡ¸ߤʤ <code>null</code>
	 */
	public static ParserInfo getParser(String name)
	{
		ParserInfo pi = (ParserInfo)parsers.get(name);
		if (pi != null)
			return pi;
		
		if (addParser(name))
			return (ParserInfo)parsers.get(name);
		
		return null;
	}
	
	/**
	 * ѡΥ饹̾ꤷơΥѡϿޤ
	 * ɲä륯饹ϡץåȥȥ꡼ѡ
	 * {@link InputStreamParser}ˤե륿ѡ{@link FilterParser}
	 * 饹ǤʤФޤ
	 * 
	 * @param     className ѡΥ饹̾
	 * 
	 * @return    Ͽ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public static boolean addParser(String className)
	{
		try {
			if (parsers.containsKey(className))
				return true;
			
			Parser parser = (Parser)Class.forName(className).newInstance();
			
			// ץåȥȥ꡼ѡǤ⡢ե륿ѡǤ̵̵
			if (!(parser instanceof InputStreamParser) &&
			    !(parser instanceof FilterParser))
				return false;
			
			ParserInfo info = new ParserInfo(className,
			                                 parser.getParserName(),
			                                 parser.getParserDescription(),
			                                 (parser instanceof FilterParser));
			
			parsers.put(className, info);
			
			return true;
		} catch (ClassNotFoundException e) {
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (SecurityException e) {
		} catch (ClassCastException e) {
		}
		return false;
	}
	
	
	/**
	 * ץåȥȥ꡼ѡΥ󥹥󥹤ޤ
	 * <p>
	 * Υ᥽åɤǤϡե륿ѡΥ󥹥󥹤Ϻޤ
	 * ե륿ѡΥ󥹥󥹤ˤϡ
	 * {@link #createInstance(String, Document, Parser, Reporter)} Ѥޤ
	 * 
	 * @param     className ѡΥ饹̾
	 * @param     document ɥȾ
	 * @param     is ϤǡΥץåȥȥ꡼
	 * @param     reporter 顼ݡ
	 * 
	 * @return    ѡΥ󥹥󥹡ʤ <code>null</code>
	 */
	public static InputStreamParser createInstance(String className, Document document, InputStream is, Reporter reporter)
	{
		try {
			InputStreamParser parser = (InputStreamParser)Class.forName(className).newInstance();
			parser.setInputStream(document, is, reporter);
			return parser;
		} catch (ClassNotFoundException e) {
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (SecurityException e) {
		} catch (ClassCastException e) {
		}
		
		return null;
	}
	
	/**
	 * ե륿ѡΥ󥹥󥹤ޤ
	 * <p>
	 * Υ᥽åɤǤϡץåȥȥ꡼ѡΥ󥹥󥹤Ϻޤ
	 * ץåȥȥ꡼ѡΥ󥹥󥹤ˤϡ
	 * {@link #createInstance(String, Document, InputStream, Reporter)} Ѥޤ
	 * 
	 * @param     className ѡΥ饹̾
	 * @param     document ɥȾ
	 * @param     parser ե륿оݤΥѡ
	 * @param     reporter 顼ݡ
	 * 
	 * @return    ѡΥ󥹥󥹡ʤ <code>null</code>
	 */
	public static FilterParser createInstance(String className, Document document, Parser parser, Reporter reporter)
	{
		try {
			FilterParser filter = (FilterParser)Class.forName(className).newInstance();
			filter.setParser(document, parser, reporter);
			return filter;
		} catch (ClassNotFoundException e) {
		} catch (InstantiationException e) {
		} catch (IllegalAccessException e) {
		} catch (SecurityException e) {
		} catch (ClassCastException e) {
		}
		
		return null;
	}
	
//### ParserInfo
	/**
	 * ѡǼ륯饹Ǥ
	 */
	public static class ParserInfo
	{
		private String  className   = null;
		private String  name        = null;
		private String  description = null;
		private boolean filter      = false;
		
		/** 󥹥󥹤ޤ */
		private ParserInfo(String className, String name, String description, boolean filter)
		{
			this.className   = className;
			this.name        = name;
			this.description = description;
			this.filter      = filter;
		}
		
		/**
		 * ѡΥ饹֤̾ޤ
		 * 
		 * @return    ѡΥ饹̾
		 */
		public String getClassName()
		{
			return className;
		}
		
		/**
		 * ѡ֤̾ޤ
		 * 
		 * @return    ѡ̾
		 */
		public String getName()
		{
			return name;
		}
		
		/**
		 * ѡʸ֤ޤ
		 * 
		 * @return    ѡʸ
		 */
		public String getDescription()
		{
			return description;
		}
		
		/**
		 * ե륿ѡɤ֤ޤ
		 * 
		 * @return    ե륿ѡξ <code>true</code>
		 *            ʳξ <code>false</code>
		 */
		public boolean isFilter()
		{
			return filter;
		}
	}
}
