/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

/**
 * ǡȯ̿Ūʥ顼ɽ㳰Ǥ
 * 㳰ȯȡǡβϤǤޤ
 * <p>
 * 顼ΰ֡ʹֹȡ֡ˤݻƤơ
 * 㳰򸵤ˡ桼˥顼ɽޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class ParseException
	extends Exception
{
	/** @serial 顼å */ private String message;
	/** @serial ֹ           */ private int    line;
	/** @serial        */ private int    column;
	
	/**
	 * ϥ顼ޤ
	 * 
	 * @param     message 顼å
	 * @param     line ֹ桢Ԥطʤ <code>0</code>
	 * @param     column ֡बطʤ <code>0</code>
	 */
	public ParseException(String message, int line, int column)
	{
		super(message);
		this.message = message;
		this.line    = line;
		this.column  = column;
	}
	
	/**
	 * ֹ֤ޤ
	 * 
	 * @return    ֹ桢Ԥطʤ <code>0</code>
	 */
	public int getLineNumber()
	{
		return line;
	}
	
	/**
	 * ֤֤ޤ
	 * 
	 * @return    ֡बطʤ <code>0</code>
	 */
	public int getColumnNumber()
	{
		return column;
	}
	
	/**
	 * 㳰ʸɽ֤ޤ
	 * 
	 * @return    㳰ʸɽ
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();
		
		sb.append(line   );
		sb.append(','    );
		sb.append(column );
		sb.append(" : "  );
		if (message != null)
			sb.append(message);
		
		return sb.toString();
	}
	
	/**
	 * 㳰ȡother ƱƤ㳰ɤĴ٤ޤ
	 * 顼μࡢֹ桢֡顼å٤Ʊ硢
	 * <code>true</code> ֤ޤ
	 * 
	 * @param     other Ӥ㳰
	 * 
	 * @return    ƱƤ㳰ξ <code>true</code>
	 *            ʳ <code>false</code>
	 */
	public boolean equals(ParseException other)
	{
		if (other == null) return false;
		return ((this.line   == other.line  ) &&
		        (this.column == other.column) &&
		        ((this .message == null &&
		          other.message == null) ||
		         (this .message != null &&
		          other.message != null &&
		          this .message.compareTo(other.message) == 0)));
	}
}
