/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Reporter;

import net.fclabs.util.Queue;

/**
 * ݡȤ򥭥塼ˤݡ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
class CacheReporter
	implements Reporter
{
	private Reporter reporter    = null;
	private Queue    reportQueue = null;
	private boolean  run         = true;
	
	/**
	 * ݡåѤݡ
	 * 
	 * @param     reporter 顼ݡ
	 */
	CacheReporter(Reporter reporter)
	{
		this.reporter = reporter;
	}
	
	/**
	 * ϥ塼ίᡢʳľܥݡȤޤ
	 * 
	 * @param     level åΥ
	 * @param     message å
	 * @param     line ֹ
	 * @param     column 
	 */
	public synchronized void report(int level, String message, int line, int column)
	{
		if (run) {
			reporter.report(level, message, line, column);
		} else {
			if (reportQueue == null)
				reportQueue = new Queue();
			reportQueue.put(new Report(level, message, line, column));
		}
	}
	
	/** Υå٥֤ */
	public int getLevel()
	{
		return reporter.getLevel();
	}
	
	/**
	 * ݡȤ쥯Ȥ˽Ϥ褦ˤޤ
	 * 
	 * @param     junk ˤޤä塼˴
	 *                 <code>true</code>ʳξ <code>false</code>
	 */
	synchronized void restart(boolean junk)
	{
		this.run = true;
		
		if (!junk) {
			if (reportQueue != null) {
				Report report = null;
				while ((report = (Report)reportQueue.get()) != null)
					reporter.report(report.level, report.message, report.line, report.column);
			}
		}
		reportQueue = null;
	}
	
	/**
	 * ݡȤνϤߤʹߤ줿ݡȤ
	 * 塼ˤ褦ˤޤ
	 */
	synchronized void pause()
	{
		this.run = false;
	}
	
//### Report
	/** ݡȾݻ륯饹 */
	private class Report
	{
		private int    level;
		private String message;
		private int    line;
		private int    column;
		
		/** ꤵ줿ݡȾ */
		private Report(int level, String message, int line, int column)
		{
			this.level   = level;
			this.message = message;
			this.line    = line;
			this.column  = column;
		}
	}
}
