/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.build;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.token.EndToken;
import net.hizlab.kagetaka.token.MiscToken;
import net.hizlab.kagetaka.token.StartToken;
import net.hizlab.kagetaka.token.TextToken;
import net.hizlab.kagetaka.token.Token;
import net.hizlab.kagetaka.token.TokenManager;
import net.hizlab.kagetaka.token.TokenTypes;
import net.fclabs.util.Queue;

import java.io.IOException;

/**
 * ĶʸˤΥӤб뤿Υե륿Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class AozoraFilterParser
	extends FilterParser
{
	private boolean use        = TokenManager.canUseRuby();
	private Queue   tokenQueue = new Queue();   // ĴѤߥȡԤ
	
	/**
	 * ĶʸˤΥӤб뤿Υե륿ޤ
	 */
	public AozoraFilterParser()
	{
	}
	
	/**
	 * ѡ֤̾ޤ
	 * 
	 * @return    ѡ̾
	 */
	public String getParserName()
	{
		return Resource.getMessage("aozorafilter.name", null);
	}
	
	/**
	 * ѡʸ֤ޤ
	 * 
	 * @return    ѡ
	 */
	public String getParserDescription()
	{
		return Resource.getMessage("aozorafilter.description", null);
	}
	
	/**
	 * ǡեϤϰ֤ƬΥȡ֤ޤ
	 * 
	 * @return    Ϥ̤ƬΥȡ
	 *            ȡ¸ߤʤ <code>null</code>
	 * 
	 * @exception ParseException ˥顼ȯ
	 * @exception IOException    IO 顼ȯ
	 */
	public Token next()
		throws ParseException, IOException
	{
		if (!use)
			return parser.next();
		
		Token token = null;
		
		if ((token = (Token)tokenQueue.get()) != null)
			return token;
		
		token = parser.next();
		
		// Ķʸӡ<!R>ʸʥӡˡפ
		if (token instanceof MiscToken && token.getName().compareTo("R") == 0) {
			Token nextToken = null;
			
			RUBY:
			{
				nextToken = parser.next();
				if (nextToken == null)
					break RUBY;
				
				if (!(nextToken instanceof TextToken))
					break RUBY;
				
				String text = ((TextToken)nextToken).getText();
				int start = 0, end = 0;
				if ((start = text.indexOf('')) == -1)
					break RUBY;
				if ((end = text.indexOf('', start)) == -1)
					break RUBY;
				
				String target = text.substring(0, start);
				String ruby   = text.substring(start + 1, end);
				text = text.substring(end + 1);
				
				int lineNumber   = nextToken.getLineNumber  ();
				int columnNumber = nextToken.getColumnNumber();
				
				token = TokenManager.createStartToken(document, reporter, lineNumber, columnNumber, TokenTypes.RUBY_START, true);
				tokenQueue.put(TokenManager.createStartToken(document, reporter, lineNumber, columnNumber, TokenTypes.RB_START, true));
				tokenQueue.put(new TextToken                (document, reporter, lineNumber, columnNumber, target                   ));
				lineNumber = countLine(target, lineNumber); columnNumber = countColumn(target, columnNumber);
				tokenQueue.put(TokenManager.createEndToken  (document, reporter, lineNumber, columnNumber, TokenTypes.RB_END  , true));
				tokenQueue.put(TokenManager.createStartToken(document, reporter, lineNumber, columnNumber, TokenTypes.RP_START, true));
				tokenQueue.put(new TextToken                (document, reporter, lineNumber, columnNumber, ""                     ));
				lineNumber++; columnNumber++;
				tokenQueue.put(TokenManager.createEndToken  (document, reporter, lineNumber, columnNumber, TokenTypes.RP_END  , true));
				tokenQueue.put(TokenManager.createStartToken(document, reporter, lineNumber, columnNumber, TokenTypes.RT_START, true));
				tokenQueue.put(new TextToken                (document, reporter, lineNumber, columnNumber, ruby                     ));
				lineNumber = countLine(ruby, lineNumber); columnNumber = countColumn(ruby, columnNumber);
				tokenQueue.put(TokenManager.createEndToken  (document, reporter, lineNumber, columnNumber, TokenTypes.RT_END  , true));
				tokenQueue.put(TokenManager.createStartToken(document, reporter, lineNumber, columnNumber, TokenTypes.RP_START, true));
				tokenQueue.put(new TextToken                (document, reporter, lineNumber, columnNumber, ""                     ));
				lineNumber++; columnNumber++;
				tokenQueue.put(TokenManager.createEndToken  (document, reporter, lineNumber, columnNumber, TokenTypes.RP_END  , true));
				tokenQueue.put(TokenManager.createEndToken  (document, reporter, lineNumber, columnNumber, TokenTypes.RUBY_END, true));
				tokenQueue.put(new TextToken                (document, reporter, lineNumber, columnNumber, text                     ));
				return token;
			}
			
			if (nextToken != null)
				tokenQueue.put(nextToken);
		}
		
		return token;
	}
	
	/** Ĺ׻ */
	private int countLine(String value, int line)
	{
		for (int i = 0; i < value.length(); i++)
			if (value.charAt(i) == 0x0A)
				line++;
		return line;
	}
	
	/** Ĺ׻ */
	private int countColumn(String value, int column)
	{
		char c;
		for (int i = 0; i < value.length(); i++) {
			c = value.charAt(i);
			if (c == 0x0A)
				column = 1;
			else if (c <= 0xFF || (0xFF61 <= c && c <= 0xFF9F))
				column += 1;
			else
				column += 2;
		}
		return column;
	}
}
