/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.bookmarks;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.awt.DialogBox;
import net.hizlab.kagetaka.awt.InputBox;
import net.hizlab.kagetaka.awt.MessageBox;
import net.hizlab.kagetaka.awt.SizedButton;
import net.hizlab.kagetaka.awt.Tree;
import net.hizlab.kagetaka.awt.TreeItem;

import java.awt.Button;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.net.MalformedURLException;
import java.util.Vector;

/**
 * ֥åޡξܺ٤Ϥ뤿ΥǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Detail
	extends DialogBox
{
	private static final String RESOURCE = "net.hizlab.kagetaka.bookmarks.Resource";
	private static final int    MARGIN   = 3;
	
	/** @serial ʡ */
	private Frame      owner;
	/** @serial ֥åޡޥ͡ */
	private BookmarkManager bm;
	/** @serial ƥ */
	private TextField  text;
	/** @serial URL */
	private TextField  urlText;
	/** @serial URL */
	private TextField  shorCut;
	/** @serial ֥åޡ */
	private Bookmark   bookmark;
	
	/**
	 * ֥åޡξܺ٤ɽη̤֤ޤ
	 * 
	 * @param     owner    ʡ
	 * @param     bm       ֥åޡޥ͡
	 * @param     bookmark ֥åޡ
	 * 
	 * @return    ֥åޡ
	 *            󥻥뤵줿 <code>null</code>
	 */
	public static Bookmark show(Frame owner, BookmarkManager bm, Bookmark bookmark)
	{
		Detail dialog = new Detail(owner, bm);
		
		dialog.setBookmark(bookmark);
		dialog.show();
		
		if (dialog.getResult() != RESULT_OK)
			return null;
		
		return dialog.getBookmark();
	}
	
	/**
	 * ֥åޡξܺ٥ܥåޤ
	 * 
	 * @param     owner ʡ
	 * @param     bm    ֥åޡޥ͡
	 */
	public Detail(Frame owner, BookmarkManager bm)
	{
		super(owner, BUTTON_OKCANCEL);
		setResizable(false);
		setModal    (true );
		this.owner = owner;
		this.bm    = bm;
		
		// ᥤѥͥ
		GridBagLayout gbl    = new GridBagLayout();
		Insets        insets = new Insets(MARGIN, MARGIN, MARGIN, MARGIN);
		mainPanel.setLayout(gbl);
		
		addToPanel(          new Label    (getMessage("label.text"  )), gbl, 0, 0, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST     , insets);
		addToPanel(text    = new TextField(                          ), gbl, 1, 0, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER   , insets);
		addToPanel(          new Label    (getMessage("label.url"   )), gbl, 0, 1, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST     , insets);
		addToPanel(urlText = new TextField(                          ), gbl, 1, 1, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER   , insets);
		addToPanel(          new Label    (getMessage("label.sc"    )), gbl, 0, 2, 1, 1, 0, 0, GridBagConstraints.NONE      , GridBagConstraints.WEST     , insets);
		addToPanel(shorCut = new TextField(                          ), gbl, 1, 2, 2, 1, 1, 0, GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER   , insets);
		
		setSize(380, 100);
		doLayout();
		
		// ֤
		setLocationToCenter();
		
		setBookmark(null);
	}
	
	/** ꥽ʸ */
	private String getMessage(String key)
	{
		if (key == null)
			return "";
		
		return Resource.getMessage(RESOURCE, "detail." + key, null);
	}
	
	/**
	 * ɽޤ
	 */
	public void show()
	{
		text   .setText(bookmark.getText       ());
		urlText.setText(bookmark.getURLText    ());
		shorCut.setText(bookmark.getShortcutURL());
		
		super.show();
	}
	
	/**
	 * ֥åޡ֤ޤ
	 * 
	 * @return    ֥åޡ
	 */
	public synchronized Bookmark getBookmark()
	{
		return bookmark;
	}
	
	/**
	 * ֥åޡꤷޤ
	 * 
	 * @param     bookmark ֥åޡ
	 */
	public synchronized void setBookmark(Bookmark bookmark)
	{
		if (bookmark == null) {
			this.bookmark = new Bookmark("", "");
			setTitle(getMessage("title.new"));
		} else {
			this.bookmark = bookmark;
			setTitle(getMessage("title.edit"));
		}
	}
	
	/** {@inheritDoc} */
	protected boolean dialogClosing(int result)
	{
		if (result == RESULT_OK)
			return saveBookmark();
		
		return true;
	}
	
	/** ̾ξ֥åޡ¸ */
	private boolean saveBookmark()
	{
		if (!bm.changeShortcut(bookmark.getShortcutURL(), shorCut.getText(), bookmark)) {
			MessageBox.show(owner,
			                getMessage("message.invalidsc.text" ),
			                getMessage("message.invalidsc.title"),
			                MessageBox.BUTTON_OK | MessageBox.ICON_EXCLAMATION);
			return false;
		}
		
		bookmark.setText       (text   .getText());
		bookmark.setURLText    (urlText.getText());
		bookmark.setShortcutURL(shorCut.getText());
		
		return true;
	}
}
