/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.FontData;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.TextManager;
import net.hizlab.kagetaka.rendering.Option;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

/**
 * ɽѤΥݡͥȤǤ
 * 
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public abstract class Component
	extends java.awt.Component
{
	private static final Font DEFAULT_FONT = Font.decode("Dialog-plain-12");
	
	/** ̤ξ */
	private static final int NONE         = -1;
	/** ̾ξ */
	public  static final int NORMAL       = 0;
	/** ޥ褿 */
	public  static final int MOUSE_OVER   = 1;
	/** ޥ줿 */
	public  static final int MOUSE_DOWN   = 2;
	/** 줿 */
	public  static final int KEY_DOWN     = 3;
	/** ̵ʾ */
	public  static final int DISABLE      = 4;
	
	/** @serial ץ */
	final Option       option;
	/** @serial ᡼ꥨ */
	final ImageCreator ic;
	
	/** @serial ̾ */
	private String  name;
	/** @serial ̾ꤵ줿ɤ */
	private boolean nameExplicitlySet = false;
	/** @serial ƥȥޥ͡ */
	private TextManager  textManager;
	/** @serial ܡ */
	private Border border;
	
	/** @serial ֥å */
	private Object    stateLock  = new Object();
	/** @serial  */
	private int       stateRequest;
	/** @serial Ρޥξ */
	private int       stateEnable;
	/** @serial ɽƤ */
	private int       statePaint = NONE;
	/** @serial ե */
	private boolean   focusRequest;
	/** @serial ɽƤ֤Υե */
	private boolean   focusPaint = false;
	/** @serial Ū˺ɽ */
	private boolean   repaintForce;
	
	/** @serial 侩 */
	private Dimension preferredSize = new Dimension(0, 0);
	
	/** @serial 줿 X  */
	private int       pressX = -1;
	/** @serial 줿 Y  */
	private int       pressY = -1;
	
	/** @serial ե꡼ */
	private Image     offScreenImage;
	/** @serial ե꡼ */
	private Dimension offScreenSize;
	/** @serial ե꡼󥰥եå */
	private Graphics  offScreenGraphics;
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 */
	public Component(Option option, ImageCreator ic)
	{
		this.option      = option;
		this.ic          = ic;
		this.textManager = new TextManager(option, ic);
		
		addFocusListener(
			new FocusListener()
			{
				/** ե */
				public void focusGained(FocusEvent e)
				{
					if (!focusRequest) {
						focusRequest = true;
						repaint();
					}
				}
				
				/** ե򼺤ä */
				public void focusLost(FocusEvent e)
				{
					boolean repaint = false;
					
					if (focusRequest) {
						focusRequest = false;
						repaint      = true;
					}
					
					setViewState(NORMAL);
					
					if (repaint)
						repaint();
				}
			}
		);
		
		addMouseListener(
			new MouseAdapter()
			{
				/** ޥ줿 */
				public void mousePressed(MouseEvent e)
				{
					if (stateRequest == KEY_DOWN)
						return;
					
					if (isEnabled()) {
						requestFocus();
						e.consume();
					}
					
					if ((e.getModifiers() & InputEvent.BUTTON1_MASK) == 0)
						return;
					
					int x = e.getX();
					int y = e.getY();
					Dimension size = getSize();
					
					if (x < 0 || y < 0 || x >= size.width || y > size.height)
						return;
					
					setViewState(MOUSE_DOWN);
					
					pressX = e.getX();
					pressY = e.getY();
				}
				
				/** ޥ줿 */
				public void mouseReleased(MouseEvent e)
				{
					if (isEnabled())
						e.consume();
					
					if (stateRequest == KEY_DOWN)
						return;
					
					if ((e.getModifiers() & InputEvent.BUTTON1_MASK) == 0)
						return;
					
					int x = e.getX();
					int y = e.getY();
					Dimension size = getSize();
					
					if (x < 0 || y < 0 || x >= size.width || y > size.height)
						setViewState(NORMAL);
					else
						setViewState(MOUSE_OVER);
					
					if (e.getClickCount() > 0 &&
					    x >= 0 && y >= 0 && x < size.width && y < size.height &&
					    (x != pressX || y != pressY)) {
						getToolkit().getSystemEventQueue().postEvent(
							new MouseEvent(e.getComponent(),
							               MouseEvent.MOUSE_CLICKED,
							               e.getWhen(),
							               e.getModifiers(),
							               e.getX(),
							               e.getY(),
							               e.getClickCount(),
							               e.isPopupTrigger()));
					}
				}
				
				/** ޥä */
				public void mouseEntered(MouseEvent e)
				{
					if (stateRequest != KEY_DOWN)
						setViewState(MOUSE_OVER);
				}
				
				/** ޥФ */
				public void mouseExited(MouseEvent e)
				{
					if (stateRequest != KEY_DOWN)
						setViewState(NORMAL);
				}
			}
		);
		
		addMouseMotionListener(
			new MouseMotionAdapter()
			{
				/** ޥɥå줿 */
				public void mouseDragged(MouseEvent e)
				{
					if (isEnabled())
						e.consume();
					
					// ݡͥȾ˥ޥ褿ϡɬ MOUSE_OVER ˤϤʤäƤ
					if (stateRequest != MOUSE_OVER)
						return;
					
					int x = e.getX();
					int y = e.getY();
					Dimension size = getSize();
					
					if (x < 0 || y < 0 || x >= size.width || y > size.height)
						return;
					
					setViewState(MOUSE_DOWN);
				}
				
				/** ޥư줿 */
				public void mouseMoved(MouseEvent e)
				{
					if (isEnabled())
						e.consume();
					
					if (stateRequest != KEY_DOWN)
						setViewState(MOUSE_OVER);
				}
			}
		);
		
		setFont      (DEFAULT_FONT           );
		setForeground(SystemColor.controlText);
		setBackground(SystemColor.control    );
	}
	
	/**
	 * 侩֤ޤ
	 * 
	 * @return    侩
	 */
	public Dimension getPreferredSize()
	{
		return new Dimension(preferredSize);
	}
	
	/**
	 * 侩ꤷޤ
	 * 
	 * @param     width  
	 * @param     height ⤵
	 */
	public void setPreferredSize(int width, int height)
	{
		synchronized (preferredSize) {
			if (preferredSize.width  != width ||
			    preferredSize.height != height) {
				
				preferredSize.width  = width;
				preferredSize.height = height;
				invalidate();
			}
		}
	}
	
	/**
	 * ̤򥢥åץǡȤޤ
	 * 
	 * @param     g եå
	 */
	public void update(Graphics g)
	{
		paint(g);
	}
	
	/**
	 * ᡼ºݤ褷ޤ
	 * 
	 * @param     g եå
	 */
	public void paint(Graphics g)
	{
		Dimension size = getSize();
		
		synchronized (stateLock) {
			// ѹƤϡե꡼ƺ
			if (offScreenImage == null || !size.equals(offScreenSize)) {
				if (offScreenImage != null) {
					offScreenGraphics.dispose();
					offScreenImage   .flush  ();
				}
				
				if (size.width == 0 || size.height == 0) {
					offScreenImage    = null;
					offScreenSize     = null;
					offScreenGraphics = null;
					return;
				} else {
					offScreenImage    = createImage(size.width, size.height);
					offScreenSize     = size;
					offScreenGraphics = offScreenImage.getGraphics();
				}
				statePaint = NONE;
			}
			
			if (offScreenGraphics != null &&
			    (stateRequest != statePaint || focusRequest != focusPaint || repaintForce)) {
				// 
				refresh(offScreenGraphics, size, stateRequest, focusRequest);
				
				// ֤¸
				statePaint   = stateRequest;
				focusPaint   = focusRequest;
				repaintForce = false;
			}
		}
		
		if (offScreenImage != null)
			g.drawImage(offScreenImage, 0, 0, size.width, size.height, this);
	}
	
	/**
	 * ݡͥȤѲǽˤޤ
	 * 
	 * @param     b Ѳǽˤ <code>true</code>
	 *              ԲĤˤ <code>false</code>
	 */
	public void setEnabled(boolean b)
	{
		super.setEnabled(b);
		
		setViewState((b ? stateEnable : DISABLE));
	}
	
	/**
	 * ե뤳Ȥ뤫֤ޤ
	 * 
	 * @return    ΥݡͥȤϥեΤǡ
	 *            <code>true</code> ֤ޤ
	 */
	public boolean isFocusTraversable()
	{
		return true;
	}
	
	/**
	 * ΥݡͥȤΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	protected String paramString()
	{
		String str = super.paramString();
		return str + ",state=" + statePaint;
	}
	
	/**
	 * ݡͥȤ֤̾ޤ
	 * 
	 * @return    ̾
	 */
	public String getName()
	{
		if (name == null && !nameExplicitlySet) {
			synchronized(this) {
				if (name == null && !nameExplicitlySet)
					name = constructComponentName();
			}
		}
		return name;
	}
	
	/**
	 * ݡͥȤ̾ꤷޤ
	 * 
	 * @param     name ̾
	 */
	public void setName(String name)
	{
		synchronized(this) {
			super.setName(name);
			this.name              = name;
			this.nameExplicitlySet = true;
		}
	}
	
	/**
	 * ꤵƤܡ֤ޤ
	 * 
	 * @return    ܡ
	 */
	public Border getBorder()
	{
		return border;
	}
	
	/**
	 * ܡꤷޤ
	 * 
	 * @param     border ܡ
	 */
	public void setBorder(Border border)
	{
		this.border = border;
	}
	
	/**
	 * ݡͥȤΥǥեȤ֤̾ޤ
	 * Υ᥽åɤϡƥ֥饹ǥС饤ɤɬפޤ
	 * 
	 * @return    ǥեȤ̾
	 */
	String constructComponentName()
	{
		return null;
	}
	
	/**
	 * ߤΥơˤä֤ˡե꡼褷ޤ
	 * Υ᥽åɤƤӽФȤϡɬ֤ѹ줿ʤΤǡ
	 * Υ᥽åɤʤɬե꡼褹ɬפޤ
	 * 
	 * @param     g     եå
	 * @param     size  礭
	 * @param     state 
	 * @param     focus եäƤ뤫
	 */
	protected abstract void refresh(Graphics g, Dimension size,
	                                int state, boolean focus);
	
	/**
	 * ߤɽ֤֤ޤ
	 * 
	 * @return    ߤξ
	 */
	protected int getViewState()
	{
		return stateRequest;
	}
	
	/**
	 * ɽ֤ѹޤ
	 * 
	 * @param     state 
	 */
	protected void setViewState(int state)
	{
		synchronized (stateLock) {
			// DISABLE ʳ׵ξϡͭξ֤Ȥ¸
			if (state != DISABLE)
				stateEnable = state;
			
			// ݡͥȤ̵ξϡɬ DISABLE ˤ
			if (!isEnabled())
				state = DISABLE;
			
			if (stateRequest != state) {
				stateRequest = state;
				
				// ɽƤϺ
				if (isVisible()) {
					Graphics g = getGraphics();
					if (g != null)
						try {
							update(g);
						} finally {
							g.dispose();
						}
					else
						repaint();
				}
			}
		}
	}
	
	/**
	 * Ū˺ɽޤ
	 */
	protected void repaintForce()
	{
		synchronized (stateLock) {
			repaintForce = true;
		}
		repaint();
	}
	
	/**
	 * Ľɽѥǡޤ
	 * 
	 * @param     text ʸ
	 * 
	 * @return    Ľɽѥǡ
	 * 
	 * @exception IllegalStateException ΥݡͥȤǤƤʤˡ
	 *                                  ɽѥǡʤ
	 */
	protected Text getText(String text)
	{
		return textManager.getText(FontData.getInstance(ic, getFont()), text);
	}
}
