/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.MemoryImageSource;
import java.util.Vector;

/**
 * ɽΥܥܥåǤ
 * 
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Choice
	extends Component
{
	private static final String BASE        = "choice";
	private static       int    nameCounter = 0;
	
	private static final int   INSET_H        = 2;
	private static final int   INSET_V        = 2;
	private static final int   INSET_A        = 2;
	private static final int   INSET_S        = 3;
	
	private static final int ARROW_WIDTH  = 11;
	private static final int ARROW_HEIGHT = 12;
	
	private static final int[] ARROW_ALLOW =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	/** @serial 򤵤Ƥ륤ǥå */
	private int     index  = -1;
	/** @serial ٥ʸ */
	private Vector  values = new Vector();
	/** @serial ƥ */
	private Vector  texts  = new Vector();
	/** @serial ꥹ */
	private List    list;
	/** @serial ϥɥƤ뤫 */
	private boolean openWindow;
	/** @serial ǸϥɥĤ */
	private long    lastClose;
	/** @serial ʸƷɬפ뤫 */
	private boolean resetText = true;
	
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 */
	public Choice(Option option, ImageCreator ic)
	{
		super(option, ic);
		
		addKeyListener(
			new KeyAdapter()
			{
				/** 줿 */
				public void keyPressed(KeyEvent e)
				{
					if (!isEnabled())
						return;
					
					switch (e.getKeyCode()) {
					case KeyEvent.VK_LEFT:
					case KeyEvent.VK_DOWN:
						e.consume();
						if ((e.getModifiers() & InputEvent.ALT_MASK) != 0) {
							showItemList();
							return;
						}
						
						synchronized (Choice.this) {
							if (index + 1 >= values.size())
								return;
							
							index++;
						}
						repaintForce();
						break;
					case KeyEvent.VK_RIGHT:
					case KeyEvent.VK_UP:
						e.consume();
						if ((e.getModifiers() & InputEvent.ALT_MASK) != 0) {
							showItemList();
							return;
						}
						
						synchronized (Choice.this) {
							if (index <= 0)
								return;
							
							index--;
						}
						repaintForce();
						break;
					case KeyEvent.VK_SPACE:
						e.consume();
						break;
					}
				}
			}
		);
		
		addMouseListener(
			new MouseAdapter()
			{
				/** ޥ줿 */
				public void mousePressed(MouseEvent e)
				{
					if (!isEnabled())
						return;
					
					e.consume();
					
					if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0)
						showItemList();
				}
			}
		);
		
		setForeground(SystemColor.textText);
		if (Environment.javaVersion < 102)
			setBackground(SystemColor.window  );
		else
			setBackground(SystemColor.text    );
	}
	
	/**
	 * 侩֤ޤ
	 * 
	 * @return    侩
	 */
	public Dimension getPreferredSize()
	{
		synchronized (this) {
			if (resetText)
				resetText();
		}
		return super.getPreferredSize();
	}
	
	/**
	 * ΥܥܥåΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	protected String paramString()
	{
		String str = super.paramString();
		return str + ",current=" + getSelectedItem();
	}
	
	/** ݡͥȤΥǥեȤ֤̾ */
	String constructComponentName()
	{
		return BASE + nameCounter++;
	}
	
	/** ߤΥơˤä֤˺ */
	protected void refresh(Graphics g, Dimension size, int state, boolean focus)
	{
		Color fg = getForeground();
		Color bg = getBackground();
		
		// ƥȤ
		Text text = null;
		synchronized (this) {
			if (resetText)
				resetText();
			
			if (index != -1 && index < texts.size())
				text = (Text)texts.elementAt(index);
		}
		
		// طʿɤ
		g.setColor(bg);
		g.fillRect(0, 0, size.width, size.height);
		
		// եѤ
		int x = INSET_H + 1;
		int y = INSET_V + 1;
		int w = size.width  - INSET_H * 2 - 2;
		int h = size.height - INSET_V * 2 - INSET_A * 2 - ARROW_HEIGHT - 2;
		
		Color color = fg;
		if (focus) {
			g.setColor(SystemColor.textHighlight);
			g.fillRect(x, y, w, h);
			g.setColor(SystemColor.textHighlightText);
		} else {
			if (state == DISABLE)
				color = new Color((new GrayFilter(bg)).filterRGB(0, 0, color.getRGB()));
			g.setColor(color);
		}
		
		// ٥
		if (text != null) {
			g.setFont(getFont());
			text.draw(g, size.width - INSET_H - INSET_S, INSET_V + INSET_S, 0);
		}
		
		// եȤɽ
		if (focus) {
			GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
			GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
			GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
			GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
		}
		
		// Ȥ
		Border border = getBorder();
		if (border != null) {
			border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
		} else {
			g.setColor(SystemColor.controlShadow);
			g.drawLine(0, 0, size.width - 1,  0);
			g.drawLine(0, 0, 0, size.height - 1);
			g.setColor(SystemColor.controlDkShadow);
			g.drawLine(1, 1, size.width - 2,  1);
			g.drawLine(1, 1, 1, size.height - 2);
			g.setColor(SystemColor.controlHighlight);
			g.drawLine(size.width - 2,  2, size.width - 2, size.height - 2);
			g.drawLine(2, size.height - 2, size.width - 2, size.height - 2);
			g.setColor(SystemColor.controlLtHighlight);
			g.drawLine(size.width - 1,  1, size.width - 1, size.height - 1);
			g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
		}
		
		// ɥåװ
		{
			int x1 = INSET_H;
			int y1 = size.height - INSET_V - ARROW_HEIGHT - INSET_A * 2;
			int x2 = size.width - INSET_H - 1;
			int y2 = y1 + ARROW_HEIGHT + INSET_A * 2 - 1;
			
			g.setColor(SystemColor.control);
			g.fillRect(x1 + INSET_A, y1 + INSET_A, x2 - x1 + 1 - INSET_A * 2, y2 - y1 + 1 - INSET_A * 2);
			g.setColor(SystemColor.controlHighlight);
			g.drawLine(x1, y1, x2, y1);
			g.drawLine(x1, y1, x1, y2);
			g.setColor(SystemColor.controlLtHighlight);
			g.drawLine(x1 + 1, y1 + 1, x2 - 1, y1 + 1);
			g.drawLine(x1 + 1, y1 + 1, x1 + 1, y2 - 1);
			g.setColor(SystemColor.controlShadow);
			g.drawLine(x2 - 1, y1 + 1, x2 - 1, y2 - 1);
			g.drawLine(x1 + 1, y2 - 1, x2 - 1, y2 - 1);
			g.setColor(SystemColor.controlDkShadow);
			g.drawLine(x2, y1, x2, y2);
			g.drawLine(x1, y2, x2, y2);
			
			drawArray(g, ARROW_ALLOW,
			          (size.width - ARROW_WIDTH) / 2,
			          y1 + INSET_A,
			          ARROW_WIDTH, ARROW_HEIGHT, color);
		}
	}
	
	/**
	 *  Choice ˹ܤɲäޤ
	 * 
	 * @param     item ɲä
	 */
	public synchronized void add(String item)
	{
		addItem(item);
	}
	
	/**
	 *  Choice ˹ܤɲäޤ
	 * 
	 * @param     item ɲä
	 */
	public synchronized void addItem(String item)
	{
		this.resetText = true;
		
		values.addElement(item);
		texts .addElement(null);
		
		if (list != null)
			list.addItem(item);
	}
	
	/**
	 *  Choice λꤵ줿֤˹ܤɲäޤ
	 * 
	 * @param     item  ɲä
	 * @param     index ɲä
	 */
	public synchronized void insert(String item, int index)
	{
		this.resetText = true;
		
		values.insertElementAt(item, index);
		texts .insertElementAt(null, index);
		
		if (list != null)
			list.addItem(item, index);
	}
	
	/**
	 * Choice λꤵ줿źʸ֤ޤ
	 * 
	 * @param     index ܤź
	 * 
	 * @return    ʸ
	 */
	public String getItem(int index)
	{
		return (String)values.elementAt(index);
	}
	
	/**
	 *  Choice ꤷܤޤ
	 * 
	 * @param     index ܤź
	 */
	public synchronized void remove(int index)
	{
		values.removeElementAt(index);
		texts .removeElementAt(index);
		
		if (index == this.index)
			select(-1);
		
		if (list != null)
			list.remove(index);
	}
	
	/**
	 *  Choice ꤷܤޤ
	 * 
	 * @param     item ܤʸ
	 */
	public synchronized void remove(String item)
	{
		int index = values.indexOf(item);
		if (index == -1)
			return;
		
		remove(index);
	}
	
	/**
	 *  Choice 餹٤Ƥιܤޤ
	 */
	public synchronized void removeAll()
	{
		values.removeAllElements();
		texts .removeAllElements();
		
		index = -1;
		repaintForce();
		
		if (list != null)
			list.removeAll();
	}
	
	/**
	 *  Choice ι֤ܿޤ
	 * 
	 * @return    ܿ
	 */
	public int getItemCount()
	{
		return values.size();
	}
	
	/**
	 * 򤵤Ƥܤź֤ޤ
	 * 
	 * @return    ιܤź
	 */
	public synchronized int getSelectedIndex()
	{
		return index;
	}
	
	/**
	 * 򤵤Ƥܤʸ֤ޤ
	 * 
	 * @return    ιܤʸ
	 */
	public synchronized String getSelectedItem()
	{
		if (index == -1)
			return null;
		
		return getItem(index);
	}
	
	/**
	 * ꤵ줿֤ιܤ򤷤ޤ
	 * 
	 * @param     index ܤΰ
	 * 
	 * @exception IllegalArgumentException ܤΰ̵֤ξ
	 */
	public synchronized void select(int index)
	{
		if (this.index == index)
			return;
		
		this.index = index;
		
		if (isVisible() && values.size() > 0)
			repaintForce();
	}
	
	/**
	 * ꤵ줿ܤ򤷤ޤ
	 * 
	 * @param     item 򤹤
	 */
	public synchronized void select(String item)
	{
		int index = values.indexOf(item);
		if (index == -1)
			return;
		
		select(index);
	}
	
	/** ɽѥǡޤ */
	private void resetText()
	{
		this.resetText = false;
		
		String    value;
		Text      text;
		Dimension size;
		int w = ARROW_WIDTH, h = 0;
		
		for (int i = values.size() - 1; i >= 0; i--) {
			value = (String)values.elementAt(i);
			text  = (Text  )texts .elementAt(i);
			
			if (value != null && text == null) {
				try {
					text = super.getText(value);
					texts.setElementAt(text, i);
				} catch (IllegalStateException e) {}
			}
			
			if (text != null) {
				size = text.getSize(0);
				w = Math.max(w, size.width );
				h = Math.max(h, size.height);
			}
		}
		
		// Ǿͤ
		try {
			size = super.getText("y").getSize(0);
			w = Math.max(w, size.width );
			h = Math.max(h, size.height);
		} catch (IllegalStateException e) {}
		
		setPreferredSize(w + INSET_H * 2 + INSET_S * 2,
		                 h + INSET_V * 2 + INSET_S * 2 + INSET_A * 2 + ARROW_HEIGHT);
	}
	
	/** 󤫤 */
	private void drawArray(Graphics g, int[] base,
	                       int x, int y, int width, int height, Color color)
	{
		int fg = color.getRGB() | 0xff000000;
		int bg = 0;
		int[] buffer = new int[base.length];
		
		for (int i = 0; i < buffer.length; i++)
			if (base[i] == 1)
				buffer[i] = fg;
			else
				buffer[i] = bg;
		
		MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
		mis.setAnimated(false);
		Image image = getToolkit().createImage(mis);
		
		SyncObserver so = new SyncObserver();
		synchronized (so) {
			so.init(g, x, y, width, height);
			if (!g.drawImage(image, x, y, width, height, so)) {
				try {
					so.wait(10000);
				} catch (InterruptedException e) {
					System.out.println("wait to draw a icon");
				}
			}
		}
	}
	
	/** ѤΥɥ򳫤 */
	private void showItemList()
	{
		synchronized (this) {
			if (openWindow || lastClose + 200 > System.currentTimeMillis())
				return;
			openWindow = true;
			lastClose  = 0;
		}
		
		Container parent = this.getParent();
		while (!(parent instanceof Frame)) {
			if ((parent = parent.getParent()) == null) {
				openWindow = false;
				return;
			}
		}
		
		ListWindow listWindow = new ListWindow((Frame)parent);
		
		Point      point = getLocationOnScreen();
		Dimension  size  = listWindow.getSize();
		listWindow.setLocation(point.x - size.width, point.y + 3);
		listWindow.show();
		this.list.requestFocus();
		listWindow.toFront();
	}
	
//### ItemList
	/** ƥꥹ */
	private class ListWindow
		extends Window
	{
		private Frame             parent;
		private MouseListener     mouseListener;
		private ComponentListener componentListener;
		private boolean isClosed;
		
		/** ƥꥹȤ */
		private ListWindow(Frame parent)
		{
			super(parent);
			this.parent = parent;
			
			synchronized (Choice.this) {
				list = new List(option, ic, 10, false, false);
				int size = values.size();
				for (int i = 0; i < size; i++)
					list.addItem((String)values.elementAt(i));
				list.select(index);
			}
			add(list);
			
			pack();
			
			// ꥹʤϿ
			addWindowListener(
				new WindowAdapter()
				{
					/** ƥ֤ǤϤʤʤä */
					public void windowDeactivated(WindowEvent e)
					{
						removeWindowListener(this);
						close(false);
					}
				}
			);
			list.addFocusListener(
				new FocusAdapter()
				{
					/** ե򼺤ä */
					public void focusLost(FocusEvent e)
					{
						close(false);
					}
				}
			);
			list.addKeyListener(
				new KeyAdapter()
				{
					/** 줿 */
					public void keyPressed(KeyEvent e)
					{
						switch (e.getKeyCode()) {
						case KeyEvent.VK_ESCAPE:
							e.consume();
							close(false);
							break;
						case KeyEvent.VK_ENTER:
							e.consume();
							close(true);
							break;
						}
					}
				}
			);
			list.addMouseListener(
				new MouseAdapter()
				{
					/** ޥå줿 */
					public void mouseClicked(MouseEvent e)
					{
						e.consume();
						
						if (list.containsScrollbar(e.getX(), e.getY()))
							return;
						
						close(true);
					}
				}
			);
			
			parent.addMouseListener(
				mouseListener = new MouseAdapter()
				{
					/** ޥ줿 */
					public void mousePressed(MouseEvent e)
					{
						close(false);
					}
				}
			);
			parent.addComponentListener(
				componentListener = new ComponentAdapter()
				{
					/** ѹ줿 */
					public void componentResized(ComponentEvent e)
					{
						close(false);
					}
					
					/** ư줿 */
					public void componentMoved(ComponentEvent e)
					{
						close(false);
					}
				}
			);
		}
		
		/** Ĥ */
		private void close(boolean commit)
		{
			synchronized (this) {
				if (isClosed)
					return;
				isClosed = true;
			}
			
			if (commit)
				select(list.getSelectedIndex());
			
			lastClose  = System.currentTimeMillis();
			openWindow = false;
			
			dispose();
		}
		
		/**  */
		public void update(Graphics g)
		{
			paint(g);
		}
		
		/** ˴ */
		public void dispose()
		{
			super.dispose();
			parent.removeMouseListener    (mouseListener    );
			parent.removeComponentListener(componentListener);
		}
	}
}
