/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.tate;

import net.hizlab.kagetaka.awt.Border;
import net.hizlab.kagetaka.awt.GraphicsUtils;
import net.hizlab.kagetaka.awt.ImageCreator;
import net.hizlab.kagetaka.awt.Text;
import net.hizlab.kagetaka.awt.image.GrayFilter;
import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.rendering.Option;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.SystemColor;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.MemoryImageSource;

/**
 * ɽΥåܥåǤ
 * 
 * @kagetaka.bugs ľ󲽤ϡꥹʤ¸ʤޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Checkbox
	extends Component
{
	private static final String BASE        = "checkbox";
	private static       int    nameCounter = 0;
	
	private static final int   INSET_H      = 3;
	private static final int   INSET_V      = 3;
	private static final int   INSET_S      = 5;
	
	private static final int CHECK_WIDTH  = 14;
	private static final int CHECK_HEIGHT = 14;
	
	private static final int[] CHECK_CHECK =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, 0, 0,
		0, 0, 0, 1, 0, 0, 0, 0, 1, 1, 1, 0, 0, 0,
		0, 0, 0, 1, 1, 0, 0, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 1, 1, 1, 0, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	private static final int RADIO_WIDTH  = 12;
	private static final int RADIO_HEIGHT = 12;
	
	private static final int[] RADIO_FRAME1 =
	{
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	private static final int[] RADIO_FRAME2 =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
		0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	private static final int[] RADIO_FRAME3 =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0,
		0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	private static final int[] RADIO_FRAME4 =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0,
		0, 0, 1, 1, 0, 0, 0, 0, 1, 1, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
	};
	
	private static final int[] RADIO_BACK =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
		0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0,
		0, 0, 0, 1, 1, 1, 1, 1, 1, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	private static final int[] RADIO_CHECK =
	{
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 1, 1, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
		0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
	};
	
	/** @serial طʿ */
	private Color   iconColor;
	/** @serial طʿ */
	private Image   backImage;
	/** @serial ٥ʸ */
	private String  label;
	/** @serial ƥ */
	private Text    text;
	/** @serial å줿 */
	private boolean state;
	/** @serial åܥå롼 */
	CheckboxGroup group;
	/** @serial ʸƷɬפ뤫 */
	private boolean resetText = true;
	
	/**
	 * Υ٥Υåܥåۤޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 */
	public Checkbox(Option option, ImageCreator ic)
	{
		this(option, ic, null, false, null);
	}
	
	/**
	 * ꤵ줿٥ɽ롢åܥåޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 * @param     label  åܥåΥ٥
	 */
	public Checkbox(Option option, ImageCreator ic, String label)
	{
		this(option, ic, label, false, null);
	}
	
	/**
	 * ꤵ줿֤ǡꤵ줿٥뤬դåܥåۤޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 * @param     label  åܥåΥ٥
	 * @param     state  å <code>true</code>
	 *                   ʳξ <code>false</code>
	 */
	public Checkbox(Option option, ImageCreator ic, String label, boolean state)
	{
		this(option, ic, label, state, null);
	}
	
	/**
	 * ꤵ줿åܥå롼ˡꤵ줿֤ǡ
	 * ꤵ줿٥뤬դåܥåۤޤ
	 * 
	 * @param     option ץ
	 * @param     ic     ᡼ꥨ
	 * @param     label  åܥåΥ٥
	 * @param     state  å <code>true</code>
	 *                   ʳξ <code>false</code>
	 * @param     group  åܥå롼
	 */
	public Checkbox(Option option, ImageCreator ic,
	                String label, boolean state, CheckboxGroup group)
	{
		super(option, ic);
		setLabel(label);
		setState(state);
		setCheckboxGroup(group);
		
		addKeyListener(
			new KeyAdapter()
			{
				/** 줿 */
				public void keyPressed(KeyEvent e)
				{
					if (!isEnabled())
						return;
					
					switch (e.getKeyCode()) {
					case KeyEvent.VK_SPACE:
						e.consume();
						setViewState(KEY_DOWN);
						break;
					}
				}
				
				/** Υ줿 */
				public void keyReleased(KeyEvent e)
				{
					if (!isEnabled())
						return;
					
					switch (e.getKeyCode()) {
					case KeyEvent.VK_SPACE:
						e.consume();
						if (getViewState() == KEY_DOWN) {
							setViewState(NORMAL);
							if (isEnabled()) {
								synchronized (Checkbox.this) {
									setState((Checkbox.this.group == null ? !Checkbox.this.state : true));
								}
							}
						}
						break;
					}
				}
			}
		);
		
		addMouseListener(
			new MouseAdapter()
			{
				/** ޥå줿 */
				public void mouseClicked(MouseEvent e)
				{
					if (!isEnabled())
						return;
					
					e.consume();
					
					if ((e.getModifiers() & InputEvent.BUTTON1_MASK) != 0) {
						synchronized (Checkbox.this) {
							setState((Checkbox.this.group == null ? !Checkbox.this.state : true));
						}
					}
				}
			}
		);
		
		if (Environment.javaVersion < 102)
			setIconcolor(SystemColor.window  );
		else
			setIconcolor(SystemColor.text    );
	}
	
	/**
	 * 侩֤ޤ
	 * 
	 * @return    侩
	 */
	public Dimension getPreferredSize()
	{
		synchronized (this) {
			if (resetText)
				resetText();
		}
		return super.getPreferredSize();
	}
	
	/**
	 * ΥåܥåΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	protected String paramString()
	{
		String str = super.paramString();
		String label = this.label;
		if (label != null)
			str += ",label=" + label;
		return str + ",state=" + state;
	}
	
	/** ݡͥȤΥǥեȤ֤̾ */
	String constructComponentName()
	{
		return BASE + nameCounter++;
	}
	
	/** ߤΥơˤä֤˺ */
	protected void refresh(Graphics g, Dimension size, int state, boolean focus)
	{
		Color fg = getForeground();
		Color bg = getBackground();
		
		// ƥȤ
		Text    text     = null;
		boolean checkBox = true;
		boolean checked  = false;
		synchronized (this) {
			if (resetText)
				resetText();
			
			text     = this.text;
			checkBox = (group == null);
			checked  = this.state;
		}
		
		// طʿɤ
		if (backImage != null) {
			SyncObserver so = new SyncObserver();
			synchronized (so) {
				so.init(g, 0, 0, size.width, size.height);
				if (!g.drawImage(backImage, 0, 0, size.width, size.height, so)) {
					try {
						so.wait(10000);
					} catch (InterruptedException e) {
						System.out.println("wait to draw a backimage");
					}
				}
			}
		} else {
			g.setColor(bg);
			g.fillRect(0, 0, size.width, size.height);
		}
		
		// ܥ
		if (checkBox) {
			int x = (size.width - CHECK_WIDTH) / 2;
			int y = (text != null ? INSET_V : 1);
			
			g.setColor(SystemColor.controlShadow);
			g.drawLine(x, y, x + CHECK_WIDTH - 2,  y);
			g.drawLine(x, y, x, y + CHECK_HEIGHT - 2);
			g.setColor(SystemColor.controlDkShadow);
			g.drawLine(x + 1, y + 1, x + CHECK_WIDTH - 3,  y + 1);
			g.drawLine(x + 1, y + 1, x + 1, y + CHECK_HEIGHT - 3);
			g.setColor(SystemColor.controlHighlight);
			g.drawLine(x + CHECK_WIDTH - 2,  y + 1, x + CHECK_WIDTH - 2, y + CHECK_HEIGHT - 2);
			g.drawLine(x + 1, y + CHECK_HEIGHT - 2, x + CHECK_WIDTH - 2, y + CHECK_HEIGHT - 2);
			g.setColor(SystemColor.controlLtHighlight);
			g.drawLine(x + CHECK_WIDTH - 1,  y, x + CHECK_WIDTH - 1, y + CHECK_HEIGHT - 1);
			g.drawLine(x, y + CHECK_HEIGHT - 1, x + CHECK_WIDTH - 1, y + CHECK_HEIGHT - 1);
			g.setColor((state == MOUSE_DOWN || state == KEY_DOWN || state == DISABLE ? SystemColor.controlHighlight : iconColor));
			g.fillRect(x + 2, y + 2, CHECK_WIDTH - 4, CHECK_HEIGHT - 4);
			if (checked)
				drawArray(g, CHECK_CHECK, new int[CHECK_WIDTH * CHECK_HEIGHT], x, y, CHECK_WIDTH, CHECK_HEIGHT, fg);
		} else {
			int[] buffer = new int[RADIO_WIDTH * RADIO_HEIGHT];
			int x = (size.width - RADIO_WIDTH) / 2;
			int y = (text != null ? INSET_V : 1);
			Color c = null;
			
			drawArray(g, RADIO_FRAME1, buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT, SystemColor.controlShadow     );
			drawArray(g, RADIO_FRAME2, buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT, SystemColor.controlDkShadow   );
			drawArray(g, RADIO_FRAME3, buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT, SystemColor.controlHighlight  );
			drawArray(g, RADIO_FRAME4, buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT, SystemColor.controlLtHighlight);
			drawArray(g, RADIO_BACK  , buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT,
			          (state == MOUSE_DOWN || state == KEY_DOWN || state == DISABLE ? SystemColor.controlHighlight : iconColor));
			if (checked)
				drawArray(g, RADIO_CHECK, buffer, x, y, RADIO_WIDTH, RADIO_HEIGHT, fg);
		}
		
		// ٥
		if (text != null) {
			Color color = fg;
			if (state == DISABLE)
				color = new Color((new GrayFilter(bg)).filterRGB(0, 0, color.getRGB()));
			g.setColor(color    );
			g.setFont (getFont());
			text.draw(g, size.width - INSET_H, INSET_V + INSET_S + (checkBox ? CHECK_HEIGHT : RADIO_HEIGHT), 0);
		}
		
		// Ȥ
		Border border = getBorder();
		if (border != null) {
			border.draw(g, 0, 0, size.width - 1, size.height - 1, fg);
		}
		
		// եȤɽ
		if (focus) {
			g.setColor(fg);
			int w = 0, h = 0;
			if (checkBox) {
				w = CHECK_WIDTH  + 2;
				h = CHECK_HEIGHT + 2;
			} else {
				w = RADIO_WIDTH  + 2;
				h = RADIO_HEIGHT + 2;
			}
			
			int x = (size.width - w) / 2;
			int y = (text != null ? INSET_V - 1 : 0);
			
			GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
			GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
			GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
			GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
			
			if (text != null) {
				x = 1;
				y = h - 2 + INSET_V + INSET_S - 2;
				w = size.width - 2;
				h = size.height - y - 1;
				GraphicsUtils.drawDashed(g, x, y, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
				GraphicsUtils.drawDashed(g, x, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
				GraphicsUtils.drawDashed(g, x, y + h - 1, w, 1, 1, 1, GraphicsUtils.HORIZONTAL);
				GraphicsUtils.drawDashed(g, x + w - 1, y, 1, h, 1, 1, GraphicsUtils.VERTICAL  );
			}
		}
	}
	
	/**
	 * طʿ֤ޤ
	 * 
	 * @return    طʿ
	 */
	public Color getIconcolor()
	{
		return iconColor;
	}
	
	/**
	 * طʿꤷޤ
	 * 
	 * @param     c طʿ
	 */
	public synchronized void setIconcolor(Color c)
	{
		this.iconColor = c;
	}
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     image ᡼
	 */
	public synchronized void setBackground(Image image)
	{
		this.backImage = image;
	}
	
	/**
	 * ܥɽ٥֤ޤ
	 * 
	 * @return    ܥΥ٥
	 */
	public String getLabel()
	{
		return label;
	}
	
	/**
	 * ܥɽ٥ꤷޤ
	 * 
	 * @param     label ܥΥ٥
	 */
	public synchronized void setLabel(String label)
	{
		if ((this.label == label) ||
		    (this.label != null && label != null && this.label.compareTo(label) == 0))
			return;
		
		this.label     = label;
		this.text      = null;
		this.resetText = true;
		
		if (isVisible())
			repaintForce();
	}
	
	/**
	 * ֤֤ޤ
	 * 
	 * @return    
	 */
	public boolean getState()
	{
		return state;
	}
	
	/**
	 * ֤ꤷޤ
	 * 
	 * @param     state 
	 */
	public synchronized void setState(boolean state)
	{
		if (this.state == state)
			return;
		
		CheckboxGroup group = this.group;
		if (group != null) {
			if (state)
				group.setSelectedCheckbox(this);
			else if (group.getSelectedCheckbox() == this)
				group.selectedCheckbox = null;
		}
		setStateInternal(state);
	}
	
	/**
	 * åܥå롼פꤷޤ
	 * 
	 * @return    åܥå롼
	 */
	public CheckboxGroup getCheckboxGroup()
	{
		return group;
	}
	
	/**
	 * åܥå롼פꤷޤ
	 * 
	 * @param     g åܥå롼
	 */
	public void setCheckboxGroup(CheckboxGroup g)
	{
		CheckboxGroup group = null;
		boolean       state = false;
		synchronized (this) {
			group = this.group;
			state = this.state;
		}
		
		if (group != null && state)
			group.setSelectedCheckbox(null);
		
		synchronized (this) {
			this.group = g;
			if (this.state && g != null)
				g.setSelectedCheckbox(this);
		}
	}
	
	/** ɽѥǡޤ */
	private void resetText()
	{
		this.resetText = false;
		this.text      = null;
		
		int w = 0, h = 0;
		if (group == null) {
			w = CHECK_WIDTH;
			h = CHECK_HEIGHT;
		} else {
			w = RADIO_WIDTH;
			h = RADIO_HEIGHT;
		}
		
		if (label != null) {
			try {
				this.text = getText(label);
				Dimension size = text.getSize(0);
				setPreferredSize(Math.max(w + 2, size.width + INSET_H * 2),
				                 h + size.height + INSET_V * 2 + INSET_S);
			} catch (IllegalStateException e) {}
		} else {
			setPreferredSize(w + 2, h + 2);
		}
	}
	
	/** 󤫤 */
	private void drawArray(Graphics g, int[] base, int[] buffer,
	                       int x, int y, int width, int height, Color color)
	{
		int fg = color.getRGB() | 0xff000000;
		int bg = 0;
		
		for (int i = 0; i < buffer.length; i++)
			if (base[i] == 1)
				buffer[i] = fg;
			else
				buffer[i] = bg;
		
		MemoryImageSource mis = new MemoryImageSource(width, height, buffer, 0, width);
		mis.setAnimated(false);
		Image image = getToolkit().createImage(mis);
		
		SyncObserver so = new SyncObserver();
		synchronized (so) {
			so.init(g, x, y, width, height);
			if (!g.drawImage(image, x, y, width, height, so)) {
				try {
					so.wait(10000);
				} catch (InterruptedException e) {
					System.out.println("wait to draw a icon");
				}
			}
		}
	}
	
	/** ֤ */
	void setStateInternal(boolean state)
	{
		synchronized (this) {
			if (this.state == state)
				return;
			
			this.state = state;
		}
		repaintForce();
	}
}
