/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;

/**
 * ᡼ιƱ뤿Υ饹Ǥ
 * <p>
 * <pre>
 *   SyncObserver so = new SyncObserver();
 *   synchronized (so) {
 *     so.init(g, x, y, width, height);
 *     if (!g.drawImage(image, x, y, width, height, so)) {
 *       try {
 *         so.wait(10000);
 *       } catch (InterruptedException e) {
 *         System.out.println("wait to draw a image");
 *       }
 *     }
 *   }
 * </pre>
 * <p>
 * Τ褦ˤ뤳Ȥǡºݤ褵ΤƱ뤳Ȥޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class SyncObserver
	implements ImageObserver
{
	private Graphics  g;
	private int       x;
	private int       y;
	private int       width;
	private int       height;
	
	/**
	 * Ʊ륪֥Фޤ
	 */
	public SyncObserver()
	{
	}
	
	/**
	 * ͤꤷޤ
	 * 
	 * @param     g եå
	 * @param     x X
	 * @param     y Y
	 * @param     width  
	 * @param     height ⤵
	 */
	public synchronized void init(Graphics g, int x, int y, int width, int height)
	{
		this.g      = g;
		this.x      = x;
		this.y      = y;
		this.width  = width;
		this.height = height;
	}
	
	/**
	 * ᡼ΤФԤޤ
	 * 
	 * @see       ImageObserver#imageUpdate(Image, int, int, int, int, int)
	 */
	public synchronized boolean imageUpdate(Image img, int infoflags,
	                                        int x, int y, int width, int height)
	{
		// 顼λ
		if ((infoflags & (ImageObserver.ABORT | ImageObserver.ERROR)) != 0) {
			notify();
			return false;
		}
		
		// 
		if ((infoflags & (ImageObserver.FRAMEBITS | ImageObserver.ALLBITS)) != 0) {
			if (g != null)
				g.drawImage(img, this.x, this.y, this.width, this.height, this);
			notify();
		}
		
		return ((infoflags & (ImageObserver.ALLBITS | ImageObserver.ABORT | ImageObserver.ERROR)) == 0);
	}
}
