/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.ImageFilter;

/**
 * 򱦤 90 ٲžե륿
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class RotateFilter
	extends ImageFilter
{
	private static ColorModel defaultColorModel = ColorModel.getRGBdefault();
	
	private int raster[];
	private int srcWidth;
	private int srcHeight;
	
	/**
	 * 򱦤 90 ٲžե륿ޤ
	 */
	public RotateFilter()
	{
	}
	
	/**
	 * žΥѴޤ
	 * 
	 * @param     width  
	 * @param     height ⤵
	 */
	public void setDimensions(int width, int height) {
		raster = new int[width * height];
		srcWidth  = width;
		srcHeight = height;
		consumer.setDimensions(height, width);
	}
	
	/**
	 * 顼ǥѴޤºݤˤ RGB ǥ뤬Ѥޤ
	 */
	public void setColorModel(ColorModel model) {
		consumer.setColorModel(defaultColorModel);
	}
	
	/**
	 * žΥҥȤѴޤ
	 * 
	 * @param     hintflags ҥ
	 */
	public void setHints(int hintflags) {
		consumer.setHints(TOPDOWNLEFTRIGHT  |
		                  COMPLETESCANLINES |
		                  SINGLEPASS        |
		                  (hintflags & SINGLEFRAME));
	}
	
	/**
	 * ԥѴޤ
	 * ºݤˤϡΥ᥽åǤѴ줺
	 * {@link #imageComplete(int)} ƤӽФޤǡХåե˳Ǽޤ
	 * 
	 * @param     x X
	 * @param     y Y
	 * @param     w 
	 * @param     h ⤵
	 * @param     model    顼ǥ
	 * @param     pixels   ԥ
	 * @param     off      եå
	 * @param     scansize 󥵥
	 */
	public void setPixels(int x, int y, int w, int h, ColorModel model,
	                      byte pixels[], int off, int scansize) {
		int srcoff = off;
		int dstoff = y * srcWidth + x;
		
		for (int yc = 0; yc < h; yc++) {
			for (int xc = 0; xc < w; xc++)
				raster[dstoff++] = model.getRGB(pixels[srcoff++] & 0xff);
			srcoff += (scansize - w);
			dstoff += (srcWidth - w);
		}
	}
	
	public void setPixels(int x, int y, int w, int h, ColorModel model,
	                      int pixels[], int off, int scansize) {
		int srcoff = off;
		int dstoff = y * srcWidth + x;
		
		if (model == defaultColorModel) {
			for (int yc = 0; yc < h; yc++) {
				System.arraycopy(pixels, srcoff, raster, dstoff, w);
				srcoff += scansize;
				dstoff += srcWidth;
			}
		} else {
			for (int yc = 0; yc < h; yc++) {
				for (int xc = 0; xc < w; xc++)
					raster[dstoff++] = model.getRGB(pixels[srcoff++]);
				srcoff += (scansize - w);
				dstoff += (srcWidth - w);
			}
		}
	}
	
	/**
	 * ᡼Υɤνλޤ
	 * ºݤˤϡΥ᥽åɤθƤӽФˤž졢
	 * 󥷥塼ޤ˲žϤޤ
	 * 
	 * @param     status ơ
	 */
	public void imageComplete(int status) {
		if (status == IMAGEERROR || status == IMAGEABORTED) {
			consumer.imageComplete(status);
			return;
		}
		
		int pixels[] = new int[srcWidth * srcHeight];
		
		int dx, dy, sy, dp = 0;
		
		for (dy = 0; dy < srcWidth; dy++) {
			sy = srcWidth * (srcHeight - 1) + dy;
			for (dx = 0; dx < srcHeight; dx++) {
				pixels[dp++] = raster[sy];
				sy -= srcWidth;
			}
		}
		
		consumer.setPixels(0, 0, srcHeight, srcWidth, defaultColorModel, pixels, 0, srcHeight);
		consumer.imageComplete(status);
	}
}
