/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt.image;

import java.awt.Color;
import java.awt.image.RGBImageFilter;

/**
 * ᡼򥰥졼ե륿Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class GrayFilter
	extends RGBImageFilter
{
	private int a, r, g, b;
	private int br, bg, bb;
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     back طʿ
	 */
	public GrayFilter(Color back)
	{
		this(back.getRGB());
	}
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     backRgb طʿ RGB
	 */
	public GrayFilter(int backRgb)
	{
		canFilterIndexColorModel = true;
		
		br = ((backRgb & 0x00ff0000) >> 16);
		bg = ((backRgb & 0x0000ff00) >>  8);
		bb =  (backRgb & 0x000000ff);
	}
	
	/**
	 * ꤷޤ
	 * 
	 * @param     x X
	 * @param     y Y
	 * @param     rgb RGB
	 * 
	 * @return    ꤷ
	 */
	public int filterRGB(int x, int y, int rgb)
	{
		a =  (rgb & 0xff000000);
		r = ((rgb & 0x00ff0000) >> 16);
		g = ((rgb & 0x0000ff00) >>  8);
		b =  (rgb & 0x000000ff);
		
		r = (((r + br) / 2) << 16);
		g = (((g + bg) / 2) <<  8);
		b =  ((b + bb) / 2);
		
		return (a | r | g | b);
	}
}
