/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.List;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.ItemEvent;
import java.util.Vector;

/**
 * ĥ꡼ΥꥹȤǤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Tree
	extends List
{
	private static final char SPACE = '';
	private static final char CLOSE = 0xFF0B;
	private static final char OPEN  = 0xFF0D;
	private static final char NONE  = '';
	private static final char BOX   = '';
	private static final char ITEM  = '';
	
	/**
	 * ֤ξ֤ˤꡢ¦¦ɲäޤ
	 * <p>
	 * ֤եƥξ硢
	 * ΥեƥबƤС
	 * ΥեΥƥκǸɲäޤ
	 * ĤƤξ硢եƥľɲäޤ
	 * ֤եƥǤϤʤϡ
	 * ֤ľɲäޤ
	 */
	public static final int ADD_ADHOC  = 0;
	/**
	 * ֤Ȥξ¦δ֤ɲäޤ
	 * <p>
	 * ֤ξ¦Υƥξ֤˴طʤ
	 * ֤Ʊ٥ΥƥȤɲäޤ
	 */
	public static final int ADD_BEFORE = 1;
	/**
	 * ֤Ȥβ¦δ֤ɲäޤ
	 * <p>
	 * ֤եξ硢ΥեκǽλǤȤɲäޤ
	 * ʳξϡ֤β¦Υƥξ֤˴طʤ
	 * ֤Ʊ٥ΥƥȤɲäޤ
	 */
	public static final int ADD_AFTER  = 2;
	/**
	 * ֤λǤȤɲäޤ
	 * <p>
	 * ֤ξ֤˴طʤ֤ΥեƥκǸλǤȤ
	 * ɲäޤ⤷֤եƥǤ̵ϡ
	 * ɲäޤ
	 */
	public static final int ADD_CHILD  = 3;
	
	/** ֤Υեƥ */
	public static final int ITEM_FOLDER_OPEN  = 1;
	/** Ĥ֤Υեƥ */
	public static final int ITEM_FOLDER_CLOSE = 2;
	/** ҤΤʤ֤Υեƥ */
	public static final int ITEM_FOLDER_NONE  = 3;
	/** ̤Υƥ */
	public static final int ITEM_NORMAL       = 4;
	
	/** @serial 롼ȥƥ */
	private TreeItem rootItem;
	/** @serial ɽ楢ƥ */
	private Vector   viewItems = new Vector();
	
	/**
	 * ꤵ줿ɽԤĥĥ꡼ۤޤ
	 * 
	 * @param     rows ɽ륢ƥο
	 */
	public Tree(int rows)
	{
		super(rows, false);
		
		// ꥹʤϿ
		addActionListener(
			new ActionListener()
			{
				/** ϥɥ */
				public void actionPerformed(ActionEvent e)
				{
					int index = getSelectedIndex();
					if (index == -1)
						return;
					
					String label = getItem(index);
					int    p     = getFolderTypePosition(label);
					
					switch (label.charAt(p)) {
					case CLOSE: openTreeItem (index); break;
					case OPEN : closeTreeItem(index); break;
					}
				}
			}
		);
		
		addKeyListener(
			new KeyAdapter()
			{
				/** 줿 */
				public void keyPressed(KeyEvent e)
				{
					int index = getSelectedIndex();
					if (index == -1)
						return;
					
					int code = e.getKeyCode();
					switch (code) {
					case KeyEvent.VK_RIGHT: openTreeItem (index); e.consume(); break;
					case KeyEvent.VK_LEFT : closeTreeItem(index); e.consume(); break;
					}
				}
			}
		);
	}
	
	/**
	 * 롼ȥƥꤷޤ
	 * 
	 * @param     root 롼ȥƥ
	 */
	public void setRootTreeItem(TreeItem root)
	{
		removeAll();
		
		rootItem = root;
		
		Vector items = root.getTreeItems();
		
		for (int i = 0; i < items.size(); i++)
			addViewItem((TreeItem)items.elementAt(i), "", -1);
	}
	
	/**
	 * mode ˽ƥɲäޤ
	 * 
	 * @param     item   ɲä륢ƥ
	 * @param     index  ̾Υǥå
	 *                   ɲä <code>-1</code>
	 * @param     mode   ɲä⡼
	 * 
	 * @return    ɲäǤ <code>true</code>
	 *            ʳξ <code>false</code>
	 */
	public boolean addTreeItem(TreeItem item, int index, int mode)
	{
		// ɲäξ
		if (index < 0) {
			if (!rootItem.addTreeItem(item, -1))
				return false;
			addViewItem(item, "", -1);
			return true;
		}
		
		// ʳɲäξ
		TreeItem current = (TreeItem)viewItems.elementAt(index);
		String   label   = getItem(index);
		int      p       = getFolderTypePosition(label);
		String   head    = label.substring(0, p);
		
		if (mode == ADD_ADHOC) {
			// ɲоݤƥ䡢Ĥեξϡμ
			if (label.charAt(p + 1) == ITEM ||
			    label.charAt(p    ) == CLOSE) {
				mode = ADD_BEFORE;
			} else {
				switch (label.charAt(p)) {
				case OPEN:
				case NONE:
					mode = ADD_CHILD;
					break;
				}
			}
		}
		
		switch (mode) {
		case ADD_BEFORE:
			// ʬľʼʬƱ٥
			{
				TreeItem parent = current.getParentTreeItem();
				if (!parent.addTreeItem(item, parent.getTreeItems().indexOf(current)))
					return false;
				addViewItem(item, head, index);
			}
			break;
		case ADD_AFTER:
			// ʬľʼʬƤв̡ʳƱ٥
			if (label.charAt(p) == OPEN) {
				if (!current.addTreeItem(item, 0))
					return false;
				head += SPACE;
			} else {
				TreeItem parent = current.getParentTreeItem();
				if (!parent.addTreeItem(item, parent.getTreeItems().indexOf(current) + 1))
					return false;
			}
			index++;
			addViewItem(item, head, index);
			break;
		case ADD_CHILD:
			// ʬλǤΰֺǸ
			if (!current.addTreeItem(item, -1))
				return false;
			
			if (label.charAt(p) == OPEN) {
				// ƤϺǸɲ
				index = getViewIndex(index + 1, -1);
				addViewItem(item, head + SPACE, index);
			} else {
				// ĤƤꤹϡФ褤
				openTreeItem(index);
				index += current.getTreeItems().size();
			}
			
			break;
		}
		selectedChange(index);
		return true;
	}
	
	/**
	 * ƥޤ
	 * 
	 * @param     index 륢ƥβ̾Υǥå
	 */
	public void removeTreeItem(int index)
	{
		TreeItem current = (TreeItem)viewItems.elementAt(index);
		TreeItem parent  = current.getParentTreeItem();
		Vector   brother = parent.getTreeItems();
		parent.removeTreeItem(brother.indexOf(current));
		
		String label = getItem(index);
		int    p     = getFolderTypePosition(label);
		if (label.charAt(p) == OPEN)
			closeTreeItem(index);
		
		// ƥ
		removeViewItem(index);
		
		// Υƥब̵ʤä顢- ä
		if (brother.size() == 0)
			changeOpenStatus(index - 1, NONE);
	}
	
	/**
	 * ꤷ֤Υƥ֤ޤ
	 * 
	 * @param     index 륢ƥβ̾Υǥå
	 * 
	 * @return    ꤷ֤Υƥ
	 */
	public Object getTreeItem(int index)
	{
		return viewItems.elementAt(index);
	}
	
	/**
	 * 򤵤줿ƥ֤ޤ
	 * 
	 * @return    򤵤Ƥ륢ƥ
	 */
	public Object getSelectedTreeItem()
	{
		int index = getSelectedIndex();
		if (index == -1)
			return null;
		
		return viewItems.elementAt(index);
	}
	
	/**
	 * ꤷ֤ΥƥΥ٥֤ޤ
	 * 
	 * @param     index 륢ƥβ̾Υǥå
	 * 
	 * @return    ꤷ֤Υƥ٥롢
	 *            Ǿ̤ <code>1</code>
	 */
	public int getTreeItemLevel(int index)
	{
		return getFolderTypePosition(getItem(index)) + 1;
	}
	
	/**
	 * ꤷ֤Υƥξ֤֤ޤ
	 * 
	 * @param     index 륢ƥβ̾Υǥå
	 * 
	 * @return    ꤷ֤Υƥξ
	 */
	public int getTreeItemState(int index)
	{
		String label = getItem(index);
		int    p     = getFolderTypePosition(label);
		
		if (label.charAt(p + 1) == ITEM) {
			return ITEM_NORMAL;
		} else {
			switch (label.charAt(p)) {
			case OPEN : return ITEM_FOLDER_OPEN;
			case CLOSE: return ITEM_FOLDER_CLOSE;
			default   : return ITEM_FOLDER_NONE;
			}
		}
	}
	
	/**
	 * ĥ꡼餹٤ƤΥƥޤ
	 */
	public void removeAll()
	{
		super.removeAll();
		viewItems.removeAllElements();
	}
	
	/**
	 * 򤵤줿ƥɽޤ
	 * 
	 * @param     index ɽ륢ƥβ̾Υǥå
	 */
	public void refresh(int index)
	{
		TreeItem current = (TreeItem)viewItems.elementAt(index);
		String   label   = getItem(index);
		replaceItem(label.substring(0, label.indexOf(' ') + 1) + current.getTreeLabel(), index);
	}
	
	/**
	 * ꤷؤΥƥ֤ˤޤ
	 * indices ϡ롼ȥƥफγؤν֤Ǥ
	 * 
	 * @param     indices ǥå
	 */
	public void selectTreeItem(int[] indices)
	{
		int lastIndex = -1;
		
		for (int i = 0; i < indices.length - 1; i++) {
			lastIndex = getViewIndex(lastIndex, indices[i]);
			openTreeItem(lastIndex);
		}
		
		lastIndex = getViewIndex(lastIndex, indices[indices.length - 1]);
		selectedChange(lastIndex);
	}
	
//### Override
	/**
	 *  ꤵ줿ǥåˤ륢ƥ֤ޤ
	 * 
	 * @param      newValue ¸Υƥ֤뿷
	 * @param      index    ֤륢ƥΰ
	 */
	public synchronized void replaceItem(String newValue, int index)
	{
		boolean selected = isIndexSelected(index);
		super.replaceItem(newValue, index);
		if (selected)
			select(index);
	}
	
//### private
	/** ƥºݤɲ */
	private void addViewItem(TreeItem item, String head, int index)
	{
		String label = item.getTreeLabel();
		
		Vector child = item.getTreeItems();
		if (child == null)
			label = head + SPACE + ITEM + " " + label;
		else if (child.size() == 0)
			label = head + SPACE + BOX  + " " + label;
		else
			label = head + CLOSE + BOX  + " " + label;
		
		if (index < 0) {
			addItem(label);
			viewItems.addElement(item);
		} else {
			addItem(label, index);
			viewItems.insertElementAt(item, index);
		}
	}
	
	/** ƥºݤ˺ */
	private void removeViewItem(int index)
	{
		remove(index);
		viewItems.removeElementAt(index);
	}
	
	/** ƥĥ꡼򳫤 */
	private void openTreeItem(int index)
	{
		Vector items = ((TreeItem)viewItems.elementAt(index)).getTreeItems();
		if (items == null)
			return;
		
		String label = getItem(index);
		int    p     = getFolderTypePosition(label);
		String head  = label.substring(0, p);
		int    size  = items.size();
		
		if (label.charAt(p) == OPEN)
			return;
		
		if (size == 0) {
			replaceItem(head + NONE + label.substring(p + 1), index);
			return;
		}
		
		replaceItem(head + OPEN + label.substring(p + 1), index);
		
		head += SPACE;
		for (int i = 0; i < items.size(); i++)
			addViewItem((TreeItem)items.elementAt(i), head, ++index);
	}
	
	/** ƥĥ꡼򳫤 */
	private void closeTreeItem(int index)
	{
		String label = getItem(index);
		int    p     = getFolderTypePosition(label);
		String head  = label.substring(0, p);
		
		if (label.charAt(p) != OPEN)
			return;
		
		replaceItem(head + CLOSE + label.substring(p + 1), index);
		
		head += SPACE;
		index++;
		p += 2;
		
		int start = index, end = getItemCount();
		while (index < end && getItem(index).indexOf(' ') > p)
			index++;
		end = index - 1;
		
		//delItems(start, end);                   // deprecated
		for (int i = end; i >= start; i--)
			//viewItems.removeElementAt(i);         // for deprecated
			removeViewItem(i);
	}
	
	/** ǽüʸΰ֤֤ */
	private int getFolderTypePosition(String label)
	{
		return label.indexOf(' ') - 2;
	}
	
	/** ٥ѹ */
	private void changeOpenStatus(int index, char status)
	{
		String label = getItem(index);
		int    p     = getFolderTypePosition(label);
		
		replaceItem(label.substring(0, p) + status + label.substring(p + 1), index);
	}
	
	/** parent λҤ index ܤβ̾奤ǥå */
	private int getViewIndex(int parent, int index)
	{
		int size = viewItems.size();
		int p    = 2;
		if (parent >= 0)
			p = getFolderTypePosition(getItem(parent)) + 3;
		
		if (index < 0) {
			for (int viewIndex = parent + 1; viewIndex < size; viewIndex++)
				if (getItem(viewIndex).indexOf(' ') < p)
					return viewIndex;
			return size;
		} else {
			for (int viewIndex = parent + 1; viewIndex < size; viewIndex++)
				if (getItem(viewIndex).charAt(p) == ' ' && index-- == 0)
					return viewIndex;
			return getViewIndex(parent, -1);
		}
	}
	
	/** 򤵤줿ƥबѹ줿 */
	private void selectedChange(int index)
	{
		select(index);
		dispatchEvent(new ItemEvent(this, ItemEvent.ITEM_STATE_CHANGED, new Integer(index), ItemEvent.SELECTED));
	}
}
