/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.util.Vector;

/**
 * ġС󶡤ޤ
 * ǥեȤǤѤΥ쥤ȥޥ͡ѤƤޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Toolbar
	extends Container
{
	/** ̾礭֤ޤ */
	public static final String NORMAL  = "normal";
	/** ƥʤ礭դ֤ޤ */
	public static final String MAXIMUM = "maximum";
	
	/** @serial طʲ */
	private Image     backImage;
	/** @serial طʲ */
	private Dimension backImageSize;
	
	/**
	 * ġСޤ
	 */
	public Toolbar()
	{
		setLayout(new Layout(1, 1, 1, 1, 0));
		
		setBackground(SystemColor.control);
	}
	
	/**
	 * ġСΥե졼ºݤ褷ޤ
	 * 
	 * @param     g եå
	 */
	protected void paintFrame(Graphics g)
	{
		Color     bg   = getBackground();
		Dimension size = getSize();
		
		g.setColor(ColorConverter.getBrighter(bg));
		g.drawLine(0, 0, size.width  - 1, 0);
		g.drawLine(0, 0, 0, size.height - 1);
		g.setColor(ColorConverter.getDarker  (bg));
		g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
		g.drawLine(size.width  - 1, 1, size.width - 1, size.height - 1);
	}
	
	/**
	 * طʲꤷޤ
	 * 
	 * @param     image 
	 */
	public void setBackImage(Image image)
	{
		backImage = image;
		if (image != null && !ImageUtils.load(image, this)) image = null;
		
		if (image != null)
			backImageSize = new Dimension(image.getWidth(this), image.getHeight(this));
	}
	
	/**
	 * ̤򥢥åץǡȤޤ
	 * 
	 * @param     g եå
	 */
	public void update(Graphics g)
	{
		paint(g);
	}
	
	/**
	 * ġСºݤ褷ޤ
	 * 
	 * @param     g եå
	 */
	public void paint(Graphics g)
	{
		Dimension size = getSize();
		
		g.setColor(getBackground());
		g.fillRect(0, 0, size.width, size.height);
		
		if (backImage != null) {
			int x = 0, y = 0;
			for (x = 0; x < size.width; x += backImageSize.width)
				for (y = 0; y < size.height; y += backImageSize.height)
					g.drawImage(backImage, x, y, this);
		}
		
		paintFrame(g);
		super.paint(g);
	}
	
	/**
	 * 侩֤ޤ
	 * 
	 * @return    侩
	 */
	public Dimension getPreferredSize()
	{
		Dimension size = super.getPreferredSize();
		if (backImageSize != null)
			return new Dimension(Math.max(backImageSize.width , size.width ),
			                     Math.max(backImageSize.height, size.height));
		else
			return size;
	}
	
	/**
	 * Ǿ֤ޤ
	 * 
	 * @return    Ǿ
	 */
	public Dimension getMinimumSize()
	{
		Dimension size = super.getMinimumSize();
		if (backImageSize != null)
			return new Dimension(Math.max(backImageSize.width , size.width ),
			                     Math.max(backImageSize.height, size.height));
		else
			return size;
	}
	
//### Layout
	/** 쥤ȥޥ͡ */
	private class Layout
		implements LayoutManager
	{
		private int top, left, bottom, right, gap;
		private Vector maximum = new Vector();
		
		/** 󥹥󥹤 */
		private Layout(int top, int left, int bottom, int right, int gap)
		{
			this.top    = top;
			this.left   = left;
			this.bottom = bottom;
			this.right  = right;
			this.gap    = gap;
		}
		
		/** ݡͥȤɲä줿 */
		public void addLayoutComponent(String name, Component comp)
		{
			if (name != null && name.compareTo(MAXIMUM) == 0)
				maximum.addElement(comp);
		}
		
		/** ݡͥȤ줿 */
		public void removeLayoutComponent(Component comp)
		{
			maximum.removeElement(comp);
		}
		
		/** 侩֤ */
		public Dimension preferredLayoutSize(Container target)
		{
			return getLayoutSize(target, true);
		}
		
		/** Ǿ֤ */
		public Dimension minimumLayoutSize(Container target)
		{
			return getLayoutSize(target, false);
		}
		
		/** ֤ */
		private Dimension getLayoutSize(Container target, boolean preferred)
		{
			synchronized (target.getTreeLock()) {
				Dimension size = new Dimension(0, 0);
				int nmembers = target.getComponentCount();
				
				Component c;
				Dimension d;
				for (int i = 0; i < nmembers; i++) {
					c = target.getComponent(i);
					if (!c.isVisible())
						continue;
					
					if (preferred)
						d = c.getPreferredSize();
					else
						d = c.getMinimumSize();
					
					size.height = Math.max(size.height, d.height);
					if (i > 0)
						size.width += gap;
					size.width += d.width;
				}
				
				Insets insets = target.getInsets();
				size.width  += insets.left + insets.right + left + right;
				size.height += insets.top + insets.bottom + top + bottom;
				
				return size;
			}
		}
		
		/** ֤Ԥ */
		public void layoutContainer(Container target)
		{
			synchronized (target.getTreeLock()) {
				Insets insets = target.getInsets();
				Dimension size = target.getSize();
				int oddwidth = 0, oddnum = 0;
				int maxheight = size.height - (insets.top + insets.bottom + top + bottom);
				int nmembers  = target.getComponentCount();
				int x = insets.left + left, y = insets.top + top;
				
				// ֤򻻽
				if (maximum.size() > 0) {
					Dimension allSize = getLayoutSize(target, true);
					oddwidth = Math.max(size.width - allSize.width, 0);
					
					for (int i = 0; i < maximum.size(); i++)
						if (((Component)maximum.elementAt(i)).isVisible())
							oddnum++;
				}
				
				Component c;
				Dimension d;
				for (int i = 0; i < nmembers; i++) {
					c = target.getComponent(i);
					if (!c.isVisible())
						continue;
					
					d = c.getPreferredSize();
					
					if (oddnum > 0 && maximum.indexOf(c) >= 0) {
						int odd = oddwidth / oddnum;
						d.width += odd;
						oddwidth -= odd;
						oddnum--;
					}
					
					//c.setBounds(x, y + ((maxheight - d.height) / 2), d.width, d.height);
					c.setBounds(x, y, d.width, maxheight);
					
					x += d.width;
					x += gap;
				}
			}
		}
	}
}
