/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;

/**
 * ݥåץåפ󶡤ޤ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.6 $
 */
public class ToolTip
{
	private static final Font DEFAULT_FONT = new Font("Dialog" , Font.PLAIN, 12);
	private static final int  INNER_MARGIN = 3;
	private static final int  OUTER_MARGIN = 3;
	
	private static int threadCount = 0;
	
	private ImageCreator creator   = null;
	private Component    component = null;
	private long         delay     = 0;
	private Insets       fix       = null;
	private Font         font      = null;
	private FontMetrics  fm        = null;
	private int          baseFull  = 0;
	private int          baseHalf  = 0;
	private Color        colorFore = null;
	private Color        colorBack = null;
	private Color        colorEdge = null;
	private Object       tipLock   = new Object();
	private String       tipValue  = null;
	private char[]       tipChars  = null;
	private boolean      tipShow   = false;
	private Rectangle    tipRect   = new Rectangle(0, 0, 0, 0);
	private Thread       timer     = null;
	
	
	/**
	 * 󥹥󥹤ޤ
	 * 
	 * @param     creator ᡼ꥨ
	 * @param     component оݤΥݡͥ
	 * @param     delay ٱʥߥá
	 * @param     fix ̤ͤФ˽
	 */
	public ToolTip(ImageCreator creator, Component component, long delay, Insets fix)
	{
		if (fix == null)
			fix = new Insets(0, 0, 0, 0);
		
		this.creator   = creator;
		this.component = component;
		this.delay     = delay;
		this.fix       = fix;
		
		setFont(DEFAULT_FONT);
		setForeground(SystemColor.infoText    );
		setBackground(SystemColor.info        );
		setEdgeColor (SystemColor.windowBorder);
	}
	
	/**
	 * ɽåꤷޤ
	 * 
	 * @param     value ɽå
	 */
	public void showTip(String value, int x, int y, Dimension view)
	{
		synchronized (tipLock) {
			tipValue      = value;
			tipChars      = value.toCharArray();
			tipShow       = false;
			tipRect.x     = x;
			tipRect.y     = y;
			tipRect.width = fm.stringWidth(value);
			
			int width  = tipRect.width  + INNER_MARGIN * 2 + 2;
			int height = tipRect.height + INNER_MARGIN * 2 + 2;
			
			if (view.width  < tipRect.x + width  + OUTER_MARGIN) tipRect.x -= fix.right;
			if (view.width  < tipRect.x + width  + OUTER_MARGIN) tipRect.x =  view.width  - width  - OUTER_MARGIN;
			if (tipRect.x < OUTER_MARGIN) tipRect.x += fix.left;
			if (tipRect.x < OUTER_MARGIN) tipRect.x =  OUTER_MARGIN;
			if (view.height < tipRect.y + height + OUTER_MARGIN) tipRect.y -= (fix.bottom + tipRect.height);
			if (view.height < tipRect.y + height + OUTER_MARGIN) tipRect.y =  view.height - height - OUTER_MARGIN;
			if (tipRect.y < OUTER_MARGIN) tipRect.y += fix.top;
			if (tipRect.y < OUTER_MARGIN) tipRect.y =  OUTER_MARGIN;
			
			if (timer == null) {
				timer = new ToolTipThread("Kankana-ToolTip-" + (++threadCount));
				timer.start();
			} else {
				timer.interrupt();
			}
		}
	}
	
	/**
	 * եȤ֤ޤ
	 * 
	 * @return    ե
	 */
	public Font getFont()
	{
		return font;
	}
	
	/**
	 * եȤꤷޤ
	 * 
	 * @param     font ե
	 */
	public void setFont(Font font)
	{
		FontData fontData = FontData.getInstance(creator, font);
		
		this.font           = font;
		this.fm             = fontData.getFontMetrics();
		this.tipRect.height = Math.max(fontData.getFullSize().height, fontData.getHalfHeight());
		this.baseFull       = fontData.getFullBase();
		this.baseHalf       = fontData.getHalfBase();
	}
	
	/**
	 * ʿ֤ޤ
	 * 
	 * @return    ʿ
	 */
	public Color getForeground()
	{
		return colorFore;
	}
	
	/**
	 * ʿꤷޤ
	 * 
	 * @param     c ʿ
	 */
	public void setForeground(Color c)
	{
		colorFore = c;
	}
	
	/**
	 * طʿ֤ޤ
	 * 
	 * @return    طʿ
	 */
	public Color getBackground()
	{
		return colorBack;
	}
	
	/**
	 * طʿꤷޤ
	 * 
	 * @param     c طʿ
	 */
	public void setBackground(Color c)
	{
		colorBack = c;
	}
	
	/**
	 * ο֤ޤ
	 * 
	 * @return    ο
	 */
	public Color getEdgeColor()
	{
		return colorEdge;
	}
	
	/**
	 * οꤷޤ
	 * 
	 * @param     c ο
	 */
	public void setEdgeColor(Color c)
	{
		colorEdge = c;
	}
	
	/**
	 * åɽ뤿 {@link Component#paint(Graphics)} ƤӽФޤ
	 * 
	 * @param     g եå
	 */
	public void paint(Graphics g)
	{
		synchronized (tipLock) {
			if (tipValue != null && tipShow) {
				g.setColor  (colorBack);
				g.fillRect  (tipRect.x + 1,
				             tipRect.y + 1,
				             tipRect.width  + INNER_MARGIN * 2,
				             tipRect.height + INNER_MARGIN * 2);
				g.setColor  (colorEdge);
				g.drawRect  (tipRect.x,
				             tipRect.y,
				             tipRect.width  + INNER_MARGIN * 2 + 1,
				             tipRect.height + INNER_MARGIN * 2 + 1);
				g.setColor  (colorFore);
				int x = tipRect.x + INNER_MARGIN + 1;
				int y = tipRect.y + INNER_MARGIN + 1;
				char c;
				for (int i = 0; i < tipChars.length; i++) {
					c = tipChars[i];
					g.drawChars(tipChars, i, 1, x, y + ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F) ? baseHalf : baseFull));
					x += fm.charWidth(tipChars[i]);
				}
			}
		}
	}
	
	/**
	 * ɽåäޤ
	 */
	public void cancel()
	{
		synchronized (tipLock) {
			if (tipValue != null) {
				tipValue = null;
				tipShow  = false;
				
				timer.interrupt();
				
				repaint();
			}
		}
	}
	
	/**
	 * ٱ֤ޤ
	 * 
	 * @return    ٱʥߥá
	 */
	public long getDelay()
	{
		return delay;
	}
	
	/**
	 * ٱ֤ߥäǻꤷޤ
	 * 
	 * @param     delay ٱʥߥá
	 */
	public void setDelay(long delay)
	{
		this.delay = delay;
	}
	
	/** Tip ʬɽ */
	private void repaint()
	{
		// +3 = 岼 + drawRect β¦
		component.repaint(tipRect.x,
		                  tipRect.y,
		                  tipRect.width  + INNER_MARGIN * 2 + 3,
		                  tipRect.height + INNER_MARGIN * 2 + 3);
	}
	
//### ToolTipThread
	/** ɽԤΥå */
	private class ToolTipThread
		extends Thread
	{
		/** 󥹥󥹤 */
		private ToolTipThread(String name)
		{
			super(name);
		}
		
		/** ¹Ԥ */
		public void run()
		{
			for (;;) {
				synchronized (tipLock) {
					try {
						if (tipValue != null) {
							tipLock.wait(delay);
							tipShow = true;
							repaint();
						} else {
							tipLock.wait();
						}
					} catch (InterruptedException e) {
					}
				}
			}
		}
	}
}
