/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.awt.image.SyncObserver;
import net.hizlab.kagetaka.util.CharList;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.util.Hashtable;
import java.util.Vector;

/**
 * ʸĽɽ뤿Υ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.1 $
 */
public class Text
{
	private static final char TYPE_MASK  = 0x00FF;           // ץޥ
	private static final char TYPE_NONE  = 0x0031;           // ž̵
	private static final char TYPE_RIGHT = 0x0032;           //  90 ٲž
	private static final char TYPE_LTRB  = 0x0033;           // 屦ȿž
	private static final char TYPE_BR    = 0x0035;           // 
	
	private static final char KK_MASK    = 0x0F00;           // §ѥޥ
	private static final char KK_OK      = 0x0000;           // Բ
	private static final char KK_NG      = 0x0100;           // Բ
	
	private static final int  MT_WAIT    = 10000;            // ǥȥåԤ
	
	private ImageCreator imageCreator;
	private Toolkit      toolkit;
	private CharList     charsSpinRight;
	private CharList     charsSpinLtrb;
	private CharList     charsKinsokuHead;
	private CharList     charsKinsokuTail;
	private FontData     fd;
	private Dimension    fs;
	private FontMetrics  fm;
	private int          ff;                  // fontFullBase
	private int          fh;                  // fontHalfBase
	private int          fx;                  // fontHalfHeight
	private int          fz;                  // fontMaxHeight
	
	private StringBuffer values  = new StringBuffer();
	private StringBuffer types   = new StringBuffer();
	private StringBuffer widths  = new StringBuffer();
	private StringBuffer heights = new StringBuffer();
	private int nowLength = 0;
	private int nowWidth  = 0;
	private int nowHeight = 0;
	private boolean lastPending     = false;  // Ǹ夬ڥǥ󥰤
	private boolean lastHankakuEisu = false;  // ǸʸȾѱѿ
	private int p = -1;
	private boolean mastHeight      = true;   // ɬ礭뤫
	
	private SyncObserver syncObserver = new SyncObserver();  // Ԥ
	
	// å
	private Hashtable cacheSize = new Hashtable();
	private Detail    cacheZero = new Detail   ();
	
	// ѿ
	private char c, s;
	private int  i, w, h;
	private Detail detail;
	private char[] tateCs = new char[1];
	
	/** 󥹥󥹤 */
	Text(TextManager manager, FontData fd, String text)
	{
		this.imageCreator     = manager.imageCreator;
		this.toolkit          = imageCreator.getToolkit();
		this.charsSpinRight   = manager.charsSpinRight;
		this.charsSpinLtrb    = manager.charsSpinLtrb;
		this.charsKinsokuHead = manager.charsKinsokuHead;
		this.charsKinsokuTail = manager.charsKinsokuTail;
		this.fd               = fd;
		this.fs               = fd.getFullSize   ();
		this.fm               = fd.getFontMetrics();
		this.ff               = fd.getFullBase   ();
		this.fh               = fd.getHalfBase   ();
		this.fx               = fd.getHalfHeight ();
		this.fz               = fd.getMaxHeight  ();
		
		append(text, 0, text.length());
		if (nowLength > 0)
			newLine();
	}
	
	/** ʸɲ */
	private void append(String text, int begin, int end)
	{
		for (i = begin; i < end; i++) {
			c = text.charAt(i);
			
			// Ԥξ
			if (c == 0x0A) {
				commit();
				append(c, TYPE_BR, false);
				newLine();
				continue;
			}
			
			// Ⱦѱѿʸ
			if ((0x30 <= c && c <= 0x39) ||
			    (0x41 <= c && c <= 0x5A) ||
			    (0x61 <= c && c <= 0x7A)) {
				if (!lastHankakuEisu)
					commit();
				
				append(c, TYPE_RIGHT, true);
				lastHankakuEisu = true;
				continue;
			}
			
			lastHankakuEisu = false;
			s = TYPE_NONE;
			
			// žη
			if ((c <= 0xFF) ||
			    (0xFF61 <= c && c <= 0xFF9F) ||
			    charsSpinRight.contains(c))
				s = TYPE_RIGHT;
			else if (charsSpinLtrb.contains(c))
				s = TYPE_LTRB;
			
			// Ƭ§ʸξϡ̤Хåե
			if (charsKinsokuHead.contains(c)) {
				append(c, s, true);
				continue;
			}
			
			// §ʸξϡߥåȤƳХåե
			if (charsKinsokuTail.contains(c)) {
				commit();
				append(c, s, false);
				continue;
			}
			
			// ̤ʸξ硢ߥåȤ̤Хåե
			commit();
			append(c, s, true);
		}
	}
	
	/** Хåեɲ */
	private void append(char c, char s, boolean pending)
	{
		if (pending) {
			if (lastPending)
				types.setCharAt(p, (char)(types.charAt(p) | KK_NG));
			else
				lastPending = true;
		}
		
		w = calculateWidth (c, s);
		h = calculateHeight(c, s);
		
		values .append(c);
		types  .append(s);
		widths .append((char)w);
		heights.append((char)h);
		p++;
		
		nowLength ++;
		nowWidth  =  Math.max(nowWidth, w);
		nowHeight += h;
	}
	
	/** ̤ʬ */
	private void commit()
	{
		if (lastPending)
			lastPending = false;
	}
	
	/** եȤ֤ޤ */
	private int calculateWidth(char c, char s)
	{
		switch (s) {
		case TYPE_RIGHT:
		case TYPE_LTRB :
			return ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F) ? fx : fs.width);
		default:
			return fm.charWidth(c);
		}
	}
	
	/** եȤι⤵֤ޤ */
	private int calculateHeight(char c, char s)
	{
		switch (s) {
		case TYPE_RIGHT:
		case TYPE_LTRB :
			return fm.charWidth(c);
		default:
			return fs.height;
		}
	}
	
	/** ԤԤ */
	private void newLine()
	{
		cacheZero.addLine(nowLength, nowWidth, nowHeight);
		
		nowLength = 0;
		nowWidth  = 0;
		nowHeight = 0;
	}
	
	/**
	 * ʸλꤵ줿⤵褹ɬפ礭֤ޤ
	 * 
	 * @param     maxHeight ι⤵⤵¤ʤ <code>0</code>
	 * 
	 * @return    ɬפ礭
	 */
	public Dimension getSize(int maxHeight)
	{
		return new Dimension(getDatail(maxHeight).size);
	}
	
	/** ǥƥ */
	private Detail getDatail(int maxHeight)
	{
		if (maxHeight <= 0)
			return cacheZero;
		
		synchronized (cacheSize) {
			Integer key = new Integer(maxHeight);
			
			// å¸ߤФ֤
			if ((detail = (Detail)cacheSize.get(key)) != null)
				return detail;
			
			// åɲ
			cacheSize.put(key, (detail = new Detail()));
			
			int w  = 0, h  = 0;
			int pl = 0, pw = 0, ph = 0;             // ڥǥ礭
			int cl = 0, cw = 0, ch = 0;             // ߤ礭
			
			for (i = 0; i <= p; i++) {
				s = types  .charAt(i);
				w = widths .charAt(i);
				h = heights.charAt(i);
				
				// ꤭ʤ
				if (mastHeight) {
					if (ch + ph + h > maxHeight) {
						// ڥǥ󥰤μǲԤƤߤ
						if (cl > 0) {
							detail.addLine(cl, cw, ch);
							cl = cw = ch = 0;
						}
						
						// ڥǥ󥰤Ǥ꤭ʤ
						if (ph + h > maxHeight) {
							detail.addLine(pl, pw, ph);
							pl = pw = ph = 0;
						}
					}
				}
				
				// §ʸξ
				if ((s & KK_MASK) == KK_NG) {
					pl++;
					pw =  Math.max(pw, w);
					ph += h;
					continue;
				}
				
				if (pl > 0) {
					// ڥǥʸä
					pl++;
					pw =  Math.max(pw, w);
					ph += h;
					
					if (!mastHeight && ch + ph > maxHeight) {
						// ʸɲäǤʤϡڥǥ󥰤μǲ
						if (cl > 0)
							detail.addLine(cl, cw, ch);
						
						cl = pl;
						cw = pw;
						ch = ph;
					} else {
						// ڥǥ󥰤ꤹ
						cl += pl;
						cw =  Math.max(cw, pw);
						ch += ph;
					}
					pl = pw = ph = 0;
				} else {
					// Ѥߤʸξ
					
					if (!mastHeight && ch + h > maxHeight) {
						// ʸɲäǤʤϡľǲ
						if (cl > 0)
							detail.addLine(cl, cw, ch);
						
						cl = 1;
						cw = w;
						ch = h;
					} else {
						cl++;
						cw =  Math.max(cw, w);
						ch += h;
					}
				}
				
				// ¤ϲʸä
				if (s == TYPE_BR) {
					detail.addLine(cl, cw, ch);
					cl = cw = ch = 0;
				}
			}
			
			if (cl > 0)
				detail.addLine(cl, cw, ch);
			
			return detail;
		}
	}
	
	/**
	 * ʸ褷ޤ
	 * 
	 * @param     g եå
	 * @param     x 夫 X
	 * @param     y 夫 Y
	 * @param     height ι⤵⤵¤ʤ <code>0</code>
	 */
	public void draw(Graphics g, int x, int y, int height)
	{
		detail = getDatail(height);
		
		int bx = x, by = y;
		
		int  begin = 0;
		Line line = null;
		int  ln   = -1, lc = 0;
		for (i = 0; i <= p;) {
			// 
			if (lc == 0) {
				if (x <= 0)
					break;
				line = (Line)detail.lines.elementAt(++ln);
				lc   = line.length;
				x -= line.width; y = by;
			}
			
			s = (char)(types.charAt(i) & TYPE_MASK);
			w = widths .charAt(i);
			h = heights.charAt(i);
			
			// 
			switch (s) {
			case TYPE_NONE:
				// Ľ񤭤ϡĤ
				tateCs[0] = values.charAt(i);
				g.drawChars(tateCs, 0, 1, (fs.width > w ? x + ((fs.width - w) / 2) : x), y + ff);
//g.drawRect(x, y, w - 1, h - 1);
				y += h;
				--lc; ++i;
				break;
			case TYPE_RIGHT:
			case TYPE_LTRB :
				// Ʊžʤ顢ޤȤƲž
				begin = i;
				for (;;) {
					--lc; ++i;
					if ((lc == 0) || ((types.charAt(i) & TYPE_MASK) != s))
						break;
					w =  Math.max(w, widths.charAt(i));
					h += heights.charAt(i);
				}
				drawTextWithSpin(g, begin, i, x, y, w, h, s);
//g.drawRect(x, y, w - 1, h - 1);
				y += h;
				break;
			case TYPE_BR:
				--lc; ++i;
				break;
			}
		}
	}
	
	/** ʸž */
	private void drawTextWithSpin(Graphics g, int begin, int end,
	                              int x, int y, int width, int height, char type)
	{
		// եȤΤʤʸž褦Ȥ
		if (height == 0)
			return;
		
		int scrapX, scrapY;
		Color backColor = Color.white;
		Color foreColor = Color.black;
		
		Image    scrap = null;
		Graphics sg    = null;
		try {
			scrap = imageCreator.createImage(height, width);
			sg    = scrap.getGraphics();
		} catch (IllegalArgumentException e) {
System.out.println("e=["+values+"],["+begin+"],["+end+"],["+height+"],["+width+"]");
			return;
		} catch (NegativeArraySizeException e) {
System.out.println("e=["+values+"],["+begin+"],["+end+"],["+height+"],["+width+"]");
			return;
		}
		
		// طʿ white ˤơwhite Ʃˤ
		sg.setColor(backColor);
		sg.fillRect(0, 0, height, width);
		
		// ʿ򤳤ꤷʤΤϡƩѤοȽŤʤǽΤȡ
		// JDK 1.1 ΰǡǤʤХб뤿
		sg.setColor(foreColor   );
		sg.setFont (fd.getFont());
		
		///// åפ˲žʸ
		
		int base = 0;
		// TYPE_LTRB ξΥ١֤׻
		if (type == TYPE_LTRB)
			base = ff + (fs.height - ff) / 2;
		
		char c;
		scrapX = 0;
		for (int i = begin; i < end; i++) {
			tateCs[0] = c = values.charAt(i);
			
			// TYPE_RIGHT ξΥ١֤׻
			if (type == TYPE_RIGHT)
				base = ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F) ? fh : ff);
			
			sg.drawChars(tateCs, 0, 1, scrapX, base);
			scrapX += heights.charAt(i);
		}
		
		sg.dispose();
		
		///// ʸž
		int[] bitmap1 = new int[width * height];
		int[] bitmap2 = new int[width * height];
		PixelGrabber pg = new PixelGrabber(scrap, 0, 0, height, width, bitmap1, 0, height);
		try{
			// ѴǼԤƤ⡢̵뤷Ʒ³ƹʤ
			pg.grabPixels(MT_WAIT);
		} catch (InterruptedException e) {}
		
		switch (type) {
		case TYPE_RIGHT:
			for (scrapX = 0; scrapX < height; scrapX++)
				for (scrapY = 0; scrapY < width; scrapY++)
					bitmap2[scrapX * width + scrapY] = bitmap1[scrapX + (width - scrapY - 1) * height];
			break;
		case TYPE_LTRB:
			for (scrapX = 0; scrapX < height; scrapX++)
				for (scrapY = 0; scrapY < width; scrapY++)
					bitmap2[scrapX * width + scrapY] = bitmap1[scrapX + scrapY * height];
			break;
		}
		
		// ʸοꤷطʤƩˤ
		int bcc = backColor.getRGB();
		int fcc = g.getColor().getRGB() | 0xff000000;
		for (int i = 0; i < bitmap2.length; i++)
			if (bitmap2[i] == bcc)
				bitmap2[i] &= 0xffffff;             // Ʃ
			else
				bitmap2[i] = fcc;                   // ʿˤ
		
		// ᡼Ǥϡwidth  height ͤϸ򴹤Ƥ
		
		MemoryImageSource mis = new MemoryImageSource(width, height, bitmap2, 0, width);
		mis.setAnimated(false);
		Image image = toolkit.createImage(mis);
		
		// 褹褦ˤ
		drawImageSync(g, image, x, y, width, height);
		
		// ꥽
		scrap.flush();
		image.flush();
	}
	
	/** Ʊ */
	private void drawImageSync(Graphics g, Image image, int x, int y, int width, int height)
	{
		synchronized (syncObserver) {
			syncObserver.init(g, x, y, width, height);
			if (!g.drawImage(image, x, y, width, height, syncObserver)) {
				try {
					syncObserver.wait(MT_WAIT);
				} catch (InterruptedException e) {
System.out.println("wait to draw a text");
				}
			}
		}
	}
	
	/**
	 * ʸ˴ơΥ꥽ޤ
	 * Υ᥽åɤƤӽФȡΥ󥹥󥹤ϥꥵ뤵뤿ᡢ
	 * ˴ѤƤϤޤ
	 */
	public void dispose()
	{
		
	}
	
//### Detail
	/** ǥƥ */
	private class Detail
	{
		private Dimension size  = new Dimension();
		private Vector    lines = new Vector();
		
		/** 󥹥󥹤 */
		private Detail()
		{
		}
		
		/** Ԥɲ */
		private void addLine(int length, int width, int height)
		{
			width = Math.max(width, fz);
			lines.addElement(new Line(length, width, height));
			size.width  += width;
			size.height =  Math.max(size.height, height);
		}
	}
	
//### Line
	/**  */
	private class Line
	{
		private int length;
		private int width;
		private int height;
		
		/** 󥹥󥹤 */
		private Line(int length, int width, int height)
		{
			this.length = length;
			this.width  = width;
			this.height = height;
		}
	}
}
