/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.Resource;
import net.hizlab.kagetaka.util.Environment;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * ơɽ뤿ΥơСݡͥȤǤ
 * ̤ϡWindow κǲˤꡢץफûå䡢
 * ʤɤɽ뤿ѤޤΤᡢΥݡͥȤ
 * 岼ϸˤʤäƤޤWindow ǲ֤뤿ˡ
 * {@link java.awt.BorderLayout} ѤǤ
 * <pre>
 * StatusBar s = new StatusBar();
 * setLayout(new BorderLayout());
 * add(s, "South");
 * s.setText("Hello");
 * </pre>
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.4 $
 */
public class StatusBar
	extends Component
{
	private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
	
	private static final int MENU_COPY = 0;
	
	/** @serial ơСθꥵ */
	private Dimension statusSize  = new Dimension(0, 0);
	/** @serial ơɽʸ */
	private String    statusText  = null;
	/** @serial ơɽʸ */
	private char[]    statusChars = null;
	/** @serial ݥåץåץ˥塼 */
	private PopupMenu popupMenu   = null;
	/** @serial ᡼ꥨ */
	private ImageCreatorComponent icc = new ImageCreatorComponent(this);
	
	/**
	 * ơСޤ
	 * Dialog եȤѤƥ५顼ǽޤ
	 */
	public StatusBar()
	{
		setFont      (Font.decode("Dialog"));
		setForeground(SystemColor.controlText);
		setBackground(SystemColor.control    );
		
		setVisible(true);
		
		addMouseListener(
			new MouseAdapter()
			{
				/** ޥå줿 */
				public void mouseClicked(MouseEvent e)
				{
					if (e.isPopupTrigger() ||
					    ((e.getModifiers() & InputEvent.BUTTON3_MASK) == InputEvent.BUTTON3_MASK)) {
						
						popupMenu.show(e.getComponent(), e.getX(), e.getY());
					}
				}
			}
		);
		
		// ˥塼Ѱ
		popupMenu = new PopupMenu(Resource.getMessage(RESOURCE, "statusbar.menu", null));
		MenuItem mi = new MenuItem(Resource.getMessage(RESOURCE, "statusbar.menu.copy", null));
		mi.addActionListener(new MenuActionListener(MENU_COPY));
		popupMenu.add(mi);
		add(popupMenu);
	}
	
	/**
	 * ơСɽʸꤷޤ
	 * 
	 * @param     value ơСɽʸ
	 */
	public synchronized void setText(String value)
	{
		if (statusText == value)
			return;
		
		if (statusText == null ||
		    value      == null ||
		    statusText.compareTo(value) != 0) {
			this.statusText = value;
			if (statusText != null)
				statusChars = statusText.toCharArray();
			else
				statusChars = null;
			if (isShowing())
				repaint();
		}
	}
	
//### Override
	/**
	 * ɽѤեȤꤷޤ
	 * 
	 * @param     font ե
	 */
	public synchronized void setFont(Font font)
	{
		super.setFont(font);
		
		statusSize.height = getFontMetrics(font).getHeight() + 5;
		
		setSize(statusSize);
	}
	
	/**
	 * ơСκǾΥ֤ޤ
	 * ⤵Τ¤Ƥޤ
	 * 
	 * @return    Ǿ
	 */
	public Dimension getMinimumSize()
	{
		return new Dimension(statusSize);
	}
	
	/**
	 * ơСκ祵֤ޤ
	 * ⤵Τ¤Ƥޤ
	 * 
	 * @return    祵
	 */
	public Dimension getMaximumSize()
	{
		return new Dimension(statusSize);
	}
	
	/**
	 * ơСο侩֤ޤ
	 * ⤵Τ߻ꤵƤޤ
	 * 
	 * @return    侩
	 */
	public Dimension getPreferredSize()
	{
		return new Dimension(statusSize);
	}
	
	/**
	 * ơСκԤޤ
	 * 
	 * @param     g Graphics ɥ
	 */
	public void update(Graphics g)
	{
		paint(g);
	}
	
	/**
	 * ơСԤޤ
	 * 
	 * @param     g Graphics ɥ
	 */
	public void paint(Graphics g)
	{
		Dimension size = getSize();
		
		// طʿɤ
		Color bg = getBackground();
		g.setColor(bg);
		g.fillRect(0, 0, size.width, size.height);
		//g.draw3DRect(0, 0, size.width, size.height, false);
		
		// ʸɽ
		g.setColor(getForeground());
		synchronized (this) {
			if (statusChars != null) {
				FontData fontData = FontData.getInstance(icc, getFont());
				FontMetrics fm = fontData.getFontMetrics();
				int x   = 4;
				int fix = (size.height - fontData.getMaxHeight()) / 2 + 1;
				int y1  = fontData.getHalfBase() + fix;
				int y2  = fontData.getFullBase() + fix;
				char c;
				for (int i = 0; i < statusChars.length; i++) {
					c = statusChars[i];
					g.drawChars(statusChars, i, 1, x, ((c <= 0xFF) || (0xFF61 <= c && c <= 0xFF9F) ? y1 : y2));
					x += fm.charWidth(statusChars[i]);
				}
			}
		}
		
		// Ȥɽ
		g.setColor(SystemColor.controlShadow);
		g.drawLine(1, 2, size.width,  2);
		g.drawLine(1, 2, 1, size.height);
		
		g.setColor(SystemColor.controlLtHighlight);
		g.drawLine(size.width - 1,  2, size.width - 1, size.height - 1);
		g.drawLine(1, size.height - 1, size.width - 1, size.height - 1);
		
		if (Environment.isWindows) {
			// ξɽ
			g.setColor(bg);
			g.drawLine(size.width - 13, size.height -  1, size.width - 1, size.height - 1);
			g.drawLine(size.width -  1, size.height - 13, size.width - 1, size.height - 1);
			
			g.drawLine(size.width -  2, size.height - 2, size.width - 2, size.height -  2);
			g.drawLine(size.width -  6, size.height - 2, size.width - 2, size.height -  6);
			g.drawLine(size.width - 10, size.height - 2, size.width - 2, size.height - 10);
			
			g.setColor(SystemColor.controlLtHighlight);
			g.drawLine(size.width -  5, size.height - 2, size.width - 2, size.height -  5);
			g.drawLine(size.width -  9, size.height - 2, size.width - 2, size.height -  9);
			g.drawLine(size.width - 13, size.height - 2, size.width - 2, size.height - 13);
			
			g.setColor(SystemColor.controlShadow);
			g.drawLine(size.width -  3, size.height - 2, size.width - 2, size.height -  3);
			g.drawLine(size.width -  4, size.height - 2, size.width - 2, size.height -  4);
			g.drawLine(size.width -  7, size.height - 2, size.width - 2, size.height -  7);
			g.drawLine(size.width -  8, size.height - 2, size.width - 2, size.height -  8);
			g.drawLine(size.width - 11, size.height - 2, size.width - 2, size.height - 11);
			g.drawLine(size.width - 12, size.height - 2, size.width - 2, size.height - 12);
		}
	}
	
	/**
	 * ΥơСΥѥ᡼ʸ֤ޤ
	 * 
	 * @return    ѥ᡼ʸ
	 */
	protected String paramString()
	{
		String str = super.paramString();
		return str;
	}
	
	/** åץܡɤ˥ԡ */
	private void copyClipboard(String value)
	{
		Clipboard       clipboard = getToolkit().getSystemClipboard();
		StringSelection data      = new StringSelection(value);
		clipboard.setContents(data, data);
	}
	
//### MenuActionListener
	/** ˥塼ѤΥꥹ */
	private class MenuActionListener
		implements ActionListener
	{
		private int index = 0;
		
		/** ˥塼ꥹ  */
		private MenuActionListener(int index)
		{
			this.index = index;
		}
		
		/** ϥɥ */
		public void actionPerformed(ActionEvent e)
		{
			switch (index) {
			case MENU_COPY: copyClipboard(statusText); break;
			}
		}
	}
}
