/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.StringTokenizer;
import java.util.Vector;

/**
 * θꤵ줿٥Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class SizedLabel
	extends SizedComponent
{
	/** @serial ٥ʸ */
	private String text;
	/** @serial ʸ */
	private Vector lines = new Vector();
	/** @serial ⤵ */
	private int    height;
	/** @serial եȤ <code>descent</code> */
	private int    descent;
	
	/**
	 * ٥ɽʸꤷƿ٥ޤ
	 * 
	 * @param     text ٥ɽʸ
	 */
	public SizedLabel(String text)
	{
		setText(text);
	}
	
	/**
	 * ٥ޤ
	 */
	public SizedLabel()
	{
	}
	
	/**
	 * ٥ɽʸꤷޤ
	 * 
	 * @param     text ٥ɽʸ
	 */
	public synchronized void setText(String text)
	{
		this.text = text;
		calculateHeight();
	}
	
	/**
	 * ٥ɽʸ֤ޤ
	 * 
	 * @return    ٥ɽʸ
	 */
	public synchronized String getText()
	{
		return text;
	}
	
	/**
	 * ٥ΥեȤꤷޤ
	 * 
	 * @param     f ե
	 */
	public synchronized void setFont(Font f)
	{
		super.setFont(f);
		calculateHeight();
	}
	
	/**
	 * ٥ºݤ褷ޤ
	 * 
	 * @param     g եå
	 */
	public synchronized void paint(Graphics g)
	{
		if (lines.size() == 0)
			return;
		
		Dimension size = getSize();
		
		g.setColor(getBackground());
		g.fillRect(0, 0, size.width, size.height);
		
		g.setColor(getForeground());
		g.setFont (getFont      ());
		int y = height - descent;
		for (int i = 0; i < lines.size(); i++, y += height)
			g.drawString((String)lines.elementAt(i), 0, y);
	}
	
	/** Ʒ׻ */
	private void calculateHeight()
	{
		lines.removeAllElements();
		
		Font        font = getFont();
		FontMetrics fm   = getFontMetrics(font);
		
		height  = fm.getHeight ();
		descent = fm.getDescent();
		size = new Dimension(0, 0);
		
		if (text == null)
			return;
		
		boolean lastCr   = false;
		boolean lastText = false;
		String  line   = null;
		StringTokenizer st = new StringTokenizer(text, "\n\r", true);
		while (st.hasMoreTokens()) {
			line = st.nextToken();
			
			if (line.compareTo("\n") == 0) {
				lastCr = true;
				if (lastText) {
					lastText = false;
					continue;
				}
				line = "";
			} else if (line.compareTo("\r") == 0) {
				if (lastCr) {
					lastCr = false;
					continue;
				}
				if (lastText) {
					lastText = false;
					continue;
				}
				line = "";
			} else {
				lastCr   = false;
				lastText = true;
			}
			
			size.width  =  Math.max(size.width, fm.stringWidth(line));
			size.height += height;
			lines.addElement(line);
		}
	}
}
