/* ----- BEGIN LICENSE BLOCK -----
 * Version: MPL 1.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is the Kagetaka Libraries.
 *
 * The Initial Developer of the Original Code is Hizuya Atsuzaki
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s): Hizuya Atsuzaki <hizuya@hizlab.net>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ----- END LICENSE BLOCK ----- */
package net.hizlab.kagetaka.awt;

import net.hizlab.kagetaka.Resource;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

/**
 * ɽ饹Ǥ
 * 
 * @author  <A HREF="mailto:hizuya@hizlab.net">Hizuya Atsuzaki</A>
 * @version $Revision: 1.2 $
 */
public class Icon
	extends SizedComponent
{
	private static final String RESOURCE = "net.hizlab.kagetaka.awt.Resource";
	
	/** ᡼ޡ */
	public static final int EXCLAMATION   = 0x0001;
	/** ޡ */
	public static final int QUESTION      = 0x0002;
	/** ޡ */
	public static final int INFORMATION   = 0x0003;
	/** ȥåץޡ */
	public static final int STOP          = 0x0004;
	
	/** @serial 󥤥᡼ */
	private Image image;
	
	/**
	 * Υ󥹥󥹤ޤ
	 * 
	 * @param     type μ
	 */
	public Icon(int type)
	{
		image = getImage(type);
		if (image == null)
			return;
		
		size = new Dimension(image.getWidth(this), image.getHeight(this));
	}
	
	/**
	 * ºݤ褷ޤ
	 * 
	 * @param     g եå
	 */
	public void paint(Graphics g)
	{
		if (image == null)
			return;
		
		Dimension nowSize = getSize();
		g.drawImage(image, (nowSize.width  - size.width ) / 2,
		                   (nowSize.height - size.height) / 2, this);
	}
	
	/** Υ᡼ */
	private Image getImage(int type)
	{
		// ᡼ɤ
		String name = "icon.";
		switch (type) {
		case EXCLAMATION: name += "warn"    ; break;
		case QUESTION   : name += "question"; break;
		case INFORMATION: name += "inform"  ; break;
		case STOP       : name += "error"   ; break;
		}
		Image image = Resource.getImageResource(RESOURCE, name, getToolkit());
		if (image == null || !ImageUtils.load(image, this))
			return null;
		
		return image;
	}
}
